/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

public class Vector2i {
    public static final Vector2i ZERO = new Vector2i(0, 0);
    public static final Vector2i ONE = new Vector2i(1, 1);
    public static final Vector2i UNIT_X = new Vector2i(1, 0);
    public static final Vector2i UNIT_Y = new Vector2i(0, 1);
    public int x;
    public int y;

    public Vector2i() {
        this.y = 0;
        this.x = 0;
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2i(Vector2i copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public Vector2i copy() {
        return new Vector2i(this.x, this.y);
    }

    public Vector2i set(Vector2i vector) {
        return this.set(vector.x, vector.y);
    }

    public Vector2i set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2i setX(int x) {
        this.x = x;
        return this;
    }

    public Vector2i setY(int y) {
        this.y = y;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public float dot(Vector2i other) {
        return this.dot(other.x, other.y);
    }

    public float dot(int x, int y) {
        return this.x * x + this.y * y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distance(Vector2i other) {
        return (float)Math.sqrt(this.distanceSquared(other.x, other.y));
    }

    public float distance(int x, int y) {
        return (float)Math.sqrt(this.distanceSquared(x, y));
    }

    public float distanceSquared(Vector2i other) {
        return this.distanceSquared(other.x, other.y);
    }

    public float distanceSquared(int x, int y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return (float)(dx * dx + dy * dy);
    }

    public Vector2i addLocal(Vector2i other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    public Vector2i addLocal(int addX, int addY) {
        this.x += addX;
        this.y += addY;
        return this;
    }

    public Vector2i subtractLocal(Vector2i other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public Vector2i subtractLocal(int subtractX, int subtractY) {
        this.x -= subtractX;
        this.y -= subtractY;
        return this;
    }

    public Vector2i multLocal(int scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2i multLocal(Vector2i other) {
        this.x *= other.x;
        this.y *= other.y;
        return this;
    }

    public Vector2i multLocal(int multX, int multY) {
        this.x *= multX;
        this.y *= multY;
        return this;
    }

    public Vector2i divideLocal(int scalar) {
        float s = 1.0f / (float)scalar;
        this.x = (int)((float)this.x * s);
        this.y = (int)((float)this.y * s);
        return this;
    }

    public Vector2i divideLocal(Vector2i other) {
        this.x /= other.x;
        this.y /= other.y;
        return this;
    }

    public Vector2i negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2i normalizeLocal() {
        float l = this.length();
        this.x = (int)((float)this.x / l);
        this.y = (int)((float)this.y / l);
        return this;
    }

    public float angleBetween(Vector2i other) {
        float dot = this.dot(other);
        return (float)Math.acos(dot) * 57.295776f;
    }

    public Vector2i zero() {
        this.y = 0;
        this.x = 0;
        return this;
    }

    public boolean isUnitVector() {
        float len = this.length();
        return len >= 0.99f && len <= 1.01f;
    }

    public boolean isOrthogonal(Vector2i other) {
        return this.isOrthogonal(other.x, other.y);
    }

    public boolean isOrthogonal(int x, int y) {
        float dot = this.dot(x, y);
        return dot >= 0.99f && dot <= 1.01f;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector2i) {
            Vector2i v = (Vector2i)o;
            return this.equals(v.x, v.y);
        }
        return false;
    }

    public boolean equals(int x, int y) {
        return this.x == x && this.y == y;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + this.x;
        hash = 47 * hash + this.y;
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

