/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import net.risingworld.api.utils.Vector2i;

public class Vector2f {
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    public static final Vector2i ONE = new Vector2i(1, 1);
    public static final Vector2f UNIT_X = new Vector2f(1.0f, 0.0f);
    public static final Vector2f UNIT_Y = new Vector2f(0.0f, 1.0f);
    public float x;
    public float y;

    public Vector2f() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(Vector2f copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public Vector2f copy() {
        return new Vector2f(this.x, this.y);
    }

    public Vector2f set(Vector2f vector) {
        return this.set(vector.x, vector.y);
    }

    public Vector2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2f setX(float x) {
        this.x = x;
        return this;
    }

    public Vector2f setY(float y) {
        this.y = y;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float dot(Vector2f other) {
        return this.dot(other.x, other.y);
    }

    public float dot(float x, float y) {
        return this.x * x + this.y * y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distance(Vector2f other) {
        return (float)Math.sqrt(this.distanceSquared(other.x, other.y));
    }

    public float distance(float x, float y) {
        return (float)Math.sqrt(this.distanceSquared(x, y));
    }

    public float distanceSquared(Vector2f other) {
        return this.distanceSquared(other.x, other.y);
    }

    public float distanceSquared(float x, float y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return (float)(dx * dx + dy * dy);
    }

    public Vector2f addLocal(Vector2f other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    public Vector2f addLocal(float addX, float addY) {
        this.x += addX;
        this.y += addY;
        return this;
    }

    public Vector2f subtractLocal(Vector2f other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public Vector2f subtractLocal(float subtractX, float subtractY) {
        this.x -= subtractX;
        this.y -= subtractY;
        return this;
    }

    public Vector2f multLocal(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2f multLocal(Vector2f other) {
        this.x *= other.x;
        this.y *= other.y;
        return this;
    }

    public Vector2f multLocal(float multX, float multY) {
        this.x *= multX;
        this.y *= multY;
        return this;
    }

    public Vector2f divideLocal(float scalar) {
        float s = 1.0f / scalar;
        this.x *= s;
        this.y *= s;
        return this;
    }

    public Vector2f divideLocal(Vector2f other) {
        this.x /= other.x;
        this.y /= other.y;
        return this;
    }

    public Vector2f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f normalizeLocal() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        return this;
    }

    public float angleBetween(Vector2f other) {
        float dot = this.dot(other);
        return (float)Math.acos(dot) * 57.295776f;
    }

    public Vector2f zero() {
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public boolean isUnitVector() {
        float len = this.length();
        return len >= 0.99f && len <= 1.01f;
    }

    public boolean isOrthogonal(Vector2f other) {
        return this.isOrthogonal(other.x, other.y);
    }

    public boolean isOrthogonal(float x, float y) {
        float dot = this.dot(x, y);
        return dot >= 0.99f && dot <= 1.01f;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector2f) {
            Vector2f v = (Vector2f)o;
            return this.equals(v.x, v.y);
        }
        return false;
    }

    public boolean equals(float x, float y) {
        return this.x == x && this.y == y;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Float.floatToIntBits(this.x);
        hash = 47 * hash + Float.floatToIntBits(this.y);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

