/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.nio.ByteBuffer;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleKeyword;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Utils;

public final class StyleColor
extends StyleField {
    private int color;
    private StyleKeyword keyword;

    StyleColor() {
        this.color = 0;
        this.keyword = StyleKeyword.Null;
    }

    StyleColor(float r, float g, float b, float a) {
        this(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    StyleColor(int color) {
        this.color = color;
        this.keyword = StyleKeyword.Undefined;
    }

    StyleColor(StyleKeyword keyword) {
        this.color = 0;
        this.keyword = keyword;
    }

    public void set(ColorRGBA color) {
        this.set(color == null ? 0 : color.toIntRGBA());
    }

    public void set(float r, float g, float b, float a) {
        this.set(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void set(int color) {
        if (this.color != color || this.keyword != StyleKeyword.Undefined) {
            this.isDirty = true;
            this.color = color;
            this.keyword = StyleKeyword.Undefined;
        }
    }

    public void set(StyleKeyword keyword) {
        this.isDirty = true;
        this.keyword = keyword;
    }

    @Override
    public void reset() {
        this.set(StyleKeyword.Null);
    }

    public int get() {
        return this.color;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put((byte)this.keyword.ordinal());
        buffer.putInt(this.color);
    }

    @Override
    void deserialize(ByteBuffer buffer) {
        this.keyword = StyleKeyword.get(buffer.get());
        this.color = buffer.getInt();
    }
}

