/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects.world;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.risingworld.api.World;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Plants;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class Plant {
    final long globalID;
    final int cx;
    final int cy;
    final int cz;
    private static ConcurrentHashMap<Long, ConcurrentHashMap<String, Object>> attributes = null;

    Plant(long id, int cx, int cy, int cz) {
        this.globalID = id;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
    }

    public boolean isValid() {
        return this.isValid(this.globalID, this.cx, this.cy, this.cz);
    }

    public long getGlobalID() {
        return this.globalID;
    }

    public int getChunkPositionX() {
        return this.cx;
    }

    public int getChunkPositionY() {
        return this.cy;
    }

    public int getChunkPositionZ() {
        return this.cz;
    }

    public short getTypeID() {
        return this.getTypeID(this.globalID, this.cx, this.cy, this.cz);
    }

    public Plants.PlantDefinition getDefinition() {
        return Definitions.getPlantDefinition(this.getTypeID());
    }

    public int getPlayerDbID() {
        return this.getPlayerDbID(this.globalID, this.cx, this.cy, this.cz);
    }

    public void setPlayerDbID(int dbID) {
        this.setPlayerDbID(this.globalID, this.cx, this.cy, this.cz, dbID);
    }

    public long getCreationDate() {
        return this.getCreationDate(this.globalID, this.cx, this.cy, this.cz);
    }

    public Vector3f getWorldPosition() {
        return this.getWorldPosition(this.globalID, this.cx, this.cy, this.cz);
    }

    public Quaternion getRotation() {
        return this.getRotation(this.globalID, this.cx, this.cy, this.cz);
    }

    public void setRotation(Quaternion rotation) {
        this.setRotation(this.globalID, this.cx, this.cy, this.cz, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public Vector3f getScale() {
        return this.getScale(this.globalID, this.cx, this.cy, this.cz);
    }

    public void setScale(float x, float y, float z) {
        this.setScale(this.globalID, this.cx, this.cy, this.cz, x, y, z);
    }

    public void setScale(Vector3f scale) {
        this.setScale(this.globalID, this.cx, this.cy, this.cz, scale.x, scale.y, scale.z);
    }

    public int getColor() {
        return this.getColor(this.globalID, this.cx, this.cy, this.cz);
    }

    public void setColor(int color) {
        this.setColor(this.globalID, this.cx, this.cy, this.cz, color);
    }

    public void setColor(ColorRGBA color) {
        this.setColor(this.globalID, this.cx, this.cy, this.cz, color == null ? 0 : color.toIntRGBA());
    }

    public boolean isCut() {
        return this.isCut(this.globalID, this.cx, this.cy, this.cz);
    }

    public short getStrength() {
        return this.getStrength(this.globalID, this.cx, this.cy, this.cz);
    }

    public void setStrength(short strength) {
        this.setStrength(this.globalID, this.cx, this.cy, this.cz, strength);
    }

    public void destroy(boolean silent) {
        World.removePlant(this.globalID, this.cx, this.cy, this.cz, false, !silent);
    }

    public void setAttribute(String key, Object value) {
        if (this.globalID == 0L) {
            return;
        }
        if (attributes == null) {
            attributes = new ConcurrentHashMap(10, 0.9f, 1);
        }
        if (value == null) {
            this.deleteAttribute(key);
        } else {
            ConcurrentHashMap<String, Object> map = attributes.get(this.globalID);
            if (map == null) {
                map = new ConcurrentHashMap(10, 0.9f, 1);
                attributes.put(this.globalID, map);
            }
            map.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        if (attributes == null || key == null) {
            return null;
        }
        ConcurrentHashMap<String, Object> map = attributes.get(this.globalID);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public boolean hasAttribute(String key) {
        ConcurrentHashMap<String, Object> map;
        if (attributes != null && key != null && (map = attributes.get(this.globalID)) != null) {
            return map.contains(key);
        }
        return false;
    }

    public boolean hasAttribute(String key, Class type) {
        if (attributes == null || key == null) {
            return false;
        }
        ConcurrentHashMap<String, Object> map = attributes.get(this.globalID);
        if (map != null) {
            Object attribute = map.get(key);
            return attribute != null && attribute.getClass() == type;
        }
        return false;
    }

    public void deleteAttribute(String key) {
        ConcurrentHashMap<String, Object> map;
        if (attributes != null && key != null && (map = attributes.get(this.globalID)) != null) {
            map.remove(key);
        }
    }

    public Set<Map.Entry<String, Object>> getAttributes() {
        ConcurrentHashMap<String, Object> map;
        if (attributes != null && (map = attributes.get(this.globalID)) != null) {
            return map.entrySet();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof Plant) {
            return ((Plant)o).globalID == this.globalID;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (int)(this.globalID ^ this.globalID >>> 32);
        return hash;
    }

    private native boolean isValid(long var1, int var3, int var4, int var5);

    private native short getTypeID(long var1, int var3, int var4, int var5);

    private native int getPlayerDbID(long var1, int var3, int var4, int var5);

    private native void setPlayerDbID(long var1, int var3, int var4, int var5, int var6);

    private native long getCreationDate(long var1, int var3, int var4, int var5);

    private native Vector3f getWorldPosition(long var1, int var3, int var4, int var5);

    private native void setWorldPosition(long var1, int var3, int var4, int var5, float var6, float var7, float var8);

    private native Quaternion getRotation(long var1, int var3, int var4, int var5);

    private native void setRotation(long var1, int var3, int var4, int var5, float var6, float var7, float var8, float var9);

    private native Vector3f getScale(long var1, int var3, int var4, int var5);

    private native void setScale(long var1, int var3, int var4, int var5, float var6, float var7, float var8);

    private native int getColor(long var1, int var3, int var4, int var5);

    private native void setColor(long var1, int var3, int var4, int var5, int var6);

    private native boolean isCut(long var1, int var3, int var4, int var5);

    private native void setCut(long var1, int var3, int var4, int var5, boolean var6);

    private native int getFlags(long var1, int var3, int var4, int var5);

    private native void setFlags(long var1, int var3, int var4, int var5, int var6);

    private native short getStrength(long var1, int var3, int var4, int var5);

    private native void setStrength(long var1, int var3, int var4, int var5, short var6);

    public static enum Flags {
        None(0),
        DisableGrowth(1),
        DisableGravity(2);

        private int value;

        private Flags(int value) {
            this.value = value;
        }
    }
}

