/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.world;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import net.risingworld.api.events.Event;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.world.generator.PlantInfo;

final class GenerateWorldPartEvent
extends Event {
    private int wpx = Integer.MAX_VALUE;
    private int wpz = Integer.MAX_VALUE;
    public static final int WORLDPART_SIZE = 512;
    public static final int WORLDPART_CHUNKS = 512 / Utils.ChunkUtils.CHUNK_SIZE_X;

    private GenerateWorldPartEvent(long pointer) {
        super(pointer);
    }

    public int getWorldPartX() {
        this.CheckIsValid();
        if (this.wpx == Integer.MAX_VALUE) {
            this.wpx = this.getWorldPartX(this.pointer);
        }
        return this.wpx;
    }

    public int getWorldPartZ() {
        this.CheckIsValid();
        if (this.wpz == Integer.MAX_VALUE) {
            this.wpz = this.getWorldPartZ(this.pointer);
        }
        return this.wpz;
    }

    public float[] getTerrain() {
        this.CheckIsValid();
        return this.getTerrain(this.pointer);
    }

    public byte[] getTerrainTextures() {
        this.CheckIsValid();
        return this.getTextures(this.pointer);
    }

    public void setTerrain(float[] heightmap, byte[] textures) {
        this.CheckIsValid();
        this.setTerrain(this.pointer, heightmap, textures);
    }

    public ArrayList<PlantInfo> getPlants() {
        this.CheckIsValid();
        byte[] data = this.getPlants(this.pointer);
        if (data == null || data.length < 4) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int len = bb.getInt();
        ArrayList<PlantInfo> plants = new ArrayList<PlantInfo>(len);
        for (int i = 0; i < len; ++i) {
            PlantInfo p = new PlantInfo();
            p.typeID = bb.getShort();
            p.x = bb.getShort();
            p.y = GenerateWorldPartEvent.heightToFloat(bb.getShort());
            p.z = bb.getShort();
            p.rx = (int)((float)bb.get() / 255.0f * 360.0f);
            p.ry = (int)((float)bb.get() / 255.0f * 360.0f);
            p.rz = (int)((float)bb.get() / 255.0f * 360.0f);
            p.scaleFactor = (float)bb.get() * 0.01f;
            p.isCut = bb.get() == 1;
            plants.add(p);
        }
        return plants;
    }

    public void setPlants(ArrayList<PlantInfo> plants) {
        this.CheckIsValid();
        if (plants == null) {
            this.setPlants(this.pointer, null);
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(4 + 13 * plants.size());
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(plants.size());
        for (PlantInfo p : plants) {
            bb.putShort(p.typeID);
            bb.putShort((short)(p.x + 0.5f));
            bb.putShort(GenerateWorldPartEvent.floatToHeight(p.y));
            bb.putShort((short)(p.z + 0.5f));
            bb.put((byte)Utils.MathUtils.clamp(0.0f, 255.0f, 0.7083333f * (float)(p.rx % 360)));
            bb.put((byte)Utils.MathUtils.clamp(0.0f, 255.0f, 0.7083333f * (float)(p.ry % 360)));
            bb.put((byte)Utils.MathUtils.clamp(0.0f, 255.0f, 0.7083333f * (float)(p.rz % 360)));
            bb.put((byte)Utils.MathUtils.clamp(1.0f, 100.0f, p.scaleFactor * 100.0f));
            bb.put(p.isCut ? (byte)1 : 0);
        }
        this.setPlants(this.pointer, bb.array());
    }

    public boolean isPositionInWorldPart(int x, int z) {
        int ix = x - this.getWorldPartX() * 512;
        int iz = z - this.getWorldPartZ() * 512;
        return ix >= -2 && ix < 514 && iz >= -2 && iz < 514;
    }

    public int getIndexFromPosition(int x, int z) {
        int ix = x - this.getWorldPartX() * 512;
        int iz = z - this.getWorldPartZ() * 512;
        return GenerateWorldPartEvent.getRawIndex(ix + 2, iz + 2);
    }

    public int getLocalPositionX(int x) {
        return x - this.getWorldPartX() * 512;
    }

    public int getLocalPositionZ(int z) {
        return z - this.getWorldPartZ() * 512;
    }

    public int getGlobalPositionX(int x) {
        return x + this.getWorldPartX() * 512;
    }

    public int getGlobalPositionZ(int z) {
        return z + this.getWorldPartZ() * 512;
    }

    public static float[] createEmptyHeightmap() {
        return new float[266256];
    }

    public static byte[] createEmptyTexturemap() {
        return new byte[266256];
    }

    public static byte[] createTexturemap(byte textureID) {
        byte[] data = GenerateWorldPartEvent.createEmptyTexturemap();
        Arrays.fill(data, textureID);
        return data;
    }

    public static int getRawIndex(int x, int z) {
        return x + z * 516;
    }

    private static float heightToFloat(short height) {
        return 0.03125f * (float)height;
    }

    private static short floatToHeight(float f) {
        return (short)(32.0f * f);
    }

    private native int getWorldPartX(long var1);

    private native int getWorldPartZ(long var1);

    private native void setTerrain(long var1, float[] var3, byte[] var4);

    private native float[] getTerrain(long var1);

    private native byte[] getTextures(long var1);

    private native byte[] getPlants(long var1);

    private native void setPlants(long var1, byte[] var3);
}

