/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

abstract class _WorldElement {
    int id;
    Vector3f position = new Vector3f();
    Quaternion rotation = new Quaternion();
    float visibleRange = 100.0f;
    ConcurrentHashMap<String, Object> attributes = null;
    private static AtomicInteger id_counter = new AtomicInteger();

    _WorldElement() {
        this.id = id_counter.getAndIncrement();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getID() {
        return this.id;
    }

    public void setPosition(Vector3f position) {
        if (!this.position.equals(position)) {
            this.position.set(position);
        }
    }

    public void setPosition(float x, float y, float z) {
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            this.position.set(x, y, z);
        }
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void moveTo(Vector3f position, float speed) {
        if (!this.position.equals(position)) {
            this.position.set(position);
        }
    }

    public void moveTo(float x, float y, float z, float speed) {
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            this.position.set(x, y, z);
        }
    }

    public void setRotation(Quaternion rotation) {
        if (!this.rotation.equals(rotation)) {
            this.rotation.set(rotation);
        }
    }

    public void setRotation(float pitch, float yaw, float roll) {
        this.rotation.fromAngles(pitch, yaw, roll);
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setVisibleRange(float range) {
        if (this.visibleRange != range) {
            this.visibleRange = range;
        }
    }

    public float getVisibleRange() {
        return this.visibleRange;
    }

    public void destroy() {
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap(10, 0.9f, 1);
        }
        if (value == null) {
            this.deleteAttribute(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        if (this.attributes == null || key == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public void deleteAttribute(String key) {
        if (this.attributes != null && key != null) {
            this.attributes.remove(key);
        }
    }

    public void refresh() {
    }
}

