/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.io.Serializable;
import net.risingworld.api.utils.Utils;

public class Vector3f
implements Serializable {
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f RIGHT = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f LEFT = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f DOWN = new Vector3f(0.0f, -1.0f, 0.0f);
    public static final Vector3f FORWARD = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f BACK = new Vector3f(0.0f, 0.0f, -1.0f);
    public float x;
    public float y;
    public float z;

    public Vector3f() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(Vector3f copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Vector3f copy() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public Vector3f set(Vector3f vector) {
        return this.set(vector.x, vector.y, vector.z);
    }

    public Vector3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3f setX(float x) {
        this.x = x;
        return this;
    }

    public Vector3f setY(float y) {
        this.y = y;
        return this;
    }

    public Vector3f setZ(float z) {
        this.z = z;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float dot(Vector3f other) {
        return this.dot(other.x, other.y, other.z);
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(Vector3f other) {
        return (float)Math.sqrt(this.distanceSquared(other.x, other.y, other.z));
    }

    public float distance(float x, float y, float z) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z));
    }

    public float distanceSquared(Vector3f other) {
        return this.distanceSquared(other.x, other.y, other.z);
    }

    public float distanceSquared(float x, float y, float z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return (float)(dx * dx + dy * dy + dz * dz);
    }

    public Vector3f add(Vector3f other) {
        return new Vector3f(this).addLocal(other);
    }

    public Vector3f add(float addX, float addY, float addZ) {
        return new Vector3f(this).addLocal(addX, addY, addZ);
    }

    public Vector3f addLocal(Vector3f other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public Vector3f addLocal(float addX, float addY, float addZ) {
        this.x += addX;
        this.y += addY;
        this.z += addZ;
        return this;
    }

    public Vector3f subtract(Vector3f other) {
        return new Vector3f(this).subtractLocal(other);
    }

    public Vector3f subtract(float subtractX, float subtractY, float subtractZ) {
        return new Vector3f(this).subtractLocal(subtractX, subtractY, subtractZ);
    }

    public Vector3f subtractLocal(Vector3f other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public Vector3f subtractLocal(float subtractX, float subtractY, float subtractZ) {
        this.x -= subtractX;
        this.y -= subtractY;
        this.z -= subtractZ;
        return this;
    }

    public Vector3f mult(float scalar) {
        return new Vector3f(this).multLocal(scalar);
    }

    public Vector3f mult(Vector3f other) {
        return new Vector3f(this).multLocal(other);
    }

    public Vector3f mult(float multX, float multY, float multZ) {
        return new Vector3f(this).multLocal(multX, multY, multZ);
    }

    public Vector3f multLocal(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3f multLocal(Vector3f other) {
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
        return this;
    }

    public Vector3f multLocal(float multX, float multY, float multZ) {
        this.x *= multX;
        this.y *= multY;
        this.z *= multZ;
        return this;
    }

    public Vector3f divide(Vector3f other) {
        return new Vector3f(this).divideLocal(other);
    }

    public Vector3f divideLocal(float scalar) {
        float s = 1.0f / scalar;
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    public Vector3f divideLocal(Vector3f other) {
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
        return this;
    }

    public Vector3f negate() {
        return new Vector3f(this).negateLocal();
    }

    public Vector3f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f cross(Vector3f other) {
        return new Vector3f(this).crossLocal(other);
    }

    public Vector3f crossLocal(Vector3f other) {
        return this.crossLocal(other.x, other.y, other.z);
    }

    public Vector3f crossLocal(float v2x, float v2y, float v2z) {
        float nx = this.y * v2z - this.z * v2y;
        float ny = this.z * v2x - this.x * v2z;
        float nz = this.x * v2y - this.y * v2x;
        this.x = nx;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public Vector3f normalize() {
        return new Vector3f(this).normalizeLocal();
    }

    public Vector3f normalizeLocal() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        this.z /= l;
        return this;
    }

    public float angleBetween(Vector3f other) {
        float num = Utils.MathUtils.sqrt(this.lengthSquared() * other.lengthSquared());
        if (num < 1.0E-15f) {
            return 0.0f;
        }
        float dot = Utils.MathUtils.clamp(-1.0f, 1.0f, this.dot(other) / num);
        return (float)Math.acos(dot) * 57.295776f;
    }

    public boolean isUnitVector() {
        float len = this.length();
        return len >= 0.99f && len <= 1.01f;
    }

    public boolean isOrthogonal(Vector3f other) {
        return this.isOrthogonal(other.x, other.y, other.z);
    }

    public boolean isOrthogonal(float x, float y, float z) {
        float dot = this.dot(x, y, z);
        return dot >= 0.99f && dot <= 1.01f;
    }

    public Vector3f interpolateLocal(Vector3f finalVector, float mu) {
        this.x = (1.0f - mu) * this.x + mu * finalVector.x;
        this.y = (1.0f - mu) * this.y + mu * finalVector.y;
        this.z = (1.0f - mu) * this.z + mu * finalVector.z;
        return this;
    }

    public Vector3f interpolateLocal(Vector3f startVector, Vector3f finalVector, float mu) {
        this.x = (1.0f - mu) * startVector.x + mu * finalVector.x;
        this.y = (1.0f - mu) * startVector.y + mu * finalVector.y;
        this.z = (1.0f - mu) * startVector.z + mu * finalVector.z;
        return this;
    }

    public Vector3f interpolate(Vector3f startVector, Vector3f finalVector, float mu) {
        Vector3f v = new Vector3f(startVector);
        return v.interpolateLocal(finalVector, mu);
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3f) {
            Vector3f v = (Vector3f)o;
            return this.equals(v.x, v.y, v.z);
        }
        return false;
    }

    public boolean equals(float x, float y, float z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Float.floatToIntBits(this.x);
        hash = 47 * hash + Float.floatToIntBits(this.y);
        hash = 47 * hash + Float.floatToIntBits(this.z);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vector3f fromString(String input) {
        if (input == null || input.isEmpty()) {
            return this;
        }
        this.set(0.0f, 0.0f, 0.0f);
        String[] values = input.replaceAll("[()\\[\\]\\s]+", "").split(",");
        if (values.length >= 3) {
            if (Utils.StringUtils.isNumeric(values[0])) {
                this.x = Float.parseFloat(values[0]);
            }
            if (Utils.StringUtils.isNumeric(values[1])) {
                this.y = Float.parseFloat(values[1]);
            }
            if (Utils.StringUtils.isNumeric(values[2])) {
                this.z = Float.parseFloat(values[2]);
            }
        }
        return this;
    }
}

