/*
 * Decompiled with CFR 0.152.
 */
package de.sbg.unity.configmanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class ConfigData {
    private final Properties newConfig;
    private final Properties oldConfig;
    private final String fullpath;
    private final String name;
    private final File File;
    private final ArrayList<Sender> newSenderList;
    private final ArrayList<String> oldSenderList;
    private final ArrayList<String> KeyList;
    private final String Extention;
    private final boolean oldExist;
    private final HashMap<String, Sender> SenderList;

    public ConfigData(String path) throws IOException {
        this.Extention = ".properties.";
        this.name = "/Config";
        this.newConfig = new Properties();
        this.oldConfig = new Properties();
        this.newSenderList = new ArrayList();
        this.oldSenderList = new ArrayList();
        this.fullpath = path + this.name + this.Extention;
        this.KeyList = new ArrayList();
        this.File = new File(this.fullpath);
        this.SenderList = new HashMap();
        this.oldExist = this.iniOld();
    }

    public ConfigData(String path, String name) throws IOException {
        this.Extention = ".properties";
        this.name = "/" + name;
        this.newConfig = new Properties();
        this.oldConfig = new Properties();
        this.newSenderList = new ArrayList();
        this.oldSenderList = new ArrayList();
        this.KeyList = new ArrayList();
        this.fullpath = path + name + this.Extention;
        this.File = new File(this.fullpath);
        this.SenderList = new HashMap();
        this.oldExist = this.iniOld();
    }

    public ConfigData(String path, String name, String extention) throws IOException {
        this.Extention = extention;
        this.name = "/" + name;
        this.newConfig = new Properties();
        this.oldConfig = new Properties();
        this.newSenderList = new ArrayList();
        this.oldSenderList = new ArrayList();
        this.KeyList = new ArrayList();
        this.fullpath = path + name + extention;
        this.File = new File(this.fullpath);
        this.SenderList = new HashMap();
        this.oldExist = this.iniOld();
    }

    private boolean iniOld() throws IOException {
        if (this.File.exists()) {
            FileInputStream fis = new FileInputStream(this.fullpath);
            this.oldConfig.load(fis);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WriteToFile() {
        PrintWriter pWriter = null;
        try {
            pWriter = new PrintWriter(new FileWriter(this.fullpath, false));
            if (!this.newSenderList.isEmpty()) {
                block9: for (Sender send : this.newSenderList) {
                    switch (send.Typ) {
                        case Commend: {
                            pWriter.println(send.key);
                            continue block9;
                        }
                        case Property: {
                            pWriter.println(send.key + "=" + send.value);
                            continue block9;
                        }
                    }
                    pWriter.println();
                }
            } else {
                System.out.println("[ConfigManager WARNING] No values for Config found!");
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            if (pWriter != null) {
                pWriter.flush();
                pWriter.close();
            }
        }
    }

    public void CreateConfig() throws IOException {
        if (this.File.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(this.fullpath));
                String zeile = null;
                while ((zeile = in.readLine()) != null) {
                    this.oldSenderList.add(zeile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this.hatChange()) {
                this.WriteToFile();
            }
        } else {
            this.WriteToFile();
        }
    }

    public void setSetting(String key, Object value) {
        String stValue = String.valueOf(value);
        this.newConfig.setProperty(key, stValue);
        this.SenderList.get((Object)key).value = stValue;
        this.WriteToFile();
    }

    public String getSetting(String key) {
        return String.valueOf(this.newConfig.getProperty(key));
    }

    public ArrayList<String> getKeys() {
        return this.KeyList;
    }

    public boolean hatChange() {
        return this.oldSenderList.size() != this.newSenderList.size();
    }

    public void addCommend(String command) {
        this.newSenderList.add(new Sender(this, command));
    }

    public void addSetting(String key, Object value) {
        Sender send;
        String sValue = String.valueOf(value);
        this.KeyList.add(key);
        if (this.oldExist) {
            if (this.oldConfig.containsKey(key)) {
                send = new Sender(this, Typ.Property, key, this.oldConfig.getProperty(key));
                this.newSenderList.add(send);
                this.newConfig.setProperty(key, this.oldConfig.getProperty(key));
            } else {
                send = new Sender(this, Typ.Property, key, sValue);
                this.newSenderList.add(send);
                this.newConfig.setProperty(key, sValue);
            }
        } else {
            send = new Sender(this, Typ.Property, key, sValue);
            this.newSenderList.add(send);
            this.newConfig.setProperty(key, sValue);
        }
        this.SenderList.put(key, send);
    }

    public void addEmptyLine() {
        this.newSenderList.add(new Sender(this));
    }

    public String getConfigName() {
        return this.name;
    }

    public String getExtention() {
        return this.Extention;
    }

    public File getFile() {
        return this.File;
    }

    public String getFullpath() {
        return this.fullpath;
    }

    public boolean isOldExist() {
        return this.oldExist;
    }

    private class Sender {
        private Typ Typ;
        private String key;
        private String value;

        public Sender(ConfigData configData) {
            this.Typ = de.sbg.unity.configmanager.ConfigData$Typ.EmptyLine;
            this.key = null;
            this.value = null;
        }

        public Sender(ConfigData configData, String command) {
            this.Typ = de.sbg.unity.configmanager.ConfigData$Typ.Commend;
            this.key = command;
            this.value = null;
        }

        public Sender(ConfigData configData, Typ Typ2, String key, String value) {
            this.Typ = Typ2;
            this.key = key;
            this.value = value;
        }
    }

    private static enum Typ {
        Property,
        EmptyLine,
        Commend;

    }
}

