/*
 * Decompiled with CFR 0.152.
 */
package CorpseLocator;

import CorpseLocator.CorpseLocatorDb;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDeathEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class CorpseLocator
extends Plugin
implements Listener {
    public CorpseLocatorDb Db;
    public Integer teleportenable;
    public Integer locateenable;

    public void onEnable() {
        try {
            this.registerEventListener(this);
            this.Db = new CorpseLocatorDb(this);
            this.Db.createDb();
            this.teleportenable = this.Db.loadSettingsTeleport();
            this.locateenable = this.Db.loadSettingsLocate();
        }
        catch (SQLException ex) {
            Logger.getLogger(CorpseLocator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onDisable() {
    }

    @EventMethod
    public void playerConnect(PlayerConnectEvent evt) throws SQLException {
        long playerid = Long.parseLong(evt.getPlayer().getUID());
        this.initPlayer(playerid, evt.getPlayer());
    }

    public void initPlayer(long playerid, Player player) throws SQLException {
        this.Db.Check(playerid);
        boolean isNew = this.Db.Check(playerid);
        if (isNew) {
            this.Db.addNewPlayer(playerid);
        }
        if (!isNew) {
            Vector3f corpseLocation = this.Db.loadPlayer(playerid);
            player.setAttribute("corpseLocation", (Object)corpseLocation);
        }
    }

    @EventMethod
    public void playerDeath(PlayerDeathEvent evt) {
        Player player = evt.getPlayer();
        long playerid = Long.parseLong(player.getUID());
        Vector3f corpseLocation = evt.getDeathPosition();
        player.setAttribute("corpseLocation", (Object)corpseLocation);
        this.Db.updatePlayer(playerid, corpseLocation);
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent command) {
        Player player = command.getPlayer();
        String[] cmd = command.getCommand().split(" ");
        if (cmd[0].equalsIgnoreCase("/Corpse")) {
            if (cmd.length != 2) {
                player.sendTextMessage("Invalid Command!");
                return;
            }
            if (!player.hasAttribute("corpseLocation")) {
                player.sendTextMessage("No Corpse Found");
                return;
            }
            Vector3f corpseLocation = (Vector3f)player.getAttribute("corpseLocation");
            if (cmd[1].equalsIgnoreCase("Locate")) {
                if (this.locateenable == 0) {
                    player.sendTextMessage("Locate Is Disabled");
                    return;
                }
                if (this.locateenable == 1) {
                    if (corpseLocation.x == 0.0f || corpseLocation.y == 0.0f || corpseLocation.z == 0.0f) {
                        player.sendTextMessage("No Corpse Found");
                        return;
                    }
                    String deathText = corpseLocation.toString();
                    player.sendTextMessage("Location " + deathText);
                    return;
                }
            }
            if (cmd[1].equalsIgnoreCase("Teleport")) {
                if (this.teleportenable == 0) {
                    player.sendTextMessage("Teleport Is Disabled");
                    return;
                }
                if (this.teleportenable == 1) {
                    if (corpseLocation.x == 0.0f || corpseLocation.y == 0.0f || corpseLocation.z == 0.0f) {
                        player.sendTextMessage("No Corpse Found");
                        return;
                    }
                    player.setPosition(corpseLocation);
                    return;
                }
            } else {
                player.sendTextMessage("Invalid Command!");
            }
        }
        if (cmd[0].equalsIgnoreCase("/Corpse!") && player.isAdmin()) {
            if (cmd.length != 2) {
                player.sendTextMessage("Invalid Command");
                return;
            }
            if (cmd[1].equalsIgnoreCase("Locate")) {
                if (this.locateenable == 0) {
                    this.locateenable = 1;
                    this.Db.Save(this.locateenable, "locate");
                    player.sendTextMessage("Corpse Locate Enabled");
                    return;
                }
                if (this.locateenable == 1) {
                    this.locateenable = 0;
                    this.Db.Save(this.locateenable, "locate");
                    player.sendTextMessage("Corpse Locate Disabled");
                    return;
                }
            }
            if (cmd[1].equalsIgnoreCase("Teleport")) {
                if (this.teleportenable == 0) {
                    this.teleportenable = 1;
                    this.Db.Save(this.teleportenable, "Teleport");
                    player.sendTextMessage("Corpse Teleport Enabled");
                    return;
                }
                if (this.teleportenable == 1) {
                    this.teleportenable = 0;
                    this.Db.Save(this.teleportenable, "Teleport");
                    player.sendTextMessage("Corpse Teleport Disabled");
                    return;
                }
            } else {
                player.sendTextMessage("Invalid Command!");
            }
        }
    }
}

