-------------------------------------------------------------------------------
-- Copyright (c) 2015, Script by s3mt3x (http://www.rw-stats.com) --
-------------------------------------------------------------------------------
include("functions.lua")
include("database.lua")
include("positions.lua")
include("help.lua")
include("messages.lua")

database = getDatabase()

function onEnable()
	create_database()
	create_cache()
    print("Teleport plugin loaded.")
end
function onDisable()
	print("Teleport plugin stopped!")
end

function onPlayerCommand(event)
	local cmd = StringUtils:explode(event.command, " ")
	local command = cmd[1]
	local value = cmd[2]

	-- Player
	if command == "/teleport" then

		if value == "help" then
			get_player_help(event)
		elseif value == "list" then
			get_positions_db(event, cmd[3])
		else
			local value = int(value)

			if type(value) == "number" then
				if isempty(position[value]) == true then
					event.player:sendTextMessage("[#ff0000]Error: [#00ff12]Unknown Position ID")
				else
					player_teleport("player", event, position[value].x, position[value].y, position[value].z)
				end
			else
				get_positions_db(event, cmd[3])
			end
		end

	-- Admin
	elseif command == "/teleportadmin" then
		if event.player:isAdmin() then

			if value == "help" then
				get_admin_help(event)
			elseif value == "set" then
				-- local position_name = cmd[3]
				local position_name = string.sub(event.command, string.len(cmd[1]) + 6);

				if (string.len(position_name) >= 4) then
					local position_value = split(tostring(event.player:getPosition()))
					database:queryupdate("INSERT INTO teleport (position_name, position_x, position_y, position_z) VALUES ('" .. position_name .. "','" .. position_value[1] .. "','" .. position_value[2] .. "','" .. position_value[3] .. "');")
					event.player:sendTextMessage("[#00ff00]Position Set: " .. position_name .. " on X:".. position_value[1] .." Y:".. position_value[2] .." Z:".. position_value[2] .."")
					create_cache()
											
				end

			elseif value == "del" then
				local position_id = int(cmd[3])
				if type(position_id) == "number" then
					database:queryupdate("DELETE FROM teleport WHERE position_id = '" .. position_id .. "'")
					event.player:sendTextMessage("[#ff0000]Position " .. position_id .. " Deleted")
					create_cache()
									
				end

			elseif value == "edit" then
				local position_id = int(cmd[3])
				if type(position_id) == "number" then
					local position_value = split(tostring(event.player:getPosition()))
					database:queryupdate("UPDATE teleport SET position_x = '"..position_value[1].."', position_y = '"..position_value[2].."', position_z = '"..position_value[3].."' WHERE position_id = '"..position_id.."';")
					event.player:sendTextMessage("[#00ff00]Change Position: "..position_id.." to X:"..position_value[1].." Y:"..position_value[2].." Z:"..position_value[2].."")
					create_cache()
				end
			else
				-- Teleport to x y z
				local x = int(cmd[2])
				local y = int(cmd[3])
				local z = int(cmd[4])

				if type(x) == "number" and type(y) == "number" and type(z) == "number" then
					player_teleport("admin", event, x, y, z)
				end
			end
		end
		

	end
end

function player_teleport(user, event, x, y, z)
	if user == "player" then
		--event.player:setPlayerPosition(x, y, z)
		event.player:setPosition(x, y, z)
	elseif user == "admin" then
		--event.player:setPlayerPosition(x, y, z)
		event.player:setPosition(x, y, z)
	else
		event.player:sendTextMessage("[#ff0000]Error: [#00ff12]Unknown Position or No Admin rights")
	end
end

addEvent("PlayerCommand", onPlayerCommand)
-------------------------------------------------------------------------------
-- Copyright (c) 2015, Script by s3mt3x (http://www.rw-stats.com) --
-------------------------------------------------------------------------------