/*
 * Decompiled with CFR 0.152.
 */
package Wisp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.assets.AssetBundle;
import net.risingworld.api.assets.PrefabAsset;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangePositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerRespawnEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.PlayerTeleportEvent;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.GameObject;
import net.risingworld.api.worldelements.Prefab;
import net.risingworld.api.worldelements.Text3D;

public class Wisp
extends Plugin
implements Listener {
    AssetBundle bundle;
    PrefabAsset asset;
    public ArrayList wisplist;
    public Database wispdb;
    public String WorldName = World.getName();

    public void onEnable() {
        this.registerEventListener(this);
        this.loadWispAsset();
        this.wispdb = this.getSQLiteConnection(this.getPath() + "/" + this.WorldName + "/Wisps.db");
        this.wispdb.execute("CREATE TABLE IF NOT EXISTS `Wisps` (`playerid` BIGINT,`name` VARCHAR(255), `r` REAL, `g` REAL, `b` REAL, `a` REAL, `radius`REAL, `brightness` REAL, `active` INTEGER, `wispscale` REAL, `textscale` REAL)");
        this.wisplist = new ArrayList();
        this.masterWisp();
    }

    public void onDisable() {
    }

    public void loadWispAsset() {
        this.bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/wisp.bundle"));
        this.asset = PrefabAsset.loadFromAssetBundle((AssetBundle)this.bundle, (String)"Wisp.prefab");
        Prefab wisp = new Prefab(this.asset);
        wisp.setLayer(0);
        wisp.setActive(true);
        System.out.println("Wisp Asset Loaded!!!");
    }

    public void masterWisp() {
        ColorRGBA color = new ColorRGBA(1.0f, 0.0f, 1.0f, 0.25f);
        Prefab wisp = new Prefab(this.asset);
        wisp.setLocalPosition(100.0f, 100.0f, 100.0f);
        wisp.setActive(true);
        wisp.setLayer(0);
        wisp.setLocalScale(0.05f, 0.05f, 0.05f);
        wisp.setComponentProperty("Light", "color", (Object)color);
        Text3D wispname = new Text3D("Master Wisp", true);
        wispname.setFontSize(5.0f);
        float xn = 0.0f;
        float yn = 2.5f;
        float zn = 0.0f;
        wispname.setLocalPosition(xn, yn, zn);
        wisp.addChild((GameObject)wispname);
        this.wisplist.add(wisp);
    }

    @EventMethod
    public void playerconnect(PlayerConnectEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        player.registerKeys(new Key[]{Key.U, Key.P, Key.O});
        player.setListenForKeyInput(true);
        this.loadOtherWisps(player);
        ResultSet result = this.wispdb.executeQuery("SELECT * FROM `Wisps` WHERE `playerid` = '" + player.getUID() + "'");
        if (!result.next()) {
            String pname = player.getName();
            this.wispdb.execute("INSERT INTO `Wisps`(playerid, name, r, g, b, a, radius, brightness, active, wispscale, textscale) Values ('" + player.getUID() + "', '" + pname + "', '1.0', '1.0', '1.0', '1.0', '15.0', '100.0', '1', '0.05', '5')");
            this.loadWisp(player, pname, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(15.0f), Float.valueOf(100.0f), 1, Float.valueOf(0.05f), Float.valueOf(5.0f));
        } else {
            String name = result.getString("name");
            float r = Float.valueOf(result.getFloat("r")).floatValue();
            float g = Float.valueOf(result.getFloat("g")).floatValue();
            float b = Float.valueOf(result.getFloat("b")).floatValue();
            float a = Float.valueOf(result.getFloat("a")).floatValue();
            float radius = Float.valueOf(result.getFloat("radius")).floatValue();
            float brightness = Float.valueOf(result.getFloat("brightness")).floatValue();
            int isactive = result.getInt("active");
            float wispscale = Float.valueOf(result.getFloat("wispscale")).floatValue();
            float textscale = Float.valueOf(result.getFloat("textscale")).floatValue();
            this.loadWisp(player, name, Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(a), Float.valueOf(radius), Float.valueOf(brightness), isactive, Float.valueOf(wispscale), Float.valueOf(textscale));
        }
    }

    @EventMethod
    public void playerDisconnect(PlayerDisconnectEvent evt) {
        Player player = evt.getPlayer();
        Prefab wisp = (Prefab)player.getAttribute("wisp");
        this.wisplist.remove(wisp);
        for (Player players : Server.getAllPlayers()) {
            players.removeGameObject((GameObject)wisp);
            player.sendTextMessage(String.valueOf(this.wisplist));
        }
    }

    @EventMethod
    public void playerSpawn(PlayerSpawnEvent evt) {
        Player player = evt.getPlayer();
        player.sendTextMessage("<color=yellow>type </color>/Wisp Help <color=yellow>for wisp help</color> ");
        player.sendTextMessage("<color=yellow>type </color>/Wisp Settings <color=yellow>to open wisp setting's</color> ");
    }

    @EventMethod
    public void playerrespawn(PlayerRespawnEvent evt) {
        Player player = evt.getPlayer();
        Vector3f direction = player.getViewPosition();
        Prefab wisp = (Prefab)player.getAttribute("wisp");
        float x = direction.x - 0.75f;
        float y = direction.y + 0.5f;
        float z = direction.z - 0.75f;
        wisp.setLocalPosition(x, y, z);
    }

    public void loadWisp(Player player, String name, Float r, Float g, Float b, Float a, Float radius, Float brightness, Integer isactive, Float wispscale, Float textscale) {
        float x = player.getViewPosition().x - 0.75f;
        float y = player.getViewPosition().y + 0.5f;
        float z = player.getViewPosition().z - 0.75f;
        float xn = 0.0f;
        float yn = 2.5f;
        float zn = 0.0f;
        boolean active = isactive == 1;
        ColorRGBA color = new ColorRGBA(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
        Prefab wisp = new Prefab(this.asset);
        wisp.setLocalPosition(x, y, z);
        wisp.setActive(active);
        wisp.setLayer(0);
        wisp.setLocalScale(wispscale.floatValue(), wispscale.floatValue(), wispscale.floatValue());
        wisp.setComponentProperty("Light", "color", (Object)color);
        wisp.setComponentProperty("Light", "range", (Object)radius);
        wisp.setComponentProperty("Light", "intensity", (Object)brightness);
        Text3D wispname = new Text3D(name, true);
        wispname.setFontSize(textscale.floatValue());
        wispname.setLocalPosition(xn, yn, zn);
        wisp.addChild((GameObject)wispname);
        player.setAttribute("wispname", (Object)wispname);
        player.setAttribute("wisp", (Object)wisp);
        this.wisplist.add(wisp);
        for (Player players : Server.getAllPlayers()) {
            Prefab wisptoadd = (Prefab)player.getAttribute("wisp");
            players.addGameObject((GameObject)wisptoadd);
        }
        player.setAttribute("wispcolorr", (Object)r);
        player.setAttribute("wispcolorg", (Object)g);
        player.setAttribute("wispcolorb", (Object)b);
        player.setAttribute("wispcolora", (Object)a);
        player.setAttribute("wisprange", (Object)radius);
        player.setAttribute("wispbrightness", (Object)brightness);
        player.setAttribute("isactive", (Object)active);
        player.setAttribute("wispscale", (Object)wispscale);
        player.setAttribute("textscale", (Object)textscale);
        this.wispUi(player);
    }

    public void loadOtherWisps(Player player) {
        int wispcount = this.wisplist.size();
        for (int i = 0; i < wispcount; ++i) {
            Prefab wisp = (Prefab)this.wisplist.get(i);
            player.addGameObject((GameObject)wisp);
        }
    }

    @EventMethod
    public void changepos(PlayerChangePositionEvent evt) {
        float z;
        float y;
        float x;
        Vector3f direction;
        float dist;
        Player player = evt.getPlayer();
        Prefab wisp = (Prefab)player.getAttribute("wisp");
        Vector3f wp = wisp.getLocalPosition();
        Vector3f pp = player.getPosition();
        if (player.isInCave() && (dist = Utils.MathUtils.distance((float)wp.x, (float)wp.y, (float)wp.z, (float)pp.x, (float)pp.y, (float)pp.z)) >= 2.5f) {
            direction = player.getViewPosition();
            x = direction.x - 0.25f;
            y = direction.y + 0.25f;
            z = direction.z - 0.25f;
            if (player.isSprinting()) {
                wisp.moveToLocalPosition(x, y, z, 10.0f);
            } else {
                wisp.moveToLocalPosition(x, y, z, 5.0f);
            }
        }
        if (player.isFlying()) {
            Vector3f direction2 = player.getViewPosition();
            float x2 = direction2.x - 0.25f;
            float y2 = direction2.y + 0.25f;
            float z2 = direction2.z - 0.25f;
            wisp.setLocalPosition(x2, y2, z2);
        } else {
            dist = Utils.MathUtils.distance((float)wp.x, (float)wp.y, (float)wp.z, (float)pp.x, (float)pp.y, (float)pp.z);
            if (dist >= 5.0f) {
                direction = player.getViewPosition();
                x = direction.x - 0.75f;
                y = direction.y + 0.5f;
                z = direction.z - 0.75f;
                if (player.isSprinting()) {
                    wisp.moveToLocalPosition(x, y, z, 10.0f);
                } else {
                    wisp.moveToLocalPosition(x, y, z, 5.0f);
                }
            }
        }
    }

    @EventMethod
    public void playertp(PlayerTeleportEvent evt) {
        Player player = evt.getPlayer();
        Prefab playerwisp = (Prefab)player.getAttribute("wisp");
        playerwisp.setLocalPosition(evt.getTargetPosition());
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent command) throws SQLException {
        Player player = command.getPlayer();
        String[] cmd = command.getCommand().split(" ");
        if (cmd[0].equalsIgnoreCase("/Wisp")) {
            if (cmd.length == 2) {
                if (cmd[1].equalsIgnoreCase("help")) {
                    player.sendTextMessage("Name: <color=yellow>Enter a name into the text field and click Set</color>");
                    player.sendTextMessage("Color: <color=yellow>Enter a value between 0.0 and 1.0 into each field and click set.");
                    player.sendTextMessage("</color> <color=yellow> (example: r 1.0 g 1.0 b 1.0 a 1.0 gives a white color)</color>");
                    player.sendTextMessage("Brightness: <color=yellow>Enter a value between 0.0 and 750.0 and click set</color>");
                    player.sendTextMessage("<color=yellow>Setting this field to 0.0 turns the light off but keeps the wisp visable</color>");
                    player.sendTextMessage("Range: <color=yellow>Enter a value between 1.0 and 25.0 and click set</color>");
                    player.sendTextMessage("Text Scale: <color=yellow>Enter a value between 0.1 and 10.0 and click set</color>");
                    player.sendTextMessage("Scale: <color=yellow>Enter a value between 0.01 and 0.10 and click set</color>");
                    player.sendTextMessage("Enable/Disable Button: <color=yellow>Click this button to enable/disable the wisp</color>");
                    player.sendTextMessage("<color=yellow>**Set the scale setting then the text setting</color>");
                }
                if (cmd[1].equalsIgnoreCase("settings")) {
                    UIElement wispsettingspanel = (UIElement)player.getAttribute("wispsettingspanel");
                    wispsettingspanel.setVisible(true);
                    player.setMouseCursorVisible(true);
                }
            } else {
                player.showStatusMessage("Valid commands are /Wisp Help and Wisp Settings", 10);
            }
        }
    }

    public void wispUi(final Player player) {
        Text3D wispname = (Text3D)player.getAttribute("wispname");
        String name = wispname.getText();
        final UIElement wispsettingspanel = new UIElement();
        wispsettingspanel.setPosition(50.0f, 50.0f, true);
        wispsettingspanel.setPivot(Pivot.MiddleCenter);
        wispsettingspanel.setSize(15.0f, 25.0f, true);
        wispsettingspanel.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.5f);
        wispsettingspanel.setVisible(false);
        wispsettingspanel.setClickable(false);
        wispsettingspanel.setBorder(1.0f);
        wispsettingspanel.setBorderColor(-1);
        wispsettingspanel.setBorderEdgeRadius(5.0f, true);
        player.addUIElement(wispsettingspanel);
        UILabel wslabel = new UILabel();
        wslabel.setPosition(50.0f, 5.0f, true);
        wslabel.setSize(90.0f, 10.0f, true);
        wslabel.setPivot(Pivot.MiddleCenter);
        wslabel.setText("Wisp Settings");
        wispsettingspanel.addChild((UIElement)wslabel);
        UILabel wnlabel = new UILabel();
        wnlabel.setPosition(50.0f, 12.0f, true);
        wnlabel.setSize(10.0f, 10.0f, true);
        wnlabel.setPivot(Pivot.MiddleCenter);
        wnlabel.setText("Name");
        wispsettingspanel.addChild((UIElement)wnlabel);
        final UITextField wntext = new UITextField();
        wntext.setText(name);
        wntext.setMaxCharacters(20);
        wntext.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.5f);
        wntext.setFontSize(13.0f);
        wntext.setBorder(1.0f);
        wntext.setBorderColor(-1);
        wntext.setSize(50.0f, 8.0f, true);
        wntext.setPosition(40.0f, 21.0f, true);
        wntext.setPivot(Pivot.MiddleCenter);
        wntext.setVisible(true);
        wntext.setClickable(true);
        wispsettingspanel.addChild((UIElement)wntext);
        UILabel wsnameset = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                wntext.getCurrentText(player, wname -> Wisp.this.SaveName(player, (String)wname));
            }
        };
        wsnameset.setPosition(75.0f, 21.0f, true);
        wsnameset.setSize(10.0f, 7.0f, true);
        wsnameset.setPivot(Pivot.MiddleCenter);
        wsnameset.setBorder(1.0f);
        wsnameset.setBorderColor(-1);
        wsnameset.setText("Set");
        wsnameset.setClickable(true);
        wispsettingspanel.addChild((UIElement)wsnameset);
        UILabel wclabel = new UILabel();
        wclabel.setPosition(50.0f, 30.0f, true);
        wclabel.setSize(10.0f, 10.0f, true);
        wclabel.setPivot(Pivot.MiddleCenter);
        wclabel.setText("Color");
        wispsettingspanel.addChild((UIElement)wclabel);
        UILabel crlabel = new UILabel();
        crlabel.setPosition(5.0f, 39.0f, true);
        crlabel.setSize(3.0f, 10.0f, true);
        crlabel.setPivot(Pivot.MiddleCenter);
        crlabel.setText("<color=red>R</color>");
        wispsettingspanel.addChild((UIElement)crlabel);
        final UITextField crtext = new UITextField();
        crtext.setText(String.valueOf(player.getAttribute("wispcolorr")));
        crtext.setMaxCharacters(5);
        crtext.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        crtext.setFontSize(10.0f);
        crtext.setBorder(1.0f);
        crtext.setBorderColor(-1);
        crtext.setSize(12.0f, 8.0f, true);
        crtext.setPosition(15.0f, 39.0f, true);
        crtext.setPivot(Pivot.MiddleCenter);
        crtext.setVisible(true);
        crtext.setClickable(true);
        wispsettingspanel.addChild((UIElement)crtext);
        UILabel cglabel = new UILabel();
        cglabel.setPosition(25.0f, 39.0f, true);
        cglabel.setSize(3.0f, 10.0f, true);
        cglabel.setPivot(Pivot.MiddleCenter);
        cglabel.setText("<color=green>G</color>");
        wispsettingspanel.addChild((UIElement)cglabel);
        final UITextField cgtext = new UITextField();
        cgtext.setText(String.valueOf(player.getAttribute("wispcolorg")));
        cgtext.setMaxCharacters(5);
        cgtext.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        cgtext.setFontSize(10.0f);
        cgtext.setBorder(1.0f);
        cgtext.setBorderColor(-1);
        cgtext.setSize(12.0f, 8.0f, true);
        cgtext.setPosition(35.0f, 39.0f, true);
        cgtext.setPivot(Pivot.MiddleCenter);
        cgtext.setVisible(true);
        cgtext.setClickable(true);
        wispsettingspanel.addChild((UIElement)cgtext);
        UILabel cblabel = new UILabel();
        cblabel.setPosition(45.0f, 39.0f, true);
        cblabel.setSize(3.0f, 10.0f, true);
        cblabel.setPivot(Pivot.MiddleCenter);
        cblabel.setText("<color=blue>B</color>");
        wispsettingspanel.addChild((UIElement)cblabel);
        final UITextField cbtext = new UITextField();
        cbtext.setText(String.valueOf(player.getAttribute("wispcolorb")));
        cbtext.setMaxCharacters(5);
        cbtext.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        cbtext.setFontSize(10.0f);
        cbtext.setBorder(1.0f);
        cbtext.setBorderColor(-1);
        cbtext.setSize(12.0f, 8.0f, true);
        cbtext.setPosition(55.0f, 39.0f, true);
        cbtext.setPivot(Pivot.MiddleCenter);
        cbtext.setVisible(true);
        cbtext.setClickable(true);
        wispsettingspanel.addChild((UIElement)cbtext);
        UILabel calabel = new UILabel();
        calabel.setPosition(65.0f, 39.0f, true);
        calabel.setSize(3.0f, 10.0f, true);
        calabel.setPivot(Pivot.MiddleCenter);
        calabel.setText("<color=white>A</color>");
        wispsettingspanel.addChild((UIElement)calabel);
        final UITextField catext = new UITextField();
        catext.setText(String.valueOf(player.getAttribute("wispcolora")));
        catext.setMaxCharacters(5);
        catext.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        catext.setFontSize(10.0f);
        catext.setBorder(1.0f);
        catext.setBorderColor(-1);
        catext.setSize(12.0f, 8.0f, true);
        catext.setPosition(75.0f, 39.0f, true);
        catext.setPivot(Pivot.MiddleCenter);
        catext.setVisible(true);
        catext.setClickable(true);
        wispsettingspanel.addChild((UIElement)catext);
        UILabel wcolorset = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                crtext.getCurrentText(player, r -> player.setAttribute("wispcolorr", r));
                cgtext.getCurrentText(player, g -> player.setAttribute("wispcolorg", g));
                cbtext.getCurrentText(player, b -> player.setAttribute("wispcolorb", b));
                catext.getCurrentText(player, a -> player.setAttribute("wispcolora", a));
                if ((double)Float.parseFloat((String)player.getAttribute("wispcolorr")) >= 0.1 && (double)Float.parseFloat((String)player.getAttribute("wispcolorr")) <= 1.0 && (double)Float.parseFloat((String)player.getAttribute("wispcolorg")) >= 0.1 && (double)Float.parseFloat((String)player.getAttribute("wispcolorg")) <= 1.0 && (double)Float.parseFloat((String)player.getAttribute("wispcolorb")) >= 0.1 && (double)Float.parseFloat((String)player.getAttribute("wispcolorb")) <= 1.0 && (double)Float.parseFloat((String)player.getAttribute("wispcolora")) >= 0.1 && (double)Float.parseFloat((String)player.getAttribute("wispcolora")) <= 1.0) {
                    Wisp.this.SaveColor(player, Float.valueOf((String)player.getAttribute("wispcolorr")), Float.valueOf((String)player.getAttribute("wispcolorg")), Float.valueOf((String)player.getAttribute("wispcolorb")), Float.valueOf((String)player.getAttribute("wispcolora")));
                } else {
                    player.showStatusMessage("R, G, B, A values must be between 0.1 and 1.0", 10);
                }
            }
        };
        wcolorset.setPosition(90.0f, 39.0f, true);
        wcolorset.setSize(10.0f, 7.0f, true);
        wcolorset.setPivot(Pivot.MiddleCenter);
        wcolorset.setBorder(1.0f);
        wcolorset.setBorderColor(-1);
        wcolorset.setText("Set");
        wcolorset.setClickable(true);
        wispsettingspanel.addChild((UIElement)wcolorset);
        UILabel wblabel = new UILabel();
        wblabel.setPosition(25.0f, 49.0f, true);
        wblabel.setSize(3.0f, 10.0f, true);
        wblabel.setPivot(Pivot.MiddleCenter);
        wblabel.setText("Brightness");
        wispsettingspanel.addChild((UIElement)wblabel);
        final UITextField wbtext = new UITextField();
        wbtext.setText(String.valueOf(player.getAttribute("wispbrightness")));
        wbtext.setMaxCharacters(5);
        wbtext.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        wbtext.setFontSize(10.0f);
        wbtext.setBorder(1.0f);
        wbtext.setBorderColor(-1);
        wbtext.setSize(20.0f, 8.0f, true);
        wbtext.setPosition(18.0f, 59.0f, true);
        wbtext.setPivot(Pivot.MiddleCenter);
        wbtext.setVisible(true);
        wbtext.setClickable(true);
        wispsettingspanel.addChild((UIElement)wbtext);
        UILabel wbrightnessset = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                wbtext.getCurrentText(player, wb -> {
                    if ((double)Float.parseFloat(wb) >= 0.0 && (double)Float.parseFloat(wb) <= 750.0) {
                        Wisp.this.SaveBrightness(player, Float.valueOf(Float.parseFloat(wb)));
                    } else {
                        player.showStatusMessage("brightness must be between 0.0(Light off) and 750.0", 10);
                    }
                });
            }
        };
        wbrightnessset.setPosition(38.0f, 59.0f, true);
        wbrightnessset.setSize(10.0f, 7.0f, true);
        wbrightnessset.setPivot(Pivot.MiddleCenter);
        wbrightnessset.setBorder(1.0f);
        wbrightnessset.setBorderColor(-1);
        wbrightnessset.setText("Set");
        wbrightnessset.setClickable(true);
        wispsettingspanel.addChild((UIElement)wbrightnessset);
        UILabel wrlabel = new UILabel();
        wrlabel.setPosition(25.0f, 69.0f, true);
        wrlabel.setSize(3.0f, 10.0f, true);
        wrlabel.setPivot(Pivot.MiddleCenter);
        wrlabel.setText("Range");
        wispsettingspanel.addChild((UIElement)wrlabel);
        final UITextField wrtext = new UITextField();
        wrtext.setText(String.valueOf(player.getAttribute("wisprange")));
        wrtext.setMaxCharacters(5);
        wrtext.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        wrtext.setFontSize(10.0f);
        wrtext.setBorder(1.0f);
        wrtext.setBorderColor(-1);
        wrtext.setSize(20.0f, 8.0f, true);
        wrtext.setPosition(18.0f, 79.0f, true);
        wrtext.setPivot(Pivot.MiddleCenter);
        wrtext.setVisible(true);
        wrtext.setClickable(true);
        wispsettingspanel.addChild((UIElement)wrtext);
        UILabel wbradiussset = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                wrtext.getCurrentText(player, wr -> {
                    if ((double)Float.parseFloat(wr) >= 1.0 && (double)Float.parseFloat(wr) <= 25.0) {
                        Wisp.this.SaveRange(player, Float.valueOf(wr));
                    } else {
                        player.showStatusMessage("Range must be between 1.0 and 25.0", 10);
                    }
                });
            }
        };
        wbradiussset.setPosition(38.0f, 79.0f, true);
        wbradiussset.setSize(10.0f, 7.0f, true);
        wbradiussset.setPivot(Pivot.MiddleCenter);
        wbradiussset.setBorder(1.0f);
        wbradiussset.setBorderColor(-1);
        wbradiussset.setText("Set");
        wbradiussset.setClickable(true);
        wispsettingspanel.addChild((UIElement)wbradiussset);
        UILabel welabel = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                UILabel welabel = (UILabel)player.getAttribute("welabel");
                String text = welabel.getText();
                if (text.equalsIgnoreCase("Enable")) {
                    welabel.setText("Disable");
                    boolean isactive = true;
                    player.setAttribute("isactive", (Object)isactive);
                    Wisp.this.SaveActive(player, isactive);
                } else {
                    welabel.setText("Enable");
                    boolean isactive = false;
                    player.setAttribute("isactive", (Object)isactive);
                    Wisp.this.SaveActive(player, isactive);
                }
            }
        };
        welabel.setPosition(75.0f, 95.0f, true);
        welabel.setSize(30.0f, 7.0f, true);
        welabel.setPivot(Pivot.MiddleCenter);
        welabel.setBorder(1.0f);
        welabel.setBorderColor(-1);
        boolean isactive = (Boolean)player.getAttribute("isactive");
        if (isactive) {
            welabel.setText("Disable");
        } else {
            welabel.setText("Enable");
        }
        welabel.setClickable(true);
        player.setAttribute("welabel", (Object)welabel);
        wispsettingspanel.addChild((UIElement)welabel);
        UILabel wscalelabel = new UILabel();
        wscalelabel.setPosition(75.0f, 49.0f, true);
        wscalelabel.setSize(3.0f, 10.0f, true);
        wscalelabel.setPivot(Pivot.MiddleCenter);
        wscalelabel.setText("Scale");
        wispsettingspanel.addChild((UIElement)wscalelabel);
        final UITextField wsText = new UITextField();
        wsText.setText(String.valueOf(player.getAttribute("wispscale")));
        wsText.setMaxCharacters(5);
        wsText.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        wsText.setFontSize(10.0f);
        wsText.setBorder(1.0f);
        wsText.setBorderColor(-1);
        wsText.setSize(13.0f, 8.0f, true);
        wsText.setPosition(70.0f, 59.0f, true);
        wsText.setPivot(Pivot.MiddleCenter);
        wsText.setVisible(true);
        wsText.setClickable(true);
        wispsettingspanel.addChild((UIElement)wsText);
        UILabel wsset = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                wsText.getCurrentText(player, ws -> {
                    if ((double)Float.parseFloat(ws) >= 0.009 && (double)Float.parseFloat(ws) <= 0.11) {
                        Wisp.this.SaveScale(player, Float.valueOf(ws));
                    } else {
                        player.showStatusMessage("Scale must be between 0.01 and 0.10", 10);
                    }
                });
            }
        };
        wsset.setPosition(85.0f, 59.0f, true);
        wsset.setSize(10.0f, 7.0f, true);
        wsset.setPivot(Pivot.MiddleCenter);
        wsset.setBorder(1.0f);
        wsset.setBorderColor(-1);
        wsset.setText("Set");
        wsset.setClickable(true);
        wispsettingspanel.addChild((UIElement)wsset);
        UILabel wtextlabel = new UILabel();
        wtextlabel.setPosition(75.0f, 69.0f, true);
        wtextlabel.setSize(3.0f, 10.0f, true);
        wtextlabel.setPivot(Pivot.MiddleCenter);
        wtextlabel.setText("Text Scale");
        wispsettingspanel.addChild((UIElement)wtextlabel);
        final UITextField wtextscale = new UITextField();
        wtextscale.setText(String.valueOf(player.getAttribute("textscale")));
        wtextscale.setMaxCharacters(5);
        wtextscale.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
        wtextscale.setFontSize(10.0f);
        wtextscale.setBorder(1.0f);
        wtextscale.setBorderColor(-1);
        wtextscale.setSize(13.0f, 8.0f, true);
        wtextscale.setPosition(70.0f, 79.0f, true);
        wtextscale.setPivot(Pivot.MiddleCenter);
        wtextscale.setVisible(true);
        wtextscale.setClickable(true);
        wispsettingspanel.addChild((UIElement)wtextscale);
        UILabel wtset = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                wtextscale.getCurrentText(player, wt -> {
                    if ((double)Float.parseFloat(wt) >= 0.1 && (double)Float.parseFloat(wt) <= 10.0) {
                        Wisp.this.SaveFontSize(player, Float.valueOf(wt));
                    } else {
                        player.showStatusMessage("text scale must be between 0.1 and 0.10", 10);
                    }
                });
            }
        };
        wtset.setPosition(85.0f, 79.0f, true);
        wtset.setSize(10.0f, 7.0f, true);
        wtset.setPivot(Pivot.MiddleCenter);
        wtset.setBorder(1.0f);
        wtset.setBorderColor(-1);
        wtset.setText("Set");
        wtset.setClickable(true);
        wispsettingspanel.addChild((UIElement)wtset);
        UILabel wsclabel = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                wispsettingspanel.setVisible(false);
                player.setMouseCursorVisible(false);
            }
        };
        wsclabel.setPosition(25.0f, 95.0f, true);
        wsclabel.setSize(30.0f, 7.0f, true);
        wsclabel.setPivot(Pivot.MiddleCenter);
        wsclabel.setBorder(1.0f);
        wsclabel.setBorderColor(-1);
        wsclabel.setText("<color=red>Close</color>");
        wsclabel.setClickable(true);
        wispsettingspanel.addChild((UIElement)wsclabel);
        player.setAttribute("wispsettingspanel", (Object)wispsettingspanel);
    }

    public void SaveName(Player player, String name) {
        Text3D wispname = (Text3D)player.getAttribute("wispname");
        wispname.setText(name);
        this.wispdb.execute("UPDATE Wisps Set name = '" + name + "' WHERE playerid = '" + player.getUID() + "'");
    }

    public void SaveColor(Player player, Float r, Float g, Float b, Float a) {
        Prefab playerwisp = (Prefab)player.getAttribute("wisp");
        ColorRGBA color = new ColorRGBA(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
        playerwisp.setComponentProperty("Light", "color", (Object)color);
        this.wispdb.execute("UPDATE Wisps Set r = '" + r + "', g = '" + g + "', b = '" + b + "', a = '" + a + "' WHERE playerid = '" + player.getUID() + "'");
    }

    public void SaveRange(Player player, Float range) {
        Prefab playerwisp = (Prefab)player.getAttribute("wisp");
        playerwisp.setComponentProperty("Light", "range", (Object)range);
        this.wispdb.execute("UPDATE Wisps Set radius = '" + range + "' WHERE playerid = '" + player.getUID() + "'");
    }

    public void SaveBrightness(Player player, Float brightness) {
        Prefab playerwisp = (Prefab)player.getAttribute("wisp");
        playerwisp.setComponentProperty("Light", "intensity", (Object)brightness);
        this.wispdb.execute("UPDATE Wisps Set Brightness = '" + brightness + "' WHERE playerid = '" + player.getUID() + "'");
    }

    public void SaveActive(Player player, Boolean isactive) {
        int bool;
        Prefab playerwisp = (Prefab)player.getAttribute("wisp");
        if (isactive.booleanValue()) {
            bool = 1;
            playerwisp.setActive(true);
            this.wispdb.execute("UPDATE Wisps Set Active = '" + bool + "' WHERE playerid = '" + player.getUID() + "'");
        }
        if (!isactive.booleanValue()) {
            bool = 0;
            playerwisp.setActive(false);
            this.wispdb.execute("UPDATE Wisps Set Active = '" + bool + "' WHERE playerid = '" + player.getUID() + "'");
        }
    }

    public void SaveScale(Player player, Float scale) {
        Prefab playerwisp = (Prefab)player.getAttribute("wisp");
        this.wispdb.execute("UPDATE Wisps Set WispScale = '" + scale + "' WHERE playerid = '" + player.getUID() + "'");
        playerwisp.setLocalScale(scale.floatValue(), scale.floatValue(), scale.floatValue());
    }

    public void SaveFontSize(Player player, Float fontsize) {
        Text3D wispname = (Text3D)player.getAttribute("wispname");
        this.wispdb.execute("UPDATE Wisps Set TextScale = '" + fontsize + "' WHERE playerid = '" + player.getUID() + "'");
        wispname.setFontSize(fontsize.floatValue());
    }
}

