/*
 * Decompiled with CFR 0.152.
 */
package de.sbg.unity.aktivesign.Objects.Tester;

import de.sbg.unity.aktivesign.AktiveSign;
import de.sbg.unity.aktivesign.Events.TestSignEvent;
import de.sbg.unity.aktivesign.Objects.Tester.Elements;
import de.sbg.unity.aktivesign.Objects.Tester.Permission;
import de.sbg.unity.aktivesign.Objects.Warps;
import de.sbg.unity.aktivesign.Objects.asSigns;
import de.sbg.unity.aktivesign.Utils.SignFormat;
import de.sbg.unity.aktivesign.Utils.TextFormat;
import de.sbg.unity.aktivesign.asConsole;
import java.util.ArrayList;
import java.util.Arrays;
import net.risingworld.api.Server;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.WeatherDefs;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Sign;
import net.risingworld.api.utils.SpawnPointType;
import net.risingworld.api.utils.Utils;

public class SignTester {
    private final AktiveSign plugin;
    private final SignFormat signFormat;
    private final asConsole Console;

    public SignTester(AktiveSign plugin, asConsole Console2) {
        this.plugin = plugin;
        this.Console = Console2;
        this.signFormat = new SignFormat(plugin, Console2);
    }

    public SignTesterStatus TestSign(Player player, String SignText) {
        return this.TestSign(player, SignText, false, null);
    }

    public SignTesterStatus TestSign(Player player, String SignText, boolean interact, Sign sign) {
        String l1;
        if (this.plugin.Config.Debug > 0) {
            this.Console.sendDebug("TestSign", "Test sign");
        }
        String[] lines = Utils.StringUtils.getLines((String)SignText);
        if (this.plugin.Config.Debug > 0) {
            this.Console.sendDebug("TestSign", "lines.length = " + lines.length);
        }
        if (SignText.isEmpty() || SignText.isBlank() || lines.length < 1) {
            return SignTesterStatus.Nothing;
        }
        if (this.plugin.Config.Debug > 0) {
            this.Console.sendDebug("TestSign", "getEditMode = " + this.plugin.Attribute.Player.Sign.getEditMode(player));
            this.Console.sendDebug("TestSign", "interact = " + interact);
        }
        if (this.plugin.Attribute.Player.Sign.getEditMode(player) && interact) {
            return SignTesterStatus.EditMode;
        }
        if (this.plugin.Config.Debug > 0) {
            this.Console.sendDebug("TestSign", "Edit = False");
        }
        if (!lines[0].contains("#") && this.plugin.Sign.isAktiveSign(l1 = this.signFormat.getCommand(lines[0]))) {
            if (this.plugin.Config.Debug > 0) {
                this.Console.sendDebug("TestSign", "isAktiveSign");
                this.Console.sendDebug("TestSign", "Run Event...");
                this.Console.sendDebug("TestSign", "===== Sign =====");
                this.Console.sendDebug("TestSign", l1);
                if (lines.length >= 2) {
                    this.Console.sendDebug("TestSign", lines[1]);
                }
                if (lines.length >= 3) {
                    this.Console.sendDebug("TestSign", lines[2]);
                }
                if (lines.length >= 4) {
                    this.Console.sendDebug("TestSign", lines[3]);
                }
                this.Console.sendDebug("TestSign", "================");
            }
            TestSignEvent evt = interact ? new TestSignEvent(player, interact, sign) : new TestSignEvent(player, SignText);
            this.plugin.triggerEvent(evt);
            if (this.plugin.Config.Debug > 0) {
                this.Console.sendDebug("TestSignEvent", "isCanceld == " + evt.isCancelled());
                this.Console.sendDebug("TestSignEvent", "EventStatatus == " + String.valueOf((Object)evt.getSignTesterStatus()));
            }
            if (evt.isCancelled()) {
                return SignTesterStatus.EventCancel;
            }
            if (evt.getSignTesterStatus() == SignTesterStatus.Nothing) {
                Signs signs = new Signs(player, SignText, interact);
                switch (l1) {
                    case "[Weather]": {
                        return signs.icWeather();
                    }
                    case "[Time]": {
                        return signs.Time();
                    }
                    case "[Gamemode]": {
                        return signs.Gamemode();
                    }
                    case "[Heal]": {
                        return signs.Heal();
                    }
                    case "[Warp]": {
                        return signs.Warp();
                    }
                    case "[Spawn]": {
                        return signs.Spawn();
                    }
                    case "[Teleport]": {
                        return signs.Teleport();
                    }
                    case "[setGroup]": {
                        return signs.setGroup();
                    }
                }
            } else {
                if (evt.getSignTesterStatus() == null) {
                    return SignTesterStatus.Nothing;
                }
                return evt.getSignTesterStatus();
            }
        }
        return SignTesterStatus.Nothing;
    }

    public static enum SignTesterStatus {
        OK("Everything OK!"),
        Permission("Player does not have enough permission!"),
        Money("Player does not have enough money!"),
        Misspelled("Sign is spelled wrong!"),
        Error("There has been an error!"),
        EventCancel("Event was cancelled!"),
        EditMode("Edit mode is active"),
        Nothing("No result found!"),
        Statement("Statement does not match"),
        GameObject("Game Object not found!"),
        Waiting("Waiting for something");

        private final String msg;

        private SignTesterStatus(String msg) {
            this.msg = msg;
        }

        public String getStatusMessage() {
            return this.msg;
        }
    }

    private class Signs
    extends asSigns {
        private final Elements elements;
        private final Permission Permission;
        private final Player player;
        private final TextFormat format;
        private final String lang;

        private Signs(Player player, String SignText, boolean interaction) {
            super(player, SignText, interaction);
            this.elements = new Elements();
            this.Permission = new Permission(SignTester.this.plugin, SignTester.this.Console);
            this.player = player;
            this.lang = player.getLanguage();
            this.format = new TextFormat();
        }

        private SignTesterStatus icWeather() {
            String[] s = this.getLine(2).split(" ");
            if (s.length == 2 && this.elements.getWeatherList().contains(s[0])) {
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                if (SignTester.this.plugin.Config.Debug > 0) {
                    SignTester.this.Console.sendDebug("icWeather", "st = " + String.valueOf((Object)st));
                }
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    WeatherDefs.Weather w = Definitions.getWeather((String)s[0]);
                    Server.setWeather((WeatherDefs.Weather)w, (boolean)Boolean.parseBoolean(s[1]));
                    this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getSign().getWeather(this.lang), s[0])));
                    return SignTesterStatus.OK;
                }
                return st;
            }
            if (s.length == 1 && this.elements.getWeatherList().contains(this.getLine(2))) {
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    WeatherDefs.Weather w = Definitions.getWeather((String)s[0]);
                    Server.setWeather((WeatherDefs.Weather)w, (boolean)true);
                    this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getSign().getWeather(this.lang), s[0])));
                    return SignTesterStatus.OK;
                }
                return st;
            }
            return SignTesterStatus.Misspelled;
        }

        private SignTesterStatus Time() {
            if (this.getLine(2).contains(":")) {
                String[] split = this.getLine(2).split(":");
                try {
                    int h = Integer.parseInt(split[0]);
                    int m = Integer.parseInt(split[1]);
                    if (h <= 24 && h >= 0 && m <= 59 && m >= 0) {
                        if (!this.isInteract()) {
                            if (this.player.isAdmin()) {
                                return SignTesterStatus.OK;
                            }
                            return SignTesterStatus.Permission;
                        }
                        SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                        if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                            Server.setGameTime((int)h, (int)m);
                            this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getSign().getTime_Number(this.lang), h, m)));
                            return SignTesterStatus.OK;
                        }
                        return st;
                    }
                    return SignTesterStatus.Misspelled;
                }
                catch (NumberFormatException ex) {
                    return SignTesterStatus.Misspelled;
                }
            }
            if (this.elements.getTimeList().contains(this.getLine(2))) {
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    switch (this.getLine(2)) {
                        case "day": {
                            Server.setGameTime((int)9, (int)0);
                            break;
                        }
                        case "night": {
                            Server.setGameTime((int)21, (int)0);
                            break;
                        }
                        case "middnight": {
                            Server.setGameTime((int)24, (int)0);
                            break;
                        }
                        case "evening": {
                            Server.setGameTime((int)18, (int)0);
                            break;
                        }
                        case "noon": {
                            Server.setGameTime((int)12, (int)0);
                            break;
                        }
                        case "afternoon": {
                            Server.setGameTime((int)15, (int)0);
                            break;
                        }
                        case "morning": {
                            Server.setGameTime((int)6, (int)0);
                        }
                    }
                    this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getSign().getTime(this.lang), this.getLine(2))));
                    return SignTesterStatus.OK;
                }
                return st;
            }
            return SignTesterStatus.Misspelled;
        }

        private SignTesterStatus Heal() {
            if (this.getLine(2).isBlank() || this.getLine(2).isEmpty() || this.elements.getHealList().contains(this.getLine(2)) || Utils.StringUtils.isNumeric((String)this.getLine(2))) {
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    if (Utils.StringUtils.isNumeric((String)this.getLine(2))) {
                        int newHealth = this.player.getHealth() + Integer.parseInt(this.getLine(2));
                        if (newHealth > this.player.getMaxHealth()) {
                            this.player.setHealth(this.player.getMaxHealth());
                        } else {
                            this.player.setHealth(newHealth);
                        }
                        this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getHeal_MoreLive(this.lang)));
                        return SignTesterStatus.OK;
                    }
                    if (this.getLine(2).contains("all")) {
                        this.player.setBleeding(false);
                        this.player.setBrokenBones(false);
                        this.player.setHunger(100);
                        this.player.setThirst(100);
                        this.player.setHealth(this.player.getMaxHealth());
                        this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getHeal(this.lang)));
                    }
                    if (this.getLine(2).contains("bleeding")) {
                        this.player.setBleeding(false);
                        this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getHeal_Bleeding(this.lang)));
                    }
                    if (this.getLine(2).contains("brokenbones") || this.getLine(2).contains("fracture")) {
                        this.player.setBrokenBones(false);
                        this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getHeal_BrokenBones(this.lang)));
                    }
                    if (this.getLine(2).contains("hunger")) {
                        this.player.setHunger(100);
                        this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getHeal_Hunger(this.lang)));
                    }
                    if (this.getLine(2).contains("thirst")) {
                        this.player.setThirst(100);
                        this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getHeal_Thirst(this.lang)));
                    }
                    if (this.getLine(2).contains("maxlive")) {
                        this.player.setHealth(this.player.getMaxHealth());
                        this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getHeal_MaxLive(this.lang)));
                    }
                    return SignTesterStatus.OK;
                }
                return st;
            }
            return SignTesterStatus.Misspelled;
        }

        private SignTesterStatus Spawn() {
            if (!this.isInteract()) {
                if (this.player.isAdmin()) {
                    return SignTesterStatus.OK;
                }
                return SignTesterStatus.Permission;
            }
            SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
            if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                if (this.getLine(2).isBlank() || this.getLine(2).isEmpty()) {
                    this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getSpawn(this.lang)));
                    return SignTesterStatus.OK;
                }
                switch (this.getLine(2)) {
                    case "respawn": {
                        if (this.player.getSpawnPosition(SpawnPointType.Primary) == null) break;
                        this.player.setPosition(this.player.getSpawnPosition(SpawnPointType.Primary));
                        this.player.setRotation(this.player.getSpawnRotation(SpawnPointType.Primary));
                        break;
                    }
                    case "primary": {
                        if (this.player.getSpawnPosition(SpawnPointType.Primary) == null) break;
                        this.player.setPosition(this.player.getSpawnPosition(SpawnPointType.Primary));
                        this.player.setRotation(this.player.getSpawnRotation(SpawnPointType.Primary));
                        break;
                    }
                    case "wildness": {
                        if (this.player.getSpawnPosition(SpawnPointType.Default) == null) break;
                        this.player.setPosition(this.player.getSpawnPosition(SpawnPointType.Default));
                        this.player.setRotation(this.player.getSpawnRotation(SpawnPointType.Default));
                        break;
                    }
                    case "secondary": {
                        if (this.player.getSpawnPosition(SpawnPointType.Secondary) == null) break;
                        this.player.setPosition(this.player.getSpawnPosition(SpawnPointType.Secondary));
                        this.player.setRotation(this.player.getSpawnRotation(SpawnPointType.Secondary));
                        break;
                    }
                    default: {
                        this.player.setPosition(Server.getDefaultSpawnPosition());
                        this.player.setRotation(Server.getDefaultSpawnRotation());
                    }
                }
                return SignTesterStatus.OK;
            }
            return st;
        }

        private SignTesterStatus Teleport() {
            String[] split = this.getLine(2).split(" ");
            if (split.length == 3) {
                int z;
                int y;
                int x;
                try {
                    x = Integer.parseInt(split[0]);
                    y = Integer.parseInt(split[1]);
                    z = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException ex) {
                    return SignTesterStatus.Misspelled;
                }
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    this.player.setPosition((float)x, (float)y, (float)z);
                    this.player.sendTextMessage(this.format.Color("green", SignTester.this.plugin.Language.getSign().getTeleport(this.lang)));
                }
                return st;
            }
            return SignTesterStatus.Misspelled;
        }

        private SignTesterStatus setGroup() {
            ArrayList<String> sGroups = new ArrayList<String>();
            sGroups.addAll(Arrays.asList(Server.getAllPermissionGroups()));
            if (sGroups.contains(this.getLine(2)) && sGroups.contains(this.getLine(3))) {
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(2), this.getLine(4), this.isInteract());
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    this.player.setPermissionGroup(this.getLine(3));
                    this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getSign().getSetGroup(this.lang), this.getLine(3))));
                }
                return st;
            }
            return SignTesterStatus.Misspelled;
        }

        private SignTesterStatus Warp() {
            if (SignTester.this.plugin.Warps.getWarpNames().contains(this.getLine(2))) {
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    Warps.Warp warp = SignTester.this.plugin.Warps.getWarp(this.getLine(2));
                    this.player.setPosition(warp.getPosition());
                    this.player.setRotation(warp.getRotation());
                    this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getCommand().getWarp_OK(this.lang), this.getLine(2))));
                }
                return st;
            }
            return SignTesterStatus.Misspelled;
        }

        private SignTesterStatus Gamemode() {
            if (this.getLine(2).toLowerCase().equals("creative") || this.getLine(2).toLowerCase().equals("c") || this.getLine(2).toLowerCase().equals("survivel") || this.getLine(2).toLowerCase().equals("s") || this.getLine(2).equals("0") || this.getLine(2).equals("1")) {
                if (!this.isInteract()) {
                    if (this.player.isAdmin()) {
                        return SignTesterStatus.OK;
                    }
                    return SignTesterStatus.Permission;
                }
                SignTesterStatus st = this.Permission.hasPermissionAndMoney(this.player, this.getLine(3), this.getLine(4), this.isInteract());
                if (st != SignTesterStatus.Permission && st != SignTesterStatus.Money) {
                    switch (this.getLine(2).toLowerCase()) {
                        case "creative": {
                            this.player.setCreativeModeEnabled(true);
                            break;
                        }
                        case "c": {
                            this.player.setCreativeModeEnabled(true);
                            break;
                        }
                        case "survivel": {
                            this.player.setCreativeModeEnabled(false);
                            break;
                        }
                        case "s": {
                            this.player.setCreativeModeEnabled(false);
                            break;
                        }
                        case "0": {
                            this.player.setCreativeModeEnabled(false);
                            break;
                        }
                        case "1": {
                            this.player.setCreativeModeEnabled(true);
                        }
                    }
                    if (this.player.isCreativeModeEnabled()) {
                        this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getSign().getGamemode(this.lang), "Creative")));
                    } else {
                        this.player.sendTextMessage(this.format.Color("green", String.format(SignTester.this.plugin.Language.getSign().getGamemode(this.lang), "Survivel")));
                    }
                    return SignTesterStatus.OK;
                }
                return st;
            }
            return SignTesterStatus.Misspelled;
        }
    }
}

