/*
 * Decompiled with CFR 0.152.
 */
package de.sbg.unity.aktivesign.Events;

import de.sbg.unity.aktivesign.AktiveSign;
import de.sbg.unity.aktivesign.Objects.Tester.SignTester;
import de.sbg.unity.aktivesign.Objects.Warps;
import de.sbg.unity.aktivesign.Utils.SignFormat;
import de.sbg.unity.aktivesign.Utils.TextFormat;
import de.sbg.unity.aktivesign.asConsole;
import java.sql.SQLException;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerSetSignTextEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Sign;
import net.risingworld.api.objects.world.ObjectElement;

public class asEvents
implements Listener {
    private final AktiveSign plugin;
    private final SignFormat format;
    private final TextFormat textFormat;
    private final asConsole Console;

    public asEvents(AktiveSign plugin, asConsole Console2) {
        this.plugin = plugin;
        this.format = new SignFormat(plugin, Console2);
        this.textFormat = new TextFormat();
        this.Console = Console2;
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.Config.Debug > 0) {
            this.Console.sendDebug("PlayerConnectEvent", "plugin = " + String.valueOf((Object)this.plugin));
            this.Console.sendDebug("PlayerConnectEvent", "plugin.Attribute = " + String.valueOf(this.plugin.Attribute));
            this.Console.sendDebug("PlayerConnectEvent", "plugin.Attribute.Player = " + String.valueOf(this.plugin.Attribute.Player));
            this.Console.sendDebug("PlayerConnectEvent", "plugin.Attribute.Player.Sign = " + String.valueOf(this.plugin.Attribute.Player.Sign));
        }
        this.plugin.Attribute.Player.Sign.setEditMode(player, false);
        this.plugin.Attribute.Player.Sign.setDestroyMode(player, false);
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String[] cmd = event.getCommand().split(" ");
        String lang = player.getLanguage();
        if (cmd.length >= 1) {
            Warps.Warp w;
            if (cmd[0].toLowerCase().equals("/as")) {
                if (cmd.length == 1) {
                    player.sendTextMessage(this.textFormat.Color("orange", "   Name: " + this.plugin.getDescription("name")));
                    player.sendTextMessage(this.textFormat.Color("orange", "Version: " + this.plugin.getDescription("version")));
                    player.sendTextMessage(this.textFormat.Color("orange", " Update: " + this.plugin.hasUpdate()));
                }
                if (cmd.length == 2 && cmd[1].toLowerCase().equals("help")) {
                    player.sendTextMessage(this.textFormat.Color("orange", "/warp <Name>"));
                    player.sendTextMessage(this.textFormat.Color("orange", "/warps"));
                    player.sendTextMessage(this.textFormat.Color("orange", "/setwarp <Name>"));
                    player.sendTextMessage(this.textFormat.Color("orange", "/delwarp <Name>"));
                    player.sendTextMessage(this.textFormat.Color("orange", "/as edit <true/false>"));
                    player.sendTextMessage(this.textFormat.Color("orange", "/as destroy <true/false>"));
                }
                if (cmd.length == 3) {
                    if (cmd[1].toLowerCase().equals("editmode") || cmd[1].toLowerCase().equals("edit")) {
                        if (player.isAdmin()) {
                            if (cmd[2].toLowerCase().equals("true") || cmd[2].toLowerCase().equals("false")) {
                                this.plugin.Attribute.Player.Sign.setEditMode(player, Boolean.parseBoolean(cmd[2]));
                                player.sendTextMessage(this.textFormat.Color("green", String.format(this.plugin.Language.getCommand().getEditMode_OK(lang), cmd[2])));
                            } else {
                                player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getCommand().getMode_Value_Not_OK(lang)));
                            }
                        } else {
                            player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                        }
                    }
                    if (cmd[1].toLowerCase().equals("destroymod") || cmd[1].toLowerCase().equals("destroy")) {
                        if (player.isAdmin()) {
                            if (cmd[2].toLowerCase().equals("true") || cmd[2].toLowerCase().equals("false")) {
                                this.plugin.Attribute.Player.Sign.setDestroyMode(player, Boolean.parseBoolean(cmd[2]));
                                player.sendTextMessage(this.textFormat.Color("green", String.format(this.plugin.Language.getCommand().getEditMode_OK(lang), cmd[2])));
                            } else {
                                player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getCommand().getMode_Value_Not_OK(lang)));
                            }
                        } else {
                            player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                        }
                    }
                }
            }
            if (cmd[0].toLowerCase().equals("/setwarp") && cmd.length == 2) {
                if (player.isAdmin()) {
                    if (!this.plugin.Warps.getWarpNames().contains(cmd[1])) {
                        try {
                            this.plugin.Warps.newWarp(cmd[1], player);
                            player.sendTextMessage(this.textFormat.Color("green", String.format(this.plugin.Language.getCommand().getSetwarp_OK(lang), cmd[1])));
                        }
                        catch (SQLException ex) {
                            player.sendTextMessage(this.textFormat.Color("red", String.format(this.plugin.Language.getCommand().getSetwarp_Fail(lang), cmd[1])));
                        }
                    } else {
                        w = this.plugin.Warps.getWarp(cmd[1]);
                        w.setPosition(player.getPosition());
                        w.setRotation(player.getRotation());
                        player.sendTextMessage(this.textFormat.Color("green", String.format(this.plugin.Language.getCommand().getSetwarp_Change(lang), cmd[1])));
                    }
                } else {
                    player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                }
            }
            if (cmd[0].toLowerCase().equals("/delwarp") && cmd.length == 2) {
                if (player.isAdmin()) {
                    if (this.plugin.Warps.getWarpNames().contains(cmd[1])) {
                        try {
                            this.plugin.Warps.removeWarp(cmd[1]);
                            player.sendTextMessage(this.textFormat.Color("green", String.format(this.plugin.Language.getCommand().getDelwarp_OK(lang), cmd[1])));
                        }
                        catch (SQLException ex) {
                            player.sendTextMessage(this.textFormat.Color("red", String.format(this.plugin.Language.getCommand().getDelwarp_Fail(lang), cmd[1])));
                        }
                    } else {
                        player.sendTextMessage(this.textFormat.Color("red", String.format(this.plugin.Language.getCommand().getWarp_Not_Exist(lang), cmd[1])));
                    }
                } else {
                    player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                }
            }
            if (cmd[0].toLowerCase().equals("/warps") && cmd.length == 1) {
                if (player.isAdmin() || !this.plugin.Config.Warp_Command_OnlyAdmin) {
                    player.sendTextMessage(this.textFormat.Color("orange", "====== Warp-List ======"));
                    if (!this.plugin.Warps.getWarpList().isEmpty()) {
                        for (Warps.Warp s : this.plugin.Warps.getWarpList()) {
                            player.sendTextMessage(this.textFormat.Color("orange", "- " + s.getName() + " (ID: " + s.getID() + ")"));
                        }
                    } else {
                        player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getCommand().getWarpList_No_Save(lang)));
                    }
                    player.sendTextMessage(this.textFormat.Color("orange", "======================="));
                } else {
                    player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                }
            }
            if (cmd[0].toLowerCase().equals("/warp")) {
                if (cmd.length == 2) {
                    if (player.isAdmin() || !this.plugin.Config.Warp_Command_OnlyAdmin) {
                        if (this.plugin.Warps.getWarpNames().contains(cmd[1])) {
                            w = this.plugin.Warps.getWarp(cmd[1]);
                            player.setPosition(w.getPosition());
                            player.setRotation(w.getRotation());
                            player.sendTextMessage(this.textFormat.Color("green", String.format(this.plugin.Language.getCommand().getWarp_OK(lang), cmd[1])));
                        } else {
                            player.sendTextMessage(this.textFormat.Color("red", String.format(this.plugin.Language.getCommand().getWarp_Not_Exist(lang), cmd[1])));
                        }
                    } else {
                        player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                    }
                }
                if (cmd.length == 3) {
                    if (player.isAdmin()) {
                        Player p2 = Server.getPlayerByName((String)cmd[1]);
                        if (p2 != null && p2.isConnected()) {
                            if (this.plugin.Warps.getWarpNames().contains(cmd[2])) {
                                Warps.Warp w2 = this.plugin.Warps.getWarp(cmd[2]);
                                p2.setPosition(w2.getPosition());
                                p2.setRotation(w2.getRotation());
                                player.sendTextMessage(this.textFormat.Color("red", String.format(this.plugin.Language.getCommand().getWarp_Player_OK(lang), p2.getName(), cmd[2])));
                            } else {
                                player.sendTextMessage(this.textFormat.Color("red", String.format(this.plugin.Language.getCommand().getWarp_Not_Exist(lang), cmd[2])));
                            }
                        } else {
                            player.sendTextMessage(this.textFormat.Color("red", String.format(this.plugin.Language.getOther().getPlayer_Not_Connected(lang), cmd[1])));
                        }
                    } else {
                        player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                    }
                }
            }
        }
    }

    @EventMethod
    public void onPlayerSetSignTextEvent(PlayerSetSignTextEvent event) {
        Player player = event.getPlayer();
        String SignText = event.getText();
        String lang = player.getLanguage();
        SignTester.SignTesterStatus st = this.plugin.Sign.SignTester.TestSign(player, SignText);
        if (this.plugin.Config.Debug > 0) {
            this.Console.sendDebug("PlayerSetSignTextEvent", "SignTesterStatus = " + String.valueOf((Object)st));
        }
        switch (st) {
            case EventCancel: {
                event.setCancelled(true);
                break;
            }
            case Misspelled: {
                event.setText(this.format.formatCommand("red", SignText));
                player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getSign().getMisspelled(lang)));
                break;
            }
            case Permission: {
                event.setCancelled(true);
                player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getOther().getNoPermission(lang)));
                break;
            }
            case Error: {
                event.setText(this.format.formatCommand("red", SignText));
                player.sendTextMessage(this.textFormat.Color("red", "Warning: Plugin Error!"));
                break;
            }
            case Waiting: {
                event.setText(this.format.formatCommand("yellow", SignText));
                break;
            }
            case OK: {
                event.setText(this.format.formatCommand("green", SignText));
                player.sendTextMessage(this.textFormat.Color("green", this.plugin.Language.getSign().getSign_OK(lang)));
            }
        }
    }

    @EventMethod
    public void onPlayerObjectInteraktionEvent(PlayerObjectInteractionEvent event) {
        Objects.ObjectDefinition def = event.getObjectDefinition();
        Player player = event.getPlayer();
        ObjectElement el = event.getObject();
        if (def.type == Objects.Type.Sign) {
            Sign sign = World.getSign((long)event.getGlobalID());
            SignTester.SignTesterStatus st = this.plugin.Sign.SignTester.TestSign(player, sign.getText(), true, sign);
            if (this.plugin.Config.Debug > 0) {
                this.Console.sendDebug("InteractSign", "SignTesterStatus = " + String.valueOf((Object)st));
            }
            if (st != SignTester.SignTesterStatus.EditMode && st != SignTester.SignTesterStatus.Nothing) {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyObjectEvent(PlayerDestroyObjectEvent event) {
        Sign sign;
        Player player = event.getPlayer();
        String lang = player.getLanguage();
        Objects.ObjectDefinition def = event.getObjectDefinition();
        if (def.type == Objects.Type.Sign && this.plugin.Sign.isAktiveSign(sign = World.getSign((long)event.getGlobalID())) && !this.plugin.Sign.isUserSign(sign) && !this.plugin.Attribute.Player.Sign.getDestroyMode(player)) {
            event.setCancelled(true);
            player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getSign().getSign_Distroy_Fail(lang)));
        }
    }

    @EventMethod
    public void onPlayerRemoveObjectEvent(PlayerRemoveObjectEvent event) {
        Sign sign;
        Player player = event.getPlayer();
        String lang = player.getLanguage();
        Objects.ObjectDefinition def = event.getObjectDefinition();
        if (def.type == Objects.Type.Sign && this.plugin.Sign.isAktiveSign(sign = World.getSign((long)event.getGlobalID())) && !this.plugin.Sign.isUserSign(sign) && !this.plugin.Attribute.Player.Sign.getDestroyMode(player)) {
            event.setCancelled(true);
            player.sendTextMessage(this.textFormat.Color("red", this.plugin.Language.getSign().getSign_Distroy_Fail(lang)));
        }
    }
}

