/*
 * Decompiled with CFR 0.152.
 */
package de.sbg.unity.aktivesign;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Scanner;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;

public final class Update
implements Listener {
    private final URI url;
    private Scanner Scanner;
    private String resultString;
    private final String currentVersion;
    private final Plugin plugin;

    public Update(Plugin plugin, String URL2) throws IOException, URISyntaxException {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription("version");
        this.url = new URI(URL2);
        this.Scanner = new Scanner(this.url.toURL().openStream());
        this.resultString = this.Scanner.hasNext() ? this.Scanner.nextLine() : null;
        this.Scanner.close();
        this.DoScann(false, true);
    }

    public void DoScann(boolean newScann, boolean console) throws IOException {
        if (newScann) {
            this.newScann();
        }
        String Plugin2 = this.plugin.getDescription("name");
        if (this.hasUpdate()) {
            this.plugin.registerEventListener((Listener)this);
            if (console) {
                System.out.println("[" + Plugin2 + "-Warning] [Update] -------- New Update --------");
                System.out.println("[" + Plugin2 + "-Warning] [Update] Plugin is NOT up to date");
                System.out.println("[" + Plugin2 + "-Warning] [Update] Current Version: " + this.currentVersion);
                System.out.println("[" + Plugin2 + "-Warning] [Update]     New Version: " + this.resultString);
                System.out.println("[" + Plugin2 + "-Warning] [Update] ----------------------------");
            }
        } else {
            System.out.println("[" + Plugin2 + "-Info] [Update] Plugin is up to date!");
        }
    }

    private void newScann() throws IOException {
        this.Scanner = new Scanner(this.url.toURL().openStream());
        this.resultString = this.Scanner.hasNext() ? this.Scanner.nextLine() : null;
        this.Scanner.close();
    }

    public boolean hasUpdate() {
        if (this.resultString != null) {
            return !this.currentVersion.equals(this.resultString);
        }
        return false;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getOnlineVersion() {
        return this.resultString;
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        if (this.hasUpdate()) {
            if (Server.getType() == Server.Type.Singleplayer) {
                player.sendTextMessage("[#ffa500][" + this.plugin.getDescription("name") + "] Plugin has an update!");
            } else if (player.isAdmin()) {
                player.sendTextMessage("[#ffa500][" + this.plugin.getDescription("name") + "] Plugin has an update!");
            }
        }
    }
}

