/*
 * Decompiled with CFR 0.152.
 */
package de.sbg.unity.aktivesign.Objects;

import de.sbg.unity.aktivesign.AktiveSign;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class Warps {
    private final List<Warp> WarpList;
    private final AktiveSign plugin;

    public Warps(AktiveSign plugin) {
        this.plugin = plugin;
        this.WarpList = new ArrayList<Warp>();
    }

    public Warp getWarp(String name) {
        for (Warp w : this.WarpList) {
            if (!w.getName().equals(name)) continue;
            return w;
        }
        return null;
    }

    public Warp getWarp(int id) {
        for (Warp w : this.WarpList) {
            if (w.getID() != id) continue;
            return w;
        }
        return null;
    }

    public List<Integer> getIDs() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Warp w : this.WarpList) {
            list.add(w.getID());
        }
        return list;
    }

    public boolean removeWarp(int id) throws SQLException {
        Warp w = this.getWarp(id);
        if (w != null) {
            this.plugin.Database.Warps.removeWarp(w);
            this.WarpList.remove(w);
            return true;
        }
        return false;
    }

    public boolean removeWarp(String name) throws SQLException {
        Warp w = this.getWarp(name);
        if (w != null) {
            this.plugin.Database.Warps.removeWarp(w);
            this.WarpList.remove(w);
            return true;
        }
        return false;
    }

    public List<Warp> getWarpList() {
        return this.WarpList;
    }

    public List<String> getWarpNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Warp w : this.getWarpList()) {
            result.add(w.getName());
        }
        return result;
    }

    public Warp newWarp(String name, Player player) throws SQLException {
        return this.newWarp(name, player.getPosition(), player.getRotation());
    }

    public Warp newWarp(String name, Vector3f pos, Quaternion rot) throws SQLException {
        int id = this.plugin.Database.Warps.addNewWarp(name, pos, rot);
        Warp Warp2 = new Warp(id, name, pos, rot);
        this.WarpList.add(Warp2);
        return Warp2;
    }

    public static class Warp {
        private String Name;
        private Vector3f Position;
        private Quaternion Rotation;
        private final int ID;

        public Warp(int ID, String Warpname, Vector3f Position, Quaternion Rotation) {
            this.Name = Warpname;
            this.Position = Position;
            this.Rotation = Rotation;
            this.ID = ID;
        }

        public Vector3f getPosition() {
            return this.Position;
        }

        public String getName() {
            return this.Name;
        }

        public void setPosition(Vector3f Position) {
            this.Position = Position;
        }

        public void setName(String Warpname) {
            this.Name = Warpname;
        }

        public int getID() {
            return this.ID;
        }

        public Quaternion getRotation() {
            return this.Rotation;
        }

        public void setRotation(Quaternion Rotation) {
            this.Rotation = Rotation;
        }
    }
}

