/*
 * Decompiled with CFR 0.152.
 */
package de.sbg.unity.aktivesign.Database;

import de.sbg.unity.aktivesign.AktiveSign;
import de.sbg.unity.aktivesign.Objects.Warps;
import de.sbg.unity.aktivesign.asConsole;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class asDatabase {
    private final AktiveSign plugin;
    private final Database Database;
    public final TabWarps Warps;
    private final asConsole Console;
    private Timer SaveTimer;

    public asDatabase(AktiveSign plugin, asConsole Console2) {
        this.plugin = plugin;
        this.Database = plugin.getSQLiteConnection(plugin.getPath() + "/database/" + plugin.getDescription("name") + "-" + World.getName() + "-Warps.db");
        this.Warps = new TabWarps(plugin, Console2);
        this.Console = Console2;
    }

    public void startSaveTimer() {
        this.SaveTimer = new Timer(180.0f, 0.0f, -1, () -> {
            try {
                this.saveAll();
            }
            catch (SQLException ex) {
                this.stopSaveTimer();
                this.Console.sendErr("DB-saveAll-SQLException", "MSG: " + ex.getMessage());
                this.Console.sendErr("DB-saveAll-SQLException", "SQL: " + ex.getSQLState());
                for (StackTraceElement ste : ex.getStackTrace()) {
                    this.Console.sendErr("DB-saveAll-SQLException", ste.toString());
                }
            }
        });
        this.SaveTimer.start();
    }

    public Database getDatabase() {
        return this.Database;
    }

    public Timer getSaveTimer() {
        return this.SaveTimer;
    }

    public boolean stopSaveTimer() {
        if (this.SaveTimer != null && this.SaveTimer.isActive()) {
            this.SaveTimer.kill();
            return true;
        }
        return false;
    }

    public void loadAll() throws SQLException {
        this.Warps.loadWarps(this.plugin.Warps.getWarpList());
    }

    public void saveAll() throws SQLException {
        this.Warps.saveAllWarps(this.plugin.Warps.getWarpList());
    }

    public String getDatbasePath() {
        return this.plugin.getPath() + "/database/";
    }

    public void iniDatabase() {
        this.Database.execute("CREATE TABLE IF NOT EXISTS Warps (ID INTEGER PRIMARY KEY NOT NULL, Warpname TXT, PosX FLOAT, PosY FLOAT, PosZ FLOAT, RotW FLOAT, RotX FLOAT, RotY FLOAT, RotZ FLOAT, More TXT ); ");
    }

    public class TabWarps {
        private final AktiveSign plugin;
        private final asConsole Console;
        private final Connection conn;
        private PreparedStatement pstmt;

        public TabWarps(AktiveSign plugin, asConsole Console2) {
            this.plugin = plugin;
            this.Console = Console2;
            this.conn = asDatabase.this.Database.getConnection();
        }

        private void loadWarps(List<Warps.Warp> WarpList) throws SQLException {
            this.Console.sendInfo("Database-Warps", "Load Warps from DB!");
            ResultSet result = asDatabase.this.Database.executeQuery("SELECT * FROM 'Warps'");
            while (result.next()) {
                int id = result.getInt("ID");
                float p1 = result.getFloat("PosX");
                float p2 = result.getFloat("PosY");
                float p3 = result.getFloat("PosZ");
                float r1 = result.getFloat("RotW");
                float r2 = result.getFloat("RotX");
                float r3 = result.getFloat("RotY");
                float r4 = result.getFloat("RotZ");
                String name = result.getString("Warpname");
                this.Console.sendInfo("Database-Warps", "Load Warp '" + name + "'");
                Vector3f pos = new Vector3f(p1, p2, p3);
                Quaternion rot = new Quaternion(r1, r2, r3, r4);
                Warps.Warp warp = new Warps.Warp(id, name, pos, rot);
                WarpList.add(warp);
            }
            this.Console.sendInfo("Database-Warps", "Done!");
        }

        public int addNewWarp(String Warpname, Vector3f pos, Quaternion rot) throws SQLException {
            this.pstmt = this.conn.prepareStatement("INSERT INTO Warps (Warpname, PosX, PosY, PosZ, RotW, RotX, RotY, RotZ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            this.pstmt.setString(1, Warpname);
            this.pstmt.setFloat(2, pos.x);
            this.pstmt.setFloat(3, pos.y);
            this.pstmt.setFloat(4, pos.z);
            this.pstmt.setFloat(5, rot.w);
            this.pstmt.setFloat(6, rot.x);
            this.pstmt.setFloat(7, rot.y);
            this.pstmt.setFloat(8, rot.z);
            this.pstmt.executeUpdate();
            this.pstmt.close();
            ResultSet result = asDatabase.this.Database.executeQuery("SELECT * FROM 'Warps' WHERE Warpname='" + Warpname + "'");
            return result.getInt("ID");
        }

        public void reloadWarps(List<Warps.Warp> WarpList) throws SQLException {
            this.plugin.Warps.getWarpList().clear();
            ResultSet result = asDatabase.this.Database.executeQuery("SELECT * FROM 'Warps'");
            while (result.next()) {
                int id = result.getInt("ID");
                float p1 = result.getFloat("PosX");
                float p2 = result.getFloat("PosY");
                float p3 = result.getFloat("PosZ");
                float r1 = result.getFloat("RotW");
                float r2 = result.getFloat("RotX");
                float r3 = result.getFloat("RotY");
                float r4 = result.getFloat("RotZ");
                String name = result.getString("Warpname");
                this.Console.sendInfo("Database-Warps", "Load Warp '" + name + "'");
                Vector3f pos = new Vector3f(p1, p2, p3);
                Quaternion rot = new Quaternion(r1, r2, r3, r4);
                Warps.Warp warp = new Warps.Warp(id, name, pos, rot);
                WarpList.add(warp);
            }
        }

        public void saveAllWarps(List<Warps.Warp> WarpList) throws SQLException {
            if (WarpList.isEmpty()) {
                for (Warps.Warp Warp2 : WarpList) {
                    this.pstmt = this.conn.prepareStatement("UPDATE Warps SET Warpname=?, PosX=?, PosY=?, PosZ=?, RotW=?, RotX=?, RotY=?, RotZ=? WHERE ID=" + Warp2.getID());
                    this.pstmt.setString(1, Warp2.getName());
                    this.pstmt.setFloat(2, Warp2.getPosition().x);
                    this.pstmt.setFloat(3, Warp2.getPosition().y);
                    this.pstmt.setFloat(4, Warp2.getPosition().z);
                    this.pstmt.setFloat(5, Warp2.getRotation().w);
                    this.pstmt.setFloat(6, Warp2.getRotation().x);
                    this.pstmt.setFloat(7, Warp2.getRotation().y);
                    this.pstmt.setFloat(8, Warp2.getRotation().z);
                    this.pstmt.executeUpdate();
                    this.pstmt.close();
                }
            }
        }

        public void removeWarp(Warps.Warp warp) throws SQLException {
            this.pstmt = this.conn.prepareStatement("DELETE FROM Warps WHERE ID=" + warp.getID());
            this.pstmt.executeUpdate();
            this.pstmt.close();
        }
    }
}

