/*
 * Decompiled with CFR 0.152.
 */
package de.sbg.unity.aktivesign;

import de.chaoswg.ClassPluginJSONManager;
import de.chaoswg.ToolsAPI;
import de.sbg.unity.aktivesign.Database.asDatabase;
import de.sbg.unity.aktivesign.Events.asEvents;
import de.sbg.unity.aktivesign.Objects.SignManager;
import de.sbg.unity.aktivesign.Objects.Tester.Permission;
import de.sbg.unity.aktivesign.Objects.Warps;
import de.sbg.unity.aktivesign.Update;
import de.sbg.unity.aktivesign.Utils.SignFormat;
import de.sbg.unity.aktivesign.Utils.TextFormat;
import de.sbg.unity.aktivesign.asAttribute;
import de.sbg.unity.aktivesign.asConsole;
import de.sbg.unity.aktivesign.asLanguage;
import de.sbg.unity.configmanager.ConfigData;
import de.sbg.unity.configmanager.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import net.risingworld.api.Plugin;

public class AktiveSign
extends Plugin {
    private ConfigManager configManager;
    public Config Config;
    public asConsole Console;
    public Warps Warps;
    public asAttribute Attribute;
    public SignManager Sign;
    private Update update;
    public asDatabase Database;
    public SignFormat signFormat;
    public TextFormat TextFormat;
    public asLanguage Language;
    private ToolsAPI ta;
    public Permission SignPermission;

    public void onEnable() {
        this.Console = new asConsole(this);
        this.Console.sendInfo("Enabled");
        this.signFormat = new SignFormat(this, this.Console);
        this.TextFormat = new TextFormat();
        this.Console.sendInfo("ini", "Load Config...");
        this.configManager = (ConfigManager)this.getPluginByName("ConfigManager");
        this.ta = (ToolsAPI)this.getPluginByName("ToolsAPI");
        if (this.configManager != null && this.ta != null) {
            this.SignPermission = new Permission(this, this.Console);
            try {
                this.Config = new Config(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.Config.iniConifg()) {
                this.Console.sendInfo("ini", "Load Config...Done!");
                this.Console.sendInfo("ini", "Load Warps...");
                this.Warps = new Warps(this);
                this.Console.sendInfo("ini", "Load Warps from Database...");
                this.Database = new asDatabase(this, this.Console);
                try {
                    this.Database.iniDatabase();
                    this.Database.loadAll();
                    this.Database.startSaveTimer();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.Console.sendInfo("ini", "Load Warps from Database...Done!");
                this.Console.sendInfo("ini", "Load Warps...Done!");
                this.Attribute = new asAttribute();
                this.Console.sendInfo("ini", "Load SignManager...");
                this.Sign = new SignManager(this, this.Console);
                this.Console.sendInfo("ini", "Load SignManager...Done!");
                this.Console.sendInfo("ini", "Ini Signs...");
                this.Sign.iniSigns();
                this.Console.sendInfo("ini", "Ini Signs...Done!");
                this.Console.sendInfo("ini", "Load Languages...");
                this.Language = new asLanguage();
                File fileCongigPhat = new File(this.getPath() + System.getProperty("file.separator") + "Languages");
                if (fileCongigPhat.mkdirs()) {
                    this.Console.sendInfo("ini", "Erstelle: " + fileCongigPhat.getAbsolutePath());
                }
                ClassPluginJSONManager jm = new ClassPluginJSONManager();
                jm.getBanList().add("defaultLanguage");
                String configFile = this.getPath() + System.getProperty("file.separator") + "Languages" + System.getProperty("file.separator") + "Language.json";
                this.Console.sendInfo("ini", "Load Languages...Done!");
                this.Language = (asLanguage)jm.update((Object)this.Language, configFile);
                this.Console.sendInfo("ini", "Load Languages...Done!");
            }
        }
        this.Console.sendInfo("Check for Updates...");
        try {
            this.update = new Update(this, "http://gs.sandboxgamer.de/downloads/Plugins/risingworld/unity/AktiveSign/version.txt");
        }
        catch (IOException | URISyntaxException ioex) {
            this.Console.sendErr("Load", ioex.getMessage());
        }
        this.registerEventListener(new asEvents(this, this.Console));
    }

    public boolean hasUpdate() {
        return this.update.hasUpdate();
    }

    public void onDisable() {
        try {
            this.Database.stopSaveTimer();
            this.Database.saveAll();
            this.Database.getDatabase().close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.Console.sendInfo("Desabled");
    }

    public class Config {
        public int Debug;
        public long Warp_Command_Cost;
        public boolean Warp_Command_OnlyAdmin;
        public boolean UseSign_Weather;
        public boolean UseSign_Time;
        public boolean UseSign_Heal;
        public boolean UseSign_Journal;
        public boolean UseSign_setGroup;
        public boolean UseSign_Warp;
        public boolean UseSign_Teleport;
        public boolean UseSign_ShowMap;
        public boolean UseSign_AdminHelp;
        public boolean UseSign_Spawn;
        public boolean UseSign_Gamemode;
        private final ConfigData Data;
        private final boolean asHome;
        private final boolean asTrade;
        private final boolean asTools;

        public Config(AktiveSign plugin) throws IOException {
            this.Data = AktiveSign.this.configManager.newConfig(plugin.getDescription("name"), plugin.getPath());
            this.asHome = plugin.getPluginByName("AktiveSignHome") != null;
            this.asTrade = plugin.getPluginByName("AktiveSignTrade") != null;
            this.asTools = plugin.getPluginByName("AktiveSignTools") != null;
        }

        public String getSetting(String key) {
            return this.Data.getSetting(key);
        }

        public void setSetting(String key, Object value) {
            this.Data.setSetting(key, value);
            AktiveSign.this.Console.sendInfo("Config", "Change setting '" + key + "' to '" + String.valueOf(value) + "'!");
        }

        private boolean iniConifg() {
            try {
                this.Data.addCommend("#--------------------------------#");
                this.Data.addCommend("#           AktiveSign           #");
                this.Data.addCommend("#--------------------------------#");
                this.Data.addEmptyLine();
                this.Data.addCommend("# Turn Debug-Mod on or off");
                this.Data.addCommend("# 0 = off (default);");
                this.Data.addCommend("# 1 = on;");
                this.Data.addSetting("Debug", (Object)"0");
                this.Data.addEmptyLine();
                this.Data.addCommend("# Only Admins can warp by command");
                this.Data.addSetting("Warp_Command_OnlyAdmin", (Object)"true");
                this.Data.addEmptyLine();
                this.Data.addCommend("# Switch signs on or off");
                this.Data.addSetting("UseSign_Heal", (Object)true);
                this.Data.addSetting("UseSign_setGroup", (Object)true);
                this.Data.addSetting("UseSign_Spawn", (Object)true);
                this.Data.addSetting("UseSign_Teleport", (Object)true);
                this.Data.addSetting("UseSign_Time", (Object)true);
                this.Data.addSetting("UseSign_Warp", (Object)true);
                this.Data.addSetting("UseSign_Weather", (Object)true);
                if (this.asTrade) {
                    this.Data.addEmptyLine();
                    this.Data.addCommend("#--------------------------------#");
                    this.Data.addCommend("#         AktiveSignTrade        #");
                    this.Data.addCommend("#--------------------------------#");
                    this.Data.addEmptyLine();
                    this.Data.addCommend("# Switch signs on or off");
                }
                if (this.asTools) {
                    this.Data.addEmptyLine();
                    this.Data.addCommend("#--------------------------------#");
                    this.Data.addCommend("#         AktiveSignTools        #");
                    this.Data.addCommend("#--------------------------------#");
                    this.Data.addEmptyLine();
                    this.Data.addCommend("# Switch signs on or off");
                    this.Data.addSetting("UseSign_Fly", (Object)true);
                }
                if (this.asHome) {
                    this.Data.addEmptyLine();
                    this.Data.addCommend("#--------------------------------#");
                    this.Data.addCommend("#          AktiveSignHome        #");
                    this.Data.addCommend("#--------------------------------#");
                    this.Data.addEmptyLine();
                }
                this.Data.CreateConfig();
                this.readConfig();
            }
            catch (IOException | NumberFormatException ex1) {
                AktiveSign.this.Console.sendErr("iniConfig", "Config konnte nicht initalisiert werden!");
                AktiveSign.this.Console.sendErr("iniConfig", ex1.getMessage());
                AktiveSign.this.Console.sendErr("iniConfig", ex1.getStackTrace());
                return false;
            }
            return true;
        }

        public void readConfig() throws NumberFormatException {
            this.Debug = Integer.parseInt(this.Data.getSetting("Debug"));
            this.Warp_Command_OnlyAdmin = Boolean.parseBoolean(this.Data.getSetting("Warp_Command_OnlyAdmin"));
            this.UseSign_Weather = Boolean.parseBoolean(this.Data.getSetting("UseSign_Weather"));
            this.UseSign_Time = Boolean.parseBoolean(this.Data.getSetting("UseSign_Time"));
            this.UseSign_Heal = Boolean.parseBoolean(this.Data.getSetting("UseSign_Heal"));
            this.UseSign_setGroup = Boolean.parseBoolean(this.Data.getSetting("UseSign_setGroup"));
            this.UseSign_Warp = Boolean.parseBoolean(this.Data.getSetting("UseSign_Warp"));
            this.UseSign_Teleport = Boolean.parseBoolean(this.Data.getSetting("UseSign_Teleport"));
            this.UseSign_Spawn = Boolean.parseBoolean(this.Data.getSetting("UseSign_Spawn"));
            this.UseSign_Gamemode = false;
            this.UseSign_Journal = false;
            this.UseSign_ShowMap = false;
            this.UseSign_AdminHelp = false;
        }
    }
}

