/*
 * Decompiled with CFR 0.152.
 */
package worldpower;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.assets.AssetBundle;
import net.risingworld.api.assets.PrefabAsset;
import net.risingworld.api.assets.SoundAsset;
import net.risingworld.api.database.Database;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.definitions.WeatherDefs;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeBlockPositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerMouseButtonEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectInfoEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectStatusEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerHitObjectEvent;
import net.risingworld.api.events.player.world.PlayerPlaceObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Time;
import net.risingworld.api.objects.world.ObjectElement;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Layer;
import net.risingworld.api.utils.MouseButton;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.GameObject;
import net.risingworld.api.worldelements.Prefab;

public class WorldPower
extends Plugin
implements Listener {
    public Database database;
    public ArrayList<Prefab> SolarPanels = new ArrayList();
    public ArrayList<Prefab> Battery = new ArrayList();
    public ArrayList<Prefab> PreviewBattery = new ArrayList();
    public ArrayList<Prefab> PreviewSolarPanel = new ArrayList();
    public ArrayList GridNameIDs = new ArrayList();
    public ArrayList LightGlobalIDs = new ArrayList();

    public void onEnable() {
        ResultSet result;
        LocalDate Date2 = LocalDate.now();
        String WorldName = World.getName();
        this.database = this.getSQLiteConnection(this.getPath() + "/" + WorldName + "/database.db");
        this.database.execute("CREATE TABLE IF NOT EXISTS `SolarPanel` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,`SolarPanelPosition` INTEGER, `SolarPanelRotation` INTEGER, `SolarPanelID` INTEGER, `SolarPanelMaxOutput` INTEGER, `GridName` VARCHAR(64),`GridNameID` VARCHAR(64), `PlayerUID` BIGINT);");
        this.database.execute("CREATE TABLE IF NOT EXISTS `Battery` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,`BatteryPosition` INTEGER,`BatteryID` INTEGER, `BatteryMaxCapacity` INTEGER, `BatteryCapacity` INTEGER, `GridName` VARCHAR(64),`GridNameID` VARCHAR(64), `PlayerUID` BIGINT);");
        this.database.execute("CREATE TABLE IF NOT EXISTS `Lights` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,`LightName` INTEGER,`LightGlobalID` INTEGER, `LightStatus` INTEGER, `ChunkPositionX` INTEGER, `ChunkPositionY` INTEGER, `ChunkPositionZ` INTEGER,`GridName` VARCHAR(64),`GridNameID` VARCHAR(64), `PlayerUID` BIGINT);");
        System.out.println("-- WorldPower PLUGIN ENABLED --");
        this.registerEventListener(this);
        Timer LightPowerUsageTimer = new Timer(10.0f, 0.0f, -1, null);
        Runnable LightUpDate = () -> {
            try (ResultSet result = this.database.executeQuery("SELECT * FROM `Lights` WHERE `LightStatus` = '1'");){
                while (result.next()) {
                    long LightGlobalID = result.getLong("LightGlobalID");
                    this.LightGlobalIDs.add(LightGlobalID);
                }
                result.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Object LightGlobalID : this.LightGlobalIDs) {
                try {
                    ResultSet LightONResult = this.database.executeQuery("SELECT * FROM `Lights` WHERE `LightGlobalID` = '" + String.valueOf(LightGlobalID) + "' ");
                    try {
                        if (!LightONResult.next()) continue;
                        String GridNameID = LightONResult.getString("GridNameID");
                        long GlobalID = LightONResult.getLong("LightGlobalID");
                        int ChunkPositionX = LightONResult.getInt("ChunkPositionX");
                        int ChunkPositionY = LightONResult.getInt("ChunkPositionY");
                        int ChunkPositionZ = LightONResult.getInt("ChunkPositionZ");
                        try {
                            ResultSet Result = this.database.executeQuery("SELECT COUNT(*) FROM `Battery` WHERE `GridNameID` = '" + GridNameID + "'");
                            try {
                                if (!Result.next()) continue;
                                int Battery = Result.getInt(1);
                                ResultSet BattryPowerResult = this.database.executeQuery("SELECT * FROM `Battery` WHERE `GridNameID` = '" + GridNameID + "'");
                                try {
                                    if (!BattryPowerResult.next()) continue;
                                    float BatteryCapacity = BattryPowerResult.getFloat("BatteryCapacity");
                                    if ((double)BatteryCapacity >= 1.0) {
                                        float DividedCapacity = (float)(1.0 / (double)Battery);
                                        float NewCapacity = BatteryCapacity - DividedCapacity;
                                        this.database.executeUpdate("UPDATE Battery SET BatteryCapacity = '" + NewCapacity + "' WHERE `GridNameID` = '" + GridNameID + "'");
                                        continue;
                                    }
                                    ObjectElement objects = World.getObject((long)GlobalID, (int)ChunkPositionX, (int)ChunkPositionY, (int)ChunkPositionZ);
                                    this.database.executeUpdate("UPDATE Lights SET LightStatus = '0' WHERE LightGlobalID = '" + GlobalID + "'");
                                    byte objectStatus = objects.getStatus();
                                    if (objectStatus != 1) continue;
                                    byte Status = 0;
                                    objects.setStatus(Status);
                                }
                                finally {
                                    if (BattryPowerResult == null) continue;
                                    BattryPowerResult.close();
                                }
                            }
                            finally {
                                if (Result == null) continue;
                                Result.close();
                            }
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    finally {
                        if (LightONResult == null) continue;
                        LightONResult.close();
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.LightGlobalIDs.clear();
        };
        LightPowerUsageTimer.setTask(LightUpDate);
        LightPowerUsageTimer.start();
        Timer SolarUpDateTimer = new Timer(10.0f, 0.0f, -1, null);
        Runnable SolarUpDate = () -> {
            try (ResultSet result = this.database.executeQuery("SELECT * FROM `SolarPanel`");){
                while (result.next()) {
                    String GridNameID = result.getString("GridNameID");
                    String SolarPanelID = result.getString("SolarPanelID");
                    this.GridNameIDs.add(GridNameID);
                }
                result.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (String GridNameID : this.GridNameIDs) {
                try {
                    ResultSet SolarResult = this.database.executeQuery("SELECT COUNT(*) FROM `SolarPanel` WHERE `GridNameID` = '" + String.valueOf(GridNameID) + "'");
                    try {
                        if (SolarResult.next()) {
                            int Solar = SolarResult.getInt(1);
                            try (ResultSet Result = this.database.executeQuery("SELECT COUNT(*) FROM `Battery` WHERE `GridNameID` = '" + String.valueOf(GridNameID) + "'");){
                                if (Result.next()) {
                                    int Battery = Result.getInt(1);
                                    try (ResultSet BatteryResult = this.database.executeQuery("SELECT * FROM `Battery` WHERE `GridNameID` = '" + String.valueOf(GridNameID) + "'");){
                                        if (BatteryResult.next()) {
                                            float SolarGen = 0.0f;
                                            float WeatherEffect = 0.0f;
                                            float BatteryCapacity = BatteryResult.getFloat("BatteryCapacity");
                                            int BatteryMaxCapacity = BatteryResult.getInt("BatteryMaxCapacity");
                                            int Hour = Server.getGameTime().getHours();
                                            WeatherDefs.Weather Weather2 = Server.getCurrentWeather();
                                            if (Weather2.name.equals("Default")) {
                                                WeatherEffect = 1.2f;
                                            }
                                            if (Weather2.name.equals("Clear")) {
                                                WeatherEffect = 0.8f;
                                            }
                                            if (Weather2.name.equals("Breeze")) {
                                                WeatherEffect = 1.2f;
                                            }
                                            if (Weather2.name.equals("Overcast")) {
                                                WeatherEffect = 2.0f;
                                            }
                                            if (Weather2.name.equals("Rain")) {
                                                WeatherEffect = 5.0f;
                                            }
                                            if (Weather2.name.equals("HeavyRain")) {
                                                WeatherEffect = 7.0f;
                                            }
                                            if (Weather2.name.equals("LightSnow")) {
                                                WeatherEffect = 8.5f;
                                            }
                                            if (Weather2.name.equals("Snow")) {
                                                WeatherEffect = 9.0f;
                                            }
                                            if (Weather2.name.equals("HeavySnow")) {
                                                WeatherEffect = 10.0f;
                                            }
                                            if (Weather2.name.equals("Storm")) {
                                                WeatherEffect = 11.0f;
                                            }
                                            if (Weather2.name.equals("Cold")) {
                                                WeatherEffect = 4.0f;
                                            }
                                            if (Weather2.name.equals("Fog")) {
                                                WeatherEffect = 12.0f;
                                            }
                                            if (Weather2.name.equals("DenseFog")) {
                                                WeatherEffect = 15.0f;
                                            }
                                            if (Hour == 0) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 1) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 2) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 3) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 4) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 5) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 6) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 7) {
                                                SolarGen = 5.5f / WeatherEffect;
                                            }
                                            if (Hour == 8) {
                                                SolarGen = 10.0f / WeatherEffect;
                                            }
                                            if (Hour == 9) {
                                                SolarGen = 20.0f / WeatherEffect;
                                            }
                                            if (Hour == 10) {
                                                SolarGen = 40.0f / WeatherEffect;
                                            }
                                            if (Hour == 11) {
                                                SolarGen = 60.0f / WeatherEffect;
                                            }
                                            if (Hour == 12) {
                                                SolarGen = 80.0f / WeatherEffect;
                                            }
                                            if (Hour == 13) {
                                                SolarGen = 110.0f / WeatherEffect;
                                            }
                                            if (Hour == 14) {
                                                SolarGen = 80.0f / WeatherEffect;
                                            }
                                            if (Hour == 15) {
                                                SolarGen = 60.0f / WeatherEffect;
                                            }
                                            if (Hour == 16) {
                                                SolarGen = 40.0f / WeatherEffect;
                                            }
                                            if (Hour == 17) {
                                                SolarGen = 20.0f / WeatherEffect;
                                            }
                                            if (Hour == 18) {
                                                SolarGen = 10.0f / WeatherEffect;
                                            }
                                            if (Hour == 19) {
                                                SolarGen = 5.5f / WeatherEffect;
                                            }
                                            if (Hour == 20) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 21) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 22) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            if (Hour == 23) {
                                                SolarGen = 0.0f / WeatherEffect;
                                            }
                                            float AddCapacity = SolarGen / (float)Battery;
                                            float AddCapacityTotal = AddCapacity * (float)Solar;
                                            float NewCapacity = AddCapacity + BatteryCapacity;
                                            if (NewCapacity >= (float)BatteryMaxCapacity) {
                                                NewCapacity = BatteryMaxCapacity;
                                            }
                                            float TotalCapacity = NewCapacity * (float)Battery;
                                            this.database.executeUpdate("UPDATE Battery SET BatteryCapacity = '" + NewCapacity + "' WHERE `GridNameID` = '" + String.valueOf(GridNameID) + "'");
                                        }
                                        BatteryResult.close();
                                    }
                                    catch (SQLException ex) {
                                        Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                Result.close();
                            }
                            catch (SQLException ex) {
                                Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        SolarResult.close();
                    }
                    finally {
                        if (SolarResult == null) continue;
                        SolarResult.close();
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.GridNameIDs.clear();
        };
        SolarUpDateTimer.setTask(SolarUpDate);
        SolarUpDateTimer.start();
        try {
            result = this.database.executeQuery("SELECT * FROM `SolarPanel`");
            try {
                while (result.next()) {
                    String SolarPanelPosition = result.getString("SolarPanelPosition");
                    String SolarPanelRotation = result.getString("SolarPanelRotation");
                    Vector3f Position = new Vector3f().add(Vector3f.ONE).fromString(SolarPanelPosition);
                    Quaternion Rotation = new Quaternion().fromString(SolarPanelRotation);
                    AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
                    PrefabAsset asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"SolarPanel.prefab");
                    Prefab prefab = new Prefab(asset);
                    prefab.setLayer(0);
                    prefab.setLocalPosition(Position);
                    prefab.setLocalRotation(0.0f, Rotation.getYaw(), 0.0f);
                    this.SolarPanels.add(prefab);
                }
                result.close();
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            result = this.database.executeQuery("SELECT * FROM `Battery`");
            try {
                while (result.next()) {
                    String BatteryPosition = result.getString("BatteryPosition");
                    Vector3f Position = new Vector3f().add(Vector3f.ONE).fromString(BatteryPosition);
                    AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
                    PrefabAsset asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"Battery.prefab");
                    Prefab prefab = new Prefab(asset);
                    prefab.setLayer(0);
                    prefab.setLocalPosition(Position);
                    this.Battery.add(prefab);
                }
                result.close();
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Prefab SolarPanels : this.SolarPanels) {
            this.database.executeUpdate("UPDATE SolarPanel SET SolarPanelID = '" + SolarPanels.getID() + "' WHERE SolarPanelPosition = '" + String.valueOf(SolarPanels.getLocalPosition()) + "'");
        }
        for (Prefab Battery : this.Battery) {
            this.database.executeUpdate("UPDATE Battery SET BatteryID = '" + Battery.getID() + "' WHERE BatteryPosition = '" + String.valueOf(Battery.getLocalPosition()) + "'");
        }
    }

    public void onDisable() {
        System.out.println("-- PLUGIN DISABLED --");
        if (this.database != null) {
            this.database.close();
        }
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        Timer BatteryCapacityTimer = (Timer)player.getAttribute("BatteryCapacityTimer");
        BatteryCapacityTimer.kill();
        Timer TimeTimer = (Timer)player.getAttribute("TimeTimer");
        TimeTimer.kill();
        for (Prefab SolarPanels : this.SolarPanels) {
            player.removeGameObject((GameObject)SolarPanels);
        }
        for (Prefab Battery : this.Battery) {
            player.removeGameObject((GameObject)Battery);
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        String UserName = player.getName();
        LocalDate Date2 = LocalDate.now();
        SoundAsset humsoundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/Assets/hum.wav"));
        SoundAsset bleepsoundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/Assets/bleep.wav"));
        player.setAttribute("HardwareType", (Object)"null");
        player.registerKeys(new Key[]{Key.S, Key.LeftShift, Key.B});
        player.setListenForKeyInput(true);
        player.setListenForMouseInput(true);
        for (Prefab SolarPanels : this.SolarPanels) {
            player.addGameObject((GameObject)SolarPanels);
        }
        for (Prefab Battery : this.Battery) {
            Battery.setLayer("Top", 3, true);
            Battery.setActive("Top", false);
            Battery.setActive("TopRed", false);
            player.playSound(humsoundfile, true, 0.3f, 0.5f, Battery.getLocalPosition());
            player.addGameObject((GameObject)Battery);
        }
        UILabel ObjectInfo = new UILabel();
        ObjectInfo.setClickable(false);
        ObjectInfo.setPosition(200.0f, 5.0f, false);
        ObjectInfo.setVisible(true);
        player.setAttribute("ObjectInfo", (Object)ObjectInfo);
        player.addUIElement((UIElement)ObjectInfo);
        UILabel BatteryCapacityInfo = new UILabel();
        BatteryCapacityInfo.setClickable(false);
        BatteryCapacityInfo.setText("Battery Capacity=");
        BatteryCapacityInfo.setPosition(600.0f, 5.0f, false);
        BatteryCapacityInfo.setVisible(true);
        player.setAttribute("BatteryCapacityInfo", (Object)BatteryCapacityInfo);
        player.addUIElement((UIElement)BatteryCapacityInfo);
        UILabel TimeInfo = new UILabel();
        TimeInfo.setClickable(false);
        TimeInfo.setPosition(1000.0f, 5.0f, false);
        TimeInfo.setVisible(true);
        player.setAttribute("TimeInfo", (Object)TimeInfo);
        player.addUIElement((UIElement)TimeInfo);
        Timer TimeTimer = new Timer(0.5f, 0.0f, -1, null);
        Runnable tic = () -> {
            Time fulltime = Server.getGameTime();
            int Hour = Server.getGameTime().getHours();
            int Minutes = Server.getGameTime().getMinutes();
            int Seconds = Server.getGameTime().getSeconds();
            int Year = Server.getGameTime().getYear();
            int Day = Server.getGameTime().getDay();
            int Month2 = Server.getGameTime().getMonth();
            String TimeFormat = null;
            Object Minute = null;
            Object sec = null;
            if (Minutes == 0) {
                Minute = "00";
            }
            if (Minutes == 1) {
                Minute = "01";
            }
            if (Minutes == 2) {
                Minute = "02";
            }
            if (Minutes == 3) {
                Minute = "03";
            }
            if (Minutes == 4) {
                Minute = "04";
            }
            if (Minutes == 5) {
                Minute = "05";
            }
            if (Minutes == 6) {
                Minute = "06";
            }
            if (Minutes == 7) {
                Minute = "07";
            }
            if (Minutes == 8) {
                Minute = "08";
            }
            if (Minutes == 9) {
                Minute = "09";
            }
            if (Minutes >= 10) {
                Minute = "" + Minutes;
            }
            if (Seconds == 0) {
                sec = "00";
            }
            if (Seconds == 1) {
                sec = "01";
            }
            if (Seconds == 2) {
                sec = "02";
            }
            if (Seconds == 3) {
                sec = "03";
            }
            if (Seconds == 4) {
                sec = "04";
            }
            if (Seconds == 5) {
                sec = "05";
            }
            if (Seconds == 6) {
                sec = "06";
            }
            if (Seconds == 7) {
                sec = "07";
            }
            if (Seconds == 8) {
                sec = "08";
            }
            if (Seconds == 9) {
                sec = "09";
            }
            if (Seconds >= 10) {
                sec = "" + Seconds;
            }
            if (Hour == 0) {
                TimeFormat = "12:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 1) {
                TimeFormat = "01:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 2) {
                TimeFormat = "02:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 3) {
                TimeFormat = "03:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 4) {
                TimeFormat = "04:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 5) {
                TimeFormat = "05:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 6) {
                TimeFormat = "06:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 7) {
                TimeFormat = "07:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 8) {
                TimeFormat = "08:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 9) {
                TimeFormat = "09:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 10) {
                TimeFormat = "10:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 11) {
                TimeFormat = "11:%s:%s AM".formatted(Minute, sec);
            }
            if (Hour == 12) {
                TimeFormat = "12:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 13) {
                TimeFormat = "01:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 14) {
                TimeFormat = "02:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 15) {
                TimeFormat = "03:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 16) {
                TimeFormat = "04:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 17) {
                TimeFormat = "05:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 18) {
                TimeFormat = "06:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 19) {
                TimeFormat = "07:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 20) {
                TimeFormat = "08:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 21) {
                TimeFormat = "09:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 22) {
                TimeFormat = "10:%s:%s PM".formatted(Minute, sec);
            }
            if (Hour == 23) {
                TimeFormat = "11:%s:%s PM".formatted(Minute, sec);
            }
            LocalDateTime CarrentTime = LocalDateTime.now();
            String getCarrentTime = "%s:%s:%s".formatted(CarrentTime.getHour(), CarrentTime.getMinute(), CarrentTime.getSecond());
            WeatherDefs.Weather Weather2 = Server.getCurrentWeather();
            TimeInfo.setText("Weather=" + Weather2.name + " -- Year=" + Year + " -- Month=" + Month2 + " -- Day=" + Day + " -- GameTime=" + TimeFormat + " -- LocalTime=" + getCarrentTime);
        };
        TimeTimer.setTask(tic);
        TimeTimer.start();
        player.setAttribute("TimeTimer", (Object)TimeTimer);
        try (ResultSet Result = this.database.executeQuery("SELECT COUNT(*) FROM `Battery` WHERE `PlayerUID` = '" + PlayerUID + "'");){
            if (Result.next()) {
                int BatteryPackCount = Result.getInt(1);
                player.setAttribute("BatteryPackCount", (Object)BatteryPackCount);
            }
        }
        try (ResultSet BattryPowerResult = this.database.executeQuery("SELECT * FROM `Battery` WHERE `PlayerUID` = '" + PlayerUID + "'");){
            if (BattryPowerResult.next()) {
                float BatteryCapacity = BattryPowerResult.getFloat("BatteryCapacity");
                int BatteryPackCount = (Integer)player.getAttribute("BatteryPackCount");
                player.setAttribute("BatteryCapacity", (Object)Float.valueOf(BatteryCapacity *= (float)BatteryPackCount));
                BatteryCapacityInfo.setText("Battery Capacity=" + String.valueOf(player.getAttribute("BatteryCapacity")) + " Banks=" + BatteryPackCount);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
        }
        Timer BatteryCapacityTimer = new Timer(10.0f, 0.0f, -1, null);
        Runnable BatteryCapacityUpDate = () -> {
            try (ResultSet Result = this.database.executeQuery("SELECT COUNT(*) FROM `Battery` WHERE `PlayerUID` = '" + PlayerUID + "'");){
                if (Result.next()) {
                    int BatteryPackCount = Result.getInt(1);
                    player.setAttribute("BatteryPackCount", (Object)BatteryPackCount);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
            }
            try (ResultSet BattryPowerResult = this.database.executeQuery("SELECT * FROM `Battery` WHERE `PlayerUID` = '" + PlayerUID + "'");){
                if (BattryPowerResult.next()) {
                    float BatteryCapacity = BattryPowerResult.getFloat("BatteryCapacity");
                    int BatteryPackCount = (Integer)player.getAttribute("BatteryPackCount");
                    player.setAttribute("BatteryCapacity", (Object)Float.valueOf(BatteryCapacity *= (float)BatteryPackCount));
                    BatteryCapacityInfo.setText("Battery Capacity=" + String.valueOf(player.getAttribute("BatteryCapacity")) + " Banks=" + BatteryPackCount);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
            }
        };
        BatteryCapacityTimer.setTask(BatteryCapacityUpDate);
        BatteryCapacityTimer.start();
        player.setAttribute("BatteryCapacityTimer", (Object)BatteryCapacityTimer);
        Timer raycastTimer = new Timer(0.5f, 0.0f, -1, null);
        Runnable raycastUpDate = () -> {
            int layerMask = Layer.getBitmask((int[])new int[]{6, 13, 25, 26, 27, 0, 9, 23, 28, 19, 31, 29, 21, 15, 20, 30, 8, 14, 1, 3, 5, 11, 11, 12, 24, 4, 10});
            player.raycast(layerMask, result -> {
                if (result != null) {
                    String GridName;
                    long getObjectID = result.getObjectGlobalID();
                    boolean Trigger = result.isTrigger();
                    int Layer2 = result.getLayer();
                    int InstanceID = result.getInstanceID();
                    float Distance = result.getDistance();
                    player.setAttribute("HardwareID", (Object)getObjectID);
                    Vector3f CollisionPoint = result.getCollisionPoint();
                    player.setAttribute("CollisionPoint", (Object)CollisionPoint);
                    for (Prefab Preview : this.PreviewBattery) {
                        Preview.moveToLocalPosition(CollisionPoint.x, CollisionPoint.y, CollisionPoint.z, 9.0f);
                    }
                    for (Prefab Preview : this.PreviewSolarPanel) {
                        Preview.moveToLocalPosition(CollisionPoint.x, CollisionPoint.y, CollisionPoint.z, 9.0f);
                        Preview.setLocalRotation(0.0f, player.getRotation().getYaw(), 0.0f);
                    }
                    try (ResultSet BatteryResult = this.database.executeQuery("SELECT * FROM `Battery` WHERE `BatteryID` = '" + getObjectID + "'");){
                        if (BatteryResult.next()) {
                            int BatteryID = BatteryResult.getInt("BatteryID");
                            GridName = BatteryResult.getString("GridName");
                            int BatteryCapacity = BatteryResult.getInt("BatteryCapacity");
                            int BatteryMaxCapacity = BatteryResult.getInt("BatteryMaxCapacity");
                            for (Prefab Battery : this.Battery) {
                                if (Battery.getID() == BatteryID) {
                                    if (BatteryCapacity >= 25000) {
                                        Battery.setActive("Top", true);
                                        Battery.setActive("TopRed", false);
                                        player.playSound(bleepsoundfile, Battery.getLocalPosition());
                                        continue;
                                    }
                                    if (BatteryCapacity > 24999) continue;
                                    Battery.setActive("Top", false);
                                    Battery.setActive("TopRed", true);
                                    player.playSound(bleepsoundfile, Battery.getLocalPosition());
                                    continue;
                                }
                                Battery.setActive("Top", false);
                                Battery.setActive("TopRed", false);
                            }
                            ObjectInfo.setText("BatteryID =" + BatteryID + " Grid=" + GridName + " Capacity=" + BatteryCapacity + "/" + BatteryMaxCapacity);
                        } else {
                            for (Prefab Battery : this.Battery) {
                                Battery.setActive("Top", false);
                                Battery.setActive("TopRed", false);
                            }
                        }
                        BatteryResult.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    try (ResultSet SolarResult = this.database.executeQuery("SELECT * FROM `SolarPanel` WHERE `SolarPanelID` = '" + getObjectID + "'");){
                        if (SolarResult.next()) {
                            int SolarPanelID = SolarResult.getInt("SolarPanelID");
                            GridName = SolarResult.getString("GridName");
                            ObjectInfo.setText("SolarID =" + SolarPanelID + " Grid=" + GridName);
                        }
                        SolarResult.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    try (ResultSet LightsResult = this.database.executeQuery("SELECT * FROM `Lights` WHERE `LightGlobalID` = '" + getObjectID + "'");){
                        if (LightsResult.next()) {
                            int LightGlobalID = LightsResult.getInt("LightGlobalID");
                            GridName = LightsResult.getString("GridName");
                            ObjectInfo.setText("LightID =" + LightGlobalID + " Grid=" + GridName);
                        }
                        LightsResult.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(WorldPower.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        };
        raycastTimer.setTask(raycastUpDate);
        raycastTimer.start();
        player.setAttribute("raycastTimer", (Object)raycastTimer);
    }

    @EventMethod
    public void onPlayerPlaceObjectEvent(PlayerPlaceObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        long GlobalID = event.getGlobalID();
        String GridNameID = player.getName() + player.getUID();
        Objects.ObjectDefinition ObjectDefinition2 = event.getObjectDefinition();
        player.sendTextMessage("object name=" + ObjectDefinition2.name);
        player.sendTextMessage("object ID=" + ObjectDefinition2.id);
        player.sendTextMessage("object Type=" + String.valueOf(ObjectDefinition2.type));
        player.sendTextMessage("object GlobalID=" + GlobalID);
        player.sendTextMessage("Event GlobalID=" + event.getGlobalID());
        player.setAttribute("ChunkPositionX", (Object)event.getChunkPositionX());
        player.setAttribute("ChunkPositionY", (Object)event.getChunkPositionY());
        player.setAttribute("ChunkPositionZ", (Object)event.getChunkPositionZ());
        player.setAttribute("GlobalID", (Object)event.getGlobalID());
        if (ObjectDefinition2.type == Objects.Type.Lamp) {
            this.database.executeUpdate("INSERT INTO `Lights` (LightName, LightGlobalID, LightStatus, ChunkPositionX, ChunkPositionY, ChunkPositionZ, GridName, GridNameID, PlayerUID) VALUES ('" + ObjectDefinition2.name + "','" + GlobalID + "','0','" + event.getChunkPositionX() + "','" + event.getChunkPositionY() + "','" + event.getChunkPositionZ() + "','" + PlayerName + "','" + GridNameID + "','" + player.getUID() + "');");
            player.sendTextMessage("This lamp is now added to your default grid");
        }
        if (ObjectDefinition2.type == Objects.Type.Clock) {
            player.sendTextMessage("this is a Clock lets add it");
        }
    }

    @EventMethod
    public void onPlayerChangeObjectStatusEvent(PlayerChangeObjectStatusEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        long GlobalID = event.getGlobalID();
        int ChunkPositionX = event.getChunkPositionX();
        int ChunkPositionY = event.getChunkPositionY();
        int ChunkPositionZ = event.getChunkPositionZ();
        String GridNameID = player.getName() + player.getUID();
        Objects.ObjectDefinition ObjectDefinition2 = event.getObjectDefinition();
        if (ObjectDefinition2.type == Objects.Type.Lamp) {
            try (ResultSet LightsResult = this.database.executeQuery("SELECT * FROM `Lights` WHERE `LightGlobalID` = '" + GlobalID + "'");){
                if (LightsResult.next()) {
                    this.database.executeUpdate("UPDATE Lights SET LightStatus = '" + event.getNewStatus() + "' WHERE LightGlobalID = '" + GlobalID + "'");
                    player.sendTextMessage("Light set to" + event.getNewStatus());
                } else {
                    this.database.executeUpdate("INSERT INTO `Lights` (LightName, LightGlobalID, LightStatus, ChunkPositionX, ChunkPositionY, ChunkPositionZ, GridName, GridNameID, PlayerUID) VALUES ('" + ObjectDefinition2.name + "','" + GlobalID + "','" + event.getNewStatus() + "','" + event.getChunkPositionX() + "','" + event.getChunkPositionY() + "','" + event.getChunkPositionZ() + "','" + PlayerName + "','" + GridNameID + "','" + player.getUID() + "');");
                    player.sendTextMessage("Light Added to your grid");
                }
            }
        }
    }

    @EventMethod
    public void onPlayerChangeObjectInfoEvent(PlayerChangeObjectInfoEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        long GlobalID = event.getGlobalID();
        int ChunkPositionX = event.getChunkPositionX();
        int ChunkPositionY = event.getChunkPositionY();
        int ChunkPositionZ = event.getChunkPositionZ();
        String GridNameID = player.getName() + player.getUID();
        Objects.ObjectDefinition ObjectDefinition2 = event.getObjectDefinition();
        player.sendTextMessage(String.valueOf(ObjectDefinition2));
    }

    @EventMethod
    public void onPlayerObjectInteractionEvent(PlayerObjectInteractionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        long GlobalID = event.getGlobalID();
        int ChunkPositionX = event.getChunkPositionX();
        int ChunkPositionY = event.getChunkPositionY();
        int ChunkPositionZ = event.getChunkPositionZ();
        String GridNameID = player.getName() + player.getUID();
        Objects.ObjectDefinition ObjectDefinition2 = event.getObjectDefinition();
        player.sendTextMessage("Object Interaction" + String.valueOf(ObjectDefinition2));
    }

    @EventMethod
    public void onPlayerRemoveObjectEvent(PlayerRemoveObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        long GlobalID = event.getGlobalID();
        int ChunkPositionX = event.getChunkPositionX();
        int ChunkPositionY = event.getChunkPositionY();
        int ChunkPositionZ = event.getChunkPositionZ();
        String GridNameID = player.getName() + player.getUID();
        Objects.ObjectDefinition ObjectDefinition2 = event.getObjectDefinition();
        if (ObjectDefinition2.type == Objects.Type.Lamp) {
            try (ResultSet LightsResult = this.database.executeQuery("SELECT * FROM `Lights` WHERE `LightGlobalID` = '" + GlobalID + "'");){
                if (LightsResult.next()) {
                    this.database.executeUpdate("DELETE FROM `Lights` WHERE LightGlobalID = '" + GlobalID + "'");
                    player.sendTextMessage("Light Removed from Grid");
                }
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyObjectEvent(PlayerDestroyObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        long GlobalID = event.getGlobalID();
        int ChunkPositionX = event.getChunkPositionX();
        int ChunkPositionY = event.getChunkPositionY();
        int ChunkPositionZ = event.getChunkPositionZ();
        String GridNameID = player.getName() + player.getUID();
        Objects.ObjectDefinition ObjectDefinition2 = event.getObjectDefinition();
        if (ObjectDefinition2.type == Objects.Type.Lamp) {
            try (ResultSet LightsResult = this.database.executeQuery("SELECT * FROM `Lights` WHERE `LightGlobalID` = '" + GlobalID + "'");){
                if (LightsResult.next()) {
                    this.database.executeUpdate("DELETE FROM `Lights` WHERE LightGlobalID = '" + GlobalID + "'");
                    player.sendTextMessage("Light Removed from Grid");
                }
            }
        }
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent evt) throws SQLException {
        Prefab prefab;
        PrefabAsset asset;
        AssetBundle bundle;
        String NewGridNameID;
        ResultSet BatteryResult;
        String NewGridName;
        Player AllPlayers;
        int n;
        int n2;
        Object GridNameID;
        String[] cmd = evt.getCommand().split(" ");
        Player player = evt.getPlayer();
        String PlayerUID = player.getUID();
        Vector3f CollisionPoint = (Vector3f)player.getAttribute("CollisionPoint");
        if (cmd[0].equalsIgnoreCase("/Solar")) {
            AssetBundle bundle2 = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            PrefabAsset asset2 = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle2, (String)"SolarPanel.prefab");
            Prefab prefab2 = new Prefab(asset2);
            prefab2.setLayer(0);
            prefab2.setLocalPosition(CollisionPoint);
            prefab2.setLocalRotation(0.0f, player.getRotation().getYaw(), 0.0f);
            for (Player playerArray : Server.getAllPlayers()) {
                playerArray.addGameObject((GameObject)prefab2);
            }
            GridNameID = player.getName() + player.getUID();
            this.database.executeUpdate("INSERT INTO `SolarPanel` (SolarPanelPosition, SolarPanelRotation, SolarPanelID, SolarPanelMaxOutput, GridName, GridNameID, PlayerUID) VALUES ('" + String.valueOf(CollisionPoint) + "','" + String.valueOf(player.getRotation()) + "','" + prefab2.getID() + "','1000','" + player.getName() + "','" + (String)GridNameID + "','" + player.getUID() + "');");
            player.sendTextMessage("Solar panel Placed");
            for (Prefab Preview : this.PreviewBattery) {
                Player[] n4 = Server.getAllPlayers();
                n2 = n4.length;
                for (n = 0; n < n2; ++n) {
                    AllPlayers = n4[n];
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            for (Prefab Preview : this.PreviewSolarPanel) {
                Player[] playerArray = Server.getAllPlayers();
                n2 = playerArray.length;
                for (n = 0; n < n2; ++n) {
                    AllPlayers = playerArray[n];
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
        }
        if (cmd[0].equalsIgnoreCase("/Battery")) {
            AssetBundle bundle2 = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            PrefabAsset asset2 = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle2, (String)"Battery.prefab");
            Prefab prefab2 = new Prefab(asset2);
            prefab2.setLayer(0);
            prefab2.setLocalPosition(CollisionPoint);
            for (Player player2 : Server.getAllPlayers()) {
                player2.addGameObject((GameObject)prefab2);
            }
            GridNameID = player.getName() + player.getUID();
            this.database.executeUpdate("INSERT INTO `Battery` (BatteryPosition, BatteryID, BatteryMaxCapacity, BatteryCapacity, GridName, GridNameID, PlayerUID) VALUES ('" + String.valueOf(CollisionPoint) + "','" + prefab2.getID() + "','50000','1000','" + player.getName() + "','" + (String)GridNameID + "','" + player.getUID() + "');");
            player.sendTextMessage("Battery Placed");
            for (Prefab Preview : this.PreviewBattery) {
                Player[] playerArray = Server.getAllPlayers();
                n2 = playerArray.length;
                for (n = 0; n < n2; ++n) {
                    AllPlayers = playerArray[n];
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            for (Prefab Preview : this.PreviewSolarPanel) {
                Player[] playerArray = Server.getAllPlayers();
                n2 = playerArray.length;
                for (n = 0; n < n2; ++n) {
                    AllPlayers = playerArray[n];
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
        }
        long HardwareID = (Long)player.getAttribute("HardwareID");
        if (cmd.length == 2 && cmd[0].equalsIgnoreCase("/Delete") && cmd[1].equalsIgnoreCase("SolarPanel")) {
            try (ResultSet SolarResult = this.database.executeQuery("SELECT * FROM `SolarPanel` WHERE `SolarPanelID` = '" + HardwareID + "' AND `PlayerUID` = '" + PlayerUID + "'");){
                if (SolarResult.next()) {
                    this.database.executeUpdate("DELETE FROM `SolarPanel` WHERE `SolarPanelID` = '" + HardwareID + "' AND `PlayerUID` = '" + PlayerUID + "'");
                    for (Prefab SolarPanels : this.SolarPanels) {
                        if ((long)SolarPanels.getID() != HardwareID) continue;
                        Player[] playerArray = Server.getAllPlayers();
                        int n3 = playerArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            Player AllPlayers3 = playerArray[n2];
                            AllPlayers3.removeGameObject((GameObject)SolarPanels);
                        }
                    }
                } else {
                    player.sendTextMessage("Error");
                }
            }
        }
        if (cmd.length == 2 && cmd[0].equalsIgnoreCase("/Delete") && cmd[1].equalsIgnoreCase("Battery")) {
            try (ResultSet BatteryResult2 = this.database.executeQuery("SELECT * FROM `Battery` WHERE `BatteryID` = '" + HardwareID + "' AND `PlayerUID` = '" + PlayerUID + "'");){
                if (BatteryResult2.next()) {
                    this.database.executeUpdate("DELETE FROM `Battery` WHERE `BatteryID` = '" + HardwareID + "' AND `PlayerUID` = '" + PlayerUID + "'");
                    for (Prefab Battery : this.Battery) {
                        if ((long)Battery.getID() != HardwareID) continue;
                        Player[] playerArray = Server.getAllPlayers();
                        int n4 = playerArray.length;
                        for (n2 = 0; n2 < n4; ++n2) {
                            Player AllPlayers4 = playerArray[n2];
                            AllPlayers4.removeGameObject((GameObject)Battery);
                            player.sendTextMessage("players=" + AllPlayers4.getName());
                        }
                    }
                } else {
                    player.sendTextMessage("Error");
                }
            }
        }
        if (cmd.length >= 3 && cmd[0].equalsIgnoreCase("/Change") && cmd[1].equalsIgnoreCase("Battery") && cmd[2].equalsIgnoreCase("GridName")) {
            NewGridName = cmd[3];
            player.sendTextMessage("new name =" + NewGridName);
            BatteryResult = this.database.executeQuery("SELECT * FROM `Battery` WHERE `BatteryID` = '" + HardwareID + "' AND `PlayerUID` = '" + PlayerUID + "'");
            try {
                if (BatteryResult.next()) {
                    NewGridNameID = NewGridName + PlayerUID;
                    this.database.executeUpdate("UPDATE Battery SET GridName = '" + NewGridName + "', GridNameID = '" + NewGridNameID + "' WHERE BatteryID = '" + HardwareID + "' AND PlayerUID = '" + PlayerUID + "'");
                    player.sendTextMessage("Battery Grid ReNamed");
                } else {
                    player.sendTextMessage("Error");
                }
            }
            finally {
                if (BatteryResult != null) {
                    BatteryResult.close();
                }
            }
        }
        if (cmd.length >= 3 && cmd[0].equalsIgnoreCase("/Change") && cmd[1].equalsIgnoreCase("SolarPanel") && cmd[2].equalsIgnoreCase("GridName")) {
            NewGridName = cmd[3];
            player.sendTextMessage("new name =" + NewGridName);
            BatteryResult = this.database.executeQuery("SELECT * FROM `SolarPanel` WHERE `SolarPanelID` = '" + HardwareID + "' AND `PlayerUID` = '" + PlayerUID + "'");
            try {
                if (BatteryResult.next()) {
                    NewGridNameID = NewGridName + PlayerUID;
                    this.database.executeUpdate("UPDATE SolarPanel SET GridName = '" + NewGridName + "', GridNameID = '" + NewGridNameID + "' WHERE SolarPanelID = '" + HardwareID + "' AND PlayerUID = '" + PlayerUID + "'");
                    player.sendTextMessage("SolarPanel Grid ReNamed");
                } else {
                    player.sendTextMessage("Error");
                }
            }
            finally {
                if (BatteryResult != null) {
                    BatteryResult.close();
                }
            }
        }
        if (cmd.length >= 3 && cmd[0].equalsIgnoreCase("/Change") && cmd[1].equalsIgnoreCase("Light") && cmd[2].equalsIgnoreCase("GridName")) {
            NewGridName = cmd[3];
            player.sendTextMessage("new name =" + NewGridName);
            BatteryResult = this.database.executeQuery("SELECT * FROM `Lights` WHERE `LightGlobalID` = '" + HardwareID + "' AND `PlayerUID` = '" + PlayerUID + "'");
            try {
                if (BatteryResult.next()) {
                    NewGridNameID = NewGridName + PlayerUID;
                    this.database.executeUpdate("UPDATE Lights SET GridName = '" + NewGridName + "', GridNameID = '" + NewGridNameID + "' WHERE LightGlobalID = '" + HardwareID + "' AND PlayerUID = '" + PlayerUID + "'");
                    player.sendTextMessage("Light Grid ReNamed");
                } else {
                    player.sendTextMessage("Error");
                }
            }
            finally {
                if (BatteryResult != null) {
                    BatteryResult.close();
                }
            }
        }
        if (cmd.length == 2 && cmd[0].equalsIgnoreCase("/Preview") && cmd[1].equalsIgnoreCase("Battery")) {
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
            bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"Battery.prefab");
            prefab = new Prefab(asset);
            prefab.setLayer(2);
            prefab.setLocalPosition(player.getPosition());
            this.PreviewBattery.add(prefab);
            player.sendTextMessage("place prefabID" + prefab.getID());
            Player[] playerArray = Server.getAllPlayers();
            int n5 = playerArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                Player AllPlayers5 = playerArray[n2];
                AllPlayers5.addGameObject((GameObject)prefab);
            }
        }
        if (cmd.length == 2 && cmd[0].equalsIgnoreCase("/Preview") && cmd[1].equalsIgnoreCase("SolarPanel")) {
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
            bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"SolarPanel.prefab");
            prefab = new Prefab(asset);
            prefab.setLayer(2);
            prefab.setLocalPosition(player.getPosition());
            this.PreviewSolarPanel.add(prefab);
            player.sendTextMessage("place prefabID" + prefab.getID());
            for (Player AllPlayers6 : Server.getAllPlayers()) {
                AllPlayers6.addGameObject((GameObject)prefab);
            }
        }
    }

    @EventMethod
    public void onPlayerMouseButtonEvent(PlayerMouseButtonEvent event) {
        Prefab prefab;
        PrefabAsset asset;
        AssetBundle bundle;
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Object HardwareType = player.getAttribute("HardwareType");
        Vector3f CollisionPoint = (Vector3f)player.getAttribute("CollisionPoint");
        SoundAsset humsoundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/Assets/hum.wav"));
        SoundAsset PlaceSolarsoundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/Assets/PlaceSolar.wav"));
        if (HardwareType.equals("SolarPanel") && event.isPressed() && event.getButton() == MouseButton.Right) {
            bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"SolarPanel.prefab");
            prefab = new Prefab(asset);
            prefab.setLayer(0);
            prefab.setLocalPosition(CollisionPoint);
            prefab.setLocalRotation(0.0f, player.getRotation().getYaw(), 0.0f);
            for (Player player2 : Server.getAllPlayers()) {
                player2.addGameObject((GameObject)prefab);
            }
            String string = player.getName() + player.getUID();
            this.database.executeUpdate("INSERT INTO `SolarPanel` (SolarPanelPosition, SolarPanelRotation, SolarPanelID, SolarPanelMaxOutput, GridName, GridNameID, PlayerUID) VALUES ('" + String.valueOf(CollisionPoint) + "','" + String.valueOf(player.getRotation()) + "','" + prefab.getID() + "','1000','" + player.getName() + "','" + string + "','" + player.getUID() + "');");
            player.sendTextMessage("Solar panel Placed");
            player.setAttribute("HardwareType", (Object)"null");
            for (Prefab Preview : this.PreviewBattery) {
                for (Player AllPlayers : Server.getAllPlayers()) {
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            for (Prefab Preview : this.PreviewSolarPanel) {
                for (Player AllPlayers : Server.getAllPlayers()) {
                    AllPlayers.playSound(PlaceSolarsoundfile, prefab.getLocalPosition());
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
        }
        if (HardwareType.equals("Battery") && event.isPressed() && event.getButton() == MouseButton.Right) {
            bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"Battery.prefab");
            prefab = new Prefab(asset);
            prefab.setLayer(0);
            prefab.setLocalPosition(CollisionPoint);
            this.Battery.add(prefab);
            for (Player player3 : Server.getAllPlayers()) {
                player3.addGameObject((GameObject)prefab);
                player3.playSound(PlaceSolarsoundfile, prefab.getLocalPosition());
                player3.playSound(humsoundfile, true, 0.3f, 0.5f, prefab.getLocalPosition());
            }
            String string = player.getName() + player.getUID();
            this.database.executeUpdate("INSERT INTO `Battery` (BatteryPosition, BatteryID, BatteryMaxCapacity, BatteryCapacity, GridName, GridNameID, PlayerUID) VALUES ('" + String.valueOf(CollisionPoint) + "','" + prefab.getID() + "','50000','1000','" + player.getName() + "','" + string + "','" + player.getUID() + "');");
            player.sendTextMessage("Battery Placed");
            player.setAttribute("HardwareType", (Object)"null");
            for (Prefab Preview : this.PreviewBattery) {
                for (Player AllPlayers : Server.getAllPlayers()) {
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            for (Prefab Preview : this.PreviewSolarPanel) {
                for (Player AllPlayers : Server.getAllPlayers()) {
                    AllPlayers.removeGameObject((GameObject)Preview);
                }
            }
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
        }
    }

    @EventMethod
    public void onPlayerKeyInputEvent(PlayerKeyEvent event) throws SQLException {
        Prefab prefab;
        PrefabAsset asset;
        AssetBundle bundle;
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        Vector3f CollisionPoint = (Vector3f)player.getAttribute("CollisionPoint");
        if (event.isPressed() && event.getKey() == Key.S && player.isKeyPressed(Key.LeftShift)) {
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
            player.setAttribute("HardwareType", (Object)"SolarPanel");
            bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"SolarPanel.prefab");
            prefab = new Prefab(asset);
            prefab.setLayer(2);
            prefab.setLocalPosition(player.getPosition());
            this.PreviewSolarPanel.add(prefab);
            player.sendTextMessage("place prefabID" + prefab.getID());
            for (Player AllPlayers : Server.getAllPlayers()) {
                AllPlayers.addGameObject((GameObject)prefab);
            }
            player.sendTextMessage("Solar Preview Eanabled");
        }
        if (event.isPressed() && event.getKey() == Key.B && player.isKeyPressed(Key.LeftShift)) {
            this.PreviewBattery.clear();
            this.PreviewSolarPanel.clear();
            player.setAttribute("HardwareType", (Object)"Battery");
            bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/Assets/solarpanel.bundle"));
            asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"Battery.prefab");
            prefab = new Prefab(asset);
            prefab.setLayer(2);
            prefab.setLocalPosition(player.getPosition());
            this.PreviewBattery.add(prefab);
            player.sendTextMessage("place prefabID" + prefab.getID());
            for (Player AllPlayers : Server.getAllPlayers()) {
                AllPlayers.addGameObject((GameObject)prefab);
            }
            player.sendTextMessage("Battery Preview Enabled");
        }
    }

    @EventMethod
    public void onPlayerChangeBlockPositionEvent(PlayerChangeBlockPositionEvent event) {
        Player player = event.getPlayer();
    }

    @EventMethod
    public void onPlayerHitObjectEvent(PlayerHitObjectEvent event) {
        Player player = event.getPlayer();
    }
}

