/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg.model3d;

import de.chaoswg.model3d.Model3D;
import de.chaoswg.model3d.PlaceGameObjectLang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.risingworld.api.Internals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Align;
import net.risingworld.api.ui.style.DisplayStyle;
import net.risingworld.api.ui.style.FlexDirection;
import net.risingworld.api.ui.style.Position;
import net.risingworld.api.ui.style.Style;
import net.risingworld.api.ui.style.Unit;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Layer;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.GameObject;

public class PlaceGameObject
implements Listener {
    private final Plugin plugin;
    private final Player player;
    private final Key[] keysPlaceGameObject = new Key[]{Key.UpArrow, Key.DownArrow, Key.LeftArrow, Key.RightArrow, Key.PageUp, Key.PageDown, Key.RightCtrl, Key.Escape, Key.Enter, Key.LeftShift, Key.Delete, Key.Backspace, Key.C};
    private final int layerMask = Layer.getBitmask((int[])new int[]{13, 8, 11, 23, 15, 14, 1});
    Timer rayCastTimer = null;
    private final String pa_GameObject = "de.chaoswg.model3d.PlaceGameObject.GameObject";
    private final String pa_GameObject_Rotate = "de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate";
    private final String pa_GameObject_Scale = "de.chaoswg.model3d.PlaceGameObject.GameObject.Scale";
    private final String pa_GameObject_Pos = "de.chaoswg.model3d.PlaceGameObject.GameObject.Pos";
    private final String pa_GameObject_ManualMode = "de.chaoswg.model3d.PlaceGameObject.ManualMode";
    final String STEP_FORMAT = "%.3f";
    String ROTAT_FORMAT = "%.2f";
    float POSITION_STEP = 0.5f;
    float ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)45.0f);
    float SCALL_STEP = 0.5f;
    private final confirmCallback cbEnter;
    private final confirmCallback cbExit;
    private UILabel transformStusLabel;
    private UILabel gridStusLabel;
    private final String transformStusText = "Gr\u00f6\u00dfe: ";
    private final String rotationStusText = "Rotation: ";
    private final String gridStusText = "Grid ";
    private final TextureAsset[] radialHauptmenuIcons;
    private final TextureAsset[] radialBewegungScalierenIcons;
    private final TextureAsset[] radialRotationIcons;
    String[] radialHauptmenuOverrideTexts = new String[]{"Zur\u00fcck", "Berwgung", "Scalierung", "Drehung"};
    String[] radialHauptmenuDescriptions = new String[]{"", "Pr\u00e4zision", "d2", "d3"};
    String[] radialScalierenOverrideTexts = new String[]{"Scalierung", "Scalierung", "Scalierung", "Scalierung", "Scalierung", "Scalierung"};
    String[] radialScalierenDescriptions = new String[]{"Zur\u00fcck", "2", "1", "0.5", "0.1", "0.01"};
    String[] radialBewegungOverrideTexts = new String[]{"Berwgung", "Berwgung", "Berwgung", "Berwgung", "Berwgung", "Berwgung"};
    String[] radialBewegungDescriptions = new String[]{"Zur\u00fcck", "2", "1", "0.5", "0.1", "0.01"};
    String[] radialRotationOverrideTexts = new String[]{"Drehung", "Drehung", "Drehung", "Drehung", "Drehung", "Drehung", "Drehung", "Drehung", "Drehung", "Drehung"};
    String[] radialRotationDescriptions = new String[]{"Zur\u00fcck", "90", "45", "15", "10", "5", "1", "0.5", "0.1", "0.01"};
    private final PlaceGameObjectLang lang;
    HashMap<String, List<Key>> keysDown = new HashMap();

    private PlaceGameObject(Plugin plugin, Player player, PlaceGameObjectLang lang, confirmCallback cbEnter, confirmCallback cbExit) {
        int i;
        this.plugin = plugin;
        this.player = player;
        this.cbEnter = cbEnter;
        this.cbExit = cbExit;
        this.lang = lang;
        this.lang.setPlayerLang(this.player.getLanguage());
        this.radialHauptmenuIcons = new TextureAsset[]{TextureAsset.loadFromGame((String)"Interface/icons/flaticon/door1.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/move1.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/size1.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/rotate1.png")};
        this.radialBewegungScalierenIcons = new TextureAsset[]{TextureAsset.loadFromGame((String)"Interface/icons/flaticon/door1.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed2.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed1.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed05.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed01.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed001.png")};
        this.radialRotationIcons = new TextureAsset[]{TextureAsset.loadFromGame((String)"Interface/icons/flaticon/door1.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed90.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed45.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed15.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed10.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed5.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed1.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed05.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed01.png"), TextureAsset.loadFromGame((String)"Interface/icons/building/fixed001.png")};
        this.radialHauptmenuOverrideTexts = new String[]{lang.getRadial().getBack(player.getLanguage()), lang.getRadial().getMove(player.getLanguage()), lang.getRadial().getScale(player.getLanguage()), lang.getRadial().getRotation(player.getLanguage())};
        for (i = 0; i < this.radialBewegungOverrideTexts.length; ++i) {
            this.radialBewegungOverrideTexts[i] = lang.getRadial().getMove(player.getLanguage());
        }
        for (i = 0; i < this.radialScalierenOverrideTexts.length; ++i) {
            this.radialScalierenOverrideTexts[i] = lang.getRadial().getScale(player.getLanguage());
        }
        for (i = 0; i < this.radialRotationOverrideTexts.length; ++i) {
            this.radialRotationOverrideTexts[i] = lang.getRadial().getRotation(player.getLanguage());
        }
    }

    public static PlaceGameObject create(Plugin plugin, Player player, PlaceGameObjectLang lang, confirmCallback cbEnter, confirmCallback cbExit) {
        return new PlaceGameObject(plugin, player, lang, cbEnter, cbExit);
    }

    public void placeGameObject(Model3D.ClassPlayerGameObject gameObject) {
        this.player.setListenForKeyInput(true);
        this.player.registerKeys(this.keysPlaceGameObject);
        this.player.disableClientsideKeys(this.keysPlaceGameObject);
        this.plugin.registerEventListener((Listener)this);
        this.player.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject", (Object)gameObject);
        this.sytyleDo(true);
        Arrays.asList(Server.getAllPlayers()).forEach(playerLokal -> new Timer(0.0f, 0.25f, 0, () -> playerLokal.addGameObject((GameObject)gameObject)).start());
        Callback callbackRayCast = raycastResult -> {
            if (raycastResult != null) {
                System.out.println(raycastResult.isTrigger() + " " + String.valueOf(raycastResult.getObjectPosition()));
                Vector3f scale = new Vector3f((Vector3f)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale"));
                Quaternion rot = (Quaternion)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate");
                Vector3f pos = raycastResult.getCollisionPoint();
                gameObject.setLocalPosition(pos);
                gameObject.setLocalScale(scale);
                gameObject.setLocalRotation(rot);
            }
        };
        Runnable taskRayCast = () -> {
            if (((Boolean)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.ManualMode")).booleanValue()) {
                Vector3f scale = new Vector3f((Vector3f)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale"));
                Quaternion rot = (Quaternion)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate");
                Vector3f pos = (Vector3f)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos");
                gameObject.setLocalPosition(pos);
                gameObject.setLocalScale(scale);
                gameObject.setLocalRotation(rot);
            } else {
                this.player.raycast(this.layerMask, callbackRayCast);
            }
        };
        this.player.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)new Quaternion());
        this.player.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)new Vector3f(1.0f, 1.0f, 1.0f));
        this.player.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)new Vector3f());
        this.player.setAttribute("de.chaoswg.model3d.PlaceGameObject.ManualMode", (Object)false);
        this.rayCastTimer = new Timer(0.05f, 0.25f, -1, taskRayCast);
        this.rayCastTimer.start();
    }

    private void sytyleDo(boolean on) {
        Style sShow = new Style();
        sShow.display.set((Enum)(on ? DisplayStyle.Flex : DisplayStyle.None));
        Style sHide = new Style();
        sHide.display.set((Enum)(on ? DisplayStyle.None : DisplayStyle.Flex));
        if (on) {
            if (this.transformStusLabel == null) {
                this.transformStusLabel = new UILabel(this.getTransformText((Model3D.ClassPlayerGameObject)((Object)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject"))));
                this.transformStusLabel.style.position.set((Enum)Position.Relative);
                this.transformStusLabel.style.alignSelf.set((Enum)Align.FlexEnd);
                this.transformStusLabel.style.alignItems.set((Enum)Align.Center);
                this.transformStusLabel.style.flexBasis.set(20.0f, Unit.Pixel);
                this.transformStusLabel.style.flexGrow.set(100.0f);
                this.transformStusLabel.style.flexShrink.set(50.0f);
                this.transformStusLabel.style.flexDirection.set((Enum)FlexDirection.ColumnReverse);
            }
            if (this.gridStusLabel == null) {
                this.gridStusLabel = new UILabel(this.getGridText());
                this.gridStusLabel.style.position.set((Enum)Position.Relative);
                this.gridStusLabel.style.alignItems.set((Enum)Align.Center);
                this.gridStusLabel.style.alignSelf.set((Enum)Align.Center);
                this.gridStusLabel.style.flexBasis.set(20.0f, Unit.Pixel);
                this.gridStusLabel.style.flexDirection.set((Enum)FlexDirection.Column);
            }
            Internals.addUIElementToPlayer((Player)this.player, (UIElement)this.transformStusLabel, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/transformStatusContainer");
            Internals.addUIElementToPlayer((Player)this.player, (UIElement)this.gridStusLabel, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/gridStatusContainer");
        } else {
            this.player.removeUIElement((UIElement)this.transformStusLabel);
            this.player.removeUIElement((UIElement)this.gridStusLabel);
        }
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer", (Style)sShow);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/transformStatusContainer", (Style)sShow);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/transformStatusContainer/statusLabel", (Style)sHide);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/gridStatusContainer", (Style)sShow);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/gridStatusContainer/statusLabel", (Style)sHide);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/collisionStatusContainer", (Style)sHide);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/surfaceEditStatusContainer", (Style)sHide);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/modularModeStatusContainer", (Style)sHide);
        Internals.overwriteUIStyle((Player)this.player, (String)"HudLayer/hudContainer/leftContainer/buildingStatusContainer/textureTilingStatusContainer", (Style)sHide);
    }

    private void doExit() {
        this.rayCastTimer.kill();
        this.plugin.unregisterEventListener((Listener)this);
        this.player.enableClientsideKeys(this.keysPlaceGameObject);
        this.player.unregisterKeys(this.keysPlaceGameObject);
        ((Model3D.ClassPlayerGameObject)((Object)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject"))).hideBoundBox();
        this.sytyleDo(false);
    }

    private String getTransformText(Model3D.ClassPlayerGameObject go) {
        StringBuilder tsl = new StringBuilder();
        tsl.append(" ");
        tsl.append("Gr\u00f6\u00dfe: ");
        tsl.append(" x: ");
        tsl.append(String.format("%.3f", Float.valueOf(go.getLocalScale().x)));
        tsl.append(" y: ");
        tsl.append(String.format("%.3f", Float.valueOf(go.getLocalScale().y)));
        tsl.append(" z: ");
        tsl.append(String.format("%.3f", Float.valueOf(go.getLocalScale().z)));
        tsl.append("\n");
        tsl.append(" ");
        tsl.append("Rotation: ");
        tsl.append(" x: ");
        tsl.append(String.format("%.3f\u00b0", Float.valueOf(go.getLocalRotation().toAngles()[0])));
        tsl.append(" y: ");
        tsl.append(String.format("%.3f\u00b0", Float.valueOf(go.getLocalRotation().toAngles()[1])));
        tsl.append(" z: ");
        tsl.append(String.format("%.3f\u00b0", Float.valueOf(go.getLocalRotation().toAngles()[2])));
        return tsl.toString();
    }

    private String getTransformText(Player player) {
        StringBuilder tsl = new StringBuilder();
        tsl.append(" ");
        tsl.append("Gr\u00f6\u00dfe: ");
        tsl.append(" x: ");
        tsl.append(String.format("%.3f", Float.valueOf(((Vector3f)player.getAttribute((String)"de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).x)));
        tsl.append(" y: ");
        tsl.append(String.format("%.3f", Float.valueOf(((Vector3f)player.getAttribute((String)"de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).y)));
        tsl.append(" z: ");
        tsl.append(String.format("%.3f", Float.valueOf(((Vector3f)player.getAttribute((String)"de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).z)));
        tsl.append("\n");
        tsl.append(" ");
        tsl.append("Rotation: ");
        tsl.append(" x: ");
        tsl.append(String.format("%.3f\u00b0", Float.valueOf(((Quaternion)player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).toAngles()[0])));
        tsl.append(" y: ");
        tsl.append(String.format("%.3f\u00b0", Float.valueOf(((Quaternion)player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).toAngles()[1])));
        tsl.append(" z: ");
        tsl.append(String.format("%.3f\u00b0", Float.valueOf(((Quaternion)player.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).toAngles()[2])));
        return tsl.toString();
    }

    private String getGridText() {
        StringBuilder gsl = new StringBuilder();
        gsl.append(" ");
        gsl.append("Grid ");
        gsl.append(this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.ManualMode") == null ? false : (Boolean)this.player.getAttribute("de.chaoswg.model3d.PlaceGameObject.ManualMode"));
        return gsl.toString();
    }

    @EventMethod
    public void onPlayerKeyInput(PlayerKeyEvent event) {
        Player playerLocal = event.getPlayer();
        Key key = event.getKey();
        if (event.isPressed() && this.player.equals(playerLocal)) {
            System.out.println("PlaceGameObject onPlayerKeyInput Key[" + key.name() + "] ");
            List<Key> kesList = this.keysDown.get(playerLocal.getUID());
            if (kesList == null) {
                kesList = new ArrayList<Key>();
                kesList.add(key);
                this.keysDown.put(playerLocal.getUID(), kesList);
            } else {
                this.keysDown.get(playerLocal.getUID()).add(key);
            }
            if (this.rayCastTimer != null) {
                Model3D.ClassPlayerGameObject gameObject = (Model3D.ClassPlayerGameObject)((Object)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject"));
                boolean manualMode = (Boolean)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.ManualMode");
                Vector3f rVD = this.roundViewDirection(playerLocal.getViewDirection());
                switch (key) {
                    case Escape: {
                        Arrays.asList(Server.getAllPlayers()).forEach(playerLopp -> playerLopp.removeGameObject((GameObject)((Model3D.ClassPlayerGameObject)((Object)((Object)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject"))))));
                        this.doExit();
                        if (this.cbExit == null) break;
                        this.cbExit.onCall(playerLocal, (Model3D.ClassPlayerGameObject)((Object)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject")));
                        break;
                    }
                    case Enter: {
                        this.doExit();
                        if (this.cbEnter == null) break;
                        this.cbEnter.onCall(playerLocal, (Model3D.ClassPlayerGameObject)((Object)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject")));
                        break;
                    }
                    case Backspace: {
                        if (manualMode) break;
                        if (this.keysDown.get(playerLocal.getUID()).contains(Key.LeftShift)) {
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)new Vector3f(1.0f, 1.0f, 1.0f));
                            break;
                        }
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)new Quaternion());
                        break;
                    }
                    case C: {
                        if (Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP) >= 1.0f) {
                            this.ROTAT_FORMAT = "%.0f\u00b0";
                        } else if (Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP) < 0.1f) {
                            this.ROTAT_FORMAT = "%.2f\u00b0";
                        } else if (Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP) < 1.0f) {
                            this.ROTAT_FORMAT = "%.1f\u00b0";
                        }
                        this.radialHauptmenuDescriptions = new String[]{"", String.valueOf(this.POSITION_STEP), String.valueOf(this.SCALL_STEP), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP)))};
                        playerLocal.showRadialMenu(this.radialHauptmenuIcons, this.radialHauptmenuDescriptions, this.radialHauptmenuOverrideTexts, false, auswahl -> {
                            System.out.println("Auswahl[" + auswahl + "] ");
                            new Timer(0.0f, 0.05f, 0, () -> {
                                switch (auswahl) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        this.radialBewegungDescriptions = new String[]{String.valueOf(this.POSITION_STEP), String.valueOf(this.POSITION_STEP), String.valueOf(this.POSITION_STEP), String.valueOf(this.POSITION_STEP), String.valueOf(this.POSITION_STEP), String.valueOf(this.POSITION_STEP)};
                                        playerLocal.showRadialMenu(this.radialBewegungScalierenIcons, this.radialBewegungDescriptions, this.radialBewegungOverrideTexts, true, auswahlBewgung -> {
                                            System.out.println("Auswahl[" + auswahlBewgung + "] ");
                                            switch (auswahlBewgung) {
                                                case 0: {
                                                    System.out.println("Zur\u00fcck");
                                                    break;
                                                }
                                                case 1: {
                                                    this.POSITION_STEP = 2.0f;
                                                    break;
                                                }
                                                case 2: {
                                                    this.POSITION_STEP = 1.0f;
                                                    break;
                                                }
                                                case 3: {
                                                    this.POSITION_STEP = 0.5f;
                                                    break;
                                                }
                                                case 4: {
                                                    this.POSITION_STEP = 0.1f;
                                                    break;
                                                }
                                                case 5: {
                                                    this.POSITION_STEP = 0.01f;
                                                }
                                            }
                                        });
                                        break;
                                    }
                                    case 2: {
                                        this.radialScalierenDescriptions = new String[]{String.valueOf(this.SCALL_STEP), String.valueOf(this.SCALL_STEP), String.valueOf(this.SCALL_STEP), String.valueOf(this.SCALL_STEP), String.valueOf(this.SCALL_STEP), String.valueOf(this.SCALL_STEP)};
                                        playerLocal.showRadialMenu(this.radialBewegungScalierenIcons, this.radialScalierenDescriptions, this.radialScalierenOverrideTexts, true, auswahlBewgung -> {
                                            System.out.println("Auswahl[" + auswahlBewgung + "] ");
                                            switch (auswahlBewgung) {
                                                case 0: {
                                                    System.out.println("Zur\u00fcck");
                                                    break;
                                                }
                                                case 1: {
                                                    this.SCALL_STEP = 2.0f;
                                                    break;
                                                }
                                                case 2: {
                                                    this.SCALL_STEP = 1.0f;
                                                    break;
                                                }
                                                case 3: {
                                                    this.SCALL_STEP = 0.5f;
                                                    break;
                                                }
                                                case 4: {
                                                    this.SCALL_STEP = 0.1f;
                                                    break;
                                                }
                                                case 5: {
                                                    this.SCALL_STEP = 0.01f;
                                                }
                                            }
                                        });
                                        break;
                                    }
                                    case 3: {
                                        if (Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP) >= 1.0f) {
                                            this.ROTAT_FORMAT = "%.0f\u00b0";
                                        } else if (Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP) < 0.1f) {
                                            this.ROTAT_FORMAT = "%.2f\u00b0";
                                        } else if (Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP) < 1.0f) {
                                            this.ROTAT_FORMAT = "%.1f\u00b0";
                                        }
                                        this.radialRotationDescriptions = new String[]{String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP))), String.format(this.ROTAT_FORMAT, Float.valueOf(Utils.MathUtils.radianToDegree((float)this.ROTATION_STEP)))};
                                        playerLocal.showRadialMenu(this.radialRotationIcons, this.radialRotationDescriptions, this.radialRotationOverrideTexts, true, auswahlBewgung -> {
                                            System.out.println("Auswahl[" + auswahlBewgung + "] ");
                                            switch (auswahlBewgung) {
                                                case 0: {
                                                    System.out.println("Zur\u00fcck");
                                                    break;
                                                }
                                                case 1: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)90.0f);
                                                    break;
                                                }
                                                case 2: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)45.0f);
                                                    break;
                                                }
                                                case 3: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)15.0f);
                                                    break;
                                                }
                                                case 4: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)10.0f);
                                                    break;
                                                }
                                                case 5: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)5.0f);
                                                    break;
                                                }
                                                case 6: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)1.0f);
                                                    break;
                                                }
                                                case 7: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)0.5f);
                                                    break;
                                                }
                                                case 8: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)0.1f);
                                                    break;
                                                }
                                                case 9: {
                                                    this.ROTATION_STEP = Utils.MathUtils.degreeToRadian((float)0.01f);
                                                }
                                            }
                                        });
                                    }
                                }
                            }).start();
                        });
                        break;
                    }
                    case LeftArrow: {
                        if (manualMode) {
                            Vector3f pos = new Vector3f((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos")).addLocal(-this.POSITION_STEP * rVD.z, 0.0f, this.POSITION_STEP * rVD.x);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)pos);
                            break;
                        }
                        if (this.keysDown.get(playerLocal.getUID()).contains(Key.LeftShift)) {
                            if (!(((Vector3f)playerLocal.getAttribute((String)"de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).x - this.SCALL_STEP > 0.0f)) break;
                            Vector3f scale = ((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).subtract(this.SCALL_STEP, 0.0f, 0.0f);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)scale);
                            break;
                        }
                        Quaternion rot = new Quaternion((Quaternion)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).multLocal(new Quaternion().fromAngles(0.0f, this.ROTATION_STEP, 0.0f));
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)rot);
                        break;
                    }
                    case RightArrow: {
                        if (manualMode) {
                            Vector3f pos = new Vector3f((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos")).addLocal(this.POSITION_STEP * rVD.z, 0.0f, -this.POSITION_STEP * rVD.x);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)pos);
                            break;
                        }
                        if (this.keysDown.get(playerLocal.getUID()).contains(Key.LeftShift)) {
                            Vector3f scale = ((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).add(this.SCALL_STEP, 0.0f, 0.0f);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)scale);
                            break;
                        }
                        Quaternion rot = new Quaternion((Quaternion)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).multLocal(new Quaternion().fromAngles(0.0f, -this.ROTATION_STEP, 0.0f));
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)rot);
                        break;
                    }
                    case UpArrow: {
                        if (manualMode) {
                            Vector3f pos = new Vector3f((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos")).addLocal(this.POSITION_STEP * rVD.x, 0.0f, this.POSITION_STEP * rVD.z);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)pos);
                            break;
                        }
                        if (this.keysDown.get(playerLocal.getUID()).contains(Key.LeftShift)) {
                            Vector3f scale = ((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).add(0.0f, 0.0f, this.SCALL_STEP);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)scale);
                            break;
                        }
                        Quaternion rot = new Quaternion((Quaternion)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).multLocal(new Quaternion().fromAngles(this.ROTATION_STEP, 0.0f, 0.0f));
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)rot);
                        break;
                    }
                    case DownArrow: {
                        if (manualMode) {
                            Vector3f pos = new Vector3f((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos")).addLocal(-this.POSITION_STEP * rVD.x, 0.0f, -this.POSITION_STEP * rVD.z);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)pos);
                            break;
                        }
                        if (this.keysDown.get(playerLocal.getUID()).contains(Key.LeftShift)) {
                            if (!(((Vector3f)playerLocal.getAttribute((String)"de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).z - this.SCALL_STEP > 0.0f)) break;
                            Vector3f scale = ((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).subtract(0.0f, 0.0f, this.SCALL_STEP);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)scale);
                            break;
                        }
                        Quaternion rot = new Quaternion((Quaternion)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).multLocal(new Quaternion().fromAngles(-this.ROTATION_STEP, 0.0f, 0.0f));
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)rot);
                        break;
                    }
                    case PageUp: {
                        if (manualMode) {
                            Vector3f pos = new Vector3f((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos")).addLocal(0.0f, this.POSITION_STEP, 0.0f);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)pos);
                            break;
                        }
                        if (this.keysDown.get(playerLocal.getUID()).contains(Key.LeftShift)) {
                            Vector3f scale = ((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).add(0.0f, this.SCALL_STEP, 0.0f);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)scale);
                            break;
                        }
                        Quaternion rot = new Quaternion((Quaternion)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, this.ROTATION_STEP));
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)rot);
                        break;
                    }
                    case PageDown: {
                        if (manualMode) {
                            Vector3f pos = new Vector3f((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos")).addLocal(0.0f, -this.POSITION_STEP, 0.0f);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)pos);
                            break;
                        }
                        if (this.keysDown.get(playerLocal.getUID()).contains(Key.LeftShift)) {
                            if (!(((Vector3f)playerLocal.getAttribute((String)"de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).y - this.SCALL_STEP > 0.0f)) break;
                            Vector3f scale = ((Vector3f)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale")).subtract(0.0f, this.SCALL_STEP, 0.0f);
                            playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Scale", (Object)scale);
                            break;
                        }
                        Quaternion rot = new Quaternion((Quaternion)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate")).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, -this.ROTATION_STEP));
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Rotate", (Object)rot);
                        break;
                    }
                    case Delete: {
                        gameObject.toggleBoundBox();
                        break;
                    }
                    case RightCtrl: {
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject.Pos", (Object)((Model3D.ClassPlayerGameObject)((Object)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.GameObject"))).getLocalPosition());
                        playerLocal.setAttribute("de.chaoswg.model3d.PlaceGameObject.ManualMode", (Object)((Boolean)playerLocal.getAttribute("de.chaoswg.model3d.PlaceGameObject.ManualMode") == false ? 1 : 0));
                        this.gridStusLabel.setText(this.getGridText());
                        break;
                    }
                }
                System.out.println("Debug 4");
                this.transformStusLabel.setText(this.getTransformText(this.player));
            }
        } else if (this.player.equals(playerLocal) && this.keysDown.get(playerLocal.getUID()) != null) {
            this.keysDown.get(playerLocal.getUID()).remove(key);
        }
        System.out.println("Key Hold Info: " + this.keysDown.toString());
    }

    private Vector3f roundViewDirection(Vector3f viewDirection) {
        Vector3f result = new Vector3f();
        if ((double)viewDirection.x > 0.5) {
            result.x = 1.0f;
        } else if ((double)viewDirection.x <= 0.5 && viewDirection.x > 0.0f || viewDirection.x < 0.0f && (double)viewDirection.x >= -0.5) {
            result.x = 0.0f;
        } else if ((double)viewDirection.x < -0.5) {
            result.x = -1.0f;
        }
        result.y = 1.0f;
        if ((double)viewDirection.z > 0.5) {
            result.z = 1.0f;
        } else if ((double)viewDirection.z <= 0.5 && viewDirection.z > 0.0f || viewDirection.z < 0.0f && (double)viewDirection.z >= -0.5) {
            result.z = 0.0f;
        } else if ((double)viewDirection.z < -0.5) {
            result.z = -1.0f;
        }
        return result;
    }

    public static interface confirmCallback {
        public void onCall(Player var1, Model3D.ClassPlayerGameObject var2);
    }
}

