/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg.model3d;

import de.chaoswg.DB;
import de.chaoswg.model3d.Model3D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.GameObject;

public class Model3DDBController
extends DB.DBController {
    @Override
    public void handleDB() {
        System.out.print("HandelDB ");
        try {
            if (this.getConnection().isClosed()) {
                this.connect();
            }
            System.out.print(".");
            Statement stmt = this.getConnection().createStatement();
            boolean dbType = false;
            boolean dbTypeMySQL = true;
            System.out.print(".");
            stmt.execute("CREATE TABLE IF NOT EXISTS '" + (String)(!this.getMySqlPrefix().equals("") ? this.getMySqlPrefix() + "_" : "") + "Model3D' (ID INTEGER " + (dbType == dbTypeMySQL ? "AUTO_INCREMENT " : "PRIMARY KEY ") + "NOT NULL, playerUID VARCHR(18), posX REAL, posY REAL, posZ REAL, rotW REAL, rotX REAL, rotY REAL, rotZ REAL, scaleX REAL, scaleY REAL, scaleZ REAL, AssetName VARCHAR(32), BundelPhat VARCHAR(255) " + (dbType == dbTypeMySQL ? ",PRIMARY KEY (ID) " : "") + "); ");
            System.out.print(".");
        }
        catch (SQLException e) {
            System.err.println("Couldn't handle DB-Query");
            System.err.println(e);
        }
        System.out.print("\n");
    }

    public int insertModel3D(Player player, GameObject gameObject, String bundelPhat, String assetName) {
        int result = -1;
        try {
            if (this.getConnection().isClosed()) {
                this.connect();
            }
            PreparedStatement ps = this.getConnection().prepareStatement("INSERT INTO '" + (String)(!this.getMySqlPrefix().equals("") ? this.getMySqlPrefix() + "_" : "") + "Model3D' (playerUID,posX,posY,posZ,rotW,rotX,rotY,rotZ,scaleX,scaleY,scaleZ,AssetName,BundelPhat) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
            ps.setString(1, player.getUID());
            ps.setFloat(2, gameObject.getLocalPosition().x);
            ps.setFloat(3, gameObject.getLocalPosition().y);
            ps.setFloat(4, gameObject.getLocalPosition().z);
            ps.setFloat(5, gameObject.getLocalRotation().w);
            ps.setFloat(6, gameObject.getLocalRotation().x);
            ps.setFloat(7, gameObject.getLocalRotation().y);
            ps.setFloat(8, gameObject.getLocalRotation().z);
            ps.setFloat(9, gameObject.getLocalScale().x);
            ps.setFloat(10, gameObject.getLocalScale().y);
            ps.setFloat(11, gameObject.getLocalScale().z);
            ps.setString(12, assetName);
            ps.setString(13, bundelPhat);
            ps.addBatch();
            this.getConnection().setAutoCommit(false);
            ps.executeBatch();
            this.getConnection().setAutoCommit(true);
            ResultSet tableKeys = ps.getGeneratedKeys();
            tableKeys.next();
            result = tableKeys.getInt(1);
            this.getConnection().close();
        }
        catch (SQLException ex) {
            Logger.getLogger(Model3DDBController.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(ex.getMessage());
        }
        return result;
    }

    public HashMap<Integer, Model3D.ClassDBModel3D> getModel3D() {
        HashMap<Integer, Model3D.ClassDBModel3D> result = new HashMap<Integer, Model3D.ClassDBModel3D>();
        try {
            if (this.getConnection().isClosed()) {
                this.connect();
            }
            try (ResultSet rs = this.getConnection().createStatement().executeQuery("SELECT * FROM '" + (String)(!this.getMySqlPrefix().equals("") ? this.getMySqlPrefix() + "_" : "") + "Model3D';");){
                while (rs.next()) {
                    result.put(rs.getInt("ID"), new Model3D().new Model3D.ClassDBModel3D(rs.getString("playerUID"), rs.getInt("ID"), new Vector3f(rs.getFloat("posX"), rs.getFloat("posY"), rs.getFloat("posZ")), new Quaternion(rs.getFloat("rotX"), rs.getFloat("rotY"), rs.getFloat("rotZ"), rs.getFloat("rotW")), new Vector3f(rs.getFloat("scaleX"), rs.getFloat("scaleY"), rs.getFloat("scaleZ")), rs.getString("AssetName"), rs.getString("BundelPhat")));
                }
            }
            this.getConnection().close();
        }
        catch (SQLException ex) {
            Logger.getLogger(Model3DDBController.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(ex.getMessage());
        }
        return result;
    }

    public void deletModel3D(int id) {
        try {
            if (this.getConnection().isClosed()) {
                this.connect();
            }
            PreparedStatement ps = this.getConnection().prepareStatement("DELETE FROM '" + (String)(!this.getMySqlPrefix().equals("") ? this.getMySqlPrefix() + "_" : "") + "Model3D' WHERE ID = " + id + ";");
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            Logger.getLogger(Model3DDBController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

