/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg.model3d;

import de.chaoswg.ClassPluginJSONManager;
import de.chaoswg.model3d.Model3DPrefabConfig;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.assets.AssetBundle;
import net.risingworld.api.assets.MaterialAsset;
import net.risingworld.api.assets.ModelAsset;
import net.risingworld.api.assets.PrefabAsset;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.GameObject;
import net.risingworld.api.worldelements.Model;

public class Model3D {
    public static File[] getBundleFiles(File path) {
        if (path.exists()) {
            System.out.println("Get Bundel Files");
            File allFiles = new File(path.getPath());
            return (File[])Arrays.stream(allFiles.listFiles()).filter(findFile -> findFile.getName().endsWith(".bundle")).toArray(File[]::new);
        }
        return null;
    }

    public HashMap<String, HashMap<String, Model3DPrefabAsset>> bundelData(File[] bundelFiles) {
        return this.bundelData(bundelFiles, false);
    }

    public HashMap<String, HashMap<String, Model3DPrefabAsset>> bundelData(File[] bundelFiles, boolean DEBUG) {
        HashMap<String, HashMap<String, Model3DPrefabAsset>> result = new HashMap<String, HashMap<String, Model3DPrefabAsset>>();
        Arrays.stream(bundelFiles).forEach(file -> {
            ClassConfigData configModelData = new Model3D().new ClassConfigData();
            if (DEBUG) {
                System.out.println("Finde Datein: " + file.getAbsolutePath());
            }
            ClassPluginJSONManager jm = new ClassPluginJSONManager();
            configModelData = (ClassConfigData)jm.update(configModelData, file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(".")) + ".json", DEBUG);
            AssetBundle bundle = AssetBundle.loadFromFile((String)file.getAbsolutePath());
            HashMap value = new HashMap();
            Arrays.asList(configModelData.Prefabs).forEach(prefabConfig -> {
                PrefabAsset asset;
                if (DEBUG) {
                    System.out.println(prefabConfig.getName());
                }
                if ((asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)prefabConfig.getPrefab())) != null) {
                    value.put(prefabConfig.getPrefab(), new Model3DPrefabAsset(asset, (Model3DPrefabConfig)prefabConfig));
                }
            });
            if (DEBUG) {
                System.out.println("");
            }
            String sBundelName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(System.getProperty("file.separator")) + 1, file.getAbsolutePath().length());
            if (DEBUG) {
                System.out.println("Bundel[" + sBundelName + "] Geladen[" + value.size() + "] \n\n");
            }
            result.put(file.getAbsolutePath(), value);
        });
        return result;
    }

    public class ClassConfigData {
        private Model3DPrefabConfig[] Prefabs = new Model3DPrefabConfig[25];

        public ClassConfigData() {
            for (int i = 0; i < this.Prefabs.length; ++i) {
                this.Prefabs[i] = new Model3DPrefabConfig();
            }
            this.Prefabs[0].setName("Prefab 1 Bezeichnung");
            this.Prefabs[0].setPrefab("Prefab1Name.prefab");
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("de", "Info");
            infoMap.put("en", "Info");
            this.Prefabs[0].setInfo(infoMap);
            this.Prefabs[1].setName("Prefab 2 Bezeichnung");
            this.Prefabs[1].setPrefab("Prefab2Name.prefab");
            infoMap = new HashMap();
            infoMap.put("de", "Info");
            infoMap.put("en", "Info");
            this.Prefabs[1].setInfo(infoMap);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Arrays.asList(this.Prefabs).forEach(PrefabEintrag -> {
                sb.append(PrefabEintrag.toString());
                sb.append("\n");
            });
            return sb.toString();
        }
    }

    public class Model3DPrefabAsset {
        private final PrefabAsset asset;
        private final Model3DPrefabConfig prefab;

        public PrefabAsset getAsset() {
            return this.asset;
        }

        public Model3DPrefabConfig getPrefab() {
            return this.prefab;
        }

        public Model3DPrefabAsset(PrefabAsset asset, Model3DPrefabConfig prefabConfig) {
            this.asset = asset;
            this.prefab = prefabConfig;
        }
    }

    public class ClassDBModel3D {
        String ownerUID;
        Integer dbID;
        Vector3f pos;
        Quaternion rot;
        Vector3f scale;
        String AssetName;
        String BundelPhat;

        public ClassDBModel3D(String ownerUID, Integer dbID, Vector3f pos, Quaternion rot, Vector3f scale, String AssetName, String BundelPhat) {
            this.ownerUID = ownerUID;
            this.dbID = dbID;
            this.pos = pos;
            this.rot = rot;
            this.scale = scale;
            this.AssetName = AssetName;
            this.BundelPhat = BundelPhat;
        }

        public String getOwnerUID() {
            return this.ownerUID;
        }

        public void setOwnerUID(String uid) {
            this.ownerUID = uid;
        }

        public Integer getDBID() {
            return this.dbID;
        }

        public void setDBID(Integer dbid) {
            this.dbID = dbid;
        }

        public Vector3f getPos() {
            return this.pos;
        }

        public void setPos(Vector3f pos) {
            this.pos = pos;
        }

        public Quaternion getRot() {
            return this.rot;
        }

        public void setRot(Quaternion rot) {
            this.rot = rot;
        }

        public Vector3f getScale() {
            return this.scale;
        }

        public void setScale(Vector3f scale) {
            this.scale = scale;
        }

        public String getAssetName() {
            return this.AssetName;
        }

        public void setAssetName(String AssetName) {
            this.AssetName = AssetName;
        }

        public String getBundelPhat() {
            return this.BundelPhat;
        }

        public void setBundelPhat(String BundelPhat) {
            this.BundelPhat = BundelPhat;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ownerID=").append(this.ownerUID).append(" \n");
            result.append(" \t").append("dbID=").append(this.dbID).append(" \n");
            result.append(" \t").append("pos=").append(this.pos.toString()).append(" \n");
            result.append(" \t").append("rot=").append(this.rot.toString()).append(" \n");
            result.append(" \t").append("scale=").append(this.scale.toString()).append(" \n");
            result.append(" \t").append("AssetName=").append(this.AssetName).append(" \n");
            result.append(" \t").append("BundelPhat=").append(this.BundelPhat).append(" \n");
            return result.toString();
        }
    }

    public class ClassPlayerGameObject
    extends GameObject {
        private final Model boundboxModel;
        private final MaterialAsset materialPlace;
        private final MaterialAsset materialRemove;
        String ownerUID;
        Integer dbID;

        public void hideBoundBox() {
            this.boundboxModel.setActive(false);
        }

        public void showBoundBox() {
            this.showBoundBox(BoundBoxMode.Place);
        }

        public void showBoundBox(BoundBoxMode bbm) {
            switch (bbm) {
                case Place: {
                    this.boundboxModel.setMaterial(this.materialPlace);
                    break;
                }
                case Remove: {
                    this.boundboxModel.setMaterial(this.materialRemove);
                    break;
                }
            }
            new Timer(0.1f, 0.0f, 0, () -> this.boundboxModel.setActive(true)).start();
        }

        public void toggleBoundBox() {
            if (this.boundboxModel.isActive()) {
                this.hideBoundBox();
            } else {
                this.showBoundBox();
            }
        }

        public ClassPlayerGameObject(Plugin plugin, String uid) {
            this.ownerUID = uid;
            TextureAsset gameObjectSelect = TextureAsset.loadFromPlugin((Plugin)plugin, (String)"/resources/assets/GameObjectSelect.png");
            this.materialPlace = MaterialAsset.create((String)"materialPlace");
            this.materialPlace.setTexture(gameObjectSelect);
            this.materialPlace.setColor(0xFF00FF);
            this.materialPlace.setFlags(new MaterialAsset.Flags[]{MaterialAsset.Flags.DoubleSided});
            this.materialPlace.setFlags(new MaterialAsset.Flags[]{MaterialAsset.Flags.Transparent});
            this.materialRemove = MaterialAsset.create((String)"materialRemove");
            this.materialRemove.setTexture(gameObjectSelect);
            this.materialRemove.setColor(-16776961);
            this.materialRemove.setFlags(new MaterialAsset.Flags[]{MaterialAsset.Flags.DoubleSided});
            this.materialRemove.setFlags(new MaterialAsset.Flags[]{MaterialAsset.Flags.Transparent});
            this.boundboxModel = new Model();
            this.boundboxModel.setLocalPosition(0.0f, 0.0f, 0.0f);
            this.boundboxModel.setMesh(ModelAsset.CubeFrame);
            this.boundboxModel.setMaterial(this.materialPlace);
            this.addChild((GameObject)this.boundboxModel);
            this.boundboxModel.setActive(false);
        }

        public String getOwnerUID() {
            return this.ownerUID;
        }

        public void setOwnerUID(String uid) {
            this.ownerUID = uid;
        }

        public Integer getDBID() {
            return this.dbID;
        }

        public void setDBID(Integer dbid) {
            this.dbID = dbid;
        }
    }

    public static enum BoundBoxMode {
        Place,
        Remove;

    }
}

