/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ClassPluginJSONManager {
    List<String> banList;
    AtomicInteger deap = new AtomicInteger(-1);

    public ClassPluginJSONManager() {
        this.banList = new ArrayList<String>();
    }

    static String parseOutput(String jsonString) {
        Object result = "";
        int tabCound = 0;
        String tab = "\t";
        for (int i = 0; i < jsonString.length(); ++i) {
            if (jsonString.toCharArray()[i] == '}') {
                if (i > 0 && --tabCound > 0) {
                    --tabCound;
                }
                if (tabCound < 0) {
                    tabCound = 0;
                }
                result = (String)result + "\n" + tab.repeat(tabCound);
            }
            if (jsonString.toCharArray()[i] == ']' && jsonString.toCharArray()[i + 1] == ',' && jsonString.toCharArray()[i + 2] == '\"') {
                if (--tabCound < 0) {
                    tabCound = 0;
                }
                result = (String)result + "\n" + tab.repeat(tabCound);
            }
            if (jsonString.toCharArray()[i] == ':') {
                result = (String)result + " " + tab.repeat(0);
            }
            result = (String)result + jsonString.toCharArray()[i];
            if (jsonString.toCharArray()[i] == '{') {
                ++tabCound;
                if (i > 0) {
                    ++tabCound;
                }
                result = (String)result + "\n" + tab.repeat(tabCound);
            }
            if (jsonString.toCharArray()[i] == '[' && i >= 1 && jsonString.toCharArray()[i - 1] == ':') {
                result = (String)result + "\n" + tab.repeat(++tabCound);
            }
            if (jsonString.toCharArray()[i] == ',' && jsonString.toCharArray()[i + 1] == '\"' && jsonString.toCharArray()[i] == ',' && (jsonString.toCharArray()[i - 2] != '\"' || jsonString.toCharArray()[i - 1] == '}')) {
                result = (String)result + "\n" + tab.repeat(tabCound);
            }
            if (jsonString.toCharArray()[i] != ':') continue;
            result = (String)result + tab.repeat(1);
        }
        return result;
    }

    public JSONObject createJSONObject(Object obj) {
        this.deap.set(-1);
        return this.FieldToJSONObject(obj, false);
    }

    public JSONObject createJSONObject(Object obj, boolean DEBUG) {
        this.deap.set(-1);
        return this.FieldToJSONObject(obj, DEBUG);
    }

    private JSONObject FieldToJSONObject(Object T, boolean DEBUG) {
        JSONObject result = new JSONObject();
        this.deap.set(this.deap.get() + 1);
        Arrays.asList(T.getClass().getDeclaredFields()).stream().sorted((o1, o2) -> {
            if (DEBUG) {
                System.out.println(o1.getName() + "\t" + o2.getName());
            }
            return o2.getName().compareTo(o1.getName());
        }).forEach(field -> {
            Object fieldObject;
            if (DEBUG) {
                System.out.println("FieldToJSONObject[" + this.deap.get() + "]: " + field.getName() + "\t" + field.getDeclaringClass().getSimpleName());
            }
            field.setAccessible(true);
            try {
                fieldObject = field.get(T);
            }
            catch (Exception e) {
                fieldObject = e;
            }
            boolean findData = false;
            if (this.banList.indexOf(field.getName()) < 0) {
                if (fieldObject != null) {
                    if (fieldObject.getClass().isArray()) {
                        if (Array.getLength(fieldObject) > 0) {
                            if (DEBUG) {
                                System.out.println("Index: " + Array.getLength(fieldObject) + " ");
                            }
                            JSONArray ja = new JSONArray();
                            int aCound = 0;
                            for (int i = 0; i < Array.getLength(fieldObject); ++i) {
                                if (DEBUG) {
                                    System.out.print("<Index[" + i + "] ");
                                }
                                if (Array.get(fieldObject, i) != null) {
                                    if (DEBUG) {
                                        System.out.print(Array.get(fieldObject, i).getClass());
                                    }
                                    if (DEBUG) {
                                        System.out.println("  >" + String.valueOf(Array.get(fieldObject, i)));
                                    }
                                    if (Array.get(fieldObject, i).getClass().equals(String.class)) {
                                        findData = true;
                                        ja.put(Array.get(fieldObject, i));
                                    } else if (Array.get(fieldObject, i).getClass().equals(Integer.class)) {
                                        findData = true;
                                        ja.put(Array.getInt(fieldObject, i));
                                    } else {
                                        if (DEBUG) {
                                            System.out.println(">>" + String.valueOf(Array.get(fieldObject, i)));
                                        }
                                        findData = true;
                                        JSONObject res = this.FieldToJSONObject(Array.get(fieldObject, i), DEBUG);
                                        if (res.length() > 0) {
                                            ja.put((Object)res);
                                        }
                                    }
                                    ++aCound;
                                    continue;
                                }
                                if (!DEBUG) continue;
                                System.out.println(" NULL");
                            }
                            if (ja.length() > 0) {
                                result.put(field.getName(), (Object)ja);
                                findData = true;
                            }
                        }
                    } else if (fieldObject.getClass() == HashMap.class) {
                        if (DEBUG) {
                            System.out.println(">HashMap> Size " + ((HashMap)fieldObject).size());
                        }
                        if (((HashMap)fieldObject).size() > 0) {
                            findData = true;
                            result.put(field.getName(), fieldObject);
                        } else {
                            findData = false;
                        }
                        if (DEBUG) {
                            System.out.println(field.getName() + "=>" + findData + ">" + String.valueOf(fieldObject) + " >h> " + String.valueOf(fieldObject.getClass()) + "\t" + fieldObject.getClass().isPrimitive());
                        }
                    } else if (fieldObject.getClass().isPrimitive() || fieldObject.getClass().equals(String.class) || fieldObject.getClass().equals(Integer.class) || fieldObject.getClass().equals(Boolean.class)) {
                        if (DEBUG) {
                            System.out.println(field.getName() + "=>" + findData + ">" + String.valueOf(fieldObject) + " >-> " + String.valueOf(fieldObject.getClass()));
                        }
                        if (!field.getName().startsWith("this")) {
                            result.put(field.getName(), fieldObject);
                        }
                    } else {
                        JSONObject res;
                        if (DEBUG) {
                            System.out.println(field.getName() + "=>" + findData + ">" + String.valueOf(fieldObject) + " >?> " + String.valueOf(fieldObject.getClass()));
                        }
                        if (DEBUG) {
                            System.out.println("\tMember[" + fieldObject.getClass().isMemberClass() + "] Enclosing[" + String.valueOf(fieldObject.getClass().getEnclosingClass()) + "] =" + String.valueOf(fieldObject.getClass().asSubclass(fieldObject.getClass())) + " ");
                        }
                        if (DEBUG) {
                            System.out.println("\tDeclaring[" + String.valueOf(fieldObject.getClass().getDeclaringClass()) + "] GenericInterfaces[" + Arrays.toString(fieldObject.getClass().getGenericInterfaces()) + "] Interfaces" + Arrays.toString(fieldObject.getClass().getInterfaces()) + " ");
                        }
                        if ((fieldObject.getClass().getEnclosingClass() != null || fieldObject.getClass().isMemberClass()) && (res = this.FieldToJSONObject(fieldObject, DEBUG)).length() > 0) {
                            result.put(field.getName(), (Object)res);
                        }
                    }
                } else if (DEBUG) {
                    System.out.println(">" + findData + ">|" + field.getName());
                }
            }
        });
        return result;
    }

    private void writeJSON(String fileTarget, String JsonString) {
        File file = new File(fileTarget);
        try {
            OutputStreamWriter fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            Date datum = new Date(System.currentTimeMillis());
            fstream.append(datum.toString() + "\n");
            fstream.append(JsonString);
            fstream.flush();
            fstream.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(ex.getMessage());
        }
    }

    private String loadJSONString(String fileTarget) {
        Object result = "";
        boolean dataIn = false;
        File file = new File(fileTarget);
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("{")) {
                    dataIn = true;
                }
                if (!dataIn) continue;
                result = (String)result + line;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(ex.getMessage());
        }
        return ((String)result).replace("\t", "").replace("\" :", "\":");
    }

    public Object reload(Object config, JSONObject loadConfig) {
        return this.reload(config, loadConfig, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object reload(Object config, JSONObject loadConfig, boolean DEBUG) {
        if (DEBUG) {
            System.out.println("");
        }
        Class<?> configClass = config.getClass();
        Field[] fields = configClass.getDeclaredFields();
        try {
            for (Field field : fields) {
                Object subConfig;
                String fieldName = field.getName();
                Object value = loadConfig.opt(fieldName);
                if (DEBUG) {
                    System.out.println("FildName[" + fieldName + "] Value[" + String.valueOf(value) + "] ");
                }
                if (value == null) continue;
                field.setAccessible(true);
                if (value instanceof JSONObject) {
                    Object reloadedSubConfig;
                    subConfig = field.get(config);
                    if (subConfig == null) {
                        if (DEBUG) {
                            System.out.println("SubConfig = NULL\t" + fieldName + "\t" + String.valueOf(field.getType()));
                        }
                        if (DEBUG) {
                            System.out.println("SubConfig = \t" + String.valueOf(field.getDeclaringClass()) + "\t" + String.valueOf(field.getType().getDeclaredConstructors()[0].getDeclaringClass()));
                        }
                        try {
                            subConfig = field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (NoSuchMethodException ex) {
                            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (InvocationTargetException ex) {
                            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (DEBUG) {
                        System.out.println("[ " + String.valueOf(subConfig) + "  ");
                    }
                    if ((reloadedSubConfig = this.reload(subConfig, (JSONObject)value)).getClass() == HashMap.class || reloadedSubConfig.getClass() == Map.class) {
                        if (DEBUG) {
                            System.out.println("[h: " + String.valueOf(reloadedSubConfig) + "  " + String.valueOf(reloadedSubConfig.getClass()));
                        }
                        field.set(config, ((JSONObject)value).toMap());
                        continue;
                    }
                    if (reloadedSubConfig.getClass().isArray()) {
                        Object objArray = reloadedSubConfig;
                        int arrayLength = Array.getLength(objArray);
                        Class<?> componentType = field.getType().getComponentType();
                        Object array = Array.newInstance(componentType, arrayLength);
                        if (DEBUG) {
                            System.out.println("->" + String.valueOf(componentType));
                        }
                        for (int i = 0; i < arrayLength; ++i) {
                            Object element = Array.get(objArray, i);
                            Object object = this.reload(element, (JSONObject)value);
                        }
                        continue;
                    }
                    field.set(config, reloadedSubConfig);
                    continue;
                }
                if (value instanceof JSONArray && field.getType().isArray()) {
                    JSONArray jsonArray = (JSONArray)value;
                    int arrayLength = jsonArray.length();
                    Class<?> componentType = field.getType().getComponentType();
                    Object array = Array.newInstance(componentType, arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        Object element = jsonArray.get(i);
                        if (componentType.isPrimitive()) {
                            if (componentType == Boolean.TYPE) {
                                Array.setBoolean(array, i, (Boolean)element);
                                continue;
                            }
                            if (componentType == Byte.TYPE) {
                                Array.setByte(array, i, (Byte)element);
                                continue;
                            }
                            if (componentType == Character.TYPE) {
                                Array.setChar(array, i, ((Character)element).charValue());
                                continue;
                            }
                            if (componentType == Short.TYPE) {
                                Array.setShort(array, i, (Short)element);
                                continue;
                            }
                            if (componentType == Integer.TYPE) {
                                Array.setInt(array, i, (Integer)element);
                                continue;
                            }
                            if (componentType == Long.TYPE) {
                                Array.setLong(array, i, (Long)element);
                                continue;
                            }
                            if (componentType == Float.TYPE) {
                                Array.setFloat(array, i, ((Float)element).floatValue());
                                continue;
                            }
                            if (componentType != Double.TYPE) continue;
                            Array.setDouble(array, i, (Double)element);
                            continue;
                        }
                        if (componentType == String.class) {
                            Array.set(array, i, element);
                            continue;
                        }
                        if (componentType == Integer.class) {
                            Array.set(array, i, (Integer)element);
                            continue;
                        }
                        if (componentType == Boolean.class) {
                            Array.set(array, i, (Boolean)element);
                            continue;
                        }
                        Object reloadedElement = null;
                        if (componentType.getDeclaredFields()[0].getType() == HashMap.class || componentType.getDeclaredFields()[0].getType() == Map.class) {
                            if (i >= Array.getLength(field.get(config))) throw new Error("Array \u00dcberlauf\nein in der Datenstrucktur Enthaltenes Arra kann nur " + Array.getLength(field.get(config)) + ". Datens\u00e4tze enthalten.");
                            reloadedElement = this.reload(Array.get(field.get(config), i), (JSONObject)element);
                        } else {
                            if (DEBUG) {
                                System.out.println("(" + i + ":  ?Type? " + String.valueOf(componentType));
                            }
                            if (DEBUG) {
                                System.out.println("\t" + Array.getLength(field.get(config)));
                            }
                            if (DEBUG) {
                                System.out.println("\t" + ((JSONObject)element).toString());
                            }
                            if (i >= Array.getLength(field.get(config))) {
                                if (DEBUG) {
                                    System.out.println("\t" + String.valueOf(Array.get(field.get(config), 0)) + ":  ? " + Array.get(field.get(config), 0).toString());
                                }
                                reloadedElement = this.reload(Array.get(field.get(config), 0), (JSONObject)element);
                            } else {
                                if (DEBUG) {
                                    System.out.println("\t" + String.valueOf(Array.get(field.get(config), i)) + ":  ? " + Array.get(field.get(config), i).toString());
                                }
                                reloadedElement = this.reload(Array.get(field.get(config), i), (JSONObject)element);
                            }
                        }
                        if (reloadedElement.getClass() == HashMap.class) {
                            Array.set(array, i, reloadedElement);
                            continue;
                        }
                        Array.set(array, i, reloadedElement);
                    }
                    field.set(config, array);
                    continue;
                }
                if (field.getType().isPrimitive() || field.getType().equals(String.class) || field.getType().equals(Integer.class) || field.getType().equals(Boolean.class)) {
                    Class<?> fieldType = field.getType();
                    if (DEBUG) {
                        System.out.println("{:" + fieldName + "-" + String.valueOf(value) + " - " + String.valueOf(fieldType));
                    }
                    Object convertedValue = this.convertValue(value, fieldType);
                    field.set(config, convertedValue);
                    continue;
                }
                System.err.println("Unsupported field type: ");
                subConfig = field.get(config);
                if (subConfig == null && DEBUG) {
                    System.out.println("subConfig: NULL");
                }
                if (DEBUG) {
                    System.out.println("sub: " + String.valueOf(subConfig) + "\t" + subConfig.getClass().getName() + "\t" + String.valueOf(subConfig.getClass()));
                }
                if (DEBUG) {
                    Arrays.asList(subConfig.getClass().getDeclaredFields()).forEach(t -> {
                        try {
                            t.setAccessible(true);
                            if (DEBUG) {
                                System.out.println("\t" + String.valueOf(t) + "\t" + t.getName() + "\t" + String.valueOf(t.get(subConfig)));
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IllegalAccessException ex) {
                            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    });
                }
                if (DEBUG) {
                    loadConfig.toMap().forEach((t, u) -> System.out.println("\t" + t + " >>>" + String.valueOf(u.getClass())));
                }
                if (DEBUG) {
                    System.out.println("LoadConfig: " + loadConfig.get(fieldName).toString() + "\t" + String.valueOf(loadConfig.get(fieldName).getClass()));
                }
                if (DEBUG) {
                    System.out.println("config: " + config.getClass().getName());
                }
                if (DEBUG) {
                    System.out.println("value: " + String.valueOf(value) + "\t" + value.getClass().getName());
                }
                if (!DEBUG) continue;
                ((JSONObject)value).toMap().forEach((t, u) -> System.out.println("\t" + t + " >>>" + String.valueOf(u.getClass())));
            }
            return config;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(String.valueOf(ex));
            return config;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(String.valueOf(ex));
            return config;
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(String.valueOf(ex));
            return config;
        }
        catch (SecurityException ex) {
            Logger.getLogger(ClassPluginJSONManager.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println(String.valueOf(ex));
        }
        return config;
    }

    private Object convertValue(Object value, Class<?> fieldType) {
        if (fieldType.equals(String.class)) {
            return value.toString();
        }
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            return Integer.valueOf(value.toString());
        }
        if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            return Long.valueOf(value.toString());
        }
        if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
            return Float.valueOf(value.toString());
        }
        if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
            return Double.valueOf(value.toString());
        }
        if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
            return Boolean.valueOf(value.toString());
        }
        if (fieldType.isArray()) {
            JSONArray jsonArray = (JSONArray)value;
            int length = jsonArray.length();
            Class<?> componentType = fieldType.getComponentType();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, this.convertValue(jsonArray.get(i), componentType));
            }
            return array;
        }
        throw new IllegalArgumentException("Unsupported field type: " + fieldType.getName());
    }

    private static Object getFieldValue(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setFieldValue(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object update(Object config, String loadConfig) {
        return this.update(config, loadConfig, false);
    }

    public Object update(Object config, String testconf, boolean DEBUG) {
        JSONObject finalData = this.createJSONObject(config, DEBUG);
        String finalDataParse = ClassPluginJSONManager.parseOutput(finalData.toString());
        if (!new File(testconf).exists()) {
            this.writeJSON(testconf, finalDataParse);
        }
        String loadJSON = this.loadJSONString(testconf);
        if (DEBUG) {
            System.out.println(loadJSON);
        }
        JSONObject loadConfig = new JSONObject(loadJSON);
        System.out.print("Config Reload ...");
        Object configReload = this.reload(config, loadConfig, DEBUG);
        if (DEBUG) {
            System.out.println("Config reloaded: \n" + configReload.toString() + "\n");
        }
        System.out.println(" Done");
        System.out.println();
        return configReload;
    }
}

