/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg.world;

import net.risingworld.api.World;
import net.risingworld.api.objects.world.Chunk;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;

public class WorldTools {
    public static Vector3f getTerrainsHeight(Vector3f pos) {
        return WorldTools.getTerrainsHeight(pos, true);
    }

    public static Vector3f getTerrainsHeight(float x, float y, float z) {
        return WorldTools.getTerrainsHeight(new Vector3f(x, y, z), true);
    }

    public static Vector3f getTerrainsHeight(float x, float y, float z, boolean withWater) {
        return WorldTools.getTerrainsHeight(new Vector3f(x, y, z), withWater);
    }

    public static Vector3f getTerrainsHeight(Vector3f pos, boolean withWater) {
        Vector3f result = new Vector3f(pos.x, pos.y, pos.z);
        Vector3i chunkPos = new Vector3i();
        Vector3i blockPos = new Vector3i();
        Utils.ChunkUtils.getChunkAndBlockPosition((Vector3f)pos, (Vector3i)chunkPos, (Vector3i)blockPos);
        Chunk chunk = World.getChunk((int)chunkPos.x, (int)chunkPos.z);
        result.y = chunk.getLODSurfaceLevel(blockPos.x, blockPos.z, withWater);
        return result;
    }

    public static byte getTerrainsTexture(Vector3f pos) {
        return WorldTools.getTerrainsTexture(pos, true);
    }

    public static byte getTerrainsTexture(float x, float y, float z) {
        return WorldTools.getTerrainsTexture(new Vector3f(x, y, z), true);
    }

    public static byte getTerrainsTexture(float x, float y, float z, boolean withWater) {
        return WorldTools.getTerrainsTexture(new Vector3f(x, y, z), withWater);
    }

    public static byte getTerrainsTexture(Vector3f pos, boolean withWater) {
        Vector3i chunkPos = new Vector3i();
        Vector3i blockPos = new Vector3i();
        Utils.ChunkUtils.getChunkAndBlockPosition((Vector3f)pos, (Vector3i)chunkPos, (Vector3i)blockPos);
        Chunk chunk = World.getChunk((int)chunkPos.x, (int)chunkPos.z);
        return chunk.getLODSurfaceTexture(blockPos.x, blockPos.z);
    }

    public class WorldPos {
        private final Vector3f pos;
        private Quaternion rot;
        private final boolean fixPoint;
        private Byte terrain;

        public Vector3f getPos() {
            return this.pos;
        }

        public Quaternion getRot() {
            return this.rot;
        }

        public void setRot(Quaternion rot) {
            this.rot = rot;
        }

        public boolean isFixPoint() {
            return this.fixPoint;
        }

        public Byte getTerrain() {
            return this.terrain;
        }

        public void setTerrain(Byte terrain) {
            this.terrain = terrain;
        }

        public WorldPos(Vector3f pos, Quaternion rot, Byte terrain, boolean fixPoint) {
            this.pos = pos;
            this.rot = rot;
            this.terrain = terrain;
            this.fixPoint = fixPoint;
        }
    }
}

