/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB {
    private static String getPhat(String phat) {
        return DB.getPhat(phat, false);
    }

    private static String getPhat(String phat, boolean debug) {
        Object result = "";
        String[] subDir = phat.split(System.getProperty("os.name").startsWith("Windows") ? "\\\\" : System.getProperty("file.separator"));
        if (debug) {
            System.out.println("getPhat [" + phat + "]");
        }
        if (debug) {
            System.out.println("getPhat L\u00e4nge[" + subDir.length + "]");
        }
        for (int n = 0; n < subDir.length - 1; ++n) {
            if (debug) {
                System.out.println("getPhat sub[" + subDir[n] + "]");
            }
            if (n > 0) {
                result = (String)result + System.getProperty("file.separator");
            }
            result = (String)result + subDir[n];
        }
        if (debug) {
            System.out.println("getPhat [" + (String)result + "]");
        }
        return result;
    }

    public static abstract class DBController
    implements DBControl {
        private static Object DatabaseType;
        private final DBController dbcontroller;
        Connection connection;
        boolean debug;
        String DB_PATH;
        private String MySqlPrefix = "";

        @Deprecated
        public String getMySqlPrefix() {
            return this.MySqlPrefix;
        }

        public DBController() {
            this.debug = false;
            this.DB_PATH = null;
            this.connection = null;
            this.dbcontroller = this;
        }

        public DBController(boolean debug) {
            this.debug = debug;
            this.DB_PATH = null;
            this.connection = null;
            this.dbcontroller = this;
        }

        public void connect() {
            this.connect(this.DB_PATH);
        }

        void connect(String DB_PATH) {
            String phat = DB.getPhat(DB_PATH, this.debug);
            File nPaht = new File(phat);
            if (nPaht.exists()) {
                if (this.debug) {
                    System.out.println("DB Phat:\t[" + nPaht.getAbsolutePath() + "]\t[" + DB_PATH + "]");
                }
            } else {
                boolean nPhat = nPaht.mkdirs();
                if (this.debug) {
                    System.out.println("DB Phat:\t[" + nPaht.getAbsolutePath() + " |> " + (nPhat ? "erstellt." : "konnte nicht erstellt werden.") + "]");
                }
            }
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + DB_PATH);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public void disconnect() {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException ex) {
                    System.err.println("DISCONNECT: " + ex.getMessage());
                }
            }
        }

        public DBController getInstance() {
            return this.dbcontroller;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void initDBConnection(String DB_PATH) {
            this.DB_PATH = DB_PATH;
            try {
                if (this.connection != null) {
                    return;
                }
                if (this.debug) {
                    System.out.println("Creating Connection to Database...");
                }
                this.connect(DB_PATH);
                this.handleDB();
                if (!this.connection.isClosed() && this.debug) {
                    System.out.println("...Connection established");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (!connection.isClosed() && connection != null) {
                            connection.close();
                            if (connection.isClosed() && debug) {
                                System.out.println("Connection to Database closed");
                            }
                        }
                    }
                    catch (SQLException e) {
                        System.err.println("Fehler[Runtime]: " + e.getMessage());
                    }
                }
            });
        }

        public static boolean isColumnExists(Statement sqlite, String table, String column) {
            try {
                ResultSet result = sqlite.executeQuery("PRAGMA table_info(" + table + ")");
                if (result != null) {
                    while (result.next()) {
                        String name = result.getString("name");
                        if (!name.toLowerCase().equals(column.toLowerCase())) continue;
                        return true;
                    }
                }
            }
            catch (SQLException e) {
                System.err.println("ChaosHQ.isColumnExists[] srvID[ERR]\n" + e.getMessage());
            }
            return false;
        }

        static {
            try {
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException e) {
                System.err.println("Fehler beim Laden des JDBC-Treibers\n" + e.getMessage());
            }
        }
    }

    public static interface DBControl {
        public void handleDB();
    }
}

