/*
 * Decompiled with CFR 0.152.
 */
package WTGWeatherHud;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.definitions.WeatherDefs;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Pivot;

public class wtgweatherhud
extends Plugin
implements Listener {
    public Timer weathertimer;
    public Player player;
    String WorldName = World.getName();
    public String nextweather;

    public void onEnable() {
        this.registerEventListener(this);
        this.createTimer();
        try (Database weatherhud = this.getSQLiteConnection(this.getPath() + "/" + this.WorldName + "/weatherhud.db");){
            weatherhud.execute("CREATE TABLE IF NOT EXISTS `weatherhud` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `playerid` BIGINT, `isvis` INTEGER)");
            System.out.println("WeatherHud.db loaded");
        }
    }

    public void onDisable() {
    }

    @EventMethod
    public void playerConnect(PlayerConnectEvent evt) throws SQLException {
        this.player = evt.getPlayer();
        this.ui(this.player);
    }

    @EventMethod
    public void playerspawn(PlayerSpawnEvent evt) {
        this.player = evt.getPlayer();
        this.player.sendTextMessage("<color=yellow>Type /Weather Help in chat for Time Hud info</color>");
    }

    public void vis(Player player) throws SQLException {
        long playerid = Long.parseLong(player.getUID());
        UIElement weatherpanel = (UIElement)player.getAttribute("weatherpanel");
        Database weatherhud = this.getSQLiteConnection(this.getPath() + "/" + this.WorldName + "/weatherhud.db");
        try (ResultSet result = weatherhud.executeQuery("SELECT * FROM `weatherhud` WHERE `playerid` = '" + playerid + "'");){
            if (result.next()) {
                int isvis = result.getInt("isvis");
                if (isvis == 0) {
                    weatherpanel.setVisible(true);
                }
                if (isvis == 1) {
                    weatherpanel.setVisible(false);
                }
            } else if (!result.next()) {
                weatherhud.execute("INSERT INTO `weatherhud`(playerid, isvis)values('" + playerid + "', '0')");
                weatherpanel.setVisible(true);
            }
        }
    }

    public void createTimer() {
        this.weathertimer = new Timer(5.0f, 0.0f, -1, () -> {
            try {
                this.update();
            }
            catch (SQLException ex) {
                Logger.getLogger(wtgweatherhud.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.weathertimer.start();
    }

    public void ui(Player player) throws SQLException {
        float tempreture = World.getTemperature((float)player.getPosition().x, (float)player.getPosition().y, (float)player.getPosition().z);
        WeatherDefs.Weather currentweather = Server.getCurrentWeather();
        if (Server.getNextWeather() == null) {
            this.nextweather = "none";
        }
        if (Server.getNextWeather() != null) {
            this.nextweather = Server.getNextWeather().name;
        }
        UIElement weatherpanel = new UIElement();
        weatherpanel.setPivot(Pivot.UpperLeft);
        weatherpanel.setPosition(1.0f, 46.5f, true);
        weatherpanel.setSize(150.0f, 60.0f, false);
        weatherpanel.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.7f);
        weatherpanel.setBorder(3.0f);
        weatherpanel.setBorderColor(255);
        weatherpanel.setBorderEdgeRadius(5.0f, true);
        weatherpanel.setVisible(true);
        player.addUIElement(weatherpanel);
        UILabel temp = new UILabel();
        temp.setSize(100.0f, 5.0f, true);
        temp.setPosition(50.0f, 23.0f, true);
        temp.setText("<color=white>Temp: " + String.valueOf(tempreture) + " C</color>");
        temp.setFontSize(15.0f);
        temp.setPivot(Pivot.MiddleCenter);
        temp.setVisible(true);
        weatherpanel.addChild((UIElement)temp);
        player.setAttribute("temp", (Object)temp);
        UILabel cweather = new UILabel();
        cweather.setSize(50.0f, 5.0f, true);
        cweather.setPosition(50.0f, 50.0f, true);
        cweather.setText("<color=white>Current: " + currentweather.name + "</color>");
        cweather.setFontSize(15.0f);
        cweather.setPivot(Pivot.MiddleCenter);
        cweather.setVisible(true);
        weatherpanel.addChild((UIElement)cweather);
        player.setAttribute("cweather", (Object)cweather);
        UILabel nweather = new UILabel();
        nweather.setSize(50.0f, 5.0f, true);
        nweather.setPosition(50.0f, 78.0f, true);
        nweather.setText("<color=white>Next: " + this.nextweather + "</color>");
        nweather.setFontSize(15.0f);
        nweather.setPivot(Pivot.MiddleCenter);
        nweather.setVisible(true);
        weatherpanel.addChild((UIElement)nweather);
        player.setAttribute("nweather", (Object)nweather);
        player.setAttribute("weatherpanel", (Object)weatherpanel);
        this.vis(player);
        this.update();
    }

    public void update() throws SQLException {
        if (Server.getPlayerCount() > 0) {
            if (Server.getNextWeather() == null) {
                this.nextweather = "none";
            }
            if (Server.getNextWeather() != null) {
                this.nextweather = Server.getNextWeather().name;
            }
            for (Player player : Server.getAllPlayers()) {
                WeatherDefs.Weather currentweather = Server.getCurrentWeather();
                float tempreture = World.getTemperature((float)player.getPosition().x, (float)player.getPosition().y, (float)player.getPosition().z);
                UILabel temp = (UILabel)player.getAttribute("temp");
                temp.setText("<color=white>Temp: " + String.valueOf(tempreture) + " C</color>");
                UILabel cweather = (UILabel)player.getAttribute("cweather");
                cweather.setText("<color=white>Current: " + currentweather.name + "</color>");
                UILabel nweather = (UILabel)player.getAttribute("nweather");
                nweather.setText("<color=white>Next: " + this.nextweather + "</color>");
            }
        } else {
            return;
        }
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent command) {
        Player player = command.getPlayer();
        long playerid = Long.parseLong(player.getUID());
        UIElement weatherpanel = (UIElement)player.getAttribute("weatherpanel");
        String[] cmd = command.getCommand().split(" ");
        if (cmd[0].equalsIgnoreCase("/Weather")) {
            int isvis;
            Database weatherhud = this.getSQLiteConnection(this.getPath() + "/" + this.WorldName + "/weatherhud.db");
            if (cmd[1].equalsIgnoreCase("Show")) {
                weatherpanel.setVisible(true);
                isvis = 0;
                weatherhud.executeUpdate("UPDATE `weatherhud` SET isvis = '" + isvis + "'where playerid = '" + playerid + "'");
            }
            if (cmd[1].equalsIgnoreCase("Hide")) {
                weatherpanel.setVisible(false);
                isvis = 1;
                weatherhud.executeUpdate("UPDATE `weatherhud` SET isvis = '" + isvis + "'where playerid = '" + playerid + "'");
            }
            if (cmd[1].equalsIgnoreCase("Help")) {
                player.sendTextMessage("<color=yellow>/Weather Hide to hide hud</color>");
                player.sendTextMessage("<color=yellow>/Weather Show to show hud</color>");
            }
        }
    }
}

