/*
 * Decompiled with CFR 0.152.
 */
package WTGTimeHud;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Time;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Pivot;

public class wtgtimehud
extends Plugin
implements Listener {
    public Timer caltimer;
    public Player player;
    String WorldName = World.getName();

    public void onEnable() {
        this.registerEventListener(this);
        this.createTimer();
        try (Database timehud = this.getSQLiteConnection(this.getPath() + "/" + this.WorldName + "/timehud.db");){
            timehud.execute("CREATE TABLE IF NOT EXISTS `timehud` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `playerid` BIGINT, `isvis` INTEGER)");
            System.out.println("TimeHud.db loaded");
        }
    }

    public void onDisable() {
    }

    @EventMethod
    public void playerConnect(PlayerConnectEvent evt) throws SQLException {
        this.player = evt.getPlayer();
        this.ui(this.player);
    }

    @EventMethod
    public void playerspawn(PlayerSpawnEvent evt) {
        this.player = evt.getPlayer();
        this.player.sendTextMessage("<color=yellow>Type /Time Help in chat for Time Hud info</color>");
    }

    public void vis(Player player) throws SQLException {
        long playerid = Long.parseLong(player.getUID());
        UIElement calpanel = (UIElement)player.getAttribute("calpanel");
        Database timehud = this.getSQLiteConnection(this.getPath() + "/" + this.WorldName + "/timehud.db");
        try (ResultSet result = timehud.executeQuery("SELECT * FROM `timehud` WHERE `playerid` = '" + playerid + "'");){
            if (result.next()) {
                int isvis = result.getInt("isvis");
                if (isvis == 0) {
                    calpanel.setVisible(true);
                }
                if (isvis == 1) {
                    calpanel.setVisible(false);
                }
            } else if (!result.next()) {
                timehud.execute("INSERT INTO `timehud`(playerid, isvis)values('" + playerid + "', '0')");
                calpanel.setVisible(true);
            }
        }
    }

    public void createTimer() {
        this.caltimer = new Timer(5.0f, 0.0f, -1, () -> {
            try {
                this.update();
            }
            catch (SQLException ex) {
                Logger.getLogger(wtgtimehud.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.caltimer.start();
    }

    public void ui(Player player) throws SQLException {
        int Minutes = Server.getGameTime((Time.Unit)Time.Unit.Minutes);
        int Hours = Server.getGameTime((Time.Unit)Time.Unit.Hours);
        int Days = Server.getGameTime((Time.Unit)Time.Unit.Days);
        int Months = Server.getGameTime((Time.Unit)Time.Unit.Months);
        int Years = Server.getGameTime((Time.Unit)Time.Unit.Years);
        UIElement calpanel = new UIElement();
        calpanel.setPivot(Pivot.UpperLeft);
        calpanel.setPosition(1.0f, 40.0f, true);
        calpanel.setSize(150.0f, 60.0f, false);
        calpanel.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.7f);
        calpanel.setBorder(3.0f);
        calpanel.setBorderColor(255);
        calpanel.setBorderEdgeRadius(5.0f, true);
        player.addUIElement(calpanel);
        UILabel years = new UILabel();
        years.setSize(100.0f, 5.0f, true);
        years.setPosition(50.0f, 14.0f, true);
        years.setText("<color=white>Year: " + String.valueOf(Years) + "</color>");
        years.setFontSize(15.0f);
        years.setPivot(Pivot.MiddleCenter);
        years.setVisible(true);
        calpanel.addChild((UIElement)years);
        player.setAttribute("years", (Object)years);
        UILabel months = new UILabel();
        months.setSize(50.0f, 5.0f, true);
        months.setPosition(5.0f, 48.0f, true);
        months.setText("<color=white>Month: " + String.valueOf(Months) + "</color>");
        months.setFontSize(15.0f);
        months.setPivot(Pivot.MiddleLeft);
        months.setVisible(true);
        calpanel.addChild((UIElement)months);
        player.setAttribute("months", (Object)months);
        UILabel days = new UILabel();
        days.setSize(50.0f, 5.0f, true);
        days.setPosition(60.0f, 48.0f, true);
        days.setText("<color=white>Day: " + String.valueOf(Days) + "</color>");
        days.setFontSize(15.0f);
        days.setPivot(Pivot.MiddleLeft);
        days.setVisible(true);
        calpanel.addChild((UIElement)days);
        player.setAttribute("days", (Object)days);
        UILabel time = new UILabel();
        time.setSize(50.0f, 5.0f, true);
        time.setPosition(50.0f, 82.0f, true);
        time.setText("<color=white> Time " + Hours + " : " + Minutes + "</color>");
        time.setFontSize(15.0f);
        time.setPivot(Pivot.MiddleCenter);
        time.setVisible(true);
        calpanel.addChild((UIElement)time);
        player.setAttribute("time", (Object)time);
        player.setAttribute("calpanel", (Object)calpanel);
        this.vis(player);
        this.update();
    }

    public void update() throws SQLException {
        int Minutes = Server.getGameTime((Time.Unit)Time.Unit.Minutes);
        int Hours = Server.getGameTime((Time.Unit)Time.Unit.Hours) + 1;
        int Days = Server.getGameTime((Time.Unit)Time.Unit.Days);
        int Months = Server.getGameTime((Time.Unit)Time.Unit.Months);
        int Years = Server.getGameTime((Time.Unit)Time.Unit.Years);
        if (Server.getPlayerCount() > 0) {
            Object minutetext = Minutes <= 9 ? "0" + String.valueOf(Minutes) : String.valueOf(Minutes);
            Object hourstext = Hours <= 9 ? "0" + String.valueOf(Hours) : String.valueOf(Hours);
            for (Player player : Server.getAllPlayers()) {
                UILabel years = (UILabel)player.getAttribute("years");
                years.setText("<color=white>Year: " + String.valueOf(Years) + "</color>");
                UILabel months = (UILabel)player.getAttribute("months");
                months.setText("<color=white>Month: " + String.valueOf(Months) + "</color>");
                UILabel days = (UILabel)player.getAttribute("days");
                days.setText("<color=white>Day: " + String.valueOf(Days) + "</color>");
                UILabel time = (UILabel)player.getAttribute("time");
                time.setText("<color=white> Time " + (String)hourstext + " : " + (String)minutetext + "</color>");
            }
        } else {
            return;
        }
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent command) {
        Player player = command.getPlayer();
        long playerid = Long.parseLong(player.getUID());
        UIElement calpanel = (UIElement)player.getAttribute("calpanel");
        String[] cmd = command.getCommand().split(" ");
        if (cmd[0].equalsIgnoreCase("/Time")) {
            int isvis;
            Database timehud = this.getSQLiteConnection(this.getPath() + "/" + this.WorldName + "/timehud.db");
            if (cmd[1].equalsIgnoreCase("Show")) {
                calpanel.setVisible(true);
                isvis = 0;
                timehud.executeUpdate("UPDATE `timehud` SET isvis = '" + isvis + "'where playerid = '" + playerid + "'");
            }
            if (cmd[1].equalsIgnoreCase("Hide")) {
                calpanel.setVisible(false);
                isvis = 1;
                timehud.executeUpdate("UPDATE `timehud` SET isvis = '" + isvis + "'where playerid = '" + playerid + "'");
            }
            if (cmd[1].equalsIgnoreCase("Help")) {
                player.sendTextMessage("<color=yellow>/Time Hide to hide hud</color>");
                player.sendTextMessage("<color=yellow>/Time Show to show hud</color>");
            }
        }
    }
}

