/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.utilities;

import java.util.HashMap;
import java.util.Map;
import net.risingworld.api.Timer;

public class TimerUtils {
    private static Map<String, Timer> timers = new HashMap<String, Timer>();

    public static Timer getTimer(String id) {
        if (!TimerUtils.timerExists(id)) {
            return null;
        }
        return timers.get(id);
    }

    public static boolean timerExists(String id) {
        return timers.containsKey(id);
    }

    public static void createTimer(String id, boolean startTimer, float interval, float delay, int repetitions, Runnable task) {
        if (TimerUtils.timerExists(id)) {
            TimerUtils.clearTimer(id);
        }
        Timer t = new Timer(interval, delay, repetitions, task);
        if (startTimer) {
            t.start();
        }
        timers.put(id, t);
    }

    public static void killTimer(String id) {
        if (!TimerUtils.timerExists(id)) {
            return;
        }
        TimerUtils.getTimer(id).kill();
        timers.remove(id);
    }

    public static void clearAll() {
        if (timers == null || timers.isEmpty()) {
            return;
        }
        timers.values().stream().forEach(timer -> {
            if (timer.isActive()) {
                timer.kill();
            }
        });
        timers.clear();
    }

    public static void clearTimer(String id) {
        if (!TimerUtils.timerExists(id)) {
            return;
        }
        TimerUtils.getTimer(id).kill();
        timers.remove(id);
    }
}

