/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.utilities;

import java.time.Duration;
import net.risingworld.api.objects.Player;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static long getTimeDifMillis(long millis) {
        return Math.abs(System.currentTimeMillis() - millis);
    }

    public static long getRemainingTimeMillis(long millis) {
        return Math.max(millis - System.currentTimeMillis(), 0L);
    }

    public static long getTimeDifSeconds(long millis) {
        return TimeUtils.getTimeDifMillis(millis) / 1000L;
    }

    public static String getFormatedTime(Duration duration) {
        long dd = duration.toDays() % 30L;
        long hh = duration.toHours() % 24L;
        long mm = duration.toMinutes() % 60L;
        long ss = duration.toSeconds() % 60L;
        if (dd > 0L) {
            return String.format("%02ddays %02dh %02dmin %02ds", dd, hh, mm, ss);
        }
        if (hh > 0L) {
            return String.format("%02dh %02dmin %02ds", hh, mm, ss);
        }
        if (mm > 0L) {
            return String.format("%02dmin %02ds", mm, ss);
        }
        return String.format("%02ds", ss);
    }

    public static String getFormatedRemainingTime(Player ply, long millis) {
        long timeDifMillis = TimeUtils.getRemainingTimeMillis(millis);
        return timeDifMillis == 0L ? "NOW" : TimeUtils.getFormatedTime(Duration.ofMillis(timeDifMillis));
    }

    public static String getFormatedTimeSystem(long millis) {
        long timeDifMillis = TimeUtils.getTimeDifMillis(millis);
        return TimeUtils.getFormatedTime(Duration.ofMillis(timeDifMillis));
    }
}

