/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.oxe.risingworld.plugins.utilities.PrintUtils;

public final class JsonUtils {
    public static String FILE_PATH = "";

    private JsonUtils() {
    }

    public static JsonObject readFile(String fileName) {
        String filePath = FILE_PATH + fileName;
        File file = new File(filePath);
        if (file == null || file.length() == 0L) {
            return null;
        }
        JsonObject output = null;
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(filePath);){
            output = gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public static void writeFile(String fileName, JsonObject json) {
        String filePath = FILE_PATH + fileName;
        File file = new File(filePath);
        if (json.isJsonNull()) {
            return;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(filePath);){
            gson.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean initFile(String fileName, String ... dir) {
        String filePath = FILE_PATH + fileName;
        boolean fileExists = false;
        try {
            File jsonFile = new File(filePath);
            if (dir.length != 0) {
                Files.createDirectories(Paths.get(FILE_PATH + dir[0], new String[0]), new FileAttribute[0]);
            }
            if (fileExists = jsonFile.createNewFile()) {
                PrintUtils.printConsole(PrintUtils.PrintType.INFO, "New JSON file \"" + filePath + "\" created");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileExists;
    }

    public static String removeExtension(String name) {
        return name.replaceFirst("[.][^.]+$", "");
    }
}

