/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.oxe.risingworld.plugins.utilities.TimeUtils;

public final class CacheUtils {
    private static Map<String, ArrayList> playerModelCache = new HashMap<String, ArrayList>();
    private static Map<String, ArrayList> rewardModelCache = new HashMap<String, ArrayList>();
    private static Map<String, ArrayList> playerRewardModelCache = new HashMap<String, ArrayList>();

    private CacheUtils() {
    }

    private static Map<String, ArrayList> getMap(CacheModelType type) {
        switch (type) {
            case PLAYERMODEL: {
                return playerModelCache;
            }
            case REWARDMODEL: {
                return rewardModelCache;
            }
            case PLAYERREWARDMODEL: {
                return playerRewardModelCache;
            }
        }
        return null;
    }

    public static long getCachedTime(CacheModelType type, String id) {
        Map<String, ArrayList> map = CacheUtils.getMap(type);
        if (!map.containsKey(id)) {
            return -1L;
        }
        return (Long)map.get(id).get(0);
    }

    public static long getCachedTimeDif(CacheModelType type, String id) {
        long time = CacheUtils.getCachedTime(type, id);
        return TimeUtils.getTimeDifMillis(time);
    }

    public static boolean isCachedTimeExpired(CacheModelType type, String id, long timeout) {
        return CacheUtils.getCachedTimeDif(type, id) > timeout;
    }

    public static void setCache(CacheModelType type, String id, ArrayList data) {
        Map<String, ArrayList> map = CacheUtils.getMap(type);
        map.put(id, data);
    }

    public static ArrayList getCache(CacheModelType type, String id) {
        Map<String, ArrayList> map = CacheUtils.getMap(type);
        return map.containsKey(id) ? map.get(id) : null;
    }

    public static Object getCachedData(CacheModelType type, String id) {
        ArrayList cachedArr = CacheUtils.getCache(type, id);
        return cachedArr != null ? cachedArr.get(1) : null;
    }

    public static boolean cacheExists(CacheModelType type, String id) {
        Map<String, ArrayList> map = CacheUtils.getMap(type);
        return map.containsKey(id);
    }

    public static void deleteCache(CacheModelType type, String id) {
        boolean cacheExists = CacheUtils.cacheExists(type, id);
        if (cacheExists) {
            CacheUtils.getMap(type).remove(id);
        }
    }

    public static enum CacheModelType {
        PLAYERMODEL,
        REWARDMODEL,
        PLAYERREWARDMODEL;

    }
}

