/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.utilities;

import net.risingworld.api.Server;
import net.risingworld.api.objects.Player;

public final class PrintUtils {
    public static String PLUGIN_PREFIX = "<NameMissing>";
    private static final String PLUGIN_COLOR = "#c4ed78";
    private static final String MARK_COLOR = "#e7b840";

    private PrintUtils() {
    }

    private static String getPrefix() {
        return String.format("[%s]", PLUGIN_PREFIX);
    }

    private static String getPrefixColors() {
        return String.format("<color=%s>[%s]</color> ", PLUGIN_COLOR, PLUGIN_PREFIX);
    }

    public static String buildConsoleMessage(PrintType type, String msg) {
        return PrintUtils.getPrefix() + type.toString() + msg;
    }

    public static String buildChatMessage(PrintType type, String msg) {
        return PrintUtils.getPrefixColors() + type.toStringColors() + msg;
    }

    public static void messagePlayer(Player ply, PrintType type, String msg) {
        String output = PrintUtils.buildChatMessage(type, msg);
        ply.sendTextMessage(output);
    }

    public static void messagePlayer(Player ply, String msg) {
        PrintUtils.messagePlayer(ply, PrintType.DEFAULT, msg);
    }

    public static void broadcastMessage(PrintType type, String msg) {
        Server.broadcastTextMessage((String)PrintUtils.buildChatMessage(type, msg));
    }

    public static void printConsole(PrintType type, String msg) {
        String output = PrintUtils.buildConsoleMessage(type, msg);
        System.out.println(output);
    }

    public static String markText(String text, String color) {
        return "<color=" + color + ">" + text + "</color>";
    }

    public static String markText(String text) {
        return PrintUtils.markText(text, MARK_COLOR);
    }

    public static String markText(int text) {
        return PrintUtils.markText("" + text, MARK_COLOR);
    }

    public static enum PrintType {
        DEBUG("#ff6529", "[DEBUG]", "#e57143"),
        ADMIN("#596338", "[COMMAND]", "#23a8e1"),
        DEFAULT("", "", "#7aaf18"),
        SUCCESS("#2fa617", "[SUCCESS]", "#4ee331"),
        INFO("#218fd4", "[INFO]", "#5cb1e6"),
        WARNING("#B83280", "[WARNING]", ""),
        ERROR("#ce1c1c", "[ERROR]", "#e33535");

        private final String prefixColor;
        private final String prefixText;
        private final String textColor;

        private PrintType(String prefixColor, String prefixText, String textColor) {
            this.prefixColor = prefixColor;
            this.prefixText = prefixText;
            this.textColor = textColor;
        }

        public String toStringColors() {
            Object output = this.prefixText;
            if (!this.prefixColor.isBlank()) {
                output = "<color=" + this.prefixColor + ">" + (String)output + " </color>";
            }
            if (!this.textColor.isBlank()) {
                output = (String)output + "<color=" + this.textColor + ">";
            }
            return output;
        }

        public String toString() {
            if (this.prefixText.isBlank()) {
                return " ";
            }
            return String.format("[%s] ", this.prefixText);
        }
    }
}

