/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.simplehome.connectors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.oxe.risingworld.plugins.simplehome.SimpleHome;
import net.oxe.risingworld.plugins.simplehome.connectors.IDataConnector;
import net.risingworld.api.objects.Player;

public class SQLiteConnector
implements IDataConnector {
    private Map plyDataCache = new HashMap();
    private static final String DB_NAME = "database.db";
    private static final String DB_FILE = SimpleHome.getPlugin().getPath() + "/database/database.db";

    public SQLiteConnector() {
        this.initDatabase();
    }

    public static Connection getConnection() {
        return SimpleHome.getPlugin().getSQLiteConnection(DB_FILE).getConnection();
    }

    public boolean checkPlayerExists(Connection connection, Player ply) throws SQLException {
        String plyUID = ply.getUID();
        Statement statement = connection.createStatement();
        ResultSet plyExistsResult = statement.executeQuery("SELECT EXISTS(SELECT id FROM player WHERE id='" + plyUID + "') AS plyExists;");
        return plyExistsResult.getBoolean("plyExists");
    }

    public static void execute(String sql) {
        try (Connection connection = SQLiteConnector.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute(sql);
        }
        catch (SQLException err) {
            err.printStackTrace();
        }
    }

    public static void executeStatement(Connection connection, String sql) {
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException err) {
            err.printStackTrace();
        }
    }

    private static void handlePreparedStatementParameters(PreparedStatement pStatement, int index, Object parameter) throws SQLException {
        if (parameter instanceof Integer) {
            pStatement.setInt(index, (Integer)parameter);
        }
        if (parameter instanceof String) {
            pStatement.setString(index, (String)parameter);
        }
        if (parameter instanceof Long) {
            pStatement.setLong(index, (Long)parameter);
        }
    }

    public static void executePreparedStatement(Connection connection, String sql, ArrayList parameters) throws SQLException {
        PreparedStatement pStatement = connection.prepareStatement(sql);
        int counter = 0;
        for (Object param : parameters) {
            SQLiteConnector.handlePreparedStatementParameters(pStatement, ++counter, param);
        }
        pStatement.executeUpdate();
        pStatement.close();
    }

    public static void executeBatchStatement(Connection connection, String ... sqls) {
        if (sqls.length == 0) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                if (sql.isBlank()) continue;
                statement.addBatch(sql);
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void initTables(Connection connection) {
        String playerSQL = "CREATE TABLE IF NOT EXISTS player (id TEXT NOT NULL,name TEXT NOT NULL,world_name TEXT NOT NULL,homes_amount INTEGER DEFAULT 0,CONSTRAINT PK_player PRIMARY KEY (id, world_name))";
        String homeSQL = "CREATE TABLE IF NOT EXISTS home (player_id TEXT NOT NULL,name TEXT NOT NULL,world_name TEXT NOT NULL,pos TEXT NOT NULL DEFAULT 0,timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,CONSTRAINT FK_player FOREIGN KEY (player_id) REFERENCES player(id) ON DELETE CASCADE,CONSTRAINT PK_player_home PRIMARY KEY (player_id, name, world_name))";
        SQLiteConnector.executeBatchStatement(connection, playerSQL, homeSQL);
    }

    @Override
    public void initDatabase() {
        try (Connection connection = SQLiteConnector.getConnection();){
            this.initTables(connection);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

