/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.simplehome.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.oxe.risingworld.plugins.simplehome.config.Config;
import net.oxe.risingworld.plugins.simplehome.core.HomeSystem;
import net.oxe.risingworld.plugins.simplehome.model.HomeModel;
import net.oxe.risingworld.plugins.simplehome.model.PlayerModel;
import net.oxe.risingworld.plugins.utilities.PrintUtils;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;

public class Command
implements Listener {
    private static final Map<String, ArrayList> COMMANDSLIST = new HashMap<String, ArrayList>();
    private static final String COMMAND_PREFIX = "sh";
    private static final String CHAT_PREFIX = ".";
    private static final boolean ALLOW_CHAT = false;
    private static ArrayList<String> commandListCache = new ArrayList();

    public Command() {
        Command.createCommand("help", "Displays a list of commands", (Callback<PlayerCommandEvent>)((Callback)e -> this.printAvailableCommands(e.getPlayer())));
        Command.createCommand("sethome", 1, "<name>", "Set a home to your current position", (Callback<PlayerCommandEvent>)((Callback)e -> {
            String name;
            Player ply = e.getPlayer();
            String plyID = ply.getUID();
            if (HomeModel.checkHomeExistsSQL(plyID, name = e.getCommand().split(" ")[2])) {
                PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("Home \"" + PrintUtils.markText((String)name) + "\" already exists!"));
                return;
            }
            int maxHomes = Config.getMaxHomes(ply);
            int plyHomeAmount = PlayerModel.getPlayerModelSQL(ply).homesAmount();
            if (plyHomeAmount >= maxHomes) {
                PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("You reached the max. amount of homes (" + PrintUtils.markText((int)maxHomes) + ")"));
                return;
            }
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.SUCCESS, (String)("Home \"" + PrintUtils.markText((String)name) + "\" created!"));
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.INFO, (String)String.format("You created %s of %s homes", PrintUtils.markText((int)(plyHomeAmount + 1)), PrintUtils.markText((int)maxHomes)));
            HomeModel.transmitModelSQL(true, new HomeModel.HomeModelRecord(plyID, name, HomeSystem.vec3fToStr(ply.getPosition())));
        }));
        Command.createCommand("removehome", 1, "<name>", "Remove a home", (Callback<PlayerCommandEvent>)((Callback)e -> {
            String name;
            Player ply = e.getPlayer();
            String plyID = ply.getUID();
            if (!HomeModel.checkHomeExistsSQL(plyID, name = e.getCommand().split(" ")[2])) {
                PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("Home \"" + PrintUtils.markText((String)name) + "\" does not exists!"));
                return;
            }
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.SUCCESS, (String)("Home \"" + PrintUtils.markText((String)name) + "\" removed!"));
            HomeModel.transmitModelSQL(false, new HomeModel.HomeModelRecord(plyID, name, null));
        }));
        Command.createCommand("home", 1, "<name>", "Teleport to your home", (Callback<PlayerCommandEvent>)((Callback)e -> {
            Player ply = e.getPlayer();
            if (!HomeSystem.canTeleport(ply)) {
                return;
            }
            String name = e.getCommand().split(" ")[2];
            HomeModel.HomeModelRecord plyHome = HomeModel.getModelSQL(ply.getUID(), name);
            if (plyHome == null) {
                PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("Home \"" + PrintUtils.markText((String)name) + "\" does not exists"));
                return;
            }
            HomeSystem.teleportPly(ply, plyHome);
        }));
        Command.createCommand("homes", "Displays a list of your homes", (Callback<PlayerCommandEvent>)((Callback)e -> {
            Player ply = e.getPlayer();
            ArrayList<HomeModel.HomeModelRecord> plyHomes = HomeModel.getModelAllSQL(ply.getUID());
            if (plyHomes == null) {
                PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)"You don't have any homes");
                return;
            }
            for (String str : this.getFormatedHomeList(plyHomes)) {
                PrintUtils.messagePlayer((Player)ply, (String)str);
            }
        }));
        Command.createCommand("credits", "Display contributors", (Callback<PlayerCommandEvent>)((Callback)e -> {
            Player ply = e.getPlayer();
            ArrayList<HomeModel.HomeModelRecord> plyHomes = HomeModel.getModelAllSQL(ply.getUID());
            if (plyHomes == null) {
                PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)"You don't have any homes");
                return;
            }
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.INFO, (String)("Plugin made by " + PrintUtils.markText((String)"Preach")));
        }));
    }

    public static EnumSet<CommandFlags> getCommandFlags(String id) {
        return (EnumSet)COMMANDSLIST.get(id).get(0);
    }

    public static int getCommandParams(String id) {
        return (Integer)COMMANDSLIST.get(id).get(1);
    }

    public static String getCommandUsage(String id) {
        return (String)COMMANDSLIST.get(id).get(2);
    }

    public String getCommandDescription(String id) {
        return (String)COMMANDSLIST.get(id).get(3);
    }

    public static Callback getCommandCallback(String id) {
        return (Callback)COMMANDSLIST.get(id).get(4);
    }

    private ArrayList<String> getFormatedCommandList() {
        ArrayList<String> output = new ArrayList<String>();
        String hyphen = "-";
        int repeatString = 10;
        String hyphen01 = hyphen.repeat(repeatString);
        String hyphen02 = hyphen.repeat(repeatString * 5);
        String cmdPrefix = "/sh ";
        output.add(hyphen01 + "[Available Commands]" + hyphen01);
        String adminFlagText = PrintUtils.markText((String)"ADMIN", (String)"#f00f0f");
        for (Map.Entry<String, ArrayList> entry : COMMANDSLIST.entrySet()) {
            String cmdKey = entry.getKey();
            EnumSet<CommandFlags> flags = Command.getCommandFlags(cmdKey);
            boolean isAdminCmd = flags.contains((Object)CommandFlags.ADMIN_ONLY);
            String usage = "";
            if (Command.getCommandParams(cmdKey) != 0) {
                usage = Command.getCommandUsage(cmdKey);
            }
            String cmd = PrintUtils.markText((String)(cmdPrefix + cmdKey + " " + usage));
            String cmdDesription = this.getCommandDescription(entry.getKey()) + (String)(isAdminCmd ? " (" + adminFlagText + ")" : "");
            String msg = String.format("%s - %s", cmd, cmdDesription);
            output.add(msg);
        }
        output.add(hyphen02);
        return output;
    }

    private ArrayList<String> getFormatedHomeList(ArrayList<HomeModel.HomeModelRecord> mdlArray) {
        ArrayList<String> output = new ArrayList<String>();
        String hyphen = "-";
        int repeatString = 30;
        String hyphen01 = hyphen.repeat(repeatString);
        String hyphen02 = hyphen.repeat(Math.round((float)repeatString * 2.5f));
        output.add(hyphen01 + "[Homes]" + hyphen01);
        for (HomeModel.HomeModelRecord mdl : mdlArray) {
            String home = PrintUtils.markText((String)mdl.name());
            String pos = HomeSystem.getCorrectSeperator(mdl.pos());
            output.add(String.format("Name: %s | Pos: %s", home, pos));
        }
        output.add(hyphen02);
        return output;
    }

    private void printAvailableCommands(Player ply) {
        if (commandListCache.isEmpty()) {
            commandListCache = this.getFormatedCommandList();
        }
        for (String msg : commandListCache) {
            PrintUtils.messagePlayer((Player)ply, (String)msg);
        }
    }

    public static void createCommand(String cmd, EnumSet<CommandFlags> flags, int params, String usage, String description, Callback<PlayerCommandEvent> cb) {
        COMMANDSLIST.put(cmd, new ArrayList<Object>(Arrays.asList(flags, params, usage, description, cb)));
    }

    public static void createCommand(String cmd, int params, String usage, String description, Callback<PlayerCommandEvent> cb) {
        Command.createCommand(cmd, EnumSet.of(CommandFlags.DEFAULT), params, usage, description, cb);
    }

    public static void createCommand(String cmd, String description, Callback<PlayerCommandEvent> cb) {
        Command.createCommand(cmd, EnumSet.of(CommandFlags.DEFAULT), 0, "", description, cb);
    }

    private String checkCommandFlagRequirement(Player ply, CommandFlags flag, boolean ... conditions) {
        boolean conditionFilled = true;
        for (boolean req : conditions) {
            conditionFilled &= req;
        }
        return !conditionFilled ? flag.toString() + ", " : "";
    }

    private boolean checkCommandFlags(Player ply, String cmd) {
        boolean isPlyAuthorzied;
        EnumSet<CommandFlags> enumFlags = Command.getCommandFlags(cmd);
        Object errorMsgs = "";
        if (enumFlags.contains((Object)CommandFlags.ADMIN_ONLY)) {
            errorMsgs = (String)errorMsgs + this.checkCommandFlagRequirement(ply, CommandFlags.ADMIN_ONLY, ply.isAdmin());
        }
        if (!(isPlyAuthorzied = ((String)errorMsgs).isBlank())) {
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)"You are not allowed to use this command");
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("Reason: " + ((String)errorMsgs).substring(0, ((String)errorMsgs).length() - 2)));
        }
        return isPlyAuthorzied;
    }

    private boolean checkCommandParams(Player ply, String cmd, int params) {
        boolean output;
        int cmdParams = Command.getCommandParams(cmd);
        boolean bl = output = params == cmdParams;
        if (!output) {
            String usage = "/sh " + cmd + " " + Command.getCommandUsage(cmd);
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("Wrong command usage! Usage: " + PrintUtils.markText((String)usage)));
        }
        return output;
    }

    private void handleCommand(PlayerEvent e, String[] subMessages) {
        Player ply = e.getPlayer();
        String cmdPrefix = (e instanceof PlayerChatEvent ? CHAT_PREFIX : "/") + COMMAND_PREFIX;
        if (subMessages.length <= 1) {
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("Atleast a command is expected. Do " + PrintUtils.markText((String)(cmdPrefix + " help")) + " for a list of commands"));
            return;
        }
        String cmd = subMessages[1];
        if (!COMMANDSLIST.containsKey(cmd)) {
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)("Command \"" + PrintUtils.markText((String)cmd) + "\" does not exist. Do " + PrintUtils.markText((String)(cmdPrefix + " help")) + " for a list of commands"));
            return;
        }
        if (!this.checkCommandParams(ply, cmd, subMessages.length - 2)) {
            return;
        }
        if (!this.checkCommandFlags(ply, cmd)) {
            return;
        }
        Command.getCommandCallback(cmd).onCall((Object)e);
    }

    private boolean isCommand(String prefix, String[] subMessages) {
        return subMessages[0].startsWith(prefix + COMMAND_PREFIX);
    }

    private void handleEvent(PlayerCommandEvent e) {
        String msg = e.getCommand();
        String[] subMessages = msg.split(" ");
        boolean isValidCmd = this.isCommand("/", subMessages);
        if (!isValidCmd) {
            return;
        }
        this.handleCommand((PlayerEvent)e, subMessages);
    }

    public static String getCommand(String cmd) {
        return "/sh " + cmd;
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent e) {
        this.handleEvent(e);
    }

    public static enum CommandFlags {
        DEFAULT(""),
        ADMIN_ONLY("Not an admin");

        private final String reason;
        public static final EnumSet<CommandFlags> ALL_OPTS;

        private CommandFlags(String reason) {
            this.reason = reason;
        }

        public String toString() {
            return this.reason;
        }

        static {
            ALL_OPTS = EnumSet.allOf(CommandFlags.class);
        }
    }
}

