/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.simplehome.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.oxe.risingworld.plugins.utilities.JsonUtils;
import net.oxe.risingworld.plugins.utilities.PrintUtils;
import net.risingworld.api.objects.Player;

public final class Config {
    private static JsonObject jsonRoot;

    private Config() {
    }

    public static void createConfig(String fileName) {
        if (!JsonUtils.initFile((String)fileName, (String[])new String[0])) {
            jsonRoot = JsonUtils.readFile((String)fileName);
        } else {
            Config.generateDefaultConfig(fileName);
        }
    }

    public static JsonElement getProperty(String property) {
        if (jsonRoot.has(property)) {
            return jsonRoot.getAsJsonObject(property).get("value");
        }
        PrintUtils.printConsole((PrintUtils.PrintType)PrintUtils.PrintType.ERROR, (String)"JSON property is missing!");
        return null;
    }

    private static void addPropertyComment(JsonObject root, String property, Object data, String comment) {
        JsonObject child = new JsonObject();
        child.addProperty("_comment", comment);
        Arrays.asList("_default", "value").stream().forEach(propertyChild -> {
            if (data instanceof Number) {
                child.addProperty(propertyChild, (Number)((Integer)data));
            }
            if (data instanceof String) {
                child.addProperty(propertyChild, (String)data);
            }
            if (data instanceof Boolean) {
                child.addProperty(propertyChild, (Boolean)data);
            }
        });
        root.add(property, (JsonElement)child);
    }

    private static void generateDefaultConfig(String fileName) {
        jsonRoot = new JsonObject();
        Config.addPropertyComment(jsonRoot, "defaultMaxHomes", 1, "Max amount of homes for regular users");
        Config.addPropertyComment(jsonRoot, "adminMaxHomes", 3, "Max amount of homes for admins");
        Config.addPropertyComment(jsonRoot, "defaultTeleportCooldown", 30, "Teleport cooldown for regular users in seconds");
        Config.addPropertyComment(jsonRoot, "adminTeleportCooldown", 5, "Teleport cooldown for admins in seconds");
        JsonUtils.writeFile((String)fileName, (JsonObject)jsonRoot);
    }

    public static int getMaxHomes(Player ply) {
        int output = ply.isAdmin() ? Config.getProperty("adminMaxHomes").getAsInt() : Config.getProperty("defaultMaxHomes").getAsInt();
        output = Math.max(output, 0);
        return output;
    }

    public static long getTeleportCooldown(Player ply) {
        long output = ply.isAdmin() ? Config.getProperty("adminTeleportCooldown").getAsLong() : Config.getProperty("defaultTeleportCooldown").getAsLong();
        output = Math.max(output, 0L);
        return output;
    }
}

