/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.simplehome.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.oxe.risingworld.plugins.simplehome.SimpleHome;
import net.oxe.risingworld.plugins.simplehome.connectors.SQLiteConnector;

public final class HomeModel {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkHomeExistsSQL(String plyID, String homeName) {
        try (Connection connection = SQLiteConnector.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet result = statement.executeQuery("SELECT (count(*) > 0) FROM home WHERE player_id = " + plyID + " and name = '" + homeName + "' and world_name = '" + SimpleHome.getWorldName() + "';");
            if (!result.next()) return false;
            boolean bl = result.getBoolean(1);
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static HomeModelRecord getModelSQL(String plyID, String homeName) {
        HomeModelRecord recordOutput = null;
        try (Connection connection = SQLiteConnector.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet result = statement.executeQuery("SELECT * FROM home WHERE player_id = " + plyID + " and name = '" + homeName + "' and world_name ='" + SimpleHome.getWorldName() + "';");
            while (result.next()) {
                String id = result.getString("player_id");
                String name = result.getString("name");
                String pos = result.getString("pos");
                recordOutput = new HomeModelRecord(id, name, pos);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return recordOutput;
    }

    public static ArrayList<HomeModelRecord> getModelAllSQL(String plyID) {
        ArrayList<HomeModelRecord> recordOutput = new ArrayList<HomeModelRecord>();
        try (Connection connection = SQLiteConnector.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet result = statement.executeQuery("SELECT * FROM home WHERE player_id = " + plyID + " and world_name = '" + SimpleHome.getWorldName() + "' ORDER BY name DESC;");
            while (result.next()) {
                String id = result.getString("player_id");
                String name = result.getString("name");
                String pos = result.getString("pos");
                recordOutput.add(new HomeModelRecord(id, name, pos));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return recordOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transmitModelSQL(boolean addHome, HomeModelRecord mdl) {
        String id = mdl.playerID();
        String name = mdl.name();
        String pos = mdl.pos();
        String updateHomeAmount = addHome ? "+1" : "-1";
        String sql1 = addHome ? "REPLACE INTO home(player_id, name, world_name, pos) VALUES(?,?,'" + SimpleHome.getWorldName() + "',?);" : "DELETE FROM home WHERE player_id = ? and name = ? and world_name = '" + SimpleHome.getWorldName() + "'";
        String sql2 = "REPLACE INTO player(id, name, world_name, homes_amount) VALUES(?, (SELECT coalesce(name, '') FROM player WHERE id = ? and world_name = '" + SimpleHome.getWorldName() + "'), '" + SimpleHome.getWorldName() + "', (SELECT coalesce(homes_amount, 0) FROM player WHERE id = ? and world_name = '" + SimpleHome.getWorldName() + "')" + updateHomeAmount + ");";
        ResultSet rs = null;
        Connection conn = null;
        Statement pstmt1 = null;
        Statement pstmt2 = null;
        try {
            conn = SQLiteConnector.getConnection();
            if (conn == null) {
                return;
            }
            conn.setAutoCommit(false);
            pstmt1 = conn.prepareStatement(sql1, 1);
            if (addHome) {
                pstmt1.setString(1, id);
                pstmt1.setString(2, name);
                pstmt1.setString(3, pos);
            } else {
                pstmt1.setString(1, id);
                pstmt1.setString(2, name);
            }
            int rowAffected = pstmt1.executeUpdate();
            pstmt2 = conn.prepareStatement(sql2);
            pstmt2.setString(1, id);
            pstmt2.setString(2, id);
            pstmt2.setString(3, id);
            pstmt2.executeUpdate();
            conn.commit();
        }
        catch (SQLException e1) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e2) {
                System.out.println(e2.getMessage());
            }
            System.out.println(e1.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                }
                if (pstmt2 != null) {
                    pstmt2.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e3) {
                System.out.println(e3.getMessage());
            }
        }
    }

    public record HomeModelRecord(String playerID, String name, String pos) {
    }
}

