/*
 * Decompiled with CFR 0.152.
 */
package net.oxe.risingworld.plugins.simplehome.core;

import net.oxe.risingworld.plugins.simplehome.config.Config;
import net.oxe.risingworld.plugins.simplehome.model.HomeModel;
import net.oxe.risingworld.plugins.utilities.PrintUtils;
import net.oxe.risingworld.plugins.utilities.TimeUtils;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public final class HomeSystem {
    private static String plyAttribute = "shCanTeleport";

    private HomeSystem() {
    }

    public static String getCorrectSeperator(String data) {
        return data.replace(",", ".");
    }

    public static Vector3f strToVec3f(String data) {
        String[] splitData = HomeSystem.getCorrectSeperator(data).split(";");
        try {
            float x = Float.parseFloat(splitData[0]);
            float y = Float.parseFloat(splitData[1]);
            float z = Float.parseFloat(splitData[2]);
            return new Vector3f(x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String vec3fToStr(Vector3f data) {
        try {
            return String.format("%f;%f;%f", Float.valueOf(data.x), Float.valueOf(data.y), Float.valueOf(data.z));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void teleportPly(Player ply, HomeModel.HomeModelRecord home) {
        Vector3f pos = HomeSystem.strToVec3f(home.pos());
        if (pos == null) {
            return;
        }
        long tpCooldown = Config.getTeleportCooldown(ply);
        ply.setAttribute(plyAttribute, (Object)(System.currentTimeMillis() + tpCooldown * 1000L));
        ply.setPosition(pos);
    }

    public static boolean canTeleport(Player ply) {
        boolean isCooldownElapsed;
        if (!ply.hasAttribute(plyAttribute)) {
            return true;
        }
        long cooldownMs = (Long)ply.getAttribute(plyAttribute);
        long difTime = cooldownMs - System.currentTimeMillis();
        boolean bl = isCooldownElapsed = difTime <= 0L;
        if (!isCooldownElapsed) {
            PrintUtils.messagePlayer((Player)ply, (PrintUtils.PrintType)PrintUtils.PrintType.INFO, (String)("Teleport canceled! You have a cooldown: " + PrintUtils.markText((String)TimeUtils.getFormatedTimeSystem((long)cooldownMs))));
        }
        return isCooldownElapsed;
    }
}

