/*
 * Decompiled with CFR 0.152.
 */
package org.yahwho.droptorch;

import java.util.Iterator;
import java.util.LinkedList;
import net.risingworld.api.Plugin;
import net.risingworld.api.World;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerDropItemEvent;
import net.risingworld.api.objects.WorldItem;
import org.yahwho.droptorch.PlayerHandler;

public class DropTorch
extends Plugin
implements Listener {
    LinkedList<PlayerHandler> players;

    public void onEnable() {
        this.registerEventListener(this);
        this.players = new LinkedList();
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        this.players.add(new PlayerHandler(event.getPlayer()));
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) {
        Iterator iter = this.players.iterator();
        while (iter.hasNext()) {
            PlayerHandler currentPlayer = (PlayerHandler)iter.next();
            if (currentPlayer.getPlayer() != event.getPlayer()) continue;
            iter.remove();
            currentPlayer.destroyAll();
            return;
        }
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent event) {
        if (event.getPlayer().isAdmin()) {
            String[] cmd = event.getCommand().split(" ");
            System.out.println("Command issued" + event.getCommand());
            if (cmd[0].equalsIgnoreCase("/seed")) {
                event.getPlayer().sendTextMessage("Seed:" + World.getSeed());
            }
        }
    }

    @EventMethod
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        WorldItem item = event.getWorldItem();
        if (item != null && item.getDefinition().type == Items.Type.Light) {
            for (PlayerHandler currentPlayer : this.players) {
                if (currentPlayer.getPlayer() != event.getPlayer()) continue;
                currentPlayer.dropTorch(item);
                return;
            }
        }
    }
}

