/*
 * Decompiled with CFR 0.152.
 */
package potions;

import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.SoundInformation;

public class Potions
extends Plugin {
    public SoundInformation potionDrink;
    public ModelInformation healthPotionModel;
    public ImageInformation healthPotionIcon;
    public ImageInformation healthPotionTexture;
    public ModelInformation sprintPotionModel;
    public ImageInformation sprintPotionIcon;
    public ImageInformation sprintPotionTexture;
    public ModelInformation nightPotionModel;
    public ImageInformation nightPotionIcon;
    public ImageInformation nightPotionTexture;
    public ModelInformation dayPotionModel;
    public ImageInformation dayPotionIcon;
    public ImageInformation dayPotionTexture;

    public void onEnable() {
        this.potionDrink = new SoundInformation(this.getPath() + "/assets/sounds/drink.wav");
        this.Potions();
    }

    public void onDisable() {
    }

    private void drinkPotion(Player player, String potion) {
        int health = player.getHealth();
        int thirst = player.getThirst();
        int hunger = player.getHunger();
        if (potion.equals("healthPotion")) {
            health += 50;
            hunger += 50;
            thirst += 50;
            player.setBrokenBones(false);
            player.playSound(this.potionDrink, player.getPosition());
        }
        if (potion.equals("sprintPotion")) {
            player.showStatusMessage("Hermes Potion Active", 120);
            player.setAttribute("Hermes", (Object)"Hermes");
            player.setSprintSpeed(1.75f);
            player.playSound(this.potionDrink, player.getPosition());
            Timer sprintTimer = new Timer(120.0f, 0.0f, 0, () -> {
                player.deleteAttribute("Hermes");
                player.setSprintSpeed(1.0f);
                player.showStatusMessage("Hermes potion has expired", 15);
                player.playGameSound("trade_success");
            });
            sprintTimer.start();
        }
        if (potion.equals("nightPotion")) {
            player.showStatusMessage("You turned it night", 15);
            player.setAttribute("Night", (Object)"Night");
            this.getServer().setGameTime(23, 59);
            player.playSound(this.potionDrink, player.getPosition());
            Timer nightTimer = new Timer(3600.0f, 0.0f, 0, () -> {
                player.deleteAttribute("Night");
                player.showStatusMessage("Night potion cooldown has expired", 15);
                player.playGameSound("trade_success");
            });
            nightTimer.start();
        }
        if (potion.equals("dayPotion")) {
            player.showStatusMessage("You turned it day", 15);
            player.setAttribute("Day", (Object)"Day");
            this.getServer().setGameTime(8, 0);
            player.playSound(this.potionDrink, player.getPosition());
            Timer dayTimer = new Timer(3600.0f, 0.0f, 0, () -> {
                player.deleteAttribute("Day");
                player.showStatusMessage("Day potion cooldown has expired", 15);
                player.playGameSound("trade_success");
            });
            dayTimer.start();
        }
        health = Math.min(100, Math.max(0, health));
        thirst = Math.min(100, Math.max(0, thirst));
        hunger = Math.min(100, Math.max(0, hunger));
        player.setHealth(health);
        player.setThirst(thirst);
        player.setHunger(hunger);
    }

    private void Potions() {
        this.healthPotionModel = new ModelInformation(this.getPath() + "/assets/potions/health.obj");
        this.healthPotionTexture = new ImageInformation(this.getPath() + "/assets/potions/pal.png");
        this.healthPotionIcon = new ImageInformation(this.getPath() + "/assets/potions/healthicon.png");
        CustomItem healthPotion = new CustomItem("healthPotion", "Health_Potion");
        healthPotion.setModel(this.healthPotionModel, this.healthPotionTexture, 1.0f);
        healthPotion.setIcon(this.healthPotionIcon);
        healthPotion.setMaxStacksize(5);
        healthPotion.setHand(CustomItem.Hand.Right);
        healthPotion.setPlayerIdleAnimation(Animation.WaterskinIdle2);
        healthPotion.setPrimaryAction(Animation.WaterskinDrink, 1.0f, (player, collision) -> {
            this.drinkPotion(player, "healthPotion");
            player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot, 1);
        });
        healthPotion.setItemRotation(0.22293362f, 0.22471714f, 0.22360678f, 0.92186356f);
        healthPotion.setItemPosition(0.019081512f, -0.04900055f, 0.14518893f);
        healthPotion.setFPBodyPosition(3.018208E-11f, -0.33201933f, 0.80180174f);
        healthPotion.setFPBodyRotation(-0.13954319f, 2.654893E-12f, 1.42185924E-11f, 0.9902161f);
        this.getServer().registerCustomItem(healthPotion);
        CustomRecipe healthPotionRecipe = new CustomRecipe("healthPotion", CustomRecipe.Type.CustomItem, 0, "Potions", new String[]{"workbench"});
        healthPotionRecipe.setIngredients(new String[]{"2x watermelon, 3x bandage, 5x perchraw, 16x cherry"});
        healthPotionRecipe.setLocalizedNames(new String[]{"Health Potion"});
        healthPotionRecipe.setLocalizedDescriptions(new String[]{"Heal's for 50 HP/Thirst/Hunger.\nand heals broken bones!"});
        healthPotionRecipe.setTargetCount(1);
        this.getServer().registerCustomRecipe(healthPotionRecipe);
        this.sprintPotionModel = new ModelInformation(this.getPath() + "/assets/potions/sprint.obj");
        this.sprintPotionTexture = new ImageInformation(this.getPath() + "/assets/potions/pal.png");
        this.sprintPotionIcon = new ImageInformation(this.getPath() + "/assets/potions/sprinticon.png");
        CustomItem sprintPotion = new CustomItem("sprintPotion", "Hermes_Potion");
        sprintPotion.setModel(this.sprintPotionModel, this.sprintPotionTexture, 1.0f);
        sprintPotion.setIcon(this.sprintPotionIcon);
        sprintPotion.setMaxStacksize(5);
        sprintPotion.setHand(CustomItem.Hand.Right);
        sprintPotion.setPlayerIdleAnimation(Animation.WaterskinIdle2);
        sprintPotion.setPrimaryAction(Animation.WaterskinDrink, 1.0f, (player, collision) -> {
            if (player.hasAttribute("Hermes")) {
                player.showStatusMessage("Hermes Potion In Cooldown!", 15);
            } else if (player.getAttribute("Hermes") == null) {
                player.setAttribute("Hermes", (Object)"Hermes");
                this.drinkPotion(player, "sprintPotion");
                player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot, 1);
            }
        });
        sprintPotion.setItemRotation(0.22293362f, 0.22471714f, 0.22360678f, 0.92186356f);
        sprintPotion.setItemPosition(0.019081512f, -0.04900055f, 0.14518893f);
        sprintPotion.setFPBodyPosition(3.018208E-11f, -0.33201933f, 0.80180174f);
        sprintPotion.setFPBodyRotation(-0.13954319f, 2.654893E-12f, 1.42185924E-11f, 0.9902161f);
        this.getServer().registerCustomItem(sprintPotion);
        CustomRecipe sprintPotionRecipe = new CustomRecipe("sprintPotion", CustomRecipe.Type.CustomItem, 0, "Potions", new String[]{"workbench"});
        sprintPotionRecipe.setIngredients(new String[]{"16x apple, 64x grass, 4x corncob"});
        sprintPotionRecipe.setLocalizedNames(new String[]{"Hermes Potion"});
        sprintPotionRecipe.setLocalizedDescriptions(new String[]{"Increases Sprint Speed By 75%"});
        sprintPotionRecipe.setTargetCount(1);
        this.getServer().registerCustomRecipe(sprintPotionRecipe);
        this.nightPotionModel = new ModelInformation(this.getPath() + "/assets/potions/night.obj");
        this.nightPotionTexture = new ImageInformation(this.getPath() + "/assets/potions/pal.png");
        this.nightPotionIcon = new ImageInformation(this.getPath() + "/assets/potions/nighticon.png");
        CustomItem nightPotion = new CustomItem("nightPotion", "Night_Potion");
        nightPotion.setModel(this.nightPotionModel, this.nightPotionTexture, 1.0f);
        nightPotion.setIcon(this.nightPotionIcon);
        nightPotion.setMaxStacksize(5);
        nightPotion.setHand(CustomItem.Hand.Right);
        nightPotion.setPlayerIdleAnimation(Animation.WaterskinIdle2);
        nightPotion.setPrimaryAction(Animation.WaterskinDrink, 1.0f, (player, collision) -> {
            if (player.hasAttribute("Night")) {
                player.showStatusMessage("Night Potion In Cooldown!", 15);
            } else if (player.getAttribute("Night") == null) {
                player.setAttribute("Night", (Object)"Night");
                this.drinkPotion(player, "nightPotion");
                player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot, 1);
            }
        });
        nightPotion.setItemRotation(0.22293362f, 0.22471714f, 0.22360678f, 0.92186356f);
        nightPotion.setItemPosition(0.019081512f, -0.04900055f, 0.14518893f);
        nightPotion.setFPBodyPosition(3.018208E-11f, -0.33201933f, 0.80180174f);
        nightPotion.setFPBodyRotation(-0.13954319f, 2.654893E-12f, 1.42185924E-11f, 0.9902161f);
        this.getServer().registerCustomItem(nightPotion);
        CustomRecipe nightPotionRecipe = new CustomRecipe("nightPotion", CustomRecipe.Type.CustomItem, 0, "Potions", new String[]{"workbench"});
        nightPotionRecipe.setIngredients(new String[]{"16x silveringot, 16x mithrilingot"});
        nightPotionRecipe.setLocalizedNames(new String[]{"Night Potion"});
        nightPotionRecipe.setLocalizedDescriptions(new String[]{"Turns day to night\n one hour cooldown"});
        nightPotionRecipe.setTargetCount(1);
        this.getServer().registerCustomRecipe(nightPotionRecipe);
        this.dayPotionModel = new ModelInformation(this.getPath() + "/assets/potions/day.obj");
        this.dayPotionTexture = new ImageInformation(this.getPath() + "/assets/potions/pal.png");
        this.dayPotionIcon = new ImageInformation(this.getPath() + "/assets/potions/dayicon.png");
        CustomItem dayPotion = new CustomItem("dayPotion", "Day_Potion");
        dayPotion.setModel(this.dayPotionModel, this.dayPotionTexture, 1.0f);
        dayPotion.setIcon(this.dayPotionIcon);
        dayPotion.setMaxStacksize(5);
        dayPotion.setHand(CustomItem.Hand.Right);
        dayPotion.setPlayerIdleAnimation(Animation.WaterskinIdle2);
        dayPotion.setPrimaryAction(Animation.WaterskinDrink, 1.0f, (player, collision) -> {
            if (player.hasAttribute("Day")) {
                player.showStatusMessage("Day Potion In Cooldown!", 15);
            } else if (player.getAttribute("Day") == null) {
                player.setAttribute("Day", (Object)"Day");
                this.drinkPotion(player, "dayPotion");
                player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot, 1);
            }
        });
        dayPotion.setItemRotation(0.22293362f, 0.22471714f, 0.22360678f, 0.92186356f);
        dayPotion.setItemPosition(0.019081512f, -0.04900055f, 0.14518893f);
        dayPotion.setFPBodyPosition(3.018208E-11f, -0.33201933f, 0.80180174f);
        dayPotion.setFPBodyRotation(-0.13954319f, 2.654893E-12f, 1.42185924E-11f, 0.9902161f);
        this.getServer().registerCustomItem(dayPotion);
        CustomRecipe dayPotionRecipe = new CustomRecipe("dayPotion", CustomRecipe.Type.CustomItem, 0, "Potions", new String[]{"workbench"});
        dayPotionRecipe.setIngredients(new String[]{"8x goldingot, 16x mithrilingot"});
        dayPotionRecipe.setLocalizedNames(new String[]{"Day Potion"});
        dayPotionRecipe.setLocalizedDescriptions(new String[]{"Turns night to day\n one hour cooldown"});
        dayPotionRecipe.setTargetCount(1);
        this.getServer().registerCustomRecipe(dayPotionRecipe);
    }
}

