/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Date;
import java.util.HashMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangePositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerDropItemEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.utils.SoundInformation;

public class AutoPickup
extends Plugin
implements Listener {
    private World world;
    private long dropCooldown;
    private HashMap<Player, Long> lastDropTimes;
    public SoundInformation pickupSound;
    private HashMap<Player, Boolean> disabled;

    public void onDisable() {
    }

    public void onEnable() {
        this.world = this.getWorld();
        this.pickupSound = new SoundInformation(String.valueOf(this.getPath()) + "/sounds/pickup.ogg");
        this.lastDropTimes = new HashMap();
        this.disabled = new HashMap();
        this.registerEventListener(this);
        this.dropCooldown = 2000L;
        System.out.println("Autopickup enabled!");
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Date date = new Date();
        this.lastDropTimes.put(event.getPlayer(), date.getTime());
        this.disabled.put(event.getPlayer(), false);
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        this.lastDropTimes.remove(event.getPlayer());
        this.disabled.remove(event.getPlayer());
    }

    @EventMethod
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Date date = new Date();
        this.lastDropTimes.put(event.getPlayer(), date.getTime());
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        Player cmdPlayer = event.getPlayer();
        String[] cmdParams = event.getCommand().split(" ");
        switch (cmdParams.length) {
            case 1: {
                break;
            }
            case 2: {
                if (cmdParams[0].equals("/ap") && cmdParams[1].equals("disable")) {
                    this.disabled.put(cmdPlayer, true);
                }
                if (!cmdParams[0].equals("/ap") || !cmdParams[1].equals("enable")) break;
                this.disabled.put(cmdPlayer, false);
            }
        }
    }

    @EventMethod
    public void onPlayerChangePosition(PlayerChangePositionEvent event) {
        block9: {
            Date date;
            if (this.disabled.get(event.getPlayer()).booleanValue() || (date = new Date()).getTime() - this.lastDropTimes.get(event.getPlayer()) <= this.dropCooldown) break block9;
            WorldItem worldItem = this.world.findNearestItem(event.getPlayer().getPosition());
            String itemType = worldItem.getDefinition().getType();
            float distanceToItem = worldItem.getPosition().distance(event.getPlayer().getPosition());
            boolean canAddItem = false;
            if (!worldItem.isDummy()) {
                canAddItem = this.inventoryCheck(event.getPlayer(), worldItem);
            }
            if (!(distanceToItem < 3.0f) || !canAddItem || worldItem.isDummy() || itemType != "BLOCK" && itemType != "PLANT" && itemType != "OBJECT" && itemType != "DEFAULT" && itemType != "ORE") break block9;
            worldItem.applyPhysicalImpulse(event.getPlayer().getPosition().subtract(worldItem.getPosition()).mult(2.0f));
            if (!(distanceToItem < 2.0f)) break block9;
            Item.Attribute attribute = worldItem.getAttribute();
            Item.ObjectAttribute objAtt = null;
            switch (itemType) {
                case "OBJECT": {
                    objAtt = (Item.ObjectAttribute)attribute;
                    if (objAtt != null) {
                        event.getPlayer().getInventory().insertNewObjectItem(objAtt.getObjectID(), worldItem.getVariation(), worldItem.getStacksize());
                        break;
                    }
                    event.getPlayer().getInventory().insertNewItem(worldItem.getDefinition().getID(), worldItem.getVariation(), worldItem.getStacksize());
                    break;
                }
                default: {
                    event.getPlayer().getInventory().insertNewItem(worldItem.getDefinition().getID(), worldItem.getVariation(), worldItem.getStacksize());
                }
            }
            worldItem.destroy();
            event.getPlayer().playSound(this.pickupSound, event.getPlayer().getPosition());
        }
    }

    private boolean inventoryCheck(Player player, WorldItem checkItem) {
        int itemMaxStackSize;
        int stackSize;
        int inventItemVariation;
        short inventItemId;
        int checkItemVariation;
        short checkItemId;
        int inventorySlotCount = player.getInventory().getSlotCount(Inventory.SlotType.Inventory);
        int quickSlotCount = player.getInventory().getSlotCount(Inventory.SlotType.Quickslot);
        boolean canAdd = false;
        String checkItemType = checkItem.getDefinition().getType();
        Item.Attribute checkItemAttribute = checkItem.getAttribute();
        Item.ObjectAttribute checkItemObjAtt = null;
        switch (checkItemType) {
            case "OBJECT": {
                checkItemObjAtt = (Item.ObjectAttribute)checkItemAttribute;
                checkItemId = checkItemObjAtt == null ? checkItem.getDefinition().getID() : checkItemObjAtt.getObjectID();
                checkItemVariation = checkItem.getVariation();
                break;
            }
            default: {
                checkItemId = checkItem.getDefinition().getID();
                checkItemVariation = checkItem.getVariation();
            }
        }
        if (checkItemId == 700 && checkItemVariation == 0) {
            checkItemVariation = 21;
        }
        Item.Attribute attribute = checkItem.getAttribute();
        Item.ObjectAttribute objAtt = null;
        int i = 0;
        while (i < inventorySlotCount) {
            block38: {
                block37: {
                    Item inventoryItem = player.getInventory().getItem(i, Inventory.SlotType.Inventory);
                    if (inventoryItem == null) break block37;
                    String inventoryItemType = inventoryItem.getDefinition().getType();
                    if (checkItemType != inventoryItemType) break block38;
                    switch (checkItemType) {
                        case "OBJECT": {
                            objAtt = (Item.ObjectAttribute)attribute;
                            inventItemId = objAtt == null ? inventoryItem.getDefinition().getID() : objAtt.getObjectID();
                            inventItemVariation = inventoryItem.getVariation();
                            break;
                        }
                        default: {
                            inventItemId = inventoryItem.getDefinition().getID();
                            inventItemVariation = inventoryItem.getVariation();
                        }
                    }
                    if (inventItemId == checkItemId && inventItemVariation == checkItemVariation && (stackSize = inventoryItem.getStacksize()) < (itemMaxStackSize = inventoryItem.getMaxStacksize())) {
                        canAdd = true;
                    }
                    break block38;
                }
                canAdd = true;
            }
            ++i;
        }
        i = 0;
        while (i < quickSlotCount) {
            block41: {
                block40: {
                    Item quickSlotItem = player.getInventory().getItem(i, Inventory.SlotType.Quickslot);
                    if (quickSlotItem == null) break block40;
                    String quickSlotItemType = quickSlotItem.getDefinition().getType();
                    if (checkItemType != quickSlotItemType) break block41;
                    switch (checkItemType) {
                        case "OBJECT": {
                            objAtt = (Item.ObjectAttribute)attribute;
                            inventItemId = objAtt == null ? quickSlotItem.getDefinition().getID() : objAtt.getObjectID();
                            inventItemVariation = quickSlotItem.getVariation();
                            break;
                        }
                        default: {
                            inventItemId = quickSlotItem.getDefinition().getID();
                            inventItemVariation = quickSlotItem.getVariation();
                        }
                    }
                    if (inventItemId == checkItemId && inventItemVariation == checkItemVariation && (stackSize = quickSlotItem.getStacksize()) < (itemMaxStackSize = quickSlotItem.getMaxStacksize())) {
                        canAdd = true;
                    }
                    break block41;
                }
                canAdd = true;
            }
            ++i;
        }
        switch (checkItem.getName()) {
            case "m14": {
                canAdd = false;
                break;
            }
            case "fireworkrocket": {
                canAdd = false;
            }
        }
        return canAdd;
    }
}

