/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.risingworld.api.Plugin;

public class ConfigManager
extends Plugin {
    public void onEnable() {
        System.out.println("[ConfigManager2] Enabled");
    }

    public void onDisable() {
        System.out.println("[ConfigManager2] Desabled");
    }

    public ConfigCreator newConfig(String path) throws IOException {
        ConfigCreator config = new ConfigCreator(path);
        return config;
    }

    public ConfigCreator newConfig(String path, String name) throws IOException {
        ConfigCreator config = new ConfigCreator(path, name);
        return config;
    }

    public ConfigCreator newConfig(String path, String name, String extention) throws IOException {
        ConfigCreator config = new ConfigCreator(path, name, extention);
        return config;
    }

    private static enum Typ {
        Property,
        EmptyLine,
        Commend;

    }

    public class ConfigCreator {
        private Properties newConfig;
        private Properties oldConfig;
        private String path;
        private String fullpath;
        private String name;
        private File File;
        private ArrayList<Sender> newSenderList;
        private ArrayList<String> oldSenderList;
        private ArrayList<String> KeyList;
        private String Extention;
        private boolean oldExist;
        private HashMap<String, Sender> SenderList;

        private ConfigCreator(String path) throws IOException {
            this.Extention = ".properties.";
            this.name = "/Settings";
            this.path = path;
            this.newConfig = new Properties();
            this.oldConfig = new Properties();
            this.newSenderList = new ArrayList();
            this.oldSenderList = new ArrayList();
            this.fullpath = path + this.name + this.Extention;
            this.KeyList = new ArrayList();
            this.File = new File(this.fullpath);
            this.SenderList = new HashMap();
            this.oldExist = this.iniOld();
        }

        private ConfigCreator(String path, String name) throws IOException {
            this.Extention = ".properties";
            this.name = "/" + name;
            this.path = path;
            this.newConfig = new Properties();
            this.oldConfig = new Properties();
            this.newSenderList = new ArrayList();
            this.oldSenderList = new ArrayList();
            this.KeyList = new ArrayList();
            this.fullpath = path + name + this.Extention;
            this.File = new File(this.fullpath);
            this.SenderList = new HashMap();
            this.oldExist = this.iniOld();
        }

        private ConfigCreator(String path, String name, String extention) throws IOException {
            this.Extention = extention;
            this.name = "/" + name;
            this.path = path;
            this.newConfig = new Properties();
            this.oldConfig = new Properties();
            this.newSenderList = new ArrayList();
            this.oldSenderList = new ArrayList();
            this.KeyList = new ArrayList();
            this.fullpath = path + name + extention;
            this.File = new File(this.fullpath);
            this.SenderList = new HashMap();
            this.oldExist = this.iniOld();
        }

        private boolean iniOld() throws IOException {
            if (this.File.exists()) {
                FileInputStream fis = new FileInputStream(this.fullpath);
                this.oldConfig.load(fis);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void WriteToFile() {
            PrintWriter pWriter = null;
            try {
                pWriter = new PrintWriter(new FileWriter(this.fullpath, false));
                if (!this.newSenderList.isEmpty()) {
                    block9: for (Sender send : this.newSenderList) {
                        switch (send.Typ) {
                            case Commend: {
                                pWriter.println(send.key);
                                continue block9;
                            }
                            case Property: {
                                pWriter.println(send.key + "=" + send.value);
                                continue block9;
                            }
                        }
                        pWriter.println();
                    }
                } else {
                    System.out.println("[ConfigManager WARNING] No values for Config found!");
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
            finally {
                if (pWriter != null) {
                    pWriter.flush();
                    pWriter.close();
                }
            }
        }

        public void CreateConfig() throws IOException {
            if (this.File.exists()) {
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new FileReader(this.fullpath));
                    String zeile = null;
                    while ((zeile = in.readLine()) != null) {
                        this.oldSenderList.add(zeile);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (this.hatChange()) {
                    this.WriteToFile();
                }
            } else {
                this.WriteToFile();
            }
        }

        public void setSetting(String key, Object value) {
            String stValue = String.valueOf(value);
            this.newConfig.setProperty(key, stValue);
            this.SenderList.get(key).value = stValue;
            this.WriteToFile();
        }

        public String getSetting(String key) {
            return String.valueOf(this.newConfig.getProperty(key));
        }

        public ArrayList<String> getKeys() {
            return this.KeyList;
        }

        private boolean hatChange() {
            return this.oldSenderList.size() != this.newSenderList.size();
        }

        public void addCommend(String command) {
            this.newSenderList.add(new Sender(command));
        }

        public void addSetting(String key, String value) {
            Sender send;
            this.newConfig.setProperty(key, value);
            this.KeyList.add(key);
            if (this.oldExist) {
                if (this.oldConfig.containsKey(key)) {
                    send = new Sender(Typ.Property, key, this.oldConfig.getProperty(key));
                    this.newSenderList.add(send);
                } else {
                    send = new Sender(Typ.Property, key, value);
                    this.newSenderList.add(send);
                }
            } else {
                send = new Sender(Typ.Property, key, value);
                this.newSenderList.add(send);
            }
            this.SenderList.put(key, send);
        }

        public void addEmptyLine() {
            this.newSenderList.add(new Sender());
        }

        private class Sender {
            private Typ Typ;
            private String key;
            private String value;

            public Sender() {
                this.Typ = de.pbplugins.ConfigManager$Typ.EmptyLine;
                this.key = null;
                this.value = null;
            }

            public Sender(String command) {
                this.Typ = de.pbplugins.ConfigManager$Typ.Commend;
                this.key = command;
                this.value = null;
            }

            public Sender(Typ Typ2, String key, String value) {
                this.Typ = Typ2;
                this.key = key;
                this.value = value;
            }
        }
    }
}

