-- global server reference
server = getServer();

function onEnable()
	print("BasicScript loaded successfully!");
end

function onPlayerSpawn(event)
	-- create a new label
	local label = Gui:createLabel("Welcome to "..server:getServerName().."!", 0.98, 0.135);
	-- change the fontcolor to a nice blue
	label:setFontColor(0x0066FFFF);
	-- change the fontsize (default: 12)
	label:setFontsize(48);
	-- change the pivot of our label. See our wiki for more information, 1 means "right bottom" (default: 0)
	label:setPivot(1);

	-- display the label on the player's screen
	event.player:addGuiElement(label);

	-- create a new timer that calls a function to remove the gui element after 5 seconds
	setTimer(function()
		event.player:removeGuiElement(label);
		Gui:destroyElement(label);
	end, 5, 1);
end
addEvent("PlayerSpawn", onPlayerSpawn);

function onPlayerCommand(event)
	local command = event.command;
  
	-- if the command contains any parameters, we need to split it (this is not necessary in this case)
	local cmd = StringUtils:explode(command, " ");

	-- check the command
	if cmd[1] == "/showtime" then
		-- get a formatted time string from server
		local currenttime = server:getGameTime();
		
		-- send the time to the player using a colorcode (yellow)
		event.player:sendTextMessage("[#FFFF00]Current time: ".. currenttime);
	end
end
addEvent("PlayerCommand", onPlayerCommand);

function onPlayerBlockDestroy(event)
	event:setCancel(true);
end
addEvent("PlayerBlockDestroy", onPlayerBlockDestroy);