/*
 * Decompiled with CFR 0.152.
 */
package mod.allielexie.chickencoop;

import java.io.File;
import java.io.FileNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Scanner;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeEquippedItemEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryAddEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Storage;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.CollisionType;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class ChickenCoop
extends Plugin
implements Listener {
    public final String COOP_ID = "mod.allielexie.chickencoop.chickencoop";
    public final String EGG_ID = "mod.allielexie.chickencoop.egg";
    public final String SKILLET_ID = "mod.allielexie.commons.item.skillet";
    public final String COOK_EGG_ID = "mod.allielexie.chickencoop.cookegg";
    public final String COOKED_EGG_ID = "mod.allielexie.chickencoop.cookedegg";
    public final String BURNED_EGG_ID = "mod.allielexie.chickencoop.burnedegg";
    public final String COOP_NAME = "chickencoop";
    public final String EGG_NAME = "egg";
    public final String SKILLET_NAME = "skillet";
    public final String COOK_EGG_NAME = "cookegg";
    public final String COOKED_EGG_NAME = "cookedegg";
    public final String BURNED_EGG_NAME = "burnedegg";
    private final float COOP_OBJ_SCALE = 0.5f;
    private final float COOP_ITEM_SCALE = 0.25f;
    private final float COOP_PREVIEW_SCALE = 0.5f;
    private final float EGG_OBJ_SCALE = 0.25f;
    private final float EGG_ITEM_SCALE = 0.07f;
    private final float EGG_PLATE_SCALE = 0.32f;
    private final float SKILLET_ITEM_SCALE = 0.25f;
    private final float SKILLET_PREVIEW_SCALE = 0.5f;
    private final float SKILLET_OBJECT_SCALE = 0.25f;
    private final int EGG_STACK_SIZE = 8;
    private final float ROTATION_STEP = 0.19634955f;
    private final short CHICKEN_ID = (short)10;
    private final short COOKING_GRILL_ID = (short)14;
    private final float CHICKEN_SPAWN_INTERVAL = 45.0f;
    private final int CHICKEN_SPAWN_LIMIT = 6;
    private final float EGG_INTERVAL = 24.0f;
    private final float CHICKEN_RANGE = 10.0f;
    private final int PLAYER_COOP_LIMIT = 2;
    private final String PREVIEW_MODEL = "mod.allielexie.chickencoop.previewmodel";
    private final String PREVIEW_TIMER = "mod.allielexie.chickencoop.previewtimer";
    private final String OBJECT_TYPE = "mod.allielexie.chickencoop.objecttype";
    private final String COOP_TIMER = "mod.allielexie.chickencoop.cooptimer";
    private final String CHICKEN_TIMER = "mod.allielexie.chickencoop.chickentimer";
    private final String COOP_STORAGE = "mod.allielexie.chickencoop.coopstorage";
    private final String COOP_AREA = "mod.allielexie.chickencoop.cooparea";
    private final String EGG_TIMER = "mod.allielexie.chickencoop.eggtimer";
    private final String COOP_OPEN = "Open";
    private final String COOP_REMOVE = "Remove";
    private final String[] COOP_OPTIONS = new String[]{"Open", "Remove"};
    private final String MSG_HEADER = "[Plugin] Chicken Coops: ";
    private final int COLLISION_BITMASK = CollisionType.getBitmask((int[])new int[]{1, 8, 16, 128});
    private Database db;
    private ArrayList<World3DModel> coops;
    private ArrayList<World3DModel> skillets;
    private ArrayList<World3DModel> eggs;
    private ModelInformation eggModel;
    private ModelInformation coopModel;
    private ModelInformation skilletModel;
    private ModelInformation cookEggModel;
    private ModelInformation eggPlateModel;
    private ImageInformation eggTexture;
    private ImageInformation eggIcon;
    private ImageInformation coopTexture;
    private ImageInformation coopIcon;
    private ImageInformation skilletTexture;
    private ImageInformation skilletIcon;
    private ImageInformation cookEggTexture;
    private ImageInformation cookedEggTexture;
    private ImageInformation burnedEggTexture;
    private ImageInformation cookedEggIcon;
    private ImageInformation burnedEggIcon;
    private Timer eggTimer;
    private String prefsFile = null;
    private float chickenSpawnInterval = 45.0f;
    private int chickenSpawnLimit = 6;
    private float layEggInterval = 24.0f;
    private float chickenRoamRange = 10.0f;
    private int playerCoopLimit = 2;

    public void onDisable() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onEnable() {
        float rw;
        float rz;
        float ry;
        float rx;
        float pz;
        float py;
        ResultSet result;
        Object var2_6;
        this.prefsFile = String.valueOf(this.getPath()) + "/prefs.txt";
        this.loadPreferences(this.prefsFile);
        this.coops = new ArrayList();
        this.skillets = new ArrayList();
        this.eggs = new ArrayList();
        this.eggModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/egg.obj");
        this.coopModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/coop.obj");
        this.skilletModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/skillet.obj");
        this.cookEggModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/cookegg.obj");
        this.eggPlateModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/eggplate.obj");
        this.eggTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/egg.png");
        this.coopTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/coop.png");
        this.skilletTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/skillet.png");
        this.cookEggTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/cookegg.png");
        this.cookedEggTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/cookedegg.png");
        this.burnedEggTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/burnedegg.png");
        this.eggIcon = new ImageInformation(String.valueOf(this.getPath()) + "/assets/eggicon.png");
        this.coopIcon = new ImageInformation(String.valueOf(this.getPath()) + "/assets/coopicon.png");
        this.skilletIcon = new ImageInformation(String.valueOf(this.getPath()) + "/assets/skilleticon.png");
        this.cookedEggIcon = new ImageInformation(String.valueOf(this.getPath()) + "/assets/cookedeggicon.png");
        this.burnedEggIcon = new ImageInformation(String.valueOf(this.getPath()) + "/assets/burnedeggicon.png");
        this.db = this.getSQLiteConnection(this.getWorld().getWorldFolder() + "/ChickenCoops.db");
        this.db.execute("CREATE TABLE IF NOT EXISTS `coops` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `playeruid` BIGINT, `storage` INT, `posx` REAL, `posy` REAL, `posz` REAL, `rotx` REAL, `roty` REAL, `rotz` REAL, `rotw` REAL)");
        this.db.execute("CREATE TABLE IF NOT EXISTS `skillets` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `playeruid` BIGINT, `posx` REAL, `posy` REAL, `posz` REAL, `rotx` REAL, `roty` REAL, `rotz` REAL, `rotw` REAL)");
        try {
            Throwable throwable = null;
            var2_6 = null;
            try {
                result = this.db.executeQuery("SELECT * FROM `coops`");
                try {
                    while (result.next()) {
                        try {
                            float px = result.getFloat("posx");
                            py = result.getFloat("posy");
                            pz = result.getFloat("posz");
                            rx = result.getFloat("rotx");
                            ry = result.getFloat("roty");
                            rz = result.getFloat("rotz");
                            rw = result.getFloat("rotw");
                            World3DModel coop = this.placeCoop(new Vector3f(px, py, pz), new Quaternion(rx, ry, rz, rw));
                            this.coops.add(coop);
                            Storage coopStorage = this.getWorld().getStorage(result.getInt("storage"));
                            coop.setAttribute("mod.allielexie.chickencoop.coopstorage", (Object)coopStorage);
                        }
                        catch (Exception e) {
                            System.out.println("[Plugin] Chicken Coops: Error reading form database ChickenCoops.db, skipping record.");
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println("[Plugin] Chicken Coops: Error reading from database ChickenCoops.db, aborting");
            e.printStackTrace();
        }
        try {
            Throwable e = null;
            var2_6 = null;
            try {
                result = this.db.executeQuery("SELECT * FROM `skillets`");
                try {
                    while (result.next()) {
                        try {
                            float px = result.getFloat("posx");
                            py = result.getFloat("posy");
                            pz = result.getFloat("posz");
                            rx = result.getFloat("rotx");
                            ry = result.getFloat("roty");
                            rz = result.getFloat("rotz");
                            rw = result.getFloat("rotw");
                            World3DModel sk = this.placeSkillet(new Vector3f(px, py, pz), new Quaternion(rx, ry, rz, rw));
                            this.skillets.add(sk);
                        }
                        catch (Exception e2) {
                            System.out.println("[Plugin] Chicken Coops: Error reading form database ChickenCoops.db, skipping record.");
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                    throw e;
                }
                if (e == throwable) throw e;
                e.addSuppressed(throwable);
                throw e;
            }
        }
        catch (Exception e) {
            System.out.println("[Plugin] Chicken Coops: Error reading from database ChickenCoops.db, aborting");
            e.printStackTrace();
        }
        CustomItem coopItem = new CustomItem("mod.allielexie.chickencoop.chickencoop", "chickencoop");
        coopItem.setModel(this.coopModel, this.coopTexture, 0.25f);
        coopItem.setIcon(this.coopIcon);
        coopItem.setMaxStacksize(1);
        coopItem.setHand(CustomItem.Hand.None);
        coopItem.setPlayerIdleAnimation(null);
        coopItem.setLocalizedNames(new String[]{"en=Chicken Coop", "de=H\u00fchnerstall"});
        coopItem.setSecondaryAction(Animation.Idle1, 0.1f, (player, collision) -> {
            World3DModel coop = this.placeCoop(player);
            if (coop != null) {
                this.coops.add(coop);
                Storage coopStorage = null;
                Item sItem = player.getInventory().getItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot);
                if (sItem.getAttribute() instanceof Item.CustomItemAttribute) {
                    Item.CustomItemAttribute cItem = (Item.CustomItemAttribute)sItem.getAttribute();
                    coopStorage = cItem.hasAttribute("mod.allielexie.chickencoop.coopstorage") ? this.getWorld().getStorage(Integer.decode(cItem.getAttribute("mod.allielexie.chickencoop.coopstorage")).intValue()) : this.getWorld().createNewStorage(4);
                }
                if (coopStorage != null) {
                    coop.setAttribute("mod.allielexie.chickencoop.coopstorage", coopStorage);
                }
                Vector3f pos = coop.getPosition();
                Quaternion rot = coop.getRotation();
                this.db.executeUpdate("INSERT INTO `coops` (`playeruid`, `storage`, `posx`, `posy`, `posz`, `rotx`, `roty`, `rotz`, `rotw`) VALUES ('" + player.getUID() + "', '" + coopStorage.getID() + "', '" + pos.x + "', '" + pos.y + "', '" + pos.z + "', '" + rot.x + "', '" + rot.y + "', '" + rot.z + "', '" + rot.w + "')");
                player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot);
            }
        });
        this.getServer().registerCustomItem(coopItem);
        CustomRecipe coopRecipe = new CustomRecipe("mod.allielexie.chickencoop.chickencoop", CustomRecipe.Type.CustomItem, 0, "Miscellaneous", new String[]{"sawmill"});
        coopRecipe.setPreviewSize(0.5f);
        coopRecipe.setPreviewOffset(0.0f, -0.5f, 0.0f);
        coopRecipe.setIngredients(new String[]{"32x lumber, 8x ironrod"});
        coopRecipe.setLocalizedNames(coopItem.getLocalizedNames());
        coopRecipe.setLocalizedDescriptions(new String[]{"en=A little house for chickens.", "de=Ein kleines Haus f\u00fcr H\u00fchner."});
        this.getServer().registerCustomRecipe(coopRecipe);
        CustomItem eggItem = new CustomItem("mod.allielexie.chickencoop.egg", "egg");
        eggItem.setModel(this.eggModel, this.eggTexture, 0.07f);
        eggItem.setIcon(this.eggIcon);
        eggItem.setMaxStacksize(8);
        eggItem.setHand(CustomItem.Hand.Right);
        eggItem.setLocalizedNames(new String[]{"en=Egg", "de=Ei"});
        eggItem.setPlayerIdleAnimation(Animation.Weapon1HandIdle);
        eggItem.setSecondaryAction(Animation.Weapon1HandHit3, 0.3f, (player, collision) -> {
            if (collision.hasCollision()) {
                Vector3f pos = collision.getElementPosition();
                for (World3DModel sk : this.skillets) {
                    if (!sk.hasAttribute("mod.allielexie.chickencoop.objecttype") || !sk.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.commons.item.skillet") || !sk.getPosition().equals((Object)pos)) continue;
                    boolean hasEgg = false;
                    for (World3DModel egg : this.eggs) {
                        if (!egg.getPosition().equals((Object)sk.getPosition())) continue;
                        hasEgg = true;
                        break;
                    }
                    if (hasEgg) continue;
                    World3DModel cookEgg = new World3DModel(this.cookEggModel, this.cookEggTexture, pos, new Quaternion());
                    cookEgg.setScale(0.25f);
                    cookEgg.setLightingEnabled(true);
                    cookEgg.setTransparencyEnabled(true);
                    cookEgg.setHittable(false);
                    cookEgg.setAlpha(0.8f);
                    cookEgg.setAttribute("mod.allielexie.chickencoop.objecttype", (Object)"mod.allielexie.chickencoop.cookegg");
                    for (Player p : this.getServer().getAllPlayers()) {
                        p.addWorldElement((WorldElement)cookEgg);
                    }
                    Timer cookEggTimer = new Timer(60.0f, 60.0f, 0, () -> {
                        cookEgg.setAttribute("mod.allielexie.chickencoop.objecttype", (Object)"mod.allielexie.chickencoop.cookedegg");
                        cookEgg.setAlpha(1.0f);
                        cookEgg.setTransparencyEnabled(false);
                        cookEgg.setTexture(this.cookedEggTexture);
                        cookEgg.setInteractable(true);
                        cookEgg.setInteractionCrosshair(Crosshair.Pickup);
                        Timer burnEggTimer = new Timer(30.0f, 30.0f, 0, () -> {
                            cookEgg.setAttribute("mod.allielexie.chickencoop.objecttype", (Object)"mod.allielexie.chickencoop.burnedegg");
                            cookEgg.setTexture(this.burnedEggTexture);
                        });
                        burnEggTimer.start();
                        cookEgg.setAttribute("mod.allielexie.chickencoop.eggtimer", (Object)burnEggTimer);
                    });
                    cookEggTimer.start();
                    cookEgg.setAttribute("mod.allielexie.chickencoop.eggtimer", (Object)cookEggTimer);
                    this.eggs.add(cookEgg);
                    player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot, 1);
                }
            }
        });
        eggItem.setItemPosition(0.00735649f, 0.033277687f, 0.04627337f);
        eggItem.setItemRotation(0.54234254f, -0.48045546f, -0.34576023f, 0.59622926f);
        eggItem.setFPBodyPosition(-0.36870015f, -0.37071902f, -0.014238805f);
        eggItem.setFPBodyRotation(-0.037235007f, 0.017355084f, 0.03135109f, 0.99866664f);
        this.getServer().registerCustomItem(eggItem);
        CustomItem skillet = new CustomItem("mod.allielexie.commons.item.skillet", "skillet");
        skillet.setModel(this.skilletModel, this.skilletTexture, 0.25f);
        skillet.setIcon(this.skilletIcon);
        skillet.setMaxStacksize(1);
        skillet.setHand(CustomItem.Hand.Right);
        skillet.setLocalizedNames(new String[]{"en=Skillet", "de=Bratpfanne"});
        skillet.setPlayerIdleAnimation(Animation.Weapon1HandIdle);
        skillet.setPrimaryAction(Animation.Weapon1HandHit3, 0.5f, (player, collision) -> {
            if (collision.hasCollision()) {
                short damage = (short)((double)Definitions.getHitDamageDefinition((String)"crowbar").getPlayerDamage() * 0.75);
                Object o = collision.getCollisionObject();
                if (o instanceof Npc) {
                    Npc n = (Npc)o;
                    n.setHealth(n.getHealth() - damage);
                    n.setAlerted(true);
                }
                if (o instanceof Player) {
                    Player p = (Player)o;
                    p.setHealth(p.getHealth() - damage);
                }
                for (Player p : this.getServer().getAllPlayers()) {
                    p.playGameSound("hit_metal", collision.getCollisionPoint());
                }
            }
        });
        skillet.setSecondaryAction(Animation.Weapon1HandHit1, 0.1f, (player, collision) -> {
            if (collision.getElementTypeID() == 14) {
                Vector3f sp = new Vector3f(collision.getCollisionPoint());
                Quaternion sr = new Quaternion();
                sr.multLocal(new Quaternion().fromAngles(0.0f, player.getRotation().toAngles()[1], 0.0f));
                World3DModel sk = this.placeSkillet(sp, sr);
                for (Player p : this.getServer().getAllPlayers()) {
                    p.addWorldElement((WorldElement)sk);
                }
                this.skillets.add(sk);
                this.db.executeUpdate("INSERT INTO `skillets` (`playeruid`, `posx`, `posy`, `posz`, `rotx`, `roty`, `rotz`, `rotw`) VALUES ('" + player.getUID() + "', '" + sp.x + "', '" + sp.y + "', '" + sp.z + "', '" + sr.x + "', '" + sr.y + "', '" + sr.z + "', '" + sr.w + "')");
                player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot);
            }
        });
        skillet.setItemPosition(-0.07792537f, 0.33685273f, 0.6402387f);
        skillet.setItemRotation(-0.15659343f, -0.1858169f, -0.784286f, 0.5707533f);
        skillet.setFPBodyPosition(-0.008700103f, -0.22271882f, -0.12623882f);
        skillet.setFPBodyRotation(-0.049182024f, 0.017780647f, 0.029142378f, 0.9982063f);
        this.getServer().registerCustomItem(skillet);
        CustomRecipe skilletRecipe = new CustomRecipe("mod.allielexie.commons.item.skillet", CustomRecipe.Type.CustomItem, 0, "Cookware", new String[]{"workbench"});
        skilletRecipe.setPreviewSize(0.5f);
        skilletRecipe.setPreviewOffset(0.0f, -0.25f, 0.0f);
        skilletRecipe.setIngredients(new String[]{"4x ironplate, 1x stick"});
        skilletRecipe.setLocalizedNames(skillet.getLocalizedNames());
        skilletRecipe.setLocalizedDescriptions(new String[]{"en=For cooking food", "de=zum Kochen"});
        this.getServer().registerCustomRecipe(skilletRecipe);
        CustomItem cookedEgg = new CustomItem("mod.allielexie.chickencoop.cookedegg", "cookedegg");
        cookedEgg.setModel(this.eggPlateModel, this.cookedEggTexture, 0.32f);
        cookedEgg.setIcon(this.cookedEggIcon);
        cookedEgg.setMaxStacksize(8);
        cookedEgg.setHand(CustomItem.Hand.Right);
        cookedEgg.setLocalizedNames(new String[]{"en=Cooked Egg", "de=Gekochtes Ei"});
        cookedEgg.setPlayerIdleAnimation(Animation.Weapon1HandIdle);
        cookedEgg.setSecondaryAction(Animation.Eat, 0.6f, (player, collision) -> {
            this.eatFood(player, "cookedegg");
            player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot, 1);
        });
        cookedEgg.setItemPosition(-0.15303025f, -0.20106938f, 0.28521857f);
        cookedEgg.setItemRotation(0.3813399f, -0.45297483f, -0.38334507f, 0.70885146f);
        cookedEgg.setFPBodyPosition(-0.36870015f, -0.37071902f, -0.014238805f);
        cookedEgg.setFPBodyRotation(-0.037235007f, 0.017355084f, 0.03135109f, 0.99866664f);
        this.getServer().registerCustomItem(cookedEgg);
        CustomItem burnedEgg = new CustomItem("mod.allielexie.chickencoop.burnedegg", "burnedegg");
        burnedEgg.setModel(this.eggPlateModel, this.burnedEggTexture, 0.32f);
        burnedEgg.setIcon(this.burnedEggIcon);
        burnedEgg.setMaxStacksize(8);
        burnedEgg.setHand(CustomItem.Hand.Right);
        burnedEgg.setLocalizedNames(new String[]{"en=Burned Egg", "de=Verbranntes Ei"});
        burnedEgg.setPlayerIdleAnimation(Animation.Weapon1HandIdle);
        burnedEgg.setSecondaryAction(Animation.Eat, 0.6f, (player, collision) -> {
            this.eatFood(player, "burnedegg");
            player.getInventory().removeItem((int)player.getInventory().getQuickslotFocus(), Inventory.SlotType.Quickslot, 1);
        });
        burnedEgg.setItemPosition(-0.15303025f, -0.20106938f, 0.28521857f);
        burnedEgg.setItemRotation(0.3813399f, -0.45297483f, -0.38334507f, 0.70885146f);
        burnedEgg.setFPBodyPosition(-0.36870015f, -0.37071902f, -0.014238805f);
        burnedEgg.setFPBodyRotation(-0.037235007f, 0.017355084f, 0.03135109f, 0.99866664f);
        this.getServer().registerCustomItem(burnedEgg);
        this.eggTimer = new Timer(this.layEggInterval * 60.0f, 30.0f, -1, () -> {
            for (World3DModel c : this.coops) {
                Storage coopStorage;
                if (this.countChickens(c) <= 0 || (coopStorage = (Storage)c.getAttribute("mod.allielexie.chickencoop.coopstorage")) == null) continue;
                coopStorage.insertNewCustomItem("mod.allielexie.chickencoop.egg", 0, 1);
            }
        });
        this.eggTimer.start();
        this.registerEventListener(this);
    }

    @EventMethod
    public void onPlayerInventoryAddEvent(PlayerInventoryAddEvent event) {
        Item.CustomItemAttribute cItem;
        Item item = event.getItem();
        if (item.getAttribute() instanceof Item.CustomItemAttribute && (cItem = (Item.CustomItemAttribute)item.getAttribute()).getUUID().equals("mod.allielexie.chickencoop.chickencoop") && !cItem.hasAttribute("mod.allielexie.chickencoop.coopstorage")) {
            Storage coopStorage = this.getWorld().createNewStorage(4);
            cItem.setAttribute("mod.allielexie.chickencoop.coopstorage", Integer.toString(coopStorage.getID()));
        }
    }

    @EventMethod
    public void onPlayerInteraction(PlayerElementInteractionEvent event) {
        WorldElement element = event.getWorldElement();
        Player player = event.getPlayer();
        if (element instanceof World3DModel) {
            if (element.hasAttribute("mod.allielexie.chickencoop.objecttype") && element.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.chickencoop.chickencoop")) {
                boolean access = false;
                Vector3f pos = element.getPosition();
                try {
                    Throwable throwable = null;
                    Object var7_14 = null;
                    try (ResultSet result = this.db.executeQuery("SELECT * FROM `coops` WHERE `posx` = '" + pos.x + "' AND `posy` =  '" + pos.y + "' AND `posz` = '" + pos.z + "'");){
                        if (result.next() && result.getLong("playeruid") == player.getUID()) {
                            access = true;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (player.isAdmin()) {
                    access = true;
                }
                if (access) {
                    World3DModel coop = (World3DModel)element;
                    Storage coopStorage = (Storage)element.getAttribute("mod.allielexie.chickencoop.coopstorage");
                    if (coopStorage != null) {
                        player.showContextMenu(this.COOP_OPTIONS, entry -> {
                            if (entry.equals("Open")) {
                                player.showStorage(coopStorage.getID());
                            }
                            if (entry.equals("Remove")) {
                                this.removeCoop(coop, player);
                            }
                        });
                    }
                } else {
                    player.sendTextMessage("[Plugin] Chicken Coops: You do not have permission to access this chicken coop.");
                }
            } else if (element.hasAttribute("mod.allielexie.chickencoop.objecttype") && element.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.commons.item.skillet")) {
                World3DModel skillet = (World3DModel)element;
                World3DModel delEgg = null;
                for (World3DModel egg : this.eggs) {
                    if (!egg.getPosition().equals((Object)skillet.getPosition())) continue;
                    if (egg.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.chickencoop.cookedegg")) {
                        player.getInventory().insertNewCustomItem("mod.allielexie.chickencoop.cookedegg", 0, 1);
                    }
                    if (egg.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.chickencoop.burnedegg")) {
                        player.getInventory().insertNewCustomItem("mod.allielexie.chickencoop.burnedegg", 0, 1);
                    }
                    delEgg = egg;
                    break;
                }
                if (delEgg != null) {
                    this.removeEgg(delEgg);
                }
                skillet.deleteAttribute("mod.allielexie.chickencoop.objecttype");
                for (Player p : this.getServer().getAllPlayers()) {
                    p.removeWorldElement((WorldElement)skillet);
                }
                Vector3f pos = skillet.getPosition();
                this.db.executeUpdate("DELETE FROM `skillets` WHERE `posx` = '" + pos.x + "' AND `posy` = '" + pos.y + "' AND `posz` = '" + pos.z + "'");
                player.getInventory().insertNewCustomItem("mod.allielexie.commons.item.skillet", 0, 1);
                this.skillets.remove(skillet);
            } else if (element.hasAttribute("mod.allielexie.chickencoop.objecttype") && element.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.chickencoop.cookedegg")) {
                World3DModel cookedEgg = (World3DModel)element;
                this.removeEgg(cookedEgg);
                player.getInventory().insertNewCustomItem("mod.allielexie.chickencoop.cookedegg", 0, 1);
            } else if (element.hasAttribute("mod.allielexie.chickencoop.objecttype") && element.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.chickencoop.burnedegg")) {
                World3DModel burnedEgg = (World3DModel)element;
                this.removeEgg(burnedEgg);
                player.getInventory().insertNewCustomItem("mod.allielexie.chickencoop.burnedegg", 0, 1);
            }
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.setListenForKeyInput(true);
        player.registerKeys(new int[]{203, 205, 1});
        for (World3DModel coop : this.coops) {
            player.addWorldElement((WorldElement)coop);
        }
        for (World3DModel skillet : this.skillets) {
            player.addWorldElement((WorldElement)skillet);
        }
    }

    @EventMethod
    public void onPlayerChangeItem(PlayerChangeEquippedItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItem();
        if (item != null && item.getAttribute() instanceof Item.CustomItemAttribute) {
            Item.CustomItemAttribute customItem = (Item.CustomItemAttribute)item.getAttribute();
            if (customItem.getUUID().equals("mod.allielexie.chickencoop.chickencoop")) {
                Vector3f pos = Utils.VectorUtils.getXYZInFrontOfPlayer((Player)player, (float)3.0f);
                Quaternion rot = new Quaternion();
                World3DModel coop = this.previewCoop(pos, rot);
                player.addWorldElement((WorldElement)coop);
                Timer timer = new Timer(0.05f, 0.5f, -1, () -> player.raycast(this.COLLISION_BITMASK, result -> {
                    Vector3f target;
                    if (result != null && result.hasCollision() && result.getDistance() < 6.0f) {
                        target = result.getCollisionPoint();
                    } else {
                        target = Utils.VectorUtils.getXYZInFrontOfPlayer((Player)player, (float)6.0f);
                        target.y = world3DModel.getPosition().y;
                    }
                    coop.moveTo(target, 9.0f);
                }));
                timer.start();
                player.setAttribute("mod.allielexie.chickencoop.previewmodel", (Object)coop);
                player.setAttribute("mod.allielexie.chickencoop.previewtimer", (Object)timer);
            } else if (this.hasPreview(player)) {
                this.abortPreview(player);
            }
        } else if (this.hasPreview(player)) {
            this.abortPreview(player);
        }
    }

    @EventMethod
    public void onPlayerKeyInput(PlayerKeyEvent event) {
        Player player = event.getPlayer();
        if (event.isPressed() && this.hasPreview(player)) {
            Quaternion rot;
            World3DModel preview = (World3DModel)player.getAttribute("mod.allielexie.chickencoop.previewmodel");
            if (event.getKeyCode() == 203) {
                rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.19634955f, 0.0f));
                preview.setRotation(rot);
            }
            if (event.getKeyCode() == 205) {
                rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, -0.19634955f, 0.0f));
                preview.setRotation(rot);
            }
            if (event.getKeyCode() == 1) {
                this.abortPreview(player);
            }
        }
    }

    @EventMethod
    public void onPlayerCraftItem(PlayerCraftItemEvent event) {
        Item item = event.getItem();
        Player player = event.getPlayer();
        if (item.getAttribute() instanceof Item.CustomItemAttribute) {
            Item.CustomItemAttribute cItem = (Item.CustomItemAttribute)item.getAttribute();
            if (!player.isAdmin() && cItem.getUUID().equals("mod.allielexie.chickencoop.chickencoop") && this.countCoops(player) >= this.playerCoopLimit) {
                this.tooManyCoops(player);
                event.setCancelled(true);
            }
        }
    }

    private int countCoops(Player player) {
        int c = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet result = this.db.executeQuery("SELECT * FROM `coops` WHERE `playeruid` = '" + player.getUID() + "'");){
                while (result.next()) {
                    ++c;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            System.out.println("[Plugin] Chicken Coops: Error reading from ChickenCoops.db on PlayerCraftItemEvent");
            e.printStackTrace();
        }
        return c;
    }

    private World3DModel previewCoop(Vector3f position, Quaternion rotation) {
        World3DModel coop = new World3DModel(this.coopModel, this.coopTexture, position, rotation);
        coop.setScale(0.5f);
        coop.setLightingEnabled(false);
        coop.setCollisionShape(null);
        coop.setHittable(false);
        coop.setTransparencyEnabled(true);
        coop.setAlpha(0.6f);
        return coop;
    }

    private World3DModel placeCoop(Vector3f position, Quaternion rotation) {
        World3DModel coop = new World3DModel(this.coopModel, this.coopTexture, position, rotation);
        coop.setScale(0.5f);
        coop.setLightingEnabled(true);
        coop.setCollisionShape(CollisionShape.createHullCollisionShape());
        coop.setHittable(false);
        coop.setInteractionCrosshair(Crosshair.Chest);
        coop.setInteractable(true);
        coop.setAttribute("mod.allielexie.chickencoop.objecttype", (Object)"mod.allielexie.chickencoop.chickencoop");
        Area coopArea = new Area((int)(position.x - this.chickenRoamRange * 1.5f), (int)(position.y - this.chickenRoamRange * 1.5f), (int)(position.z - this.chickenRoamRange * 1.5f), (int)(position.x + this.chickenRoamRange * 1.5f), (int)(position.y + this.chickenRoamRange * 1.5f), (int)(position.z + this.chickenRoamRange * 1.5f));
        coop.setAttribute("mod.allielexie.chickencoop.cooparea", (Object)coopArea);
        Timer coopTimer = new Timer(this.chickenSpawnInterval * 60.0f, 30.0f, -1, () -> {
            int c = this.countChickens(coop);
            if (c < this.chickenSpawnLimit) {
                Vector3f cpos = new Vector3f(coop.getPosition()).add(this.plusMinus(this.chickenRoamRange), 0.0f, this.plusMinus(this.chickenRoamRange));
                this.getWorld().spawnNpc((short)10, cpos, new Quaternion());
            }
        });
        coopTimer.start();
        coop.setAttribute("mod.allielexie.chickencoop.cooptimer", (Object)coopTimer);
        Timer chickenTimer = new Timer(12.0f, 5.0f, -1, () -> {
            for (Npc chicken : this.getWorld().getAllNpcsInArea(coopArea, null)) {
                if (chicken.getTypeID() != 10 || !(chicken.getPosition().distance(coop.getPosition()) > this.chickenRoamRange)) continue;
                Vector3f target = new Vector3f(coop.getPosition()).add(this.plusMinus(this.chickenRoamRange), 0.0f, this.plusMinus(this.chickenRoamRange));
                chicken.moveTo(target);
            }
        });
        chickenTimer.start();
        coop.setAttribute("mod.allielexie.chickencoop.chickentimer", (Object)chickenTimer);
        return coop;
    }

    private World3DModel placeCoop(Player player) {
        World3DModel coop = null;
        if (this.countCoops(player) < this.playerCoopLimit || player.isAdmin()) {
            Timer timer = (Timer)player.getAttribute("mod.allielexie.chickencoop.previewtimer");
            World3DModel preview = (World3DModel)player.getAttribute("mod.allielexie.chickencoop.previewmodel");
            if (timer != null && preview != null) {
                timer.kill();
                Vector3f pos = preview.getPosition();
                Quaternion rot = preview.getRotation();
                coop = this.placeCoop(pos, rot);
                player.removeWorldElement((WorldElement)preview);
                for (Player p : this.getServer().getAllPlayers()) {
                    p.addWorldElement((WorldElement)coop);
                }
                player.deleteAttribute("mod.allielexie.chickencoop.previewmodel");
                player.deleteAttribute("mod.allielexie.chickencoop.previewtimer");
            }
        } else {
            this.tooManyCoops(player);
            this.abortPreview(player);
        }
        return coop;
    }

    private World3DModel placeSkillet(Vector3f position, Quaternion rotation) {
        World3DModel sk = new World3DModel(this.skilletModel, this.skilletTexture, position, rotation);
        sk.setScale(0.25f);
        sk.setInteractable(true);
        sk.setInteractionCrosshair(Crosshair.Pickup);
        sk.setAttribute("mod.allielexie.chickencoop.objecttype", (Object)"mod.allielexie.commons.item.skillet");
        sk.setLightingEnabled(true);
        sk.setHittable(false);
        return sk;
    }

    private void abortPreview(Player player) {
        World3DModel preview;
        Timer timer = (Timer)player.getAttribute("mod.allielexie.chickencoop.previewtimer");
        if (timer != null) {
            timer.kill();
            player.deleteAttribute("mod.allielexie.chickencoop.previewtimer");
        }
        if ((preview = (World3DModel)player.getAttribute("mod.allielexie.chickencoop.previewmodel")) != null) {
            player.removeWorldElement((WorldElement)preview);
            player.deleteAttribute("mod.allielexie.chickencoop.previewmodel");
        }
    }

    private void removeCoop(World3DModel coop, Player player) {
        if (coop.hasAttribute("mod.allielexie.chickencoop.objecttype") && coop.getAttribute("mod.allielexie.chickencoop.objecttype").equals("mod.allielexie.chickencoop.chickencoop")) {
            Timer chickenTimer;
            Item coopItem = player.getInventory().insertNewCustomItem("mod.allielexie.chickencoop.chickencoop", 0, 1);
            coop.deleteAttribute("mod.allielexie.chickencoop.objecttype");
            Timer coopTimer = (Timer)coop.getAttribute("mod.allielexie.chickencoop.cooptimer");
            if (coopTimer != null) {
                coopTimer.kill();
            }
            if ((chickenTimer = (Timer)coop.getAttribute("mod.allielexie.chickencoop.chickentimer")) != null) {
                chickenTimer.kill();
            }
            coop.deleteAttribute("mod.allielexie.chickencoop.cooptimer");
            coop.deleteAttribute("mod.allielexie.chickencoop.chickentimer");
            Vector3f pos = coop.getPosition();
            Area a = (Area)coop.getAttribute("mod.allielexie.chickencoop.cooparea");
            if (a != null) {
                for (Npc c : this.getWorld().getAllNpcsInArea(a, null)) {
                    if (c.getTypeID() != 10) continue;
                    c.kill();
                }
            }
            coop.deleteAttribute("mod.allielexie.chickencoop.cooparea");
            this.db.executeUpdate("DELETE FROM `coops` WHERE `posx` = '" + pos.x + "' AND `posy` = '" + pos.y + "' AND `posz` = '" + pos.z + "'");
            Storage coopStorage = (Storage)coop.getAttribute("mod.allielexie.chickencoop.coopstorage");
            if (coopStorage != null && coopItem != null && coopItem.getAttribute() instanceof Item.CustomItemAttribute) {
                Item.CustomItemAttribute cItem = (Item.CustomItemAttribute)coopItem.getAttribute();
                cItem.setAttribute("mod.allielexie.chickencoop.coopstorage", Integer.toString(coopStorage.getID()));
            }
            coop.deleteAttribute("mod.allielexie.chickencoop.coopstorage");
            this.coops.remove(coop);
            for (Player p : this.getServer().getAllPlayers()) {
                p.removeWorldElement((WorldElement)coop);
            }
        }
    }

    private void removeEgg(World3DModel egg) {
        egg.deleteAttribute("mod.allielexie.chickencoop.objecttype");
        Timer eggTimer = (Timer)egg.getAttribute("mod.allielexie.chickencoop.eggtimer");
        if (eggTimer != null) {
            eggTimer.kill();
            egg.deleteAttribute("mod.allielexie.chickencoop.eggtimer");
        }
        for (Player p : this.getServer().getAllPlayers()) {
            p.removeWorldElement((WorldElement)egg);
        }
        this.eggs.remove(egg);
    }

    private boolean hasPreview(Player player) {
        return player.hasAttribute("mod.allielexie.chickencoop.previewmodel") && player.hasAttribute("mod.allielexie.chickencoop.previewtimer");
    }

    private int countChickens(World3DModel coop) {
        int c = 0;
        Area a = (Area)coop.getAttribute("mod.allielexie.chickencoop.cooparea");
        if (a != null) {
            for (Npc n : this.getWorld().getAllNpcsInArea(a, null)) {
                if (n.getTypeID() != 10) continue;
                ++c;
            }
        }
        return c;
    }

    private float plusMinus(float range) {
        return (float)Math.random() * range * 2.0f - range;
    }

    private void tooManyCoops(Player player) {
        player.sendTextMessage("[Plugin] Chicken Coops: Cannot place coop, Max number of coops reached. Limit per player : " + this.playerCoopLimit);
    }

    private void eatFood(Player player, String food) {
        int health = player.getHealth();
        int thirst = player.getThirst();
        int hunger = player.getHunger();
        if (food.equals("cookedegg")) {
            health += 25;
            hunger += 35;
            thirst += 20;
            player.playGameSound("player_eat_steak_cooked");
        }
        if (food.equals("burnedegg")) {
            health += 5;
            hunger += 5;
            thirst -= 10;
            player.playGameSound("player_eat_steak_burned");
        }
        health = Math.min(100, Math.max(0, health));
        thirst = Math.min(100, Math.max(0, thirst));
        hunger = Math.min(100, Math.max(0, hunger));
        player.setHealth(health);
        player.setThirst(thirst);
        player.setHunger(hunger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPreferences(String fileName) {
        boolean readError = false;
        int i = 0;
        File f = new File(fileName);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Scanner sc = new Scanner(f);){
                while (true) {
                    if (!sc.hasNextLine()) {
                        sc.close();
                        break;
                    }
                    String line = sc.nextLine();
                    ++i;
                    line = this.stripComment(line);
                    if ((line = line.trim()).contains("playerCoopLimit")) {
                        try {
                            this.playerCoopLimit = Integer.decode(line.split("=")[1].trim());
                        }
                        catch (Exception e) {
                            System.out.println("[Plugin] Chicken Coops: Error reading prefs.txt line " + i + ": " + line);
                            readError = true;
                        }
                        continue;
                    }
                    if (line.contains("chickenRoamRange")) {
                        try {
                            this.chickenRoamRange = Integer.decode(line.split("=")[1].trim()).intValue();
                        }
                        catch (Exception e) {
                            System.out.println("[Plugin] Chicken Coops: Error reading prefs.txt line " + i + ": " + line);
                            readError = true;
                        }
                        continue;
                    }
                    if (line.contains("chickenSpawnLimit")) {
                        try {
                            this.chickenSpawnLimit = Integer.decode(line.split("=")[1].trim());
                        }
                        catch (Exception e) {
                            System.out.println("[Plugin] Chicken Coops: Error reading prefs.txt line " + i + ": " + line);
                            readError = true;
                        }
                        continue;
                    }
                    if (line.contains("chickenSpawnInterval")) {
                        try {
                            this.chickenSpawnInterval = Integer.decode(line.split("=")[1].trim()).intValue();
                        }
                        catch (Exception e) {
                            System.out.println("[Plugin] Chicken Coops: Error reading prefs.txt line " + i + ": " + line);
                            readError = true;
                        }
                        continue;
                    }
                    if (line.contains("layEggInterval")) {
                        try {
                            this.layEggInterval = Integer.decode(line.split("=")[1].trim()).intValue();
                        }
                        catch (Exception e) {
                            System.out.println("[Plugin] Chicken Coops: Error reading prefs.txt line " + i + ": " + line);
                            readError = true;
                        }
                        continue;
                    }
                    if (line.equals("")) continue;
                    System.out.println("[Plugin] Chicken Coops: Unrecognized command in prefs.txt line " + i + ": " + line);
                    readError = true;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                System.out.println("[Plugin] Chicken Coops: prefs.txt file not found!");
            } else {
                e.printStackTrace();
            }
            readError = true;
        }
        if (readError) {
            System.out.println("[Plugin] Chicken Coops: Error loading preferences from prefs.txt- setting missing preferences to defaults");
        } else {
            System.out.println("[Plugin] Chicken Coops: prefs.txt loaded successfully");
        }
        System.out.println("[Plugin] Chicken Coops: Preferences Settings:\nPlayer Coop Limit : " + this.playerCoopLimit + "\n" + "Chicken Roam Range : " + this.chickenRoamRange + "\n" + "Chicken Spawn Limit : " + this.chickenSpawnLimit + "\n" + "Chicken Spawn Interval : " + this.chickenSpawnInterval + "\n" + "Lay Egg Interval : " + this.layEggInterval);
    }

    private String stripComment(String cmd) {
        if (cmd.contains("#")) {
            cmd = cmd.substring(0, cmd.indexOf("#"));
        }
        return cmd;
    }
}

