/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.AktiveSign;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.Timer;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.world.PlayerPlaceConstructionEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class asSize
implements Listener {
    private List<Long> PerList;
    private AktiveSign plugin;

    public asSize(AktiveSign plugin) {
        this.plugin = plugin;
    }

    public void createPermissionList() {
        this.PerList = new ArrayList<Long>();
        try (ResultSet result = this.plugin.Database().executeQuery("SELECT * FROM 'Sizebuy' ; ");){
            if (result != null) {
                while (result.next()) {
                    this.PerList.add(result.getLong("UID"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceConstructionEvent(PlayerPlaceConstructionEvent event) {
        Player player = event.getPlayer();
        Vector3f size = event.getConstructionSize();
        Quaternion rotate = event.getConstructionRotation();
        if (this.isSizeActive(player)) {
            player.sendTextMessage("Size: " + size);
            player.sendTextMessage("Rotation: " + rotate);
            event.setCancelled(true);
            player.setAttribute(this.plugin.att.player.Size, (Object)false);
        }
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String cmd = event.getCommand();
        String[] cmd2 = cmd.split(" ");
        if (cmd.toLowerCase().equals("/getsize") && (this.hasSizePermission(player) || player.isAdmin() || this.plugin.Permission.Size_Admin.contains(player.getPermissionGroup()))) {
            player.setAttribute(this.plugin.att.player.Size, (Object)true);
        }
        if (cmd2.length == 2 && cmd2[0].toLowerCase().equals("/as") && cmd2[1].toLowerCase().equals("help") && (this.hasSizePermission(player) || player.isAdmin() || this.plugin.Permission.Size_Admin.contains(player.getPermissionGroup()))) {
            player.sendTextMessage("NEW: /getsize - Get the size and rotation of an construction in your hand");
        }
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.setAttribute(this.plugin.att.player.Size, (Object)false);
        player.setAttribute(this.plugin.att.player.SizeTimed, (Object)false);
    }

    public boolean isSizeActive(Player player) {
        return (Boolean)player.getAttribute(this.plugin.att.player.Size);
    }

    public boolean hasSizePermission(Player player) {
        return this.hasSizePermission(player.getUID()) || (Boolean)player.getAttribute(this.plugin.att.player.SizeTimed) != false;
    }

    public boolean hasSizePermission(long uid) {
        return this.PerList.contains(uid);
    }

    public void addSizePermission(Player player, boolean unlimit) {
        this.addSizePermission(player, unlimit, false, 0.0f);
    }

    public void addSizePermission(Player player, boolean unlimit, boolean timed, float time) {
        if (unlimit) {
            this.PerList.add(player.getUID());
            Connection connection = this.plugin.Database().getConnection();
            PreparedStatement pstmt = null;
            try {
                pstmt = connection.prepareStatement("INSERT INTO Sizebuy (UID) VALUES (?)");
                pstmt.setLong(1, player.getUID());
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                System.out.println("[AktiveSign - SQLite-ERR] addSizePermission");
            }
        } else if (timed) {
            player.setAttribute(this.plugin.att.player.SizeTimed, (Object)true);
            this.createTimer(player, time);
        } else {
            player.setAttribute(this.plugin.att.player.SizeTimed, (Object)true);
        }
    }

    public Timer createTimer(Player player, float time) {
        Timer timer = new Timer(time, 0.0f, 0, () -> {
            player.setAttribute(this.plugin.att.player.Size, (Object)false);
            player.sendTextMessage("Size-Time is over!");
        });
        player.setAttribute(this.plugin.att.player.SizeTime, (Object)timer);
        timer.start();
        return timer;
    }
}

