/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins.java.modifyworld;

import de.pbplugins.java.modifyworld.Modifyworld;
import de.pbplugins.java.permissionmanager.PermissionManager;
import de.pbplugins.java.permissionmanager.exception.GroupNotFoundException;
import de.pbplugins.java.permissionmanager.exception.UserNotFoundException;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerSetSignTextEvent;
import net.risingworld.api.events.player.world.PlayerCreateBlueprintEvent;
import net.risingworld.api.events.player.world.PlayerCreativePlaceBlockEvent;
import net.risingworld.api.events.player.world.PlayerCreativePlaceVegetationEvent;
import net.risingworld.api.events.player.world.PlayerCreativeRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerCreativeRemoveObjectEvent;
import net.risingworld.api.events.player.world.PlayerCreativeRemoveVegetationEvent;
import net.risingworld.api.events.player.world.PlayerCreativeTerrainEditEvent;
import net.risingworld.api.events.player.world.PlayerDestroyBlockEvent;
import net.risingworld.api.events.player.world.PlayerDestroyConstructionEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerDestroyTerrainEvent;
import net.risingworld.api.events.player.world.PlayerDestroyVegetationEvent;
import net.risingworld.api.events.player.world.PlayerEditConstructionEvent;
import net.risingworld.api.events.player.world.PlayerPlaceBlockEvent;
import net.risingworld.api.events.player.world.PlayerPlaceBlueprintEvent;
import net.risingworld.api.events.player.world.PlayerPlaceConstructionEvent;
import net.risingworld.api.events.player.world.PlayerPlaceGrassEvent;
import net.risingworld.api.events.player.world.PlayerPlaceObjectEvent;
import net.risingworld.api.events.player.world.PlayerPlaceTerrainEvent;
import net.risingworld.api.events.player.world.PlayerPlaceVegetationEvent;
import net.risingworld.api.events.player.world.PlayerPlaceWaterEvent;
import net.risingworld.api.events.player.world.PlayerRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerRemoveGrassEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.events.player.world.PlayerRemoveWaterEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Sign;
import net.risingworld.api.utils.Definitions;

public class PlayerWorldEvents
implements Listener {
    private final Modifyworld plugin;
    private final PermissionManager pm;

    public PlayerWorldEvents(Modifyworld plugin, PermissionManager pm) {
        this.plugin = plugin;
        this.pm = pm;
    }

    @EventMethod
    public void onPlayerObjectInteractionEvent(PlayerObjectInteractionEvent event) {
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        Player player = event.getPlayer();
        try {
            if (def.isFurnace()) {
                if (this.pm.hasPermission(player, "modifyworld.objects.interaction.furnace") || this.pm.hasPermission(player, "modifyworld.interaction")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (def.isDoor()) {
                if (this.pm.hasPermission(player, "modifyworld.objects.interaction.door") || this.pm.hasPermission(player, "modifyworld.interaction")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (def.isSign()) {
                Sign sign = this.plugin.getWorld().getSign(event.getObjectInfoID());
                if (sign != null) {
                    if (this.pm.hasPermission(player, "modifyworld.sign.interaction") || this.pm.hasPermission(player, "modifyworld.sign.interaction." + sign.getID()) || this.pm.hasPermission(player, "modifyworld.interaction")) {
                        event.setCancelled(false);
                    } else {
                        event.setCancelled(true);
                    }
                }
            } else if (def.isPickupable()) {
                if (this.pm.hasPermission(player, "modifyworld.objects.interaction.pickupable") || this.pm.hasPermission(player, "modifyworld.interaction")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (this.pm.hasPermission(player, "modifyworld.objects.interaction") || this.pm.hasPermission(player, "modifyworld.interaction")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerCreateBlueprintEvent(PlayerCreateBlueprintEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.blueprint.create")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerCreativePlaceBlockEvent(PlayerCreativePlaceBlockEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.creative.block.place")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerCreativePlaceVegetationEvent(PlayerCreativePlaceVegetationEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.creative.vegetation.place")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerCreativeRemoveConstructionEvent(PlayerCreativeRemoveConstructionEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.creative.construction.remove")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerCreativeRemoveObjectEvent(PlayerCreativeRemoveObjectEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.creative.object.remove")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerCreativeRemoveVegetationEvent(PlayerCreativeRemoveVegetationEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.creative.vegetation.remove")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerCreativeTerrainEditEvent(PlayerCreativeTerrainEditEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.creative.terrain")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerDestroyBlockEvent(PlayerDestroyBlockEvent event) {
        Player player = event.getPlayer();
        int id = event.getBlockID();
        try {
            if (this.pm.hasPermission(player, "modifyworld.block.destroy") || this.pm.hasPermission(player, "modifyworld.block.destroy." + id) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerDestroyConstructionEvent(PlayerDestroyConstructionEvent event) {
        Player player = event.getPlayer();
        Definitions.ConstructionDefinition def = event.getConstructionDefinition();
        try {
            if (def.isGlass()) {
                if (this.pm.hasPermission(player, "modifyworld.construction.destroy.glass") || this.pm.hasPermission(player, "modifyworld.loot")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (def.isPoster()) {
                if (this.pm.hasPermission(player, "modifyworld.customimage.destroy") || this.pm.hasPermission(player, "modifyworld.loot")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (this.pm.hasPermission(player, "modifyworld.construction.destroy") || this.pm.hasPermission(player, "modifyworld.construction.destroy." + event.getConstructionTypeID()) || this.pm.hasPermission(player, "modifyworld.construction.destroy." + event.getConstructionTypeID() + "." + event.getConstructionTextureID()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerDestroyObjectEvent(PlayerDestroyObjectEvent event) {
        Player player = event.getPlayer();
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        try {
            if (!def.isSign() || this.pm.hasPermission(player, "modifyworld.sign.destroy") || this.pm.hasPermission(player, "modifyworld.loot")) {
                // empty if block
            }
            if (this.pm.hasPermission(player, "modifyworld.object.destroy") || this.pm.hasPermission(player, "modifyworld.object.destroy." + event.getObjectTypeID()) || this.pm.hasPermission(player, "modifyworld.object.destroy." + event.getObjectTypeID() + "." + event.getObjectVariation()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerSetSignTextEvent(PlayerSetSignTextEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.sign.settext")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerDestroyTerrainEvent(PlayerDestroyTerrainEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.terrain.destroy") || this.pm.hasPermission(player, "modifyworld.terrain.destroy." + event.getTerrainID()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerDestroyVegetationEvent(PlayerDestroyVegetationEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.vegetation.destroy") || this.pm.hasPermission(player, "modifyworld.vegetation.destroy." + event.getPlantTypeID()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerEditConstructionEvent(PlayerEditConstructionEvent event) {
        Player player = event.getPlayer();
        Definitions.ConstructionDefinition def = event.getConstructionDefinition();
        try {
            if (def.isGlass()) {
                if (this.pm.hasPermission(player, "modifyworld.construction.edit.glass") || this.pm.hasPermission(player, "modifyworld.build")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (def.isPoster()) {
                if (this.pm.hasPermission(player, "modifyworld.customimage.edit") || this.pm.hasPermission(player, "modifyworld.build")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (this.pm.hasPermission(player, "modifyworld.construction.edit") || this.pm.hasPermission(player, "modifyworld.construction.edit." + event.getConstructionTypeID()) || this.pm.hasPermission(player, "modifyworld.construction.edit." + event.getConstructionTypeID() + "." + event.getConstructionTextureID()) || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceBlockEvent(PlayerPlaceBlockEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.block.place") || this.pm.hasPermission(player, "modifyworld.block.place." + event.getBlockID()) || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceBlueprintEvent(PlayerPlaceBlueprintEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.blueprint.place")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceConstructionEvent(PlayerPlaceConstructionEvent event) {
        Player player = event.getPlayer();
        Definitions.ConstructionDefinition def = event.getConstructionDefinition();
        try {
            if (def.isGlass()) {
                if (this.pm.hasPermission(player, "modifyworld.construction.place.glass") || this.pm.hasPermission(player, "modifyworld.build")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (def.isPoster()) {
                if (this.pm.hasPermission(player, "modifyworld.customimage.place") || this.pm.hasPermission(player, "modifyworld.build")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (this.pm.hasPermission(player, "modifyworld.construction.place") || this.pm.hasPermission(player, "modifyworld.construction.place." + event.getConstructionTypeID()) || this.pm.hasPermission(player, "modifyworld.construction.place." + event.getConstructionTypeID() + "." + event.getConstructionTextureID()) || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceGrassEvent(PlayerPlaceGrassEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.grass.place") || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceObjectEvent(PlayerPlaceObjectEvent event) {
        Player player = event.getPlayer();
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        try {
            if (def.isSign()) {
                if (this.pm.hasPermission(player, "modifyworld.sign.place") || this.pm.hasPermission(player, "modifyworld.build")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (this.pm.hasPermission(player, "modifyworld.object.place") || this.pm.hasPermission(player, "modifyworld.object.place." + event.getObjectTypeID()) || this.pm.hasPermission(player, "modifyworld.object.place." + event.getObjectTypeID() + "." + event.getObjectVariation()) || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceTerrainEvent(PlayerPlaceTerrainEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.terrain.place") || this.pm.hasPermission(player, "modifyworld.terrain.place." + event.getTerrainID()) || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceVegetationEvent(PlayerPlaceVegetationEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.vegetation.place") || this.pm.hasPermission(player, "modifyworld.vegetation.place" + event.getPlantTypeID()) || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerPlaceWaterEvent(PlayerPlaceWaterEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.water.place") || this.pm.hasPermission(player, "modifyworld.water.place." + event.getWaterID()) || this.pm.hasPermission(player, "modifyworld.build")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerRemoveConstructionEvent(PlayerRemoveConstructionEvent event) {
        Player player = event.getPlayer();
        Definitions.ConstructionDefinition def = event.getConstructionDefinition();
        try {
            if (def.isGlass()) {
                if (this.pm.hasPermission(player, "modifyworld.construction.remove.glass") || this.pm.hasPermission(player, "modifyworld.loot")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (def.isPoster()) {
                if (this.pm.hasPermission(player, "modifyworld.customimage.remove") || this.pm.hasPermission(player, "modifyworld.loot")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            } else if (this.pm.hasPermission(player, "modifyworld.construction.remove") || this.pm.hasPermission(player, "modifyworld.construction.remove." + event.getConstructionTypeID()) || this.pm.hasPermission(player, "modifyworld.construction.remove." + event.getConstructionTypeID() + "." + event.getConstructionTextureID()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerRemoveGrassEvent(PlayerRemoveGrassEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.grass.remove") || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerRemoveObjectEvent(PlayerRemoveObjectEvent event) {
        Player player = event.getPlayer();
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        try {
            if (def.isSign()) {
                Sign sign = this.plugin.getWorld().getSign(event.getObjectInfoID());
                if (sign != null) {
                    if (this.pm.hasPermission(player, "modifyworld.sign.remove") || this.pm.hasPermission(player, "modifyworld.sign.remove." + sign.getID()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                        event.setCancelled(false);
                    } else {
                        event.setCancelled(true);
                    }
                }
            } else if (this.pm.hasPermission(player, "modifyworld.object.remove") || this.pm.hasPermission(player, "modifyworld.object.remove." + event.getObjectTypeID()) || this.pm.hasPermission(player, "modifyworld.object.remove." + event.getObjectTypeID() + "." + event.getObjectVariation()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerRemoveVegetationEvent(PlayerRemoveVegetationEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.vegetation.remove") || this.pm.hasPermission(player, "modifyworld.vegetation.remove." + event.getPlantTypeID()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerRemoveWaterEvent(PlayerRemoveWaterEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.water.remove") || this.pm.hasPermission(player, "modifyworld.water.remove." + event.getWaterID()) || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException throwable) {
            // empty catch block
        }
    }
}

