/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins.java.modifyworld;

import de.pbplugins.java.modifyworld.Modifyworld;
import de.pbplugins.java.permissionmanager.PermissionManager;
import de.pbplugins.java.permissionmanager.exception.GroupNotFoundException;
import de.pbplugins.java.permissionmanager.exception.UserNotFoundException;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCatchFishEvent;
import net.risingworld.api.events.player.PlayerChangeGamemodeEvent;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerChestAccessEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerCustomImageDeleteEvent;
import net.risingworld.api.events.player.PlayerCustomImageUploadRequestEvent;
import net.risingworld.api.events.player.PlayerDamageEvent;
import net.risingworld.api.events.player.PlayerDropItemEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.events.player.PlayerEnterVehicleEvent;
import net.risingworld.api.events.player.PlayerHitEvent;
import net.risingworld.api.events.player.PlayerHitNpcEvent;
import net.risingworld.api.events.player.PlayerMountNpcEvent;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Gamemode;

public class PlayerEvents
implements Listener {
    private Modifyworld plugin;
    private PermissionManager pm;

    public PlayerEvents(Modifyworld plugin, PermissionManager pm) {
        this.plugin = plugin;
        this.pm = pm;
    }

    @EventMethod
    public void onPlayerCatchFishEvent(PlayerCatchFishEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.catchfish") || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerChangeGamemodeEvent(PlayerChangeGamemodeEvent event) {
        Player player = event.getPlayer();
        Gamemode gm = event.getNewGamemode();
        if (gm == Gamemode.Creative) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.gamemode.creative")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (gm == Gamemode.Survival) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.gamemode.survival")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerChatEvent(PlayerChatEvent event) {
        event.setCancelled(true);
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.chat") || this.pm.hasPermission(player, "modifyworld.player")) {
                this.plugin.getServer().getAllPlayers().forEach(p2 -> p2.sendTextMessage(event.getPlayerChatName() + ": " + event.getChatMessage()));
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerChestAccessEvent(PlayerChestAccessEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.chest.access." + event.getChest().getID()) || this.pm.hasPermission(player, "modifyworld.interaction")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerCraftItemEvent(PlayerCraftItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItem();
        try {
            if (this.pm.hasPermission(player, "modifyworld.item.craft." + item.getTypeID()) || this.pm.hasPermission(player, "modifyworld.item.craft." + item.getName())) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerCustomImageDeleteEvent(PlayerCustomImageDeleteEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.customimage.delete")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerCustomImageUploadRequestEvent(PlayerCustomImageUploadRequestEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.customimage.upload")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerDamageEvent(PlayerDamageEvent event) {
        Player player = event.getPlayer();
        PlayerDamageEvent.Cause c = event.getCause();
        if (c == PlayerDamageEvent.Cause.Bleeding) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.bleeding") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.Burning) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.burning") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.Dehydration) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.dehydration") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.Drowning) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.drowning") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.Explosion) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.explosion") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.FallDamage) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.fall") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.NpcAttack) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.npc") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.PlayerAttack) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.pvp")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.Starvation) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.starvation") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.Temperature) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.temperature") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
        if (c == PlayerDamageEvent.Cause.Trap) {
            try {
                if (this.pm.hasPermission(player, "modifyworld.damage.trap") || this.pm.hasPermission(player, "modifyworld.player")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerDropItemEvent(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItem();
        try {
            if (this.pm.hasPermission(player, "modifyworld.item.drop." + item.getTypeID()) || this.pm.hasPermission(player, "modifyworld.item.drop." + item.getName()) || this.pm.hasPermission(player, "modifyworld.player")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerElementHitEvent(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.element.hit") || this.pm.hasPermission(player, "modifyworld.loot")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerElementInteractionEvent(PlayerElementInteractionEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.element.interaction") || this.pm.hasPermission(player, "modifyworld.interaction")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerEnterVehicleEvent(PlayerEnterVehicleEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.vehicle.enter") || this.pm.hasPermission(player, "modifyworld.interaction")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerHitEvent(PlayerHitEvent event) {
        Player player = event.getPlayer();
        try {
            if (this.pm.hasPermission(player, "modifyworld.pvp")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerHitNpcEvent(PlayerHitNpcEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        try {
            if (this.pm.hasPermission(player, "modifyworld.npc.hit." + npc.getTypeID()) || this.pm.hasPermission(player, "modifyworld.npc.hit." + npc.getName()) || this.pm.hasPermission(player, "modifyworld.npc")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerNpcInteractionEvent(PlayerNpcInteractionEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        try {
            if (this.pm.hasPermission(player, "modifyworld.npc.interaction." + npc.getGlobalID()) || this.pm.hasPermission(player, "modifyworld.npc.interaction." + npc.getName()) || this.pm.hasPermission(player, "modifyworld.npc")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerMountNpcEvent(PlayerMountNpcEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        try {
            if (this.pm.hasPermission(player, "modifyworld.npc.mount." + npc.getName()) || this.pm.hasPermission(player, "modifyworld.npc.mount." + npc.getTypeID()) || this.pm.hasPermission(player, "modifyworld.npc")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
        catch (GroupNotFoundException | UserNotFoundException ex) {
            event.setCancelled(true);
        }
    }
}

