/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins.java.permissionmanager;

import de.chaoswg.ToolsAPI;
import de.pbplugins.java.permissionmanager.ClassPermissionFile;
import de.pbplugins.java.permissionmanager.PermissionManager;
import de.pbplugins.java.permissionmanager.exception.GroupAlreadyExistException;
import de.pbplugins.java.permissionmanager.exception.GroupNotFoundException;
import de.pbplugins.java.permissionmanager.exception.UserNotFoundException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.objects.Player;
import org.yaml.snakeyaml.DumperOptions;

public class FileManager {
    PermissionManager plugin;
    Groups Groups;
    Users Users;

    public FileManager() {
    }

    public FileManager(PermissionManager plugin) {
        this.Groups = new Groups();
        this.Users = new Users();
        this.plugin = plugin;
    }

    void Yaml\u00dcberschreiben() {
        ClassPermissionFile daten = this.plugin.YAML;
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndent(2);
        options.setWidth(80);
        String yamlName = "permissions";
        File dirYamlPhat = new File(this.plugin.getPath());
        String fileCongigFile = dirYamlPhat + System.getProperty("file.separator") + yamlName + ".yml";
        File configFile = new File(fileCongigFile);
        if (configFile.exists()) {
            ToolsAPI.writeYAMAL((File)configFile, (Object)daten, (DumperOptions)options);
        }
    }

    public class Users {
        void addUser(Player player) {
            this.addUser(player.getUID());
        }

        void addUser(long uid) {
            ClassPermissionFile.ClassUserDetail uDetails = new ClassPermissionFile.ClassUserDetail();
            ArrayList<String> permissions = new ArrayList<String>();
            uDetails.setPermissions(permissions);
            ArrayList<String> groups = new ArrayList<String>();
            uDetails.setGroup(groups);
            FileManager.this.plugin.YAML.getUsers().put(uid, uDetails);
            FileManager.this.Yaml\u00dcberschreiben();
        }

        boolean hasUser(long uid) {
            return this.getAllUsers().contains(uid);
        }

        public List<Long> getAllUsers() {
            ArrayList<Long> users = new ArrayList<Long>();
            FileManager.this.plugin.YAML.getUsers().keySet().forEach(user -> users.add((Long)user));
            return users;
        }

        public List<String> getGroups(Player player) throws UserNotFoundException {
            return this.getGroups(player.getUID());
        }

        public List<String> getGroups(long uid) throws UserNotFoundException {
            if (this.hasUser(uid)) {
                return FileManager.this.plugin.YAML.getUsers().get(uid).getGroup();
            }
            throw new UserNotFoundException();
        }

        public boolean addGroups(Player player, String group) throws UserNotFoundException {
            return this.addGroups(player.getUID(), group);
        }

        public boolean addGroups(long uid, String group) throws UserNotFoundException {
            boolean b;
            if (this.hasUser(uid)) {
                b = FileManager.this.plugin.YAML.getUsers().get(uid).getGroup().add(group);
                if (b) {
                    FileManager.this.Yaml\u00dcberschreiben();
                }
            } else {
                throw new UserNotFoundException();
            }
            return b;
        }

        public boolean removeGroups(Player player, String group) throws UserNotFoundException {
            return this.removeGroups(player.getUID(), group);
        }

        public boolean removeGroups(long uid, String group) throws UserNotFoundException {
            boolean b;
            if (this.hasUser(uid)) {
                b = FileManager.this.plugin.YAML.getUsers().get(uid).getGroup().remove(group);
                if (b) {
                    FileManager.this.Yaml\u00dcberschreiben();
                }
            } else {
                throw new UserNotFoundException();
            }
            return b;
        }

        public boolean setGroups(Player player, String group) throws UserNotFoundException {
            return this.setGroups(player.getUID(), group);
        }

        public boolean setGroups(long uid, String group) throws UserNotFoundException {
            boolean b;
            if (this.hasUser(uid)) {
                FileManager.this.plugin.YAML.getUsers().get(uid).getGroup().clear();
                b = FileManager.this.plugin.YAML.getUsers().get(uid).getGroup().add(group);
                if (b) {
                    FileManager.this.Yaml\u00dcberschreiben();
                }
            } else {
                throw new UserNotFoundException();
            }
            return b;
        }

        public List<String> getPermissions(Player player) throws UserNotFoundException {
            return this.getPermissions(player.getUID());
        }

        public List<String> getPermissions(long uid) throws UserNotFoundException {
            if (this.hasUser(uid)) {
                return FileManager.this.plugin.YAML.getUsers().get(uid).getPermissions();
            }
            throw new UserNotFoundException();
        }

        public boolean addPermission(Player player, String permission) throws UserNotFoundException {
            return this.addPermission(player.getUID(), permission);
        }

        public boolean addPermission(long uid, String permission) throws UserNotFoundException {
            if (this.hasUser(uid)) {
                boolean b = FileManager.this.plugin.YAML.getUsers().get(uid).getPermissions().add(permission);
                if (b) {
                    FileManager.this.Yaml\u00dcberschreiben();
                }
                return b;
            }
            throw new UserNotFoundException();
        }

        public boolean removePermission(Player player, String permission) throws UserNotFoundException {
            return this.removePermission(player.getUID(), permission);
        }

        public boolean removePermission(long uid, String permission) throws UserNotFoundException {
            if (this.hasUser(uid)) {
                boolean b = FileManager.this.plugin.YAML.getUsers().get(uid).getPermissions().remove(permission);
                if (b) {
                    FileManager.this.Yaml\u00dcberschreiben();
                }
                return b;
            }
            throw new UserNotFoundException();
        }

        public boolean hasGroup(Player player) throws UserNotFoundException {
            return this.hasGroup(player.getUID());
        }

        public boolean hasGroup(long uid) throws UserNotFoundException {
            return !this.getGroups(uid).isEmpty();
        }

        public String getPlayerPrefix(Player player) throws UserNotFoundException, GroupNotFoundException {
            return this.getPlayerPrefix(player.getUID());
        }

        public String getPlayerPrefix(long uid) throws UserNotFoundException, GroupNotFoundException {
            if (this.hasUser(uid)) {
                String group;
                if (FileManager.this.plugin.debug > 0) {
                    System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: hasUser = true");
                    System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: FirstGroup: " + this.getGroups(uid).get(0));
                }
                if (((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.Prefix(group = this.getGroups(uid).get(0)) == null || ((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.Prefix(group).equals("")) {
                    return null;
                }
                return ((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.Prefix(group);
            }
            throw new UserNotFoundException();
        }

        public String getPlayerSufix(Player player) throws UserNotFoundException, GroupNotFoundException {
            return this.getPlayerSufix(player.getUID());
        }

        public String getPlayerSufix(long uid) throws UserNotFoundException, GroupNotFoundException {
            if (this.hasUser(uid)) {
                String group;
                if (FileManager.this.plugin.debug > 0) {
                    System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: hasUser = true");
                    System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: FirstGroup: " + this.getGroups(uid).get(0));
                }
                if (((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.Sufix(group = this.getGroups(uid).get(0)) == null || ((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.Sufix(group).equals("")) {
                    return null;
                }
                return ((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.Sufix(group);
            }
            throw new UserNotFoundException();
        }

        public String getPlayerChatColor(Player player) throws UserNotFoundException, GroupNotFoundException {
            return this.getPlayerChatColor(player.getUID());
        }

        public String getPlayerChatColor(long uid) throws UserNotFoundException, GroupNotFoundException {
            if (this.hasUser(uid)) {
                String group;
                if (FileManager.this.plugin.debug > 0) {
                    System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: hasUser = true");
                    System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: FirstGroup: " + this.getGroups(uid).get(0));
                }
                if (((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.ChatColor(group = this.getGroups(uid).get(0)) == null || ((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.ChatColor(group).equals("")) {
                    return "[#ffffff]";
                }
                return ((FileManager)((Object)FileManager.this.plugin.api)).Groups.get.ChatColor(group);
            }
            throw new UserNotFoundException();
        }
    }

    public class Groups {
        public get get = new get();
        public set set = new set();

        public List<String> getAllGroups() {
            ArrayList<String> groups = new ArrayList<String>();
            FileManager.this.plugin.YAML.getGroups().keySet().forEach(key -> groups.add((String)key));
            return groups;
        }

        public String getDefaultGroup() {
            for (String group : this.getAllGroups()) {
                if (!FileManager.this.plugin.YAML.getGroups().get(group).getOptions().getDefault()) continue;
                return group;
            }
            return null;
        }

        public boolean hasGroup(String group) {
            if (FileManager.this.plugin.debug > 0) {
                System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: getAllGroups");
                this.getAllGroups().forEach(g -> System.out.println("- " + g));
                System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: hasGroup = " + this.getAllGroups().contains(group));
            }
            return this.getAllGroups().contains(group);
        }

        public void addNewGroup(String GroupName) throws GroupAlreadyExistException {
            this.addNewGroup(GroupName, false);
        }

        public void addNewGroup(String GroupName, boolean def) throws GroupAlreadyExistException {
            if (this.hasGroup(GroupName)) {
                throw new GroupAlreadyExistException();
            }
            ClassPermissionFile.ClassGroupDetail gDetails = new ClassPermissionFile.ClassGroupDetail();
            ClassPermissionFile.ClassGroupDetail.ClassGroupOptionDetail cl = new ClassPermissionFile.ClassGroupDetail.ClassGroupOptionDetail();
            cl.setDefault(def);
            cl.setPrefix(GroupName.toUpperCase());
            cl.setRank(-1);
            gDetails.setOptions(cl);
            ArrayList<String> inheritance = new ArrayList<String>();
            gDetails.setInheritance(inheritance);
            ArrayList<String> permissions = new ArrayList<String>();
            gDetails.setPermissions(permissions);
            FileManager.this.plugin.YAML.getGroups().put(GroupName, gDetails);
            FileManager.this.Yaml\u00dcberschreiben();
        }

        public void removeGroup(String GroupName) throws GroupNotFoundException {
            if (!this.hasGroup(GroupName)) {
                throw new GroupNotFoundException();
            }
            FileManager.this.plugin.YAML.getGroups().remove(GroupName);
            FileManager.this.Yaml\u00dcberschreiben();
        }

        public boolean addGroupPermission(String group, String permission) throws GroupNotFoundException {
            boolean b;
            if (this.hasGroup(group)) {
                b = FileManager.this.plugin.YAML.getGroups().get(group).getPermissions().add(permission);
                if (b) {
                    FileManager.this.Yaml\u00dcberschreiben();
                }
            } else {
                throw new GroupNotFoundException();
            }
            return b;
        }

        public boolean removeGroupPermission(String group, String permission) throws GroupNotFoundException {
            boolean b;
            if (this.hasGroup(group)) {
                b = FileManager.this.plugin.YAML.getGroups().get(group).getPermissions().remove(permission);
                if (b) {
                    FileManager.this.Yaml\u00dcberschreiben();
                }
            } else {
                throw new GroupNotFoundException();
            }
            return b;
        }

        public class set {
            public boolean Prefix(String group, String prefix) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    FileManager.this.plugin.YAML.getGroups().get(group).getOptions().setPrefix(prefix);
                    FileManager.this.Yaml\u00dcberschreiben();
                    return true;
                }
                throw new GroupNotFoundException();
            }

            public boolean Sufix(String group, String sufix) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    FileManager.this.plugin.YAML.getGroups().get(group).getOptions().setSufix(sufix);
                    FileManager.this.Yaml\u00dcberschreiben();
                    return true;
                }
                throw new GroupNotFoundException();
            }

            public boolean ChatColor(String group, String ChatColor) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    FileManager.this.plugin.YAML.getGroups().get(group).getOptions().setChatColor(ChatColor);
                    FileManager.this.Yaml\u00dcberschreiben();
                    return true;
                }
                throw new GroupNotFoundException();
            }

            public boolean Servergroup(String group, String Servergroup) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    FileManager.this.plugin.YAML.getGroups().get(group).getOptions().setServergroup(Servergroup);
                    FileManager.this.Yaml\u00dcberschreiben();
                    return true;
                }
                throw new GroupNotFoundException();
            }

            public void Rank(String group, int rank) throws GroupNotFoundException {
                if (!Groups.this.hasGroup(group)) {
                    throw new GroupNotFoundException();
                }
                FileManager.this.plugin.YAML.getGroups().get(group).getOptions().setRank(rank);
                FileManager.this.Yaml\u00dcberschreiben();
            }

            public void Default(String group, boolean def) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    if (FileManager.this.plugin.debug > 0) {
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: ---------------------");
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: DEFAULT");
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: ---------------------");
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: YAML = " + FileManager.this.plugin.YAML);
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: YAML.getGroups() = " + FileManager.this.plugin.YAML.getGroups());
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: YAML.getGroups().get(group) = " + FileManager.this.plugin.YAML.getGroups().get(group));
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: YAML.getGroups().get(group).getOptions() = " + FileManager.this.plugin.YAML.getGroups().get(group).getOptions());
                        System.out.println(FileManager.this.plugin.PluginName + "[DEBUG]: ---------------------");
                    }
                } else {
                    throw new GroupNotFoundException();
                }
                FileManager.this.plugin.YAML.getGroups().get(group).getOptions().setDefault(def);
                FileManager.this.Yaml\u00dcberschreiben();
            }

            public boolean addInheritance(String group, String inheritance) throws GroupNotFoundException {
                boolean b;
                if (Groups.this.hasGroup(group)) {
                    b = FileManager.this.plugin.YAML.getGroups().get(group).getInheritance().add(inheritance);
                    if (b) {
                        FileManager.this.Yaml\u00dcberschreiben();
                    }
                } else {
                    throw new GroupNotFoundException();
                }
                return b;
            }

            public boolean removeInheritance(String group, String inheritance) throws GroupNotFoundException {
                boolean b;
                if (Groups.this.hasGroup(group)) {
                    b = FileManager.this.plugin.YAML.getGroups().get(group).getInheritance().remove(inheritance);
                    if (b) {
                        FileManager.this.Yaml\u00dcberschreiben();
                    }
                } else {
                    throw new GroupNotFoundException();
                }
                return b;
            }
        }

        public class get {
            public String Prefix(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getOptions().getPrefix();
                }
                throw new GroupNotFoundException();
            }

            public String Sufix(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getOptions().getSufix();
                }
                throw new GroupNotFoundException();
            }

            public String ChatColor(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getOptions().getChatColor();
                }
                throw new GroupNotFoundException();
            }

            public String Servergroup(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getOptions().getServergroup();
                }
                throw new GroupNotFoundException();
            }

            public List<String> GroupPermissions(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getPermissions();
                }
                throw new GroupNotFoundException();
            }

            public int Rank(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getOptions().getRank();
                }
                throw new GroupNotFoundException();
            }

            public boolean Default(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getOptions().getDefault();
                }
                throw new GroupNotFoundException();
            }

            public List<String> Inheritance(String group) throws GroupNotFoundException {
                if (Groups.this.hasGroup(group)) {
                    return FileManager.this.plugin.YAML.getGroups().get(group).getInheritance();
                }
                throw new GroupNotFoundException();
            }
        }
    }
}

