/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins.java.permissionmanager;

import de.pbplugins.java.permissionmanager.PermissionManager;
import de.pbplugins.java.permissionmanager.exception.GroupAlreadyExistException;
import de.pbplugins.java.permissionmanager.exception.GroupNotFoundException;
import de.pbplugins.java.permissionmanager.exception.UserNotFoundException;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.general.InputEvent;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Definitions;

public class EventManager
implements Listener {
    private PermissionManager plugin;
    private final String Rot = "[#ff0000]";
    private final String Gr\u00fcn = "[#00ff00]";
    private final String Orange = "[#ffa500]";
    private String AttGetID;

    EventManager(PermissionManager plugin) {
        this.plugin = plugin;
        this.AttGetID = "pbplugins.PermissionManager.PlayerAttribute.GetID";
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.setAttribute(this.AttGetID, (Object)false);
        boolean add = false;
        try {
            if (event.isNewPlayer()) {
                this.plugin.api.Users.addUser(player);
                add = true;
                if (this.plugin.api.Groups.getDefaultGroup() != null) {
                    this.plugin.api.Users.addGroups(player.getUID(), this.plugin.api.Groups.getDefaultGroup());
                }
            }
            if (!add && !this.plugin.api.Users.hasUser(player.getUID())) {
                this.plugin.api.Users.addUser(player);
            }
            if (!this.plugin.api.Users.hasGroup(player) && this.plugin.api.Groups.getDefaultGroup() != null) {
                this.plugin.api.Users.addGroups(player, this.plugin.api.Groups.getDefaultGroup());
            }
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @EventMethod
    public void onPlayerChatEvent(PlayerChatEvent event) {
        event.setCancelled(true);
        if (!this.plugin.Config.getUse_Server_Chat()) {
            Player player = event.getPlayer();
            String ConfigChat = this.plugin.Config.getChat();
            try {
                if (this.plugin.api.Users.hasGroup(player)) {
                    String msg = event.getChatMessage();
                    String playername = player.getName();
                    String prefix = this.plugin.api.Users.getPlayerPrefix(player);
                    String sufix = this.plugin.api.Users.getPlayerSufix(player);
                    String color = this.plugin.api.Users.getPlayerChatColor(player);
                    String msgNeu1 = prefix != null ? color + ConfigChat.replace("PREFIX", prefix) : ConfigChat.replace("[PREFIX] ", "");
                    String msgNeu2 = msgNeu1.replace("PLAYERNAME", playername);
                    String msgNeu3 = sufix != null ? msgNeu2.replace("SUFIX", sufix) : msgNeu2.replace(" [SUFIX]", "");
                    String msgNeu4 = "[#ffffff]" + msgNeu3.replace("MSG", msg);
                    if (this.plugin.debug > 0) {
                        System.out.println(this.plugin.PluginName + "[DEBUG]: Sufix = " + sufix);
                        System.out.println(this.plugin.PluginName + "[DEBUG]: Prefix = " + prefix);
                    }
                    this.plugin.getServer().getAllPlayers().forEach(p2 -> p2.sendTextMessage(msgNeu4));
                }
            }
            catch (GroupNotFoundException | UserNotFoundException ex) {
                player.sendTextMessage("EIN FEHLER IST AUFGETRETEN!");
            }
        } else {
            this.plugin.getServer().getAllPlayers().forEach(p2 -> p2.sendTextMessage(event.getPlayerChatName() + ": " + event.getChatMessage()));
        }
    }

    @EventMethod
    public void onPlayerCommandEvnet(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String command = event.getCommand();
        String[] cmd = command.split(" ");
        boolean pem = false;
        try {
            if (cmd[0].toLowerCase().equals("/pm")) {
                if (this.plugin.debug > 0) {
                    System.out.println(this.plugin.PluginName + "[DEBUG]: 'pm' erkannt");
                }
                if (cmd.length == 1) {
                    if (this.plugin.debug > 0) {
                        System.out.println(this.plugin.PluginName + "[DEBUG]: cmd.length == 1");
                    }
                    pem = true;
                    if (player.isAdmin()) {
                        if (!this.plugin.api.Users.getGroups(player).contains(this.plugin.Config.getAdminGroup())) {
                            this.plugin.api.Users.setGroups(player, this.plugin.Config.getAdminGroup());
                            player.sendTextMessage("[#00ff00]You are now in the Admin-Group: " + this.plugin.Config.getAdminGroup());
                        } else {
                            player.sendTextMessage(this.plugin.PluginName);
                            player.sendTextMessage("Version: " + this.plugin.getDescription("version"));
                        }
                    } else {
                        player.sendTextMessage(this.plugin.PluginName);
                        player.sendTextMessage("Version: " + this.plugin.getDescription("version"));
                    }
                }
                if (cmd.length == 2) {
                    if (this.plugin.debug > 0) {
                        System.out.println(this.plugin.PluginName + "[DEBUG]: cmd.length == 1");
                    }
                    if (cmd[1].toLowerCase().equals("reload") && this.plugin.hasPermission(player, "permissionmanager.reload")) {
                        pem = true;
                        this.plugin.reloadPermissions(player.getUID());
                    }
                    if (cmd[1].toLowerCase().equals("help") && this.plugin.hasPermission(player, "permissionmanager.help")) {
                        pem = true;
                        player.sendTextMessage("[#ffa500]------PermissionManager-Help------");
                        player.sendTextMessage("[#ffa500]/pm help");
                        player.sendTextMessage("[#ffa500]/pm reload");
                        player.sendTextMessage("[#ffa500]/pm group <group> create");
                        player.sendTextMessage("[#ffa500]/pm group <group> delete");
                        player.sendTextMessage("[#ffa500]/pm group <group> info");
                        player.sendTextMessage("[#ffa500]/pm group <group> add <permission>");
                        player.sendTextMessage("[#ffa500]/pm group <group> remove <permission>");
                        player.sendTextMessage("[#ffa500]/pm group <group> addi <inheritance>");
                        player.sendTextMessage("[#ffa500]/pm group <group> removei <inheritance>");
                        player.sendTextMessage("[#ffa500]/pm group <group> prefix");
                        player.sendTextMessage("[#ffa500]/pm group <group> prefix <prefix (text)>");
                        player.sendTextMessage("[#ffa500]/pm group <group> sufix");
                        player.sendTextMessage("[#ffa500]/pm group <group> sufix <sufix (text)>");
                        player.sendTextMessage("[#ffa500]/pm group <group> rank <number>");
                        player.sendTextMessage("[#ffa500]/pm group <group> default <true|false>");
                        player.sendTextMessage("[#ffa500]/pm user <playername> info");
                        player.sendTextMessage("[#ffa500]/pm user <playername> add <permission>");
                        player.sendTextMessage("[#ffa500]/pm user <playername> remove <permission>");
                        player.sendTextMessage("[#ffa500]/pm user <playername> setgroup <group>");
                        player.sendTextMessage("[#ffa500]/pm user <playername> addgroup <group>");
                        player.sendTextMessage("[#ffa500]/pm user <playername> removegroup <group>");
                        player.sendTextMessage("[#ffa500]/pm getid");
                        player.sendTextMessage("[#ffa500]----------------------------------");
                    }
                    if (cmd[1].toLowerCase().equals("getid")) {
                        Item item = player.getEquippedItem();
                        if (item != null) {
                            Item.Attribute attribute = item.getAttribute();
                            if (attribute != null) {
                                if (attribute instanceof Item.ObjectAttribute) {
                                    Item.ObjectAttribute obj = (Item.ObjectAttribute)attribute;
                                    player.sendTextMessage("----------Equipped Item Info-----------");
                                    player.sendTextMessage("            Type = Object");
                                    player.sendTextMessage("     Object Name = " + Definitions.getObjectDefinition((short)obj.getObjectID()).getName());
                                    player.sendTextMessage("Object Stacksize = " + item.getStacksize());
                                    player.sendTextMessage("       Object ID = " + obj.getObjectID());
                                    player.sendTextMessage("Object Variation = " + item.getVariation());
                                    player.sendTextMessage("-----------------End-------------------");
                                } else if (attribute instanceof Item.ClothingAttribute) {
                                    Item.ClothingAttribute clo = (Item.ClothingAttribute)attribute;
                                    player.sendTextMessage("----------Equipped Item Info-----------");
                                    player.sendTextMessage("             Type  = Clothing");
                                    player.sendTextMessage("     Clothing Name = " + Definitions.getClothingDefinition((short)clo.getClothingID()).getName());
                                    player.sendTextMessage("Clothing Stacksize = " + item.getStacksize());
                                    player.sendTextMessage("       Clothing ID = " + clo.getClothingID());
                                    player.sendTextMessage("Clothing Variation = " + item.getVariation());
                                    player.sendTextMessage("-----------------End-------------------");
                                } else {
                                    player.sendTextMessage("----------Equipped Item Info-----------");
                                    player.sendTextMessage("          Type = Item");
                                    player.sendTextMessage("     Item Name = " + item.getName());
                                    player.sendTextMessage("Item Stacksize = " + item.getStacksize());
                                    player.sendTextMessage("       Item ID = " + item.getTypeID());
                                    player.sendTextMessage("Item Variation = " + item.getVariation());
                                    player.sendTextMessage("-----------------End-------------------");
                                }
                            } else {
                                player.sendTextMessage("----------Equipped Item Info-----------");
                                player.sendTextMessage("     Type = Item");
                                player.sendTextMessage("     Name = " + item.getName());
                                player.sendTextMessage("Stacksize = " + item.getStacksize());
                                player.sendTextMessage("       ID = " + item.getTypeID());
                                player.sendTextMessage("Variation = " + item.getVariation());
                                player.sendTextMessage("-----------------End-------------------");
                            }
                        } else {
                            player.setAttribute(this.AttGetID, (Object)true);
                            player.sendTextMessage("[#00ff00][PermissionManager] Interact now with an npc/chest/sign");
                        }
                    }
                }
                if (cmd.length >= 4) {
                    if (this.plugin.debug > 0) {
                        System.out.println(this.plugin.PluginName + "[DEBUG]: cmd.length >= 4");
                    }
                    if (cmd[1].toLowerCase().equals("group")) {
                        if (this.plugin.debug > 0) {
                            System.out.println(this.plugin.PluginName + "[DEBUG]: 'group' erkannt!");
                        }
                        if (cmd.length == 4) {
                            if (this.plugin.debug > 0) {
                                System.out.println(this.plugin.PluginName + "[DEBUG]: cmd.length == 4");
                            }
                            if (cmd[3].toLowerCase().equals("info") && this.plugin.hasPermission(player, "permissionmanager.groups.info")) {
                                pem = true;
                                player.sendTextMessage("[#ffa500]------Group-Info------");
                                player.sendTextMessage("[#ffa500]Name: " + cmd[2]);
                                player.sendTextMessage("[#ffa500]Rank: " + this.plugin.api.Groups.get.Rank(cmd[2]));
                                player.sendTextMessage("[#ffa500]Default: " + this.plugin.api.Groups.get.Default(cmd[2]));
                                player.sendTextMessage("[#ffa500]Prefix: " + this.plugin.api.Groups.get.Prefix(cmd[2]));
                                player.sendTextMessage("[#ffa500]Sufix: " + this.plugin.api.Groups.get.Sufix(cmd[2]));
                                player.sendTextMessage("[#ffa500]Inheritance:");
                                this.plugin.api.Groups.get.Inheritance(cmd[2]).forEach(i -> player.sendTextMessage("[#ffa500]- " + i));
                                player.sendTextMessage("[#ffa500]Permissions:");
                                this.plugin.api.Groups.get.GroupPermissions(cmd[2]).forEach(p -> player.sendTextMessage("[#ffa500]- " + p));
                                player.sendTextMessage("----------------------");
                            }
                            if (cmd[3].toLowerCase().equals("create") && this.plugin.hasPermission(player, "permissionmanager.groups.create")) {
                                pem = true;
                                this.plugin.api.Groups.addNewGroup(cmd[2]);
                                player.sendTextMessage("[#00ff00]You have creaded the group '" + cmd[2] + "'!");
                            }
                            if (cmd[3].toLowerCase().equals("delete") && this.plugin.hasPermission(player, "permissionmanager.groups.delete")) {
                                pem = true;
                                this.plugin.api.Groups.removeGroup(cmd[2]);
                                player.sendTextMessage("[#00ff00]You have deleted the group '" + cmd[2] + "'!");
                            }
                            if (cmd[3].toLowerCase().equals("prefix") && this.plugin.hasPermission(player, "permissionmanager.groups.prefix")) {
                                pem = true;
                                if (this.plugin.api.Groups.set.Prefix(cmd[2], "")) {
                                    player.sendTextMessage("[#00ff00]Prefix from group '" + cmd[2] + "' removed!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Prefix from group '" + cmd[2] + "' can not be removed!");
                                }
                            }
                            if (cmd[3].toLowerCase().equals("sufix") && this.plugin.hasPermission(player, "permissionmanager.groups.sufix")) {
                                pem = true;
                                if (this.plugin.api.Groups.set.Sufix(cmd[2], "")) {
                                    player.sendTextMessage("[#00ff00]Sufix from group '" + cmd[2] + "' removed!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Sufix from group '" + cmd[2] + "' can not be removed!");
                                }
                            }
                        }
                        if (cmd.length == 5) {
                            if (this.plugin.debug > 0) {
                                System.out.println(this.plugin.PluginName + "[DEBUG]: cmd.length == 5");
                            }
                            if (cmd[3].toLowerCase().equals("add") && this.plugin.hasPermission(player, "permissionmanager.groups.permissions.add")) {
                                pem = true;
                                if (this.plugin.api.Groups.addGroupPermission(cmd[2], cmd[4])) {
                                    player.sendTextMessage("[#00ff00]Permission '" + cmd[4] + "' added to group '" + cmd[2] + "'!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Permission '" + cmd[4] + "' can not be added to group '" + cmd[2] + "'!");
                                }
                            }
                            if (cmd[3].toLowerCase().equals("remove") && this.plugin.hasPermission(player, "permissionmanager.groups.permissions.remove")) {
                                pem = true;
                                if (this.plugin.api.Groups.removeGroupPermission(cmd[2], cmd[4])) {
                                    player.sendTextMessage("[#00ff00]Permission '" + cmd[4] + "' removed from group '" + cmd[2] + "'!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Permission '" + cmd[4] + "' can not removed from group '" + cmd[2] + "'!");
                                }
                            }
                            if (cmd[3].toLowerCase().equals("addi") && this.plugin.hasPermission(player, "permissionmanager.groups.inheritance.add")) {
                                pem = true;
                                if (this.plugin.api.Groups.set.addInheritance(cmd[2], cmd[4])) {
                                    player.sendTextMessage("[#00ff00]Inheritance '" + cmd[4] + "' added to group '" + cmd[2] + "'!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Inheritance '" + cmd[4] + "' can not added to group '" + cmd[2] + "'!");
                                }
                            }
                            if (cmd[3].toLowerCase().equals("removei") && this.plugin.hasPermission(player, "permissionmanager.groups.inheritance.remove")) {
                                pem = true;
                                if (this.plugin.api.Groups.set.removeInheritance(cmd[2], cmd[4])) {
                                    player.sendTextMessage("[#00ff00]Inheritance '" + cmd[4] + "' removed from group '" + cmd[2] + "'!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Inheritance '" + cmd[4] + "' can not removed from to group '" + cmd[2] + "'!");
                                }
                            }
                            if (cmd[3].toLowerCase().equals("prefix") && this.plugin.hasPermission(player, "permissionmanager.groups.prefix")) {
                                pem = true;
                                if (this.plugin.api.Groups.set.Prefix(cmd[2], cmd[4])) {
                                    player.sendTextMessage("[#00ff00]Prefix from group '" + cmd[2] + "' changed!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Prefix from group '" + cmd[2] + "' can not be changed!");
                                }
                            }
                            if (cmd[3].toLowerCase().equals("sufix") && this.plugin.hasPermission(player, "permissionmanager.groups.sufix")) {
                                pem = true;
                                if (this.plugin.api.Groups.set.Sufix(cmd[2], cmd[4])) {
                                    player.sendTextMessage("[#00ff00]Sufix from group '" + cmd[2] + "' changed!");
                                } else {
                                    player.sendTextMessage("[#ff0000]Sufix from group '" + cmd[2] + "' can not be changed!");
                                }
                            }
                            if (cmd[3].toLowerCase().equals("default") && this.plugin.hasPermission(player, "permissionmanager.groups.default")) {
                                pem = true;
                                boolean value = Boolean.parseBoolean(cmd[4]);
                                this.plugin.api.Groups.set.Default(cmd[2], value);
                                player.sendTextMessage("[#00ff00]Default from group '" + cmd[2] + "' changed!");
                            }
                            if (cmd[3].toLowerCase().equals("rank") && this.plugin.hasPermission(player, "permissionmanager.groups.rank")) {
                                pem = true;
                                int value = Integer.parseInt(cmd[4]);
                                this.plugin.api.Groups.set.Rank(cmd[2], value);
                                player.sendTextMessage("[#00ff00]Rank from group '" + cmd[2] + "' changed!");
                            }
                            if (cmd[3].toLowerCase().equals("ChatColor") && this.plugin.hasPermission(player, "permissionmanager.groups.chatcolor")) {
                                pem = true;
                                if (this.plugin.api.Groups.set.ChatColor(cmd[2], cmd[4])) {
                                    player.sendTextMessage("[#00ff00]ChatColor from group '" + cmd[2] + "' changed!");
                                } else {
                                    player.sendTextMessage("[#ff0000]ChatColor from group '" + cmd[2] + "' can not be changed!");
                                }
                            }
                        }
                    }
                    if (cmd[1].toLowerCase().equals("user")) {
                        Player p2;
                        if (this.plugin.debug > 0) {
                            System.out.println(this.plugin.PluginName + "[DEBUG]: 'user' erkannt!");
                        }
                        if ((p2 = this.plugin.getServer().getPlayer(cmd[2])) != null) {
                            if (cmd.length == 4) {
                                if (this.plugin.debug > 0) {
                                    System.out.println(this.plugin.PluginName + "[DEBUG]: cmd.length == 4");
                                }
                                if (cmd[3].toLowerCase().equals("info") && this.plugin.hasPermission(player, "permissionmanager.users.info")) {
                                    pem = true;
                                    player.sendTextMessage("[#ffa500]------Player-Info------");
                                    player.sendTextMessage("[#ffa500]UID: " + p2.getUID());
                                    player.sendTextMessage("[#ffa500]groups:");
                                    for (String g : this.plugin.api.Users.getGroups(p2)) {
                                        player.sendTextMessage("[#ffa500]- " + g);
                                    }
                                    player.sendTextMessage("[#ffa500]permissions:");
                                    for (String p3 : this.plugin.api.Users.getPermissions(p2)) {
                                        player.sendTextMessage("[#ffa500]- " + p3);
                                    }
                                    player.sendTextMessage("[#ffa500]-----------------------");
                                }
                            }
                            if (cmd.length == 5) {
                                if (this.plugin.debug > 0) {
                                    System.out.println(this.plugin.PluginName + "[DEBUG]: cmd.length == 5");
                                }
                                String value = cmd[4];
                                if (cmd[3].toLowerCase().equals("add") && this.plugin.hasPermission(player, "permissionmanager.users.permissions.add")) {
                                    pem = true;
                                    this.plugin.api.Users.addPermission(p2, value);
                                    player.sendTextMessage("[#00ff00]Added permission to the player '" + cmd[2] + "'!");
                                    if (p2.isConnected()) {
                                        p2.sendTextMessage("[#ffa500]Your permissions has changed!");
                                    }
                                }
                                if (cmd[3].toLowerCase().equals("remove") && this.plugin.hasPermission(player, "permissionmanager.users.permissions.remove")) {
                                    pem = true;
                                    this.plugin.api.Users.removePermission(p2, value);
                                    player.sendTextMessage("[#00ff00]Removed permission from the player '" + cmd[2] + "'!");
                                    if (p2.isConnected()) {
                                        p2.sendTextMessage("[#ffa500]Your permissions has changed!");
                                    }
                                }
                                if (cmd[3].toLowerCase().equals("setgroup") && this.plugin.hasPermission(player, "permissionmanager.users.group.set")) {
                                    pem = true;
                                    this.plugin.api.Users.setGroups(player, value);
                                    player.sendTextMessage("[#00ff00]Set the group of the player '" + cmd[2] + "'!");
                                    if (this.plugin.Config.getChange_Servergroup_with_Group() && (this.plugin.api.Groups.get.Servergroup(value) != null || !this.plugin.api.Groups.get.Servergroup(value).equals(""))) {
                                        p2.setPermissionGroup(this.plugin.api.Groups.get.Servergroup(value));
                                    }
                                    if (p2.isConnected()) {
                                        p2.sendTextMessage("[#ffa500]Your permissions has changed!");
                                    }
                                }
                                if (cmd[3].toLowerCase().equals("addgroup") && this.plugin.hasPermission(player, "permissionmanager.users.group.add")) {
                                    pem = true;
                                    this.plugin.api.Users.addGroups(player, value);
                                    player.sendTextMessage("[#00ff00]Added the group of the player '" + cmd[2] + "'!");
                                    if (p2.isConnected()) {
                                        p2.sendTextMessage("[#ffa500]Your permissions has changed!");
                                    }
                                }
                                if (cmd[3].toLowerCase().equals("removegroup") && this.plugin.hasPermission(player, "permissionmanager.users.group.remove")) {
                                    pem = true;
                                    this.plugin.api.Users.removeGroups(player, value);
                                    player.sendTextMessage("[#00ff00]Removed the group of the player '" + cmd[2] + "'!");
                                    if (p2.isConnected()) {
                                        p2.sendTextMessage("[#ffa500]Your permissions has changed!");
                                    }
                                }
                            }
                        }
                    }
                }
                if (!pem) {
                    player.showStatusMessage("You have not anouth permission to do that!", 5);
                }
            }
        }
        catch (GroupAlreadyExistException ex) {
            player.sendTextMessage("[#ff0000]Group already exist!");
        }
        catch (GroupNotFoundException ex) {
            player.sendTextMessage("[#ff0000]Group not found in the permissions.yml");
        }
        catch (UserNotFoundException ex) {
            player.sendTextMessage("[#ff0000]Player not found in the permissions.yml");
        }
    }

    @EventMethod
    public void onInputEvent(InputEvent event) {
        String input = event.getInput();
        String[] in = input.split(" ");
        if (in.length >= 2 && in[0].toLowerCase().equals("pm")) {
            if (in.length == 2) {
                if (in[1].toLowerCase().equals("groups")) {
                    this.plugin.api.Groups.getAllGroups().forEach(g -> System.out.println("- " + g));
                    System.out.println("--------------");
                }
                if (in[1].toLowerCase().equals("users")) {
                    this.plugin.api.Users.getAllUsers().forEach(u -> System.out.println("- " + u));
                    System.out.println("--------------");
                }
            }
            if (in.length == 3) {
                Player player;
                if (in[1].toLowerCase().equals("setadmin") && (player = this.plugin.getServer().getPlayer(in[2])) != null) {
                    this.plugin.api.Users.addUser(player);
                    try {
                        this.plugin.api.Users.setGroups(player, "Admin");
                    }
                    catch (UserNotFoundException ex) {
                        System.out.println("User was not found!");
                    }
                }
                if (in[1].toLowerCase().equals("getprefix")) {
                    player = this.plugin.getServer().getPlayer(in[2]);
                    try {
                        System.out.println(this.plugin.api.Users.getPlayerPrefix(player));
                    }
                    catch (GroupNotFoundException | UserNotFoundException ex) {
                        System.out.println("Player / Group not found!");
                    }
                }
            }
            if (in.length == 4 && in[1].toLowerCase().equals("group") && in[3].toLowerCase().equals("info")) {
                String g2 = in[2];
                try {
                    System.out.println("Name: " + in[2]);
                    System.out.println("Rank: " + this.plugin.api.Groups.get.Rank(g2));
                    System.out.println("Default: " + this.plugin.api.Groups.get.Default(g2));
                    System.out.println("Prefix: " + this.plugin.api.Groups.get.Prefix(g2));
                    System.out.println("Sufix: " + this.plugin.api.Groups.get.Sufix(g2));
                    System.out.println("Inheritance:");
                    this.plugin.api.Groups.get.Inheritance(g2).forEach(i -> System.out.println("- " + i));
                    System.out.println("Permissions:");
                    this.plugin.api.Groups.get.GroupPermissions(g2).forEach(p -> System.out.println("- " + p));
                    System.out.println("--------------");
                }
                catch (GroupNotFoundException ex) {
                    System.out.println("Group was not found!");
                }
            }
        }
    }

    @EventMethod
    public void onPlayerNpcInteractionEvent(PlayerNpcInteractionEvent event) {
        Player player = event.getPlayer();
        if (((Boolean)player.getAttribute(this.AttGetID)).booleanValue()) {
            Npc npc = event.getNpc();
            player.sendTextMessage("---------NPC Info----------");
            player.sendTextMessage("  Type-ID = " + npc.getTypeID());
            player.sendTextMessage("Type-Name = " + npc.getType().toString());
            player.sendTextMessage("Global-ID = " + npc.getGlobalID());
            player.sendTextMessage("     Name = " + npc.getName());
            player.sendTextMessage("------------End-----------");
            player.setAttribute(this.AttGetID, (Object)false);
        }
    }

    @EventMethod
    public void onPlayerObjectInteractionEvent(PlayerObjectInteractionEvent event) {
        Player player = event.getPlayer();
        if (((Boolean)player.getAttribute(this.AttGetID)).booleanValue()) {
            Definitions.ObjectDefinition def = event.getObjectDefinition();
            player.setAttribute(this.AttGetID, (Object)false);
            if (def.isSign()) {
                player.sendTextMessage("------------Sign Info-------------");
                player.sendTextMessage("            Sign-ID = " + event.getObjectInfoID());
                player.sendTextMessage("     Obejct-Type-ID = " + event.getObjectTypeID());
                player.sendTextMessage("Objekt-Variation-ID = " + event.getObjectVariation());
                player.sendTextMessage("---------------End-----------------");
            } else if (def.isChest()) {
                player.sendTextMessage("------------NPC Info-------------");
                player.sendTextMessage("           Chest-ID = " + event.getObjectInfoID());
                player.sendTextMessage("     Obejct-Type-ID = " + event.getObjectTypeID());
                player.sendTextMessage("Objekt-Variation-ID = " + event.getObjectVariation());
                player.sendTextMessage("---------------End-----------------");
            } else {
                player.sendTextMessage("------------Objekt Info-------------");
                player.sendTextMessage("     Obejct-Type-ID = " + event.getObjectTypeID());
                player.sendTextMessage("Objekt-Variation-ID = " + event.getObjectVariation());
                player.sendTextMessage("---------------End-----------------");
            }
        }
    }
}

