/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins.java.protectedslots;

import de.pbplugins.java.permissionmanager.PermissionManager;
import de.pbplugins.java.permissionmanager.exception.GroupNotFoundException;
import de.pbplugins.java.permissionmanager.exception.UserNotFoundException;
import de.pbplugins.java.protectedslots.psConfig;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;

public class ProtectedSlots
extends Plugin
implements Listener {
    private psConfig config;
    private Server server;
    private PermissionManager pm;
    private boolean Per;
    int PS;
    public Config Config;
    private boolean PluginStop = false;

    public void onEnable() {
        System.out.println("[ProtectedSlots (Java)] Enabled");
        System.out.println("[ProtectedSlots (Java)] Load config...");
        String[][] sysConfigArray = new String[][]{{"Debug", "0"}, {"SlotAmounth", "1"}, {"NoAdminPlayersUID", ""}};
        this.config = new psConfig("System", sysConfigArray, this, 0);
        this.Config = new Config();
        this.Config.setValues();
        boolean bl = this.Per = this.getPluginByName("PermissionManager") != null;
        if (this.Per) {
            this.pm = (PermissionManager)this.getPluginByName("PermissionManager");
        }
        this.PS = this.Config.get.SlotAmounth();
        this.registerEventListener(this);
    }

    public void onDisable() {
        System.out.println("[ProtectedSlots (Java)] Desabled");
    }

    public boolean inConfig(long uid) {
        String stUID = String.valueOf(uid);
        return this.Config.get.NoAdminPlayersUID().contains(stUID);
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        int PlayerMax = this.server.getMaxPlayerCount();
        int PlayerAmounth = this.server.getMaxPlayerCount();
        int AdminPlayers = 0;
        if (!this.PluginStop) {
            int FreeSlots;
            for (Player p : this.server.getAllPlayers()) {
                if (p.isAdmin() || this.inConfig(p.getUID())) {
                    ++AdminPlayers;
                    continue;
                }
                if (!this.Per) continue;
                try {
                    if (event.isNewPlayer() || !this.pm.hasPermission(player, "protectedslots.login")) continue;
                    ++AdminPlayers;
                }
                catch (GroupNotFoundException | UserNotFoundException throwable) {}
            }
            if (AdminPlayers > this.PS) {
                AdminPlayers = this.PS;
            }
            if ((FreeSlots = PlayerMax - PlayerAmounth) <= this.PS - AdminPlayers && !player.isAdmin()) {
                try {
                    if (this.Per) {
                        if (this.inConfig(player.getUID()) || event.isNewPlayer() && this.pm.hasPermission(player, "protectedslots.login")) {
                            event.setCancelled(false);
                        } else {
                            player.kick("Sorry, but the last slots are reserved for certain players.");
                        }
                    } else if (!this.inConfig(player.getUID())) {
                        player.kick("Sorry, but the last slots are reserved for certain players.");
                    }
                }
                catch (GroupNotFoundException | UserNotFoundException throwable) {
                    // empty catch block
                }
            }
        }
    }

    public class Config {
        String NoAdminPlayersUID;
        int Debug;
        int SlotAmounth;
        public get get = new get();

        public void setValues() {
            try {
                this.Debug = Integer.parseInt(ProtectedSlots.this.config.getValue("Debug"));
                this.NoAdminPlayersUID = ProtectedSlots.this.config.getValue("NoAdminPlayersUID");
                this.SlotAmounth = Integer.parseInt(ProtectedSlots.this.config.getValue("SlotAmounth"));
            }
            catch (NumberFormatException ex) {
                ProtectedSlots.this.PluginStop = true;
                System.err.println("[ProtectedSlots (Java)]  ERR: The Config has an Error!");
                System.err.println("[ProtectedSlots (Java)]  ERR: A number cannot be text!");
                System.err.println("[ProtectedSlots (Java)]  ERR: --------------------------");
                System.err.println("[ProtectedSlots (Java)]  ERR: Debug = number (0-9)");
                System.err.println("[ProtectedSlots (Java)]  ERR: SlotAmounth = number (0-9999)");
                System.err.println("[ProtectedSlots (Java)]  ERR: NoAdminPlayerUID = text");
                System.err.println("[ProtectedSlots (Java)]  ERR: --------------------------");
                System.err.println("[ProtectedSlots (Java)] INFO: Plugin is stopped!");
                System.out.println("[ProtectedSlots (Java)] Desabled");
            }
        }

        public class get {
            public int Debug() {
                return Config.this.Debug;
            }

            public String NoAdminPlayersUID() {
                return Config.this.NoAdminPlayersUID;
            }

            public int SlotAmounth() {
                return Config.this.SlotAmounth;
            }
        }
    }
}

