/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.ClassPluginConfig;
import de.chaoswg.ToolsAPI;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import net.risingworld.api.Plugin;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;
import org.yaml.snakeyaml.DumperOptions;

public class ClassRecipes {
    private Plugin plugin;
    private ClassPluginConfig debug;
    private Map<String, ClassRecipe> recipe;

    ClassRecipes() {
    }

    ClassRecipes(Plugin plugin, ClassPluginConfig debug) {
        this.debug = debug;
        this.plugin = plugin;
        this.recipe = new HashMap<String, ClassRecipe>();
    }

    public Map<String, ClassRecipe> getRecipe() {
        return this.recipe;
    }

    public void setRecipe(Map<String, ClassRecipe> recipe) {
        this.recipe = recipe;
    }

    void loadConfig(String assets) {
        this.loadConfig(assets, "Config");
    }

    void loadConfig(String assets, String configName) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndent(2);
        options.setWidth(80);
        File fileCongigPhat = new File(this.plugin.getPath() + (assets != null && !assets.equals("") ? System.getProperty("file.separator") + assets : ""));
        if (fileCongigPhat.mkdirs()) {
            this.debug.printlnDebug(0, "Erstelle: " + fileCongigPhat.getAbsolutePath());
        }
        String fileCongigFile = this.plugin.getPath() + (assets != null && !assets.equals("") ? System.getProperty("file.separator") + assets : "") + System.getProperty("file.separator") + configName + ".yml";
        File configFile = new File(fileCongigFile);
        this.debug.printlnDebug(2, "[" + this.plugin.getDescription("name") + "] configFile: " + configFile.getAbsolutePath());
        if (configFile.exists()) {
            this.debug.printlnDebug(0, "[" + this.plugin.getDescription("name") + "] Lade: " + configFile.getAbsolutePath());
            try {
                ToolsAPI.loadConfigByDefault(this, (ClassRecipes)ToolsAPI.loadYAML(configFile, ClassRecipes.class, options), ClassRecipes.class, this.debug);
                ToolsAPI.writeYAMAL(configFile, this, options);
                if (this.debug.isDebug(3)) {
                    ToolsAPI.writeYAMAL(new File(configFile.getAbsolutePath() + "_"), this, options);
                }
            }
            catch (FileNotFoundException ex) {
                System.err.println("[" + this.plugin.getDescription("name") + "] ERR load recipesDaten[] " + ex.getMessage());
            }
        } else {
            this.debug.printlnDebug(0, "[" + this.plugin.getDescription("name") + "] Erstelle: " + configFile.getAbsolutePath());
            ToolsAPI.writeYAMAL(configFile, this, options);
        }
    }

    public static class ClassRecipe {
        private String modelPreviewICO;
        private String modelPreviewOBJ;
        private String modelPreviewDiffuse;
        private String modelPreviewNormal;
        private float modelPreviewScale;
        private int invMaxStacksize;
        Vector3f itemPosition;
        Quaternion itemRotation;
        Vector3f FPBodyPosition;
        Quaternion FPBodyRotation;
        String[] localizedNames;
        float previewSize;
        String[] ingredients;
        String[] localizedCategories;
        String[] localizedDescriptions;
        ClassRecipesDataVariation[] variation;

        public void setModelPreviewICO(String modelPreviewICO) {
            this.modelPreviewICO = modelPreviewICO;
        }

        public String getModelPreviewICO() {
            return this.modelPreviewICO;
        }

        public void setModelPreviewOBJ(String modelPreviewOBJ) {
            this.modelPreviewOBJ = modelPreviewOBJ;
        }

        public String getModelPreviewOBJ() {
            return this.modelPreviewOBJ;
        }

        public String getModelPreviewDiffuse() {
            return this.modelPreviewDiffuse;
        }

        public void setModelPreviewDiffuse(String modelPreviewDiffuse) {
            this.modelPreviewDiffuse = modelPreviewDiffuse;
        }

        public void setModelPreviewNormal(String modelPreviewNormal) {
            this.modelPreviewNormal = modelPreviewNormal;
        }

        public String getModelPreviewNormal() {
            return this.modelPreviewNormal;
        }

        public void setModelPreviewScale(float modelPreviewScale) {
            this.modelPreviewScale = modelPreviewScale;
        }

        public float getModelPreviewScale() {
            return this.modelPreviewScale;
        }

        public void setInvMaxStacksize(int invMaxStacksize) {
            this.invMaxStacksize = invMaxStacksize;
        }

        public int getInvMaxStacksize() {
            return this.invMaxStacksize;
        }

        public void setItemPosition(Vector3f itemPosition) {
            this.itemPosition = itemPosition;
        }

        public Vector3f getItemPosition() {
            return this.itemPosition;
        }

        public void setItemRotation(Quaternion itemRotation) {
            this.itemRotation = itemRotation;
        }

        public Quaternion getItemRotation() {
            return this.itemRotation;
        }

        public void setFPBodyPosition(Vector3f FPBodyPosition) {
            this.FPBodyPosition = FPBodyPosition;
        }

        public Vector3f getFPBodyPosition() {
            return this.FPBodyPosition;
        }

        public void setFPBodyRotation(Quaternion FPBodyRotation) {
            this.FPBodyRotation = FPBodyRotation;
        }

        public Quaternion getFPBodyRotation() {
            return this.FPBodyRotation;
        }

        public void setLocalizedNames(String[] localizedNames) {
            this.localizedNames = localizedNames;
        }

        public String[] getLocalizedNames() {
            return this.localizedNames;
        }

        public void setPreviewSize(float previewSize) {
            this.previewSize = previewSize;
        }

        public float getPreviewSize() {
            return this.previewSize;
        }

        public void setIngredients(String[] ingredients) {
            this.ingredients = ingredients;
        }

        public String[] getIngredients() {
            return this.ingredients;
        }

        public void setLocalizedCategories(String[] localizedCategories) {
            this.localizedCategories = localizedCategories;
        }

        public String[] getLocalizedCategories() {
            return this.localizedCategories;
        }

        public void setLocalizedDescriptions(String[] localizedDescriptions) {
            this.localizedDescriptions = localizedDescriptions;
        }

        public String[] getLocalizedDescriptions() {
            return this.localizedDescriptions;
        }

        public void setVariation(ClassRecipesDataVariation[] variation) {
            this.variation = variation;
        }

        public ClassRecipesDataVariation[] getVariation() {
            return this.variation;
        }

        public String toString() {
            return "ClassClockDetail{modelPreviewICO=" + this.modelPreviewICO + " modelPreviewDiffuse=" + this.modelPreviewDiffuse + " modelPreviewNormal=" + this.modelPreviewNormal + "modelPreviewScale=" + this.modelPreviewScale + " invMaxStacksize=" + this.invMaxStacksize + " itemPosition=" + this.itemPosition + " itemRotation=" + this.itemRotation + " FPBodyPosition=" + this.FPBodyPosition + " FPBodyRotation=" + this.FPBodyRotation + " localizedNames=" + this.localizedNames + " ingredients=" + this.ingredients + " localizedCategories=" + this.localizedCategories + " localizedDescriptions=" + this.localizedDescriptions + " variation=" + String.valueOf(this.variation != null ? this.variation.toString() : "NOT") + "" + '}';
        }

        public static class ClassRecipesDataVariation {
            int id = -1;
            String texture = null;
            String icon = null;

            public ClassRecipesDataVariation() {
            }

            public ClassRecipesDataVariation(int id, String texture, String icon) {
                this.id = id;
                this.texture = texture;
                this.icon = icon;
            }

            public int getId() {
                return this.id;
            }

            public void setId(int id) {
                this.id = id;
            }

            public String getTexture() {
                return this.texture;
            }

            public void setTexture(String texture) {
                this.texture = texture;
            }

            public String getIcon() {
                return this.icon;
            }

            public void setIcon(String icon) {
                this.icon = icon;
            }

            public String toString() {
                return "ClassRecipesVariation{id=" + this.id + " texture=" + this.texture + " icon=" + this.icon + "" + '}';
            }
        }
    }
}

