/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.ClassImpToolsLang;
import de.chaoswg.ClassPluginConfig;
import de.chaoswg.ToolsAPI;
import java.io.File;
import java.io.FileNotFoundException;
import net.risingworld.api.Plugin;
import org.yaml.snakeyaml.DumperOptions;

public abstract class ToolsLang
implements ClassImpToolsLang {
    private final Plugin plugin;
    private final ClassPluginConfig debug;

    ToolsLang(Plugin plugin, ClassPluginConfig debug) {
        this.plugin = plugin;
        this.debug = debug;
        this.ini();
    }

    void goConfig(String assets, Class<?> aClass) {
        this.goConfig(assets, "Config", aClass);
    }

    void goConfig(String assets, String configName, Class<?> aClass) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndent(2);
        options.setWidth(80);
        File fileCongigPhat = new File(this.plugin.getPath() + (assets != null && !assets.equals("") ? System.getProperty("file.separator") + assets : ""));
        if (fileCongigPhat.mkdirs()) {
            this.debug.printlnDebug(0, "Erstelle: " + fileCongigPhat.getAbsolutePath());
        }
        String fileCongigFile = this.plugin.getPath() + (assets != null && !assets.equals("") ? System.getProperty("file.separator") + assets : "") + System.getProperty("file.separator") + configName + ".yml";
        File configFile = new File(fileCongigFile);
        this.debug.printlnDebug(2, "[" + this.plugin.getDescription("name") + "] configFile: " + configFile.getAbsolutePath());
        if (configFile.exists()) {
            this.debug.printlnDebug(0, "[" + this.plugin.getDescription("name") + "] Lade: " + configFile.getAbsolutePath());
            try {
                Object object = ToolsAPI.loadYAML(configFile, aClass, options);
            }
            catch (FileNotFoundException ex) {
                System.err.println("[" + this.plugin.getDescription("name") + "] ERR load langDaten[] " + ex.getMessage());
            }
        } else {
            this.debug.printlnDebug(0, "[" + this.plugin.getDescription("name") + "] Erstelle: " + configFile.getAbsolutePath());
            ToolsAPI.writeYAMAL(configFile, this, options);
        }
    }
}

